// chromeos/services/machine_learning/public/mojom/graph_executor.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.ExecuteResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.ExecuteResult = {
  
  OK: 0,
  INPUT_MISSING_ERROR: 1,
  UNKNOWN_INPUT_ERROR: 2,
  INPUT_TYPE_ERROR: 3,
  INPUT_SHAPE_ERROR: 4,
  INPUT_FORMAT_ERROR: 5,
  OUTPUT_MISSING_ERROR: 6,
  UNKNOWN_OUTPUT_ERROR: 7,
  DUPLICATE_OUTPUT_ERROR: 8,
  EXECUTION_ERROR: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.GraphExecutorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.GraphExecutor.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.GraphExecutorInterface }
 */
chromeos.machineLearning.mojom.GraphExecutorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.GraphExecutorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.GraphExecutorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.GraphExecutorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object<!string, !chromeos.machineLearning.mojom.Tensor> } inputs
   * @param { !Array<!string> } outputNames
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.ExecuteResult,
        outputs: ?Array<!chromeos.machineLearning.mojom.Tensor>,
   *  }>}
   */

  execute(
      inputs,
      outputNames) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.GraphExecutor_Execute_ParamsSpec.$,
        chromeos.machineLearning.mojom.GraphExecutor_Execute_ResponseParamsSpec.$,
        [
          inputs,
          outputNames
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GraphExecutor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.GraphExecutorReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.GraphExecutorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.GraphExecutorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.GraphExecutorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.GraphExecutorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.GraphExecutor_Execute_ParamsSpec.$,
        chromeos.machineLearning.mojom.GraphExecutor_Execute_ResponseParamsSpec.$,
        impl.execute.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.GraphExecutor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.GraphExecutor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.GraphExecutorRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.GraphExecutorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GraphExecutor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.GraphExecutorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.GraphExecutorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.GraphExecutorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.execute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.GraphExecutor_Execute_ParamsSpec.$,
        chromeos.machineLearning.mojom.GraphExecutor_Execute_ResponseParamsSpec.$,
        this.execute.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GraphExecutor_Execute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GraphExecutor_Execute_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.GraphExecutor_Execute_ParamsSpec.$,
    'GraphExecutor_Execute_Params',
    [
      mojo.internal.StructField(
        'inputs', 0,
        0,
        mojo.internal.Map(mojo.internal.String, chromeos.machineLearning.mojom.TensorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputNames', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.GraphExecutor_Execute_Params = class {
  constructor() {
    /** @export { !Object<!string, !chromeos.machineLearning.mojom.Tensor> } */
    this.inputs;
    /** @export { !Array<!string> } */
    this.outputNames;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.GraphExecutor_Execute_ResponseParamsSpec.$,
    'GraphExecutor_Execute_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.ExecuteResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputs', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.TensorSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.GraphExecutor_Execute_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.ExecuteResult } */
    this.result;
    /** @export { (Array<!chromeos.machineLearning.mojom.Tensor>|undefined) } */
    this.outputs;
  }
};

