// chromeos/services/machine_learning/public/mojom/graph_executor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/graph_executor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var tensor$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/tensor.mojom', 'tensor.mojom.js');
  }


  var ExecuteResult = {};
  ExecuteResult.OK = 0;
  ExecuteResult.INPUT_MISSING_ERROR = 1;
  ExecuteResult.UNKNOWN_INPUT_ERROR = 2;
  ExecuteResult.INPUT_TYPE_ERROR = 3;
  ExecuteResult.INPUT_SHAPE_ERROR = 4;
  ExecuteResult.INPUT_FORMAT_ERROR = 5;
  ExecuteResult.OUTPUT_MISSING_ERROR = 6;
  ExecuteResult.UNKNOWN_OUTPUT_ERROR = 7;
  ExecuteResult.DUPLICATE_OUTPUT_ERROR = 8;
  ExecuteResult.EXECUTION_ERROR = 9;
  ExecuteResult.MIN_VALUE = 0;
  ExecuteResult.MAX_VALUE = 9;

  ExecuteResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  ExecuteResult.toKnownEnumValue = function(value) {
    return value;
  };

  ExecuteResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GraphExecutor_Execute_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GraphExecutor_Execute_Params.prototype.initDefaults_ = function() {
    this.inputs = null;
    this.outputNames = null;
  };
  GraphExecutor_Execute_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GraphExecutor_Execute_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GraphExecutor_Execute_Params.inputs
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(tensor$.Tensor), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GraphExecutor_Execute_Params.outputNames
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GraphExecutor_Execute_Params.encodedSize = codec.kStructHeaderSize + 16;

  GraphExecutor_Execute_Params.decode = function(decoder) {
    var packed;
    var val = new GraphExecutor_Execute_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputs =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(tensor$.Tensor));
    val.outputNames =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  GraphExecutor_Execute_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GraphExecutor_Execute_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(tensor$.Tensor), val.inputs);
    encoder.encodeArrayPointer(codec.String, val.outputNames);
  };
  function GraphExecutor_Execute_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GraphExecutor_Execute_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.outputs = null;
  };
  GraphExecutor_Execute_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GraphExecutor_Execute_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GraphExecutor_Execute_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ExecuteResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GraphExecutor_Execute_ResponseParams.outputs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(tensor$.Tensor), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GraphExecutor_Execute_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  GraphExecutor_Execute_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new GraphExecutor_Execute_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(ExecuteResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.outputs =
        decoder.decodeArrayPointer(new codec.PointerTo(tensor$.Tensor));
    return val;
  };

  GraphExecutor_Execute_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GraphExecutor_Execute_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(tensor$.Tensor), val.outputs);
  };
  var kGraphExecutor_Execute_Name = 0;

  function GraphExecutorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(GraphExecutor,
                                                   handleOrPtrInfo);
  }

  function GraphExecutorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        GraphExecutor, associatedInterfacePtrInfo);
  }

  GraphExecutorAssociatedPtr.prototype =
      Object.create(GraphExecutorPtr.prototype);
  GraphExecutorAssociatedPtr.prototype.constructor =
      GraphExecutorAssociatedPtr;

  function GraphExecutorProxy(receiver) {
    this.receiver_ = receiver;
  }
  GraphExecutorPtr.prototype.execute = function() {
    return GraphExecutorProxy.prototype.execute
        .apply(this.ptr.getProxy(), arguments);
  };

  GraphExecutorProxy.prototype.execute = function(inputs, outputNames) {
    var params_ = new GraphExecutor_Execute_Params();
    params_.inputs = inputs;
    params_.outputNames = outputNames;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kGraphExecutor_Execute_Name,
          codec.align(GraphExecutor_Execute_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(GraphExecutor_Execute_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(GraphExecutor_Execute_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function GraphExecutorStub(delegate) {
    this.delegate_ = delegate;
  }
  GraphExecutorStub.prototype.execute = function(inputs, outputNames) {
    return this.delegate_ && this.delegate_.execute && this.delegate_.execute(inputs, outputNames);
  }

  GraphExecutorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  GraphExecutorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kGraphExecutor_Execute_Name:
      var params = reader.decodeStruct(GraphExecutor_Execute_Params);
      this.execute(params.inputs, params.outputNames).then(function(response) {
        var responseParams =
            new GraphExecutor_Execute_ResponseParams();
        responseParams.result = response.result;
        responseParams.outputs = response.outputs;
        var builder = new codec.MessageV1Builder(
            kGraphExecutor_Execute_Name,
            codec.align(GraphExecutor_Execute_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(GraphExecutor_Execute_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateGraphExecutorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kGraphExecutor_Execute_Name:
        if (message.expectsResponse())
          paramsClass = GraphExecutor_Execute_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateGraphExecutorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kGraphExecutor_Execute_Name:
        if (message.isResponse())
          paramsClass = GraphExecutor_Execute_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var GraphExecutor = {
    name: 'chromeos.machine_learning.mojom.GraphExecutor',
    kVersion: 0,
    ptrClass: GraphExecutorPtr,
    proxyClass: GraphExecutorProxy,
    stubClass: GraphExecutorStub,
    validateRequest: validateGraphExecutorRequest,
    validateResponse: validateGraphExecutorResponse,
  };
  GraphExecutorStub.prototype.validator = validateGraphExecutorRequest;
  GraphExecutorProxy.prototype.validator = validateGraphExecutorResponse;
  exports.ExecuteResult = ExecuteResult;
  exports.GraphExecutor = GraphExecutor;
  exports.GraphExecutorPtr = GraphExecutorPtr;
  exports.GraphExecutorAssociatedPtr = GraphExecutorAssociatedPtr;
})();