// chromeos/services/machine_learning/public/mojom/graph_executor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Tensor as chromeos_machineLearning_mojom_Tensor,
  TensorSpec as chromeos_machineLearning_mojom_TensorSpec
} from './tensor.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ExecuteResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ExecuteResult = {
  
  OK: 0,
  INPUT_MISSING_ERROR: 1,
  UNKNOWN_INPUT_ERROR: 2,
  INPUT_TYPE_ERROR: 3,
  INPUT_SHAPE_ERROR: 4,
  INPUT_FORMAT_ERROR: 5,
  OUTPUT_MISSING_ERROR: 6,
  UNKNOWN_OUTPUT_ERROR: 7,
  DUPLICATE_OUTPUT_ERROR: 8,
  EXECUTION_ERROR: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GraphExecutorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.GraphExecutor', scope);
  }
}

/** @interface */
export class GraphExecutorInterface {
  
  /**
   * @param { !Object<!string, !chromeos_machineLearning_mojom_Tensor> } inputs
   * @param { !Array<!string> } outputNames
   * @return {!Promise<{
        result: !ExecuteResult,
        outputs: ?Array<!chromeos_machineLearning_mojom_Tensor>,
   *  }>}
   */

  execute(inputs, outputNames) {}
}

/**
 * @implements { GraphExecutorInterface }
 */
export class GraphExecutorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GraphExecutorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GraphExecutorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GraphExecutorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object<!string, !chromeos_machineLearning_mojom_Tensor> } inputs
   * @param { !Array<!string> } outputNames
   * @return {!Promise<{
        result: !ExecuteResult,
        outputs: ?Array<!chromeos_machineLearning_mojom_Tensor>,
   *  }>}
   */

  execute(
      inputs,
      outputNames) {
    return this.proxy.sendMessage(
        0,
        GraphExecutor_Execute_ParamsSpec.$,
        GraphExecutor_Execute_ResponseParamsSpec.$,
        [
          inputs,
          outputNames
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GraphExecutor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GraphExecutorReceiver {
  /**
   * @param {!GraphExecutorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GraphExecutorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GraphExecutorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GraphExecutorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GraphExecutor_Execute_ParamsSpec.$,
        GraphExecutor_Execute_ResponseParamsSpec.$,
        impl.execute.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GraphExecutor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.GraphExecutor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GraphExecutorRemote}
   */
  static getRemote() {
    let remote = new GraphExecutorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GraphExecutor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GraphExecutorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GraphExecutorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GraphExecutorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.execute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GraphExecutor_Execute_ParamsSpec.$,
        GraphExecutor_Execute_ResponseParamsSpec.$,
        this.execute.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GraphExecutor_Execute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GraphExecutor_Execute_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GraphExecutor_Execute_ParamsSpec.$,
    'GraphExecutor_Execute_Params',
    [
      mojo.internal.StructField(
        'inputs', 0,
        0,
        mojo.internal.Map(mojo.internal.String, chromeos_machineLearning_mojom_TensorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputNames', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GraphExecutor_Execute_Params {
  constructor() {
    /** @type { !Object<!string, !chromeos_machineLearning_mojom_Tensor> } */
    this.inputs;
    /** @type { !Array<!string> } */
    this.outputNames;
  }
}



mojo.internal.Struct(
    GraphExecutor_Execute_ResponseParamsSpec.$,
    'GraphExecutor_Execute_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ExecuteResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputs', 8,
        0,
        mojo.internal.Array(chromeos_machineLearning_mojom_TensorSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GraphExecutor_Execute_ResponseParams {
  constructor() {
    /** @type { !ExecuteResult } */
    this.result;
    /** @type { (Array<!chromeos_machineLearning_mojom_Tensor>|undefined) } */
    this.outputs;
  }
}

