// chromeos/services/machine_learning/public/mojom/handwriting_recognizer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.LoadHandwritingModelResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.LoadHandwritingModelResult = {
  
  OK: 0,
  DEPRECATED_MODEL_SPEC_ERROR: 1,
  LOAD_MODEL_ERROR: 2,
  FEATURE_NOT_SUPPORTED_ERROR: 3,
  LANGUAGE_NOT_SUPPORTED_ERROR: 4,
  FEATURE_DISABLED_BY_USER: 5,
  DLC_DOES_NOT_EXIST: 6,
  DLC_INSTALL_ERROR: 7,
  DLC_GET_PATH_ERROR: 8,
  LOAD_NATIVE_LIB_ERROR: 9,
  LOAD_FUNC_PTR_ERROR: 10,
  LOAD_MODEL_FILES_ERROR: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.HandwritingRecognizer.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.HandwritingRecognizerInterface }
 */
chromeos.machineLearning.mojom.HandwritingRecognizerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognitionQuery } query
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.HandwritingRecognizerResult,
   *  }>}
   */

  recognize(
      query) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ParamsSpec.$,
        chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
        [
          query
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.HandwritingRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.HandwritingRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ParamsSpec.$,
        chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
        impl.recognize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.HandwritingRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.HandwritingRecognizerRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.HandwritingRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recognize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ParamsSpec.$,
        chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
        this.recognize.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.InkPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.InkStrokeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.WritingGuideSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.RecognitionContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognitionQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerInkRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerSegmentationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.InkPointSpec.$,
    'InkPoint',
    [
      mojo.internal.StructField(
        'x', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'y', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        't', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.InkPoint = class {
  constructor() {
    /** @export { !number } */
    this.x;
    /** @export { !number } */
    this.y;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.t;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.InkStrokeSpec.$,
    'InkStroke',
    [
      mojo.internal.StructField(
        'points', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.InkPointSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.InkStroke = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.mojom.InkPoint> } */
    this.points;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.WritingGuideSpec.$,
    'WritingGuide',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.WritingGuide = class {
  constructor() {
    /** @export { !number } */
    this.width;
    /** @export { !number } */
    this.height;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.RecognitionContextSpec.$,
    'RecognitionContext',
    [
      mojo.internal.StructField(
        'writingGuide', 0,
        0,
        chromeos.machineLearning.mojom.WritingGuideSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preContext', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.RecognitionContext = class {
  constructor() {
    /** @export { (chromeos.machineLearning.mojom.WritingGuide|undefined) } */
    this.writingGuide;
    /** @export { (string|undefined) } */
    this.preContext;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognitionQuerySpec.$,
    'HandwritingRecognitionQuery',
    [
      mojo.internal.StructField(
        'ink', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.InkStrokeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        chromeos.machineLearning.mojom.RecognitionContextSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxNumResults', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'returnSegmentation', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognitionQuery = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.mojom.InkStroke> } */
    this.ink;
    /** @export { (chromeos.machineLearning.mojom.RecognitionContext|undefined) } */
    this.context;
    /** @export { !number } */
    this.maxNumResults;
    /** @export { !boolean } */
    this.returnSegmentation;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizerInkRangeSpec.$,
    'HandwritingRecognizerInkRange',
    [
      mojo.internal.StructField(
        'startStroke', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endStroke', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startPoint', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endPoint', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizerInkRange = class {
  constructor() {
    /** @export { !number } */
    this.startStroke;
    /** @export { !number } */
    this.endStroke;
    /** @export { !number } */
    this.startPoint;
    /** @export { !number } */
    this.endPoint;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizerSegmentSpec.$,
    'HandwritingRecognizerSegment',
    [
      mojo.internal.StructField(
        'sublabel', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inkRanges', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.HandwritingRecognizerInkRangeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizerSegment = class {
  constructor() {
    /** @export { !string } */
    this.sublabel;
    /** @export { !Array<!chromeos.machineLearning.mojom.HandwritingRecognizerInkRange> } */
    this.inkRanges;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizerSegmentationSpec.$,
    'HandwritingRecognizerSegmentation',
    [
      mojo.internal.StructField(
        'segments', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.HandwritingRecognizerSegmentSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizerSegmentation = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.mojom.HandwritingRecognizerSegment> } */
    this.segments;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizerCandidateSpec.$,
    'HandwritingRecognizerCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'score', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'segmentation', 16,
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizerSegmentationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizerCandidate = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.score;
    /** @export { (chromeos.machineLearning.mojom.HandwritingRecognizerSegmentation|undefined) } */
    this.segmentation;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerResultSpec.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.HandwritingRecognizerResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizerResultSpec.$,
    'HandwritingRecognizerResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizerResultSpec.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.HandwritingRecognizerCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizerResult = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognizerResult_Status } */
    this.status;
    /** @export { !Array<!chromeos.machineLearning.mojom.HandwritingRecognizerCandidate> } */
    this.candidates;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizerSpecSpec.$,
    'HandwritingRecognizerSpec',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'languagePackPath', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'libraryDlcPath', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[1, 24],[2, 32],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizerSpec = class {
  constructor() {
    /** @export { !string } */
    this.language;
    /** @export { (string|undefined) } */
    this.languagePackPath;
    /** @export { (string|undefined) } */
    this.libraryDlcPath;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ParamsSpec.$,
    'HandwritingRecognizer_Recognize_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        chromeos.machineLearning.mojom.HandwritingRecognitionQuerySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognitionQuery } */
    this.query;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
    'HandwritingRecognizer_Recognize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizerResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.HandwritingRecognizer_Recognize_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognizerResult } */
    this.result;
  }
};

