// chromeos/services/machine_learning/public/mojom/handwriting_recognizer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/handwriting_recognizer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var LoadHandwritingModelResult = {};
  LoadHandwritingModelResult.OK = 0;
  LoadHandwritingModelResult.DEPRECATED_MODEL_SPEC_ERROR = 1;
  LoadHandwritingModelResult.LOAD_MODEL_ERROR = 2;
  LoadHandwritingModelResult.FEATURE_NOT_SUPPORTED_ERROR = 3;
  LoadHandwritingModelResult.LANGUAGE_NOT_SUPPORTED_ERROR = 4;
  LoadHandwritingModelResult.FEATURE_DISABLED_BY_USER = 5;
  LoadHandwritingModelResult.DLC_DOES_NOT_EXIST = 6;
  LoadHandwritingModelResult.DLC_INSTALL_ERROR = 7;
  LoadHandwritingModelResult.DLC_GET_PATH_ERROR = 8;
  LoadHandwritingModelResult.LOAD_NATIVE_LIB_ERROR = 9;
  LoadHandwritingModelResult.LOAD_FUNC_PTR_ERROR = 10;
  LoadHandwritingModelResult.LOAD_MODEL_FILES_ERROR = 11;
  LoadHandwritingModelResult.MIN_VALUE = 0;
  LoadHandwritingModelResult.MAX_VALUE = 11;

  LoadHandwritingModelResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  LoadHandwritingModelResult.toKnownEnumValue = function(value) {
    return value;
  };

  LoadHandwritingModelResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function InkPoint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InkPoint.prototype.initDefaults_ = function() {
    this.x = 0;
    this.y = 0;
    this.t = null;
  };
  InkPoint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InkPoint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate InkPoint.t
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InkPoint.encodedSize = codec.kStructHeaderSize + 16;

  InkPoint.decode = function(decoder) {
    var packed;
    var val = new InkPoint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.x =
        decoder.decodeStruct(codec.Float);
    val.y =
        decoder.decodeStruct(codec.Float);
    val.t =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  InkPoint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InkPoint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.x);
    encoder.encodeStruct(codec.Float, val.y);
    encoder.encodeStructPointer(time$.TimeDelta, val.t);
  };
  function InkStroke(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InkStroke.prototype.initDefaults_ = function() {
    this.points = null;
  };
  InkStroke.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InkStroke.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InkStroke.points
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(InkPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InkStroke.encodedSize = codec.kStructHeaderSize + 8;

  InkStroke.decode = function(decoder) {
    var packed;
    var val = new InkStroke();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.points =
        decoder.decodeArrayPointer(new codec.PointerTo(InkPoint));
    return val;
  };

  InkStroke.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InkStroke.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(InkPoint), val.points);
  };
  function WritingGuide(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WritingGuide.prototype.initDefaults_ = function() {
    this.width = 0;
    this.height = 0;
  };
  WritingGuide.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WritingGuide.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WritingGuide.encodedSize = codec.kStructHeaderSize + 8;

  WritingGuide.decode = function(decoder) {
    var packed;
    var val = new WritingGuide();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.width =
        decoder.decodeStruct(codec.Float);
    val.height =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  WritingGuide.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WritingGuide.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.width);
    encoder.encodeStruct(codec.Float, val.height);
  };
  function RecognitionContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RecognitionContext.prototype.initDefaults_ = function() {
    this.writingGuide = null;
    this.preContext = null;
  };
  RecognitionContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RecognitionContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RecognitionContext.writingGuide
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WritingGuide, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RecognitionContext.preContext
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RecognitionContext.encodedSize = codec.kStructHeaderSize + 16;

  RecognitionContext.decode = function(decoder) {
    var packed;
    var val = new RecognitionContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.writingGuide =
        decoder.decodeStructPointer(WritingGuide);
    val.preContext =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RecognitionContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RecognitionContext.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WritingGuide, val.writingGuide);
    encoder.encodeStruct(codec.String, val.preContext);
  };
  function HandwritingRecognitionQuery(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognitionQuery.prototype.initDefaults_ = function() {
    this.ink = null;
    this.context = null;
    this.maxNumResults = 0;
    this.returnSegmentation = false;
  };
  HandwritingRecognitionQuery.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognitionQuery.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionQuery.ink
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(InkStroke), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionQuery.context
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, RecognitionContext, true);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  HandwritingRecognitionQuery.encodedSize = codec.kStructHeaderSize + 24;

  HandwritingRecognitionQuery.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognitionQuery();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ink =
        decoder.decodeArrayPointer(new codec.PointerTo(InkStroke));
    val.context =
        decoder.decodeStructPointer(RecognitionContext);
    val.maxNumResults =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.returnSegmentation = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HandwritingRecognitionQuery.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognitionQuery.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(InkStroke), val.ink);
    encoder.encodeStructPointer(RecognitionContext, val.context);
    encoder.encodeStruct(codec.Uint32, val.maxNumResults);
    packed = 0;
    packed |= (val.returnSegmentation & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HandwritingRecognizerInkRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizerInkRange.prototype.initDefaults_ = function() {
    this.startStroke = 0;
    this.endStroke = 0;
    this.startPoint = 0;
    this.endPoint = 0;
  };
  HandwritingRecognizerInkRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizerInkRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  HandwritingRecognizerInkRange.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingRecognizerInkRange.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizerInkRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startStroke =
        decoder.decodeStruct(codec.Uint32);
    val.endStroke =
        decoder.decodeStruct(codec.Uint32);
    val.startPoint =
        decoder.decodeStruct(codec.Uint32);
    val.endPoint =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  HandwritingRecognizerInkRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizerInkRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.startStroke);
    encoder.encodeStruct(codec.Uint32, val.endStroke);
    encoder.encodeStruct(codec.Uint32, val.startPoint);
    encoder.encodeStruct(codec.Uint32, val.endPoint);
  };
  function HandwritingRecognizerSegment(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizerSegment.prototype.initDefaults_ = function() {
    this.sublabel = null;
    this.inkRanges = null;
  };
  HandwritingRecognizerSegment.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizerSegment.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerSegment.sublabel
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerSegment.inkRanges
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(HandwritingRecognizerInkRange), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizerSegment.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingRecognizerSegment.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizerSegment();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sublabel =
        decoder.decodeStruct(codec.String);
    val.inkRanges =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingRecognizerInkRange));
    return val;
  };

  HandwritingRecognizerSegment.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizerSegment.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sublabel);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingRecognizerInkRange), val.inkRanges);
  };
  function HandwritingRecognizerSegmentation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizerSegmentation.prototype.initDefaults_ = function() {
    this.segments = null;
  };
  HandwritingRecognizerSegmentation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizerSegmentation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerSegmentation.segments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(HandwritingRecognizerSegment), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizerSegmentation.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognizerSegmentation.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizerSegmentation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.segments =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingRecognizerSegment));
    return val;
  };

  HandwritingRecognizerSegmentation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizerSegmentation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingRecognizerSegment), val.segments);
  };
  function HandwritingRecognizerCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizerCandidate.prototype.initDefaults_ = function() {
    this.text = null;
    this.score = 0;
    this.segmentation = null;
  };
  HandwritingRecognizerCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizerCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerCandidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate HandwritingRecognizerCandidate.segmentation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, HandwritingRecognizerSegmentation, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizerCandidate.encodedSize = codec.kStructHeaderSize + 24;

  HandwritingRecognizerCandidate.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizerCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.score =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.segmentation =
        decoder.decodeStructPointer(HandwritingRecognizerSegmentation);
    return val;
  };

  HandwritingRecognizerCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizerCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Float, val.score);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(HandwritingRecognizerSegmentation, val.segmentation);
  };
  function HandwritingRecognizerResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  HandwritingRecognizerResult.Status = {};
  HandwritingRecognizerResult.Status.OK = 0;
  HandwritingRecognizerResult.Status.ERROR = 1;
  HandwritingRecognizerResult.Status.MIN_VALUE = 0;
  HandwritingRecognizerResult.Status.MAX_VALUE = 1;

  HandwritingRecognizerResult.Status.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  HandwritingRecognizerResult.Status.toKnownEnumValue = function(value) {
    return value;
  };

  HandwritingRecognizerResult.Status.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  HandwritingRecognizerResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.candidates = null;
  };
  HandwritingRecognizerResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizerResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, HandwritingRecognizerResult.Status);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerResult.candidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(HandwritingRecognizerCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizerResult.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingRecognizerResult.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizerResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(HandwritingRecognizerResult.Status));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.candidates =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingRecognizerCandidate));
    return val;
  };

  HandwritingRecognizerResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizerResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingRecognizerCandidate), val.candidates);
  };
  function HandwritingRecognizerSpec(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizerSpec.prototype.initDefaults_ = function() {
    this.language = null;
    this.languagePackPath = null;
    this.libraryDlcPath = null;
  };
  HandwritingRecognizerSpec.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizerSpec.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 1, numBytes: 24},
      {version: 2, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizerSpec.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check HandwritingRecognizerSpec.languagePackPath
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate HandwritingRecognizerSpec.languagePackPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;



    // version check HandwritingRecognizerSpec.libraryDlcPath
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate HandwritingRecognizerSpec.libraryDlcPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizerSpec.encodedSize = codec.kStructHeaderSize + 24;

  HandwritingRecognizerSpec.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizerSpec();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.language =
        decoder.decodeStruct(codec.String);
    if (version >= 1) {
      val.languagePackPath =
          decoder.decodeStruct(codec.String);
    } else {
      val.languagePackPath = null;
    }
    if (version >= 2) {
      val.libraryDlcPath =
          decoder.decodeStruct(codec.String);
    } else {
      val.libraryDlcPath = null;
    }
    return val;
  };

  HandwritingRecognizerSpec.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizerSpec.encodedSize);
    encoder.writeUint32(2);
    encoder.encodeStruct(codec.String, val.language);
    encoder.encodeStruct(codec.String, val.languagePackPath);
    encoder.encodeStruct(codec.String, val.libraryDlcPath);
  };
  function HandwritingRecognizer_Recognize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizer_Recognize_Params.prototype.initDefaults_ = function() {
    this.query = null;
  };
  HandwritingRecognizer_Recognize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizer_Recognize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizer_Recognize_Params.query
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HandwritingRecognitionQuery, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizer_Recognize_Params.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognizer_Recognize_Params.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizer_Recognize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.query =
        decoder.decodeStructPointer(HandwritingRecognitionQuery);
    return val;
  };

  HandwritingRecognizer_Recognize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizer_Recognize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HandwritingRecognitionQuery, val.query);
  };
  function HandwritingRecognizer_Recognize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizer_Recognize_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  HandwritingRecognizer_Recognize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizer_Recognize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizer_Recognize_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HandwritingRecognizerResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizer_Recognize_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognizer_Recognize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizer_Recognize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(HandwritingRecognizerResult);
    return val;
  };

  HandwritingRecognizer_Recognize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizer_Recognize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HandwritingRecognizerResult, val.result);
  };
  var kHandwritingRecognizer_Recognize_Name = 0;

  function HandwritingRecognizerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HandwritingRecognizer,
                                                   handleOrPtrInfo);
  }

  function HandwritingRecognizerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HandwritingRecognizer, associatedInterfacePtrInfo);
  }

  HandwritingRecognizerAssociatedPtr.prototype =
      Object.create(HandwritingRecognizerPtr.prototype);
  HandwritingRecognizerAssociatedPtr.prototype.constructor =
      HandwritingRecognizerAssociatedPtr;

  function HandwritingRecognizerProxy(receiver) {
    this.receiver_ = receiver;
  }
  HandwritingRecognizerPtr.prototype.recognize = function() {
    return HandwritingRecognizerProxy.prototype.recognize
        .apply(this.ptr.getProxy(), arguments);
  };

  HandwritingRecognizerProxy.prototype.recognize = function(query) {
    var params_ = new HandwritingRecognizer_Recognize_Params();
    params_.query = query;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHandwritingRecognizer_Recognize_Name,
          codec.align(HandwritingRecognizer_Recognize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HandwritingRecognizer_Recognize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HandwritingRecognizer_Recognize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function HandwritingRecognizerStub(delegate) {
    this.delegate_ = delegate;
  }
  HandwritingRecognizerStub.prototype.recognize = function(query) {
    return this.delegate_ && this.delegate_.recognize && this.delegate_.recognize(query);
  }

  HandwritingRecognizerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  HandwritingRecognizerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHandwritingRecognizer_Recognize_Name:
      var params = reader.decodeStruct(HandwritingRecognizer_Recognize_Params);
      this.recognize(params.query).then(function(response) {
        var responseParams =
            new HandwritingRecognizer_Recognize_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHandwritingRecognizer_Recognize_Name,
            codec.align(HandwritingRecognizer_Recognize_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HandwritingRecognizer_Recognize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateHandwritingRecognizerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHandwritingRecognizer_Recognize_Name:
        if (message.expectsResponse())
          paramsClass = HandwritingRecognizer_Recognize_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHandwritingRecognizerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kHandwritingRecognizer_Recognize_Name:
        if (message.isResponse())
          paramsClass = HandwritingRecognizer_Recognize_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var HandwritingRecognizer = {
    name: 'chromeos.machine_learning.mojom.HandwritingRecognizer',
    kVersion: 0,
    ptrClass: HandwritingRecognizerPtr,
    proxyClass: HandwritingRecognizerProxy,
    stubClass: HandwritingRecognizerStub,
    validateRequest: validateHandwritingRecognizerRequest,
    validateResponse: validateHandwritingRecognizerResponse,
  };
  HandwritingRecognizerStub.prototype.validator = validateHandwritingRecognizerRequest;
  HandwritingRecognizerProxy.prototype.validator = validateHandwritingRecognizerResponse;
  exports.LoadHandwritingModelResult = LoadHandwritingModelResult;
  exports.InkPoint = InkPoint;
  exports.InkStroke = InkStroke;
  exports.WritingGuide = WritingGuide;
  exports.RecognitionContext = RecognitionContext;
  exports.HandwritingRecognitionQuery = HandwritingRecognitionQuery;
  exports.HandwritingRecognizerInkRange = HandwritingRecognizerInkRange;
  exports.HandwritingRecognizerSegment = HandwritingRecognizerSegment;
  exports.HandwritingRecognizerSegmentation = HandwritingRecognizerSegmentation;
  exports.HandwritingRecognizerCandidate = HandwritingRecognizerCandidate;
  exports.HandwritingRecognizerResult = HandwritingRecognizerResult;
  exports.HandwritingRecognizerSpec = HandwritingRecognizerSpec;
  exports.HandwritingRecognizer = HandwritingRecognizer;
  exports.HandwritingRecognizerPtr = HandwritingRecognizerPtr;
  exports.HandwritingRecognizerAssociatedPtr = HandwritingRecognizerAssociatedPtr;
})();