// chromeos/services/machine_learning/public/mojom/handwriting_recognizer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LoadHandwritingModelResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LoadHandwritingModelResult = {
  
  OK: 0,
  DEPRECATED_MODEL_SPEC_ERROR: 1,
  LOAD_MODEL_ERROR: 2,
  FEATURE_NOT_SUPPORTED_ERROR: 3,
  LANGUAGE_NOT_SUPPORTED_ERROR: 4,
  FEATURE_DISABLED_BY_USER: 5,
  DLC_DOES_NOT_EXIST: 6,
  DLC_INSTALL_ERROR: 7,
  DLC_GET_PATH_ERROR: 8,
  LOAD_NATIVE_LIB_ERROR: 9,
  LOAD_FUNC_PTR_ERROR: 10,
  LOAD_MODEL_FILES_ERROR: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HandwritingRecognizerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.HandwritingRecognizer', scope);
  }
}

/** @interface */
export class HandwritingRecognizerInterface {
  
  /**
   * @param { !HandwritingRecognitionQuery } query
   * @return {!Promise<{
        result: !HandwritingRecognizerResult,
   *  }>}
   */

  recognize(query) {}
}

/**
 * @implements { HandwritingRecognizerInterface }
 */
export class HandwritingRecognizerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HandwritingRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HandwritingRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HandwritingRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !HandwritingRecognitionQuery } query
   * @return {!Promise<{
        result: !HandwritingRecognizerResult,
   *  }>}
   */

  recognize(
      query) {
    return this.proxy.sendMessage(
        0,
        HandwritingRecognizer_Recognize_ParamsSpec.$,
        HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
        [
          query
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HandwritingRecognizerReceiver {
  /**
   * @param {!HandwritingRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HandwritingRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HandwritingRecognizer_Recognize_ParamsSpec.$,
        HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
        impl.recognize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HandwritingRecognizer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.HandwritingRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HandwritingRecognizerRemote}
   */
  static getRemote() {
    let remote = new HandwritingRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HandwritingRecognizerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recognize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HandwritingRecognizer_Recognize_ParamsSpec.$,
        HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
        this.recognize.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InkPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InkStrokeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WritingGuideSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RecognitionContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognitionQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizerInkRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizerSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizerSegmentationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizerCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizerResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizerSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizer_Recognize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizer_Recognize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InkPointSpec.$,
    'InkPoint',
    [
      mojo.internal.StructField(
        'x', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'y', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        't', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InkPoint {
  constructor() {
    /** @type { !number } */
    this.x;
    /** @type { !number } */
    this.y;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.t;
  }
}



mojo.internal.Struct(
    InkStrokeSpec.$,
    'InkStroke',
    [
      mojo.internal.StructField(
        'points', 0,
        0,
        mojo.internal.Array(InkPointSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InkStroke {
  constructor() {
    /** @type { !Array<!InkPoint> } */
    this.points;
  }
}



mojo.internal.Struct(
    WritingGuideSpec.$,
    'WritingGuide',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WritingGuide {
  constructor() {
    /** @type { !number } */
    this.width;
    /** @type { !number } */
    this.height;
  }
}



mojo.internal.Struct(
    RecognitionContextSpec.$,
    'RecognitionContext',
    [
      mojo.internal.StructField(
        'writingGuide', 0,
        0,
        WritingGuideSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preContext', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RecognitionContext {
  constructor() {
    /** @type { (WritingGuide|undefined) } */
    this.writingGuide;
    /** @type { (string|undefined) } */
    this.preContext;
  }
}



mojo.internal.Struct(
    HandwritingRecognitionQuerySpec.$,
    'HandwritingRecognitionQuery',
    [
      mojo.internal.StructField(
        'ink', 0,
        0,
        mojo.internal.Array(InkStrokeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        RecognitionContextSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxNumResults', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'returnSegmentation', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class HandwritingRecognitionQuery {
  constructor() {
    /** @type { !Array<!InkStroke> } */
    this.ink;
    /** @type { (RecognitionContext|undefined) } */
    this.context;
    /** @type { !number } */
    this.maxNumResults;
    /** @type { !boolean } */
    this.returnSegmentation;
  }
}



mojo.internal.Struct(
    HandwritingRecognizerInkRangeSpec.$,
    'HandwritingRecognizerInkRange',
    [
      mojo.internal.StructField(
        'startStroke', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endStroke', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startPoint', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endPoint', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingRecognizerInkRange {
  constructor() {
    /** @type { !number } */
    this.startStroke;
    /** @type { !number } */
    this.endStroke;
    /** @type { !number } */
    this.startPoint;
    /** @type { !number } */
    this.endPoint;
  }
}



mojo.internal.Struct(
    HandwritingRecognizerSegmentSpec.$,
    'HandwritingRecognizerSegment',
    [
      mojo.internal.StructField(
        'sublabel', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inkRanges', 8,
        0,
        mojo.internal.Array(HandwritingRecognizerInkRangeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingRecognizerSegment {
  constructor() {
    /** @type { !string } */
    this.sublabel;
    /** @type { !Array<!HandwritingRecognizerInkRange> } */
    this.inkRanges;
  }
}



mojo.internal.Struct(
    HandwritingRecognizerSegmentationSpec.$,
    'HandwritingRecognizerSegmentation',
    [
      mojo.internal.StructField(
        'segments', 0,
        0,
        mojo.internal.Array(HandwritingRecognizerSegmentSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HandwritingRecognizerSegmentation {
  constructor() {
    /** @type { !Array<!HandwritingRecognizerSegment> } */
    this.segments;
  }
}



mojo.internal.Struct(
    HandwritingRecognizerCandidateSpec.$,
    'HandwritingRecognizerCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'score', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'segmentation', 16,
        0,
        HandwritingRecognizerSegmentationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class HandwritingRecognizerCandidate {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.score;
    /** @type { (HandwritingRecognizerSegmentation|undefined) } */
    this.segmentation;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HandwritingRecognizerResult_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HandwritingRecognizerResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    HandwritingRecognizerResultSpec.$,
    'HandwritingRecognizerResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        HandwritingRecognizerResult_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(HandwritingRecognizerCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingRecognizerResult {
  constructor() {
    /** @type { !HandwritingRecognizerResult_Status } */
    this.status;
    /** @type { !Array<!HandwritingRecognizerCandidate> } */
    this.candidates;
  }
}



mojo.internal.Struct(
    HandwritingRecognizerSpecSpec.$,
    'HandwritingRecognizerSpec',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'languagePackPath', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'libraryDlcPath', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        2,
      ),
    ],
    [[0, 16],[1, 24],[2, 32],]);



/**
 * @record
 */
export class HandwritingRecognizerSpec {
  constructor() {
    /** @type { !string } */
    this.language;
    /** @type { (string|undefined) } */
    this.languagePackPath;
    /** @type { (string|undefined) } */
    this.libraryDlcPath;
  }
}



mojo.internal.Struct(
    HandwritingRecognizer_Recognize_ParamsSpec.$,
    'HandwritingRecognizer_Recognize_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        HandwritingRecognitionQuerySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HandwritingRecognizer_Recognize_Params {
  constructor() {
    /** @type { !HandwritingRecognitionQuery } */
    this.query;
  }
}



mojo.internal.Struct(
    HandwritingRecognizer_Recognize_ResponseParamsSpec.$,
    'HandwritingRecognizer_Recognize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        HandwritingRecognizerResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HandwritingRecognizer_Recognize_ResponseParams {
  constructor() {
    /** @type { !HandwritingRecognizerResult } */
    this.result;
  }
}

