// chromeos/services/machine_learning/public/mojom/heatmap_palm_rejection.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResult = {
  
  OK: 0,
  UNKNOWN_ERROR: 1,
  LOAD_MODEL_ERROR: 2,
  CREATE_GRAPH_EXECUTOR_ERROR: 3,
  OPEN_DEVICE_ERROR: 4,
  WATCH_DEVICE_ERROR: 5,
  FEATURE_NOT_SUPPORTED_ERROR: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.HeatmapPalmRejectionClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.HeatmapPalmRejectionClientInterface }
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.HeatmapPalmRejectionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.HeatmapProcessedEvent } event
   */

  onHeatmapProcessedEvent(
      event) {
    this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HeatmapPalmRejectionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClientReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
        null,
        impl.onHeatmapProcessedEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.HeatmapPalmRejectionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HeatmapPalmRejectionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHeatmapProcessedEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
        null,
        this.onHeatmapProcessedEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HeatmapProcessedEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.CropHeatmapSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.HeatmapPalmRejectionConfigSpec.$,
    'HeatmapPalmRejectionConfig',
    [
      mojo.internal.StructField(
        'tfModelPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'heatmapHidrawDevice', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputNode', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputNode', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'palmThreshold', 24,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cropHeatmap', 32,
        0,
        chromeos.machineLearning.mojom.CropHeatmapSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[1, 40],[3, 48],]);





/** @record */
chromeos.machineLearning.mojom.HeatmapPalmRejectionConfig = class {
  constructor() {
    /** @export { !string } */
    this.tfModelPath;
    /** @export { !string } */
    this.heatmapHidrawDevice;
    /** @export { !number } */
    this.inputNode;
    /** @export { !number } */
    this.outputNode;
    /** @export { !number } */
    this.palmThreshold;
    /** @export { (chromeos.machineLearning.mojom.CropHeatmap|undefined) } */
    this.cropHeatmap;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HeatmapProcessedEventSpec.$,
    'HeatmapProcessedEvent',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPalm', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.HeatmapProcessedEvent = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.timestamp;
    /** @export { !boolean } */
    this.isPalm;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.CropHeatmapSpec.$,
    'CropHeatmap',
    [
      mojo.internal.StructField(
        'bottomCrop', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'leftCrop', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rightCrop', 2,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topCrop', 3,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.CropHeatmap = class {
  constructor() {
    /** @export { !number } */
    this.bottomCrop;
    /** @export { !number } */
    this.leftCrop;
    /** @export { !number } */
    this.rightCrop;
    /** @export { !number } */
    this.topCrop;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
    'HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        chromeos.machineLearning.mojom.HeatmapProcessedEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HeatmapProcessedEvent } */
    this.event;
  }
};

