// chromeos/services/machine_learning/public/mojom/heatmap_palm_rejection.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/heatmap_palm_rejection.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var LoadHeatmapPalmRejectionResult = {};
  LoadHeatmapPalmRejectionResult.OK = 0;
  LoadHeatmapPalmRejectionResult.UNKNOWN_ERROR = 1;
  LoadHeatmapPalmRejectionResult.LOAD_MODEL_ERROR = 2;
  LoadHeatmapPalmRejectionResult.CREATE_GRAPH_EXECUTOR_ERROR = 3;
  LoadHeatmapPalmRejectionResult.OPEN_DEVICE_ERROR = 4;
  LoadHeatmapPalmRejectionResult.WATCH_DEVICE_ERROR = 5;
  LoadHeatmapPalmRejectionResult.FEATURE_NOT_SUPPORTED_ERROR = 6;
  LoadHeatmapPalmRejectionResult.MIN_VALUE = 0;
  LoadHeatmapPalmRejectionResult.MAX_VALUE = 6;
  LoadHeatmapPalmRejectionResult.DEFAULT_VALUE = 1;

  LoadHeatmapPalmRejectionResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  LoadHeatmapPalmRejectionResult.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  LoadHeatmapPalmRejectionResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function HeatmapPalmRejectionConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HeatmapPalmRejectionConfig.prototype.initDefaults_ = function() {
    this.tfModelPath = null;
    this.heatmapHidrawDevice = null;
    this.inputNode = 0;
    this.outputNode = 0;
    this.palmThreshold = 0;
    this.cropHeatmap = null;
  };
  HeatmapPalmRejectionConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HeatmapPalmRejectionConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 1, numBytes: 40},
      {version: 3, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeatmapPalmRejectionConfig.tfModelPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeatmapPalmRejectionConfig.heatmapHidrawDevice
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;






    // version check HeatmapPalmRejectionConfig.cropHeatmap
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate HeatmapPalmRejectionConfig.cropHeatmap
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, CropHeatmap, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HeatmapPalmRejectionConfig.encodedSize = codec.kStructHeaderSize + 40;

  HeatmapPalmRejectionConfig.decode = function(decoder) {
    var packed;
    var val = new HeatmapPalmRejectionConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tfModelPath =
        decoder.decodeStruct(codec.String);
    val.heatmapHidrawDevice =
        decoder.decodeStruct(codec.String);
    val.inputNode =
        decoder.decodeStruct(codec.Uint32);
    val.outputNode =
        decoder.decodeStruct(codec.Uint32);
    if (version >= 1) {
      val.palmThreshold =
          decoder.decodeStruct(codec.Double);
    } else {
      val.palmThreshold = null;
    }
    if (version >= 3) {
      val.cropHeatmap =
          decoder.decodeStructPointer(CropHeatmap);
    } else {
      val.cropHeatmap = null;
    }
    return val;
  };

  HeatmapPalmRejectionConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HeatmapPalmRejectionConfig.encodedSize);
    encoder.writeUint32(3);
    encoder.encodeStruct(codec.String, val.tfModelPath);
    encoder.encodeStruct(codec.String, val.heatmapHidrawDevice);
    encoder.encodeStruct(codec.Uint32, val.inputNode);
    encoder.encodeStruct(codec.Uint32, val.outputNode);
    encoder.encodeStruct(codec.Double, val.palmThreshold);
    encoder.encodeStructPointer(CropHeatmap, val.cropHeatmap);
  };
  function HeatmapProcessedEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HeatmapProcessedEvent.prototype.initDefaults_ = function() {
    this.timestamp = null;
    this.isPalm = false;
  };
  HeatmapProcessedEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HeatmapProcessedEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeatmapProcessedEvent.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HeatmapProcessedEvent.encodedSize = codec.kStructHeaderSize + 16;

  HeatmapProcessedEvent.decode = function(decoder) {
    var packed;
    var val = new HeatmapProcessedEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timestamp =
        decoder.decodeStructPointer(time$.Time);
    packed = decoder.readUint8();
    val.isPalm = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HeatmapProcessedEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HeatmapProcessedEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.timestamp);
    packed = 0;
    packed |= (val.isPalm & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CropHeatmap(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CropHeatmap.prototype.initDefaults_ = function() {
    this.bottomCrop = 0;
    this.leftCrop = 0;
    this.rightCrop = 0;
    this.topCrop = 0;
  };
  CropHeatmap.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CropHeatmap.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  CropHeatmap.encodedSize = codec.kStructHeaderSize + 8;

  CropHeatmap.decode = function(decoder) {
    var packed;
    var val = new CropHeatmap();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bottomCrop =
        decoder.decodeStruct(codec.Uint8);
    val.leftCrop =
        decoder.decodeStruct(codec.Uint8);
    val.rightCrop =
        decoder.decodeStruct(codec.Uint8);
    val.topCrop =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CropHeatmap.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CropHeatmap.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint8, val.bottomCrop);
    encoder.encodeStruct(codec.Uint8, val.leftCrop);
    encoder.encodeStruct(codec.Uint8, val.rightCrop);
    encoder.encodeStruct(codec.Uint8, val.topCrop);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HeatmapProcessedEvent, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.decode = function(decoder) {
    var packed;
    var val = new HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(HeatmapProcessedEvent);
    return val;
  };

  HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HeatmapProcessedEvent, val.event);
  };
  var kHeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Name = 0;

  function HeatmapPalmRejectionClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HeatmapPalmRejectionClient,
                                                   handleOrPtrInfo);
  }

  function HeatmapPalmRejectionClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HeatmapPalmRejectionClient, associatedInterfacePtrInfo);
  }

  HeatmapPalmRejectionClientAssociatedPtr.prototype =
      Object.create(HeatmapPalmRejectionClientPtr.prototype);
  HeatmapPalmRejectionClientAssociatedPtr.prototype.constructor =
      HeatmapPalmRejectionClientAssociatedPtr;

  function HeatmapPalmRejectionClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  HeatmapPalmRejectionClientPtr.prototype.onHeatmapProcessedEvent = function() {
    return HeatmapPalmRejectionClientProxy.prototype.onHeatmapProcessedEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  HeatmapPalmRejectionClientProxy.prototype.onHeatmapProcessedEvent = function(event) {
    var params_ = new HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kHeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Name,
        codec.align(HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params.encodedSize));
    builder.encodeStruct(HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function HeatmapPalmRejectionClientStub(delegate) {
    this.delegate_ = delegate;
  }
  HeatmapPalmRejectionClientStub.prototype.onHeatmapProcessedEvent = function(event) {
    return this.delegate_ && this.delegate_.onHeatmapProcessedEvent && this.delegate_.onHeatmapProcessedEvent(event);
  }

  HeatmapPalmRejectionClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Name:
      var params = reader.decodeStruct(HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params);
      this.onHeatmapProcessedEvent(params.event);
      return true;
    default:
      return false;
    }
  };

  HeatmapPalmRejectionClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateHeatmapPalmRejectionClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHeatmapPalmRejectionClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var HeatmapPalmRejectionClient = {
    name: 'chromeos.machine_learning.mojom.HeatmapPalmRejectionClient',
    kVersion: 0,
    ptrClass: HeatmapPalmRejectionClientPtr,
    proxyClass: HeatmapPalmRejectionClientProxy,
    stubClass: HeatmapPalmRejectionClientStub,
    validateRequest: validateHeatmapPalmRejectionClientRequest,
    validateResponse: null,
  };
  HeatmapPalmRejectionClientStub.prototype.validator = validateHeatmapPalmRejectionClientRequest;
  HeatmapPalmRejectionClientProxy.prototype.validator = null;
  exports.LoadHeatmapPalmRejectionResult = LoadHeatmapPalmRejectionResult;
  exports.HeatmapPalmRejectionConfig = HeatmapPalmRejectionConfig;
  exports.HeatmapProcessedEvent = HeatmapProcessedEvent;
  exports.CropHeatmap = CropHeatmap;
  exports.HeatmapPalmRejectionClient = HeatmapPalmRejectionClient;
  exports.HeatmapPalmRejectionClientPtr = HeatmapPalmRejectionClientPtr;
  exports.HeatmapPalmRejectionClientAssociatedPtr = HeatmapPalmRejectionClientAssociatedPtr;
})();