// chromeos/services/machine_learning/public/mojom/heatmap_palm_rejection.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LoadHeatmapPalmRejectionResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LoadHeatmapPalmRejectionResult = {
  
  OK: 0,
  UNKNOWN_ERROR: 1,
  LOAD_MODEL_ERROR: 2,
  CREATE_GRAPH_EXECUTOR_ERROR: 3,
  OPEN_DEVICE_ERROR: 4,
  WATCH_DEVICE_ERROR: 5,
  FEATURE_NOT_SUPPORTED_ERROR: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HeatmapPalmRejectionClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.HeatmapPalmRejectionClient', scope);
  }
}

/** @interface */
export class HeatmapPalmRejectionClientInterface {
  
  /**
   * @param { !HeatmapProcessedEvent } event
   */

  onHeatmapProcessedEvent(event) {}
}

/**
 * @implements { HeatmapPalmRejectionClientInterface }
 */
export class HeatmapPalmRejectionClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HeatmapPalmRejectionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HeatmapPalmRejectionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HeatmapPalmRejectionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !HeatmapProcessedEvent } event
   */

  onHeatmapProcessedEvent(
      event) {
    this.proxy.sendMessage(
        0,
        HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HeatmapPalmRejectionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HeatmapPalmRejectionClientReceiver {
  /**
   * @param {!HeatmapPalmRejectionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HeatmapPalmRejectionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HeatmapPalmRejectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeatmapPalmRejectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
        null,
        impl.onHeatmapProcessedEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HeatmapPalmRejectionClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.HeatmapPalmRejectionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HeatmapPalmRejectionClientRemote}
   */
  static getRemote() {
    let remote = new HeatmapPalmRejectionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HeatmapPalmRejectionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HeatmapPalmRejectionClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HeatmapPalmRejectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeatmapPalmRejectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHeatmapProcessedEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
        null,
        this.onHeatmapProcessedEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeatmapPalmRejectionConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeatmapProcessedEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CropHeatmapSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HeatmapPalmRejectionConfigSpec.$,
    'HeatmapPalmRejectionConfig',
    [
      mojo.internal.StructField(
        'tfModelPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'heatmapHidrawDevice', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputNode', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputNode', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'palmThreshold', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'cropHeatmap', 32,
        0,
        CropHeatmapSpec.$,
        null,
        true /* nullable */,
        3,
      ),
    ],
    [[0, 32],[1, 40],[3, 48],]);



/**
 * @record
 */
export class HeatmapPalmRejectionConfig {
  constructor() {
    /** @type { !string } */
    this.tfModelPath;
    /** @type { !string } */
    this.heatmapHidrawDevice;
    /** @type { !number } */
    this.inputNode;
    /** @type { !number } */
    this.outputNode;
    /** @type { !number } */
    this.palmThreshold;
    /** @type { (CropHeatmap|undefined) } */
    this.cropHeatmap;
  }
}



mojo.internal.Struct(
    HeatmapProcessedEventSpec.$,
    'HeatmapProcessedEvent',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPalm', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HeatmapProcessedEvent {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.timestamp;
    /** @type { !boolean } */
    this.isPalm;
  }
}



mojo.internal.Struct(
    CropHeatmapSpec.$,
    'CropHeatmap',
    [
      mojo.internal.StructField(
        'bottomCrop', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'leftCrop', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rightCrop', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topCrop', 3,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CropHeatmap {
  constructor() {
    /** @type { !number } */
    this.bottomCrop;
    /** @type { !number } */
    this.leftCrop;
    /** @type { !number } */
    this.rightCrop;
    /** @type { !number } */
    this.topCrop;
  }
}



mojo.internal.Struct(
    HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_ParamsSpec.$,
    'HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        HeatmapProcessedEventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HeatmapPalmRejectionClient_OnHeatmapProcessedEvent_Params {
  constructor() {
    /** @type { !HeatmapProcessedEvent } */
    this.event;
  }
}

