// chromeos/services/machine_learning/public/mojom/image_content_annotation.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.ImageContentAnnotator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.ImageContentAnnotatorInterface }
 */
chromeos.machineLearning.mojom.ImageContentAnnotatorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } rgbBytes
   * @param { !number } width
   * @param { !number } height
   * @param { !number } lineStride
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.ImageAnnotationResult,
   *  }>}
   */

  annotateRawImage(
      rgbBytes,
      width,
      height,
      lineStride) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
        [
          rgbBytes,
          width,
          height,
          lineStride
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } encodedImage
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.ImageAnnotationResult,
   *  }>}
   */

  annotateEncodedImage(
      encodedImage) {
    return this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
        [
          encodedImage
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ImageContentAnnotator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotatorReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.ImageContentAnnotatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.ImageContentAnnotatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.ImageContentAnnotatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.ImageContentAnnotatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
        impl.annotateRawImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
        impl.annotateEncodedImage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.ImageContentAnnotator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.ImageContentAnnotatorRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.ImageContentAnnotatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ImageContentAnnotator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotatorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.ImageContentAnnotatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.ImageContentAnnotatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.annotateRawImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
        this.annotateRawImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.annotateEncodedImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
        this.annotateEncodedImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageAnnotatorConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageAnnotationScoreSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageAnnotationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageAnnotatorConfigSpec.$,
    'ImageAnnotatorConfig',
    [
      mojo.internal.StructField(
        'locale', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.ImageAnnotatorConfig = class {
  constructor() {
    /** @export { !string } */
    this.locale;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageAnnotationScoreSpec.$,
    'ImageAnnotationScore',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dEPRECATEDConfidence', 4,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mid', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'score', 24,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'boundingBox', 32,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[1, 48],]);





/** @record */
chromeos.machineLearning.mojom.ImageAnnotationScore = class {
  constructor() {
    /** @export { !number } */
    this.id;
    /** @export { !number } */
    this.dEPRECATEDConfidence;
    /** @export { !string } */
    this.mid;
    /** @export { (string|undefined) } */
    this.name;
    /** @export { !number } */
    this.score;
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.boundingBox;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.ImageAnnotationResultSpec.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.ImageAnnotationResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageAnnotationResultSpec.$,
    'ImageAnnotationResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        chromeos.machineLearning.mojom.ImageAnnotationResultSpec.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'annotations', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.ImageAnnotationScoreSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.ImageAnnotationResult = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.ImageAnnotationResult_Status } */
    this.status;
    /** @export { !Array<!chromeos.machineLearning.mojom.ImageAnnotationScore> } */
    this.annotations;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
    'ImageContentAnnotator_AnnotateRawImage_Params',
    [
      mojo.internal.StructField(
        'rgbBytes', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'width', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'height', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineStride', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.rgbBytes;
    /** @export { !number } */
    this.width;
    /** @export { !number } */
    this.height;
    /** @export { !number } */
    this.lineStride;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
    'ImageContentAnnotator_AnnotateRawImage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.ImageAnnotationResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateRawImage_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.ImageAnnotationResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
    'ImageContentAnnotator_AnnotateEncodedImage_Params',
    [
      mojo.internal.StructField(
        'encodedImage', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.encodedImage;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
    'ImageContentAnnotator_AnnotateEncodedImage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.ImageAnnotationResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.ImageContentAnnotator_AnnotateEncodedImage_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.ImageAnnotationResult } */
    this.result;
  }
};

