// chromeos/services/machine_learning/public/mojom/image_content_annotation.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/image_content_annotation.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }



  function ImageAnnotatorConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageAnnotatorConfig.prototype.initDefaults_ = function() {
    this.locale = null;
  };
  ImageAnnotatorConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageAnnotatorConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageAnnotatorConfig.locale
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageAnnotatorConfig.encodedSize = codec.kStructHeaderSize + 8;

  ImageAnnotatorConfig.decode = function(decoder) {
    var packed;
    var val = new ImageAnnotatorConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.locale =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ImageAnnotatorConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageAnnotatorConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.locale);
  };
  function ImageAnnotationScore(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageAnnotationScore.prototype.initDefaults_ = function() {
    this.id = 0;
    this.dEPRECATEDConfidence = 0;
    this.mid = null;
    this.name = null;
    this.score = 0;
    this.boundingBox = null;
  };
  ImageAnnotationScore.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageAnnotationScore.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 1, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ImageAnnotationScore.mid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageAnnotationScore.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;




    // version check ImageAnnotationScore.boundingBox
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate ImageAnnotationScore.boundingBox
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageAnnotationScore.encodedSize = codec.kStructHeaderSize + 40;

  ImageAnnotationScore.decode = function(decoder) {
    var packed;
    var val = new ImageAnnotationScore();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.dEPRECATEDConfidence =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.mid =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    if (version >= 1) {
      val.score =
          decoder.decodeStruct(codec.Float);
    } else {
      val.score = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 1) {
      val.boundingBox =
          decoder.decodeStructPointer(geometry$.Rect);
    } else {
      val.boundingBox = null;
    }
    return val;
  };

  ImageAnnotationScore.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageAnnotationScore.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Uint8, val.dEPRECATEDConfidence);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.mid);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Float, val.score);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Rect, val.boundingBox);
  };
  function ImageAnnotationResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ImageAnnotationResult.Status = {};
  ImageAnnotationResult.Status.OK = 0;
  ImageAnnotationResult.Status.ERROR = 1;
  ImageAnnotationResult.Status.MIN_VALUE = 0;
  ImageAnnotationResult.Status.MAX_VALUE = 1;
  ImageAnnotationResult.Status.DEFAULT_VALUE = 0;

  ImageAnnotationResult.Status.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ImageAnnotationResult.Status.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ImageAnnotationResult.Status.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ImageAnnotationResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.annotations = null;
  };
  ImageAnnotationResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageAnnotationResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageAnnotationResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ImageAnnotationResult.Status);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageAnnotationResult.annotations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(ImageAnnotationScore), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageAnnotationResult.encodedSize = codec.kStructHeaderSize + 16;

  ImageAnnotationResult.decode = function(decoder) {
    var packed;
    var val = new ImageAnnotationResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(ImageAnnotationResult.Status));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.annotations =
        decoder.decodeArrayPointer(new codec.PointerTo(ImageAnnotationScore));
    return val;
  };

  ImageAnnotationResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageAnnotationResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ImageAnnotationScore), val.annotations);
  };
  function ImageContentAnnotator_AnnotateRawImage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageContentAnnotator_AnnotateRawImage_Params.prototype.initDefaults_ = function() {
    this.rgbBytes = null;
    this.width = 0;
    this.height = 0;
    this.lineStride = 0;
  };
  ImageContentAnnotator_AnnotateRawImage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageContentAnnotator_AnnotateRawImage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageContentAnnotator_AnnotateRawImage_Params.rgbBytes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  ImageContentAnnotator_AnnotateRawImage_Params.encodedSize = codec.kStructHeaderSize + 24;

  ImageContentAnnotator_AnnotateRawImage_Params.decode = function(decoder) {
    var packed;
    var val = new ImageContentAnnotator_AnnotateRawImage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rgbBytes =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.width =
        decoder.decodeStruct(codec.Uint32);
    val.height =
        decoder.decodeStruct(codec.Uint32);
    val.lineStride =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ImageContentAnnotator_AnnotateRawImage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageContentAnnotator_AnnotateRawImage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.rgbBytes);
    encoder.encodeStruct(codec.Uint32, val.width);
    encoder.encodeStruct(codec.Uint32, val.height);
    encoder.encodeStruct(codec.Uint32, val.lineStride);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ImageContentAnnotator_AnnotateRawImage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageContentAnnotator_AnnotateRawImage_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ImageContentAnnotator_AnnotateRawImage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageContentAnnotator_AnnotateRawImage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageContentAnnotator_AnnotateRawImage_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ImageAnnotationResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageContentAnnotator_AnnotateRawImage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ImageContentAnnotator_AnnotateRawImage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ImageContentAnnotator_AnnotateRawImage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(ImageAnnotationResult);
    return val;
  };

  ImageContentAnnotator_AnnotateRawImage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageContentAnnotator_AnnotateRawImage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ImageAnnotationResult, val.result);
  };
  function ImageContentAnnotator_AnnotateEncodedImage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageContentAnnotator_AnnotateEncodedImage_Params.prototype.initDefaults_ = function() {
    this.encodedImage = null;
  };
  ImageContentAnnotator_AnnotateEncodedImage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageContentAnnotator_AnnotateEncodedImage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageContentAnnotator_AnnotateEncodedImage_Params.encodedImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageContentAnnotator_AnnotateEncodedImage_Params.encodedSize = codec.kStructHeaderSize + 8;

  ImageContentAnnotator_AnnotateEncodedImage_Params.decode = function(decoder) {
    var packed;
    var val = new ImageContentAnnotator_AnnotateEncodedImage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encodedImage =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    return val;
  };

  ImageContentAnnotator_AnnotateEncodedImage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageContentAnnotator_AnnotateEncodedImage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.encodedImage);
  };
  function ImageContentAnnotator_AnnotateEncodedImage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ImageAnnotationResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ImageContentAnnotator_AnnotateEncodedImage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(ImageAnnotationResult);
    return val;
  };

  ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ImageAnnotationResult, val.result);
  };
  var kImageContentAnnotator_AnnotateRawImage_Name = 0;
  var kImageContentAnnotator_AnnotateEncodedImage_Name = 1;

  function ImageContentAnnotatorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ImageContentAnnotator,
                                                   handleOrPtrInfo);
  }

  function ImageContentAnnotatorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ImageContentAnnotator, associatedInterfacePtrInfo);
  }

  ImageContentAnnotatorAssociatedPtr.prototype =
      Object.create(ImageContentAnnotatorPtr.prototype);
  ImageContentAnnotatorAssociatedPtr.prototype.constructor =
      ImageContentAnnotatorAssociatedPtr;

  function ImageContentAnnotatorProxy(receiver) {
    this.receiver_ = receiver;
  }
  ImageContentAnnotatorPtr.prototype.annotateRawImage = function() {
    return ImageContentAnnotatorProxy.prototype.annotateRawImage
        .apply(this.ptr.getProxy(), arguments);
  };

  ImageContentAnnotatorProxy.prototype.annotateRawImage = function(rgbBytes, width, height, lineStride) {
    var params_ = new ImageContentAnnotator_AnnotateRawImage_Params();
    params_.rgbBytes = rgbBytes;
    params_.width = width;
    params_.height = height;
    params_.lineStride = lineStride;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kImageContentAnnotator_AnnotateRawImage_Name,
          codec.align(ImageContentAnnotator_AnnotateRawImage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ImageContentAnnotator_AnnotateRawImage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ImageContentAnnotator_AnnotateRawImage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ImageContentAnnotatorPtr.prototype.annotateEncodedImage = function() {
    return ImageContentAnnotatorProxy.prototype.annotateEncodedImage
        .apply(this.ptr.getProxy(), arguments);
  };

  ImageContentAnnotatorProxy.prototype.annotateEncodedImage = function(encodedImage) {
    var params_ = new ImageContentAnnotator_AnnotateEncodedImage_Params();
    params_.encodedImage = encodedImage;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kImageContentAnnotator_AnnotateEncodedImage_Name,
          codec.align(ImageContentAnnotator_AnnotateEncodedImage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ImageContentAnnotator_AnnotateEncodedImage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ImageContentAnnotator_AnnotateEncodedImage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ImageContentAnnotatorStub(delegate) {
    this.delegate_ = delegate;
  }
  ImageContentAnnotatorStub.prototype.annotateRawImage = function(rgbBytes, width, height, lineStride) {
    return this.delegate_ && this.delegate_.annotateRawImage && this.delegate_.annotateRawImage(rgbBytes, width, height, lineStride);
  }
  ImageContentAnnotatorStub.prototype.annotateEncodedImage = function(encodedImage) {
    return this.delegate_ && this.delegate_.annotateEncodedImage && this.delegate_.annotateEncodedImage(encodedImage);
  }

  ImageContentAnnotatorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ImageContentAnnotatorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kImageContentAnnotator_AnnotateRawImage_Name:
      var params = reader.decodeStruct(ImageContentAnnotator_AnnotateRawImage_Params);
      this.annotateRawImage(params.rgbBytes, params.width, params.height, params.lineStride).then(function(response) {
        var responseParams =
            new ImageContentAnnotator_AnnotateRawImage_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kImageContentAnnotator_AnnotateRawImage_Name,
            codec.align(ImageContentAnnotator_AnnotateRawImage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ImageContentAnnotator_AnnotateRawImage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kImageContentAnnotator_AnnotateEncodedImage_Name:
      var params = reader.decodeStruct(ImageContentAnnotator_AnnotateEncodedImage_Params);
      this.annotateEncodedImage(params.encodedImage).then(function(response) {
        var responseParams =
            new ImageContentAnnotator_AnnotateEncodedImage_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kImageContentAnnotator_AnnotateEncodedImage_Name,
            codec.align(ImageContentAnnotator_AnnotateEncodedImage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ImageContentAnnotator_AnnotateEncodedImage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateImageContentAnnotatorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kImageContentAnnotator_AnnotateRawImage_Name:
        if (message.expectsResponse())
          paramsClass = ImageContentAnnotator_AnnotateRawImage_Params;
      break;
      case kImageContentAnnotator_AnnotateEncodedImage_Name:
        if (message.expectsResponse())
          paramsClass = ImageContentAnnotator_AnnotateEncodedImage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateImageContentAnnotatorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kImageContentAnnotator_AnnotateRawImage_Name:
        if (message.isResponse())
          paramsClass = ImageContentAnnotator_AnnotateRawImage_ResponseParams;
        break;
      case kImageContentAnnotator_AnnotateEncodedImage_Name:
        if (message.isResponse())
          paramsClass = ImageContentAnnotator_AnnotateEncodedImage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ImageContentAnnotator = {
    name: 'chromeos.machine_learning.mojom.ImageContentAnnotator',
    kVersion: 0,
    ptrClass: ImageContentAnnotatorPtr,
    proxyClass: ImageContentAnnotatorProxy,
    stubClass: ImageContentAnnotatorStub,
    validateRequest: validateImageContentAnnotatorRequest,
    validateResponse: validateImageContentAnnotatorResponse,
  };
  ImageContentAnnotatorStub.prototype.validator = validateImageContentAnnotatorRequest;
  ImageContentAnnotatorProxy.prototype.validator = validateImageContentAnnotatorResponse;
  exports.ImageAnnotatorConfig = ImageAnnotatorConfig;
  exports.ImageAnnotationScore = ImageAnnotationScore;
  exports.ImageAnnotationResult = ImageAnnotationResult;
  exports.ImageContentAnnotator = ImageContentAnnotator;
  exports.ImageContentAnnotatorPtr = ImageContentAnnotatorPtr;
  exports.ImageContentAnnotatorAssociatedPtr = ImageContentAnnotatorAssociatedPtr;
})();