// chromeos/services/machine_learning/public/mojom/image_content_annotation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ReadOnlySharedMemoryRegion as mojoBase_mojom_ReadOnlySharedMemoryRegion,
  ReadOnlySharedMemoryRegionSpec as mojoBase_mojom_ReadOnlySharedMemoryRegionSpec
} from '../../../../../mojo/public/mojom/base/shared_memory.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ImageContentAnnotatorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.ImageContentAnnotator', scope);
  }
}

/** @interface */
export class ImageContentAnnotatorInterface {
  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } rgbBytes
   * @param { !number } width
   * @param { !number } height
   * @param { !number } lineStride
   * @return {!Promise<{
        result: !ImageAnnotationResult,
   *  }>}
   */

  annotateRawImage(rgbBytes, width, height, lineStride) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } encodedImage
   * @return {!Promise<{
        result: !ImageAnnotationResult,
   *  }>}
   */

  annotateEncodedImage(encodedImage) {}
}

/**
 * @implements { ImageContentAnnotatorInterface }
 */
export class ImageContentAnnotatorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ImageContentAnnotatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ImageContentAnnotatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ImageContentAnnotatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } rgbBytes
   * @param { !number } width
   * @param { !number } height
   * @param { !number } lineStride
   * @return {!Promise<{
        result: !ImageAnnotationResult,
   *  }>}
   */

  annotateRawImage(
      rgbBytes,
      width,
      height,
      lineStride) {
    return this.proxy.sendMessage(
        0,
        ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
        ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
        [
          rgbBytes,
          width,
          height,
          lineStride
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } encodedImage
   * @return {!Promise<{
        result: !ImageAnnotationResult,
   *  }>}
   */

  annotateEncodedImage(
      encodedImage) {
    return this.proxy.sendMessage(
        1,
        ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
        ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
        [
          encodedImage
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ImageContentAnnotator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ImageContentAnnotatorReceiver {
  /**
   * @param {!ImageContentAnnotatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ImageContentAnnotatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ImageContentAnnotatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImageContentAnnotatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
        ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
        impl.annotateRawImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
        ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
        impl.annotateEncodedImage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ImageContentAnnotator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.ImageContentAnnotator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ImageContentAnnotatorRemote}
   */
  static getRemote() {
    let remote = new ImageContentAnnotatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ImageContentAnnotator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ImageContentAnnotatorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ImageContentAnnotatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImageContentAnnotatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.annotateRawImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
        ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
        this.annotateRawImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.annotateEncodedImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
        ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
        this.annotateEncodedImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageAnnotatorConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageAnnotationScoreSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageAnnotationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageContentAnnotator_AnnotateRawImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ImageAnnotatorConfigSpec.$,
    'ImageAnnotatorConfig',
    [
      mojo.internal.StructField(
        'locale', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImageAnnotatorConfig {
  constructor() {
    /** @type { !string } */
    this.locale;
  }
}



mojo.internal.Struct(
    ImageAnnotationScoreSpec.$,
    'ImageAnnotationScore',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dEPRECATEDConfidence', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mid', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'score', 24,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'boundingBox', 32,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        1,
      ),
    ],
    [[0, 32],[1, 48],]);



/**
 * @record
 */
export class ImageAnnotationScore {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !number } */
    this.dEPRECATEDConfidence;
    /** @type { !string } */
    this.mid;
    /** @type { (string|undefined) } */
    this.name;
    /** @type { !number } */
    this.score;
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.boundingBox;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ImageAnnotationResult_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ImageAnnotationResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    ImageAnnotationResultSpec.$,
    'ImageAnnotationResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ImageAnnotationResult_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'annotations', 8,
        0,
        mojo.internal.Array(ImageAnnotationScoreSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ImageAnnotationResult {
  constructor() {
    /** @type { !ImageAnnotationResult_Status } */
    this.status;
    /** @type { !Array<!ImageAnnotationScore> } */
    this.annotations;
  }
}



mojo.internal.Struct(
    ImageContentAnnotator_AnnotateRawImage_ParamsSpec.$,
    'ImageContentAnnotator_AnnotateRawImage_Params',
    [
      mojo.internal.StructField(
        'rgbBytes', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'width', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'height', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineStride', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ImageContentAnnotator_AnnotateRawImage_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.rgbBytes;
    /** @type { !number } */
    this.width;
    /** @type { !number } */
    this.height;
    /** @type { !number } */
    this.lineStride;
  }
}



mojo.internal.Struct(
    ImageContentAnnotator_AnnotateRawImage_ResponseParamsSpec.$,
    'ImageContentAnnotator_AnnotateRawImage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ImageAnnotationResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImageContentAnnotator_AnnotateRawImage_ResponseParams {
  constructor() {
    /** @type { !ImageAnnotationResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ImageContentAnnotator_AnnotateEncodedImage_ParamsSpec.$,
    'ImageContentAnnotator_AnnotateEncodedImage_Params',
    [
      mojo.internal.StructField(
        'encodedImage', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImageContentAnnotator_AnnotateEncodedImage_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.encodedImage;
  }
}



mojo.internal.Struct(
    ImageContentAnnotator_AnnotateEncodedImage_ResponseParamsSpec.$,
    'ImageContentAnnotator_AnnotateEncodedImage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ImageAnnotationResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImageContentAnnotator_AnnotateEncodedImage_ResponseParams {
  constructor() {
    /** @type { !ImageAnnotationResult } */
    this.result;
  }
}

