// chromeos/services/machine_learning/public/mojom/machine_learning_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('chromeos.machineLearning.mojom.LoadHandwritingModelResult');
goog.require('chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResult');
goog.require('chromeos.machineLearning.mojom.DocumentScanner');
goog.require('chromeos.machineLearning.mojom.GrammarChecker');
goog.require('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer');
goog.require('chromeos.machineLearning.mojom.HandwritingRecognizer');
goog.require('chromeos.machineLearning.mojom.HeatmapPalmRejectionClient');
goog.require('chromeos.machineLearning.mojom.ImageContentAnnotator');
goog.require('chromeos.machineLearning.mojom.Model');
goog.require('chromeos.machineLearning.mojom.SodaClient');
goog.require('chromeos.machineLearning.mojom.SodaRecognizer');
goog.require('chromeos.machineLearning.mojom.TextClassifier');
goog.require('chromeos.machineLearning.mojom.TextSuggester');
goog.require('chromeos.machineLearning.mojom.BuiltinModelSpec');
goog.require('chromeos.machineLearning.mojom.DocumentScannerConfig');
goog.require('chromeos.machineLearning.mojom.FlatBufferModelSpec');
goog.require('chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraint');
goog.require('chromeos.machineLearning.mojom.HandwritingRecognizerSpec');
goog.require('chromeos.machineLearning.mojom.HeatmapPalmRejectionConfig');
goog.require('chromeos.machineLearning.mojom.ImageAnnotatorConfig');
goog.require('chromeos.machineLearning.mojom.SodaConfig');
goog.require('chromeos.machineLearning.mojom.TextSuggesterSpec');




goog.provide('chromeos.machineLearning.mojom.LoadModelResult');
goog.provide('chromeos.machineLearning.mojom.LoadModelResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.LoadModelResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.LoadModelResult = {
  
  OK: 0,
  MODEL_SPEC_ERROR: 1,
  LOAD_MODEL_ERROR: 2,
  FEATURE_NOT_SUPPORTED_ERROR: 3,
  LANGUAGE_NOT_SUPPORTED_ERROR: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('chromeos.machineLearning.mojom.MachineLearningService');
goog.provide('chromeos.machineLearning.mojom.MachineLearningServiceReceiver');
goog.provide('chromeos.machineLearning.mojom.MachineLearningServiceCallbackRouter');
goog.provide('chromeos.machineLearning.mojom.MachineLearningServiceInterface');
goog.provide('chromeos.machineLearning.mojom.MachineLearningServiceRemote');
goog.provide('chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.MachineLearningService.$interfaceName,
        scope);
  }
};

/** @interface */
chromeos.machineLearning.mojom.MachineLearningServiceInterface = class {
  
  /**
   * @param { !chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver } receiver
   */

  clone(receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.BuiltinModelSpec } spec
   * @param { !chromeos.machineLearning.mojom.ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadBuiltinModel(spec, receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.FlatBufferModelSpec } spec
   * @param { !chromeos.machineLearning.mojom.ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadFlatBufferModel(spec, receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.TextClassifierPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadTextClassifier(receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerSpec } spec
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadHandwritingModelResult,
   *  }>}
   */

  loadHandwritingModel(spec, receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.SodaConfig } config
   * @param { !chromeos.machineLearning.mojom.SodaClientRemote } sodaClient
   * @param { !chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver } sodaRecognizer
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadSpeechRecognizer(config, sodaClient, sodaRecognizer) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadGrammarChecker(receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.TextSuggesterPendingReceiver } receiver
   * @param { ?chromeos.machineLearning.mojom.TextSuggesterSpec } spec
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadTextSuggester(receiver, spec) {}
  
  /**
   * @param { !chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraint } constraint
   * @param { !chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadHandwritingModelResult,
   *  }>}
   */

  loadWebPlatformHandwritingModel(constraint, receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.DocumentScannerPendingReceiver } receiver
   * @param { ?chromeos.machineLearning.mojom.DocumentScannerConfig } config
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadDocumentScanner(receiver, config) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.ImageAnnotatorConfig } config
   * @param { !chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadImageAnnotator(config, receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.HeatmapPalmRejectionConfig } config
   * @param { !chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote } client
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResult,
   *  }>}
   */

  loadHeatmapPalmRejection(config, client) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerSpec } spec
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  rEMOVED4(spec, receiver) {}
};

/**
 * @export
 * @implements { chromeos.machineLearning.mojom.MachineLearningServiceInterface }
 */
chromeos.machineLearning.mojom.MachineLearningServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        5,
        chromeos.machineLearning.mojom.MachineLearningService_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.BuiltinModelSpec } spec
   * @param { !chromeos.machineLearning.mojom.ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadBuiltinModel(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.FlatBufferModelSpec } spec
   * @param { !chromeos.machineLearning.mojom.ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadFlatBufferModel(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.TextClassifierPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadTextClassifier(
      receiver) {
    return this.proxy.sendMessage(
        2,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerSpec } spec
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadHandwritingModelResult,
   *  }>}
   */

  loadHandwritingModel(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        3,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.SodaConfig } config
   * @param { !chromeos.machineLearning.mojom.SodaClientRemote } sodaClient
   * @param { !chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver } sodaRecognizer
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadSpeechRecognizer(
      config,
      sodaClient,
      sodaRecognizer) {
    return this.proxy.sendMessage(
        6,
        chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
        [
          config,
          sodaClient,
          sodaRecognizer
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadGrammarChecker(
      receiver) {
    return this.proxy.sendMessage(
        7,
        chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.TextSuggesterPendingReceiver } receiver
   * @param { ?chromeos.machineLearning.mojom.TextSuggesterSpec } spec
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadTextSuggester(
      receiver,
      spec) {
    return this.proxy.sendMessage(
        8,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
        [
          receiver,
          spec
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraint } constraint
   * @param { !chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadHandwritingModelResult,
   *  }>}
   */

  loadWebPlatformHandwritingModel(
      constraint,
      receiver) {
    return this.proxy.sendMessage(
        9,
        chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
        [
          constraint,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.DocumentScannerPendingReceiver } receiver
   * @param { ?chromeos.machineLearning.mojom.DocumentScannerConfig } config
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadDocumentScanner(
      receiver,
      config) {
    return this.proxy.sendMessage(
        10,
        chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
        [
          receiver,
          config
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.ImageAnnotatorConfig } config
   * @param { !chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  loadImageAnnotator(
      config,
      receiver) {
    return this.proxy.sendMessage(
        12,
        chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
        [
          config,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.HeatmapPalmRejectionConfig } config
   * @param { !chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote } client
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResult,
   *  }>}
   */

  loadHeatmapPalmRejection(
      config,
      client) {
    return this.proxy.sendMessage(
        13,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
        [
          config,
          client
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerSpec } spec
   * @param { !chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.LoadModelResult,
   *  }>}
   */

  rEMOVED4(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        4,
        chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MachineLearningService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningServiceReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.MachineLearningServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.MachineLearningServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.MachineLearningServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.MachineLearningServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        5,
        chromeos.machineLearning.mojom.MachineLearningService_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
        impl.loadBuiltinModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
        impl.loadFlatBufferModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
        impl.loadTextClassifier.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
        impl.loadHandwritingModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
        impl.loadSpeechRecognizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
        impl.loadGrammarChecker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
        impl.loadTextSuggester.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
        impl.loadWebPlatformHandwritingModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
        impl.loadDocumentScanner.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
        impl.loadImageAnnotator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
        impl.loadHeatmapPalmRejection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
        impl.rEMOVED4.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.MachineLearningService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.MachineLearningService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.MachineLearningServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.MachineLearningServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MachineLearningService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.MachineLearningServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.MachineLearningServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        chromeos.machineLearning.mojom.MachineLearningService_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadBuiltinModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
        this.loadBuiltinModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadFlatBufferModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
        this.loadFlatBufferModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadTextClassifier =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
        this.loadTextClassifier.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadHandwritingModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
        this.loadHandwritingModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadSpeechRecognizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
        this.loadSpeechRecognizer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadGrammarChecker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
        this.loadGrammarChecker.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadTextSuggester =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
        this.loadTextSuggester.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadWebPlatformHandwritingModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
        this.loadWebPlatformHandwritingModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadDocumentScanner =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
        this.loadDocumentScanner.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadImageAnnotator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
        this.loadImageAnnotator.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadHeatmapPalmRejection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
        this.loadHeatmapPalmRejection.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED4 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ParamsSpec.$,
        chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
        this.rEMOVED4.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('chromeos.machineLearning.mojom.MachineLearningService_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_Clone_ParamsSpec.$,
    'MachineLearningService_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_Clone_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_Clone_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.MachineLearningServicePendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
    'MachineLearningService_LoadBuiltinModel_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos.machineLearning.mojom.BuiltinModelSpecSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.ModelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.BuiltinModelSpec } */
    this.spec;
    /** @export { !chromeos.machineLearning.mojom.ModelPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadBuiltinModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadBuiltinModel_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
    'MachineLearningService_LoadFlatBufferModel_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos.machineLearning.mojom.FlatBufferModelSpecSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.ModelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.FlatBufferModelSpec } */
    this.spec;
    /** @export { !chromeos.machineLearning.mojom.ModelPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadFlatBufferModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadFlatBufferModel_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ParamsSpec.$,
    'MachineLearningService_LoadTextClassifier_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.TextClassifierPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.TextClassifierPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
    'MachineLearningService_LoadTextClassifier_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextClassifier_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
    'MachineLearningService_LoadHandwritingModel_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizerSpecSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognizerSpec } */
    this.spec;
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadHandwritingModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadHandwritingModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadHandwritingModel_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadHandwritingModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
    'MachineLearningService_LoadSpeechRecognizer_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        chromeos.machineLearning.mojom.SodaConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sodaClient', 8,
        0,
        mojo.internal.InterfaceProxy(chromeos.machineLearning.mojom.SodaClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sodaRecognizer', 16,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.SodaConfig } */
    this.config;
    /** @export { !chromeos.machineLearning.mojom.SodaClientRemote } */
    this.sodaClient;
    /** @export { !chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver } */
    this.sodaRecognizer;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
    'MachineLearningService_LoadSpeechRecognizer_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadSpeechRecognizer_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
    'MachineLearningService_LoadGrammarChecker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
    'MachineLearningService_LoadGrammarChecker_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadGrammarChecker_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ParamsSpec.$,
    'MachineLearningService_LoadTextSuggester_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.TextSuggesterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spec', 8,
        0,
        chromeos.machineLearning.mojom.TextSuggesterSpecSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[3, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.TextSuggesterPendingReceiver } */
    this.receiver;
    /** @export { (chromeos.machineLearning.mojom.TextSuggesterSpec|undefined) } */
    this.spec;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
    'MachineLearningService_LoadTextSuggester_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadTextSuggester_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
    'MachineLearningService_LoadWebPlatformHandwritingModel_Params',
    [
      mojo.internal.StructField(
        'constraint', 0,
        0,
        chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraintSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraint } */
    this.constraint;
    /** @export { !chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadHandwritingModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadHandwritingModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
    'MachineLearningService_LoadDocumentScanner_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.DocumentScannerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        chromeos.machineLearning.mojom.DocumentScannerConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[6, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.DocumentScannerPendingReceiver } */
    this.receiver;
    /** @export { (chromeos.machineLearning.mojom.DocumentScannerConfig|undefined) } */
    this.config;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
    'MachineLearningService_LoadDocumentScanner_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadDocumentScanner_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
    'MachineLearningService_LoadImageAnnotator_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        chromeos.machineLearning.mojom.ImageAnnotatorConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.ImageAnnotatorConfig } */
    this.config;
    /** @export { !chromeos.machineLearning.mojom.ImageContentAnnotatorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
    'MachineLearningService_LoadImageAnnotator_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadImageAnnotator_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
    'MachineLearningService_LoadHeatmapPalmRejection_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        chromeos.machineLearning.mojom.HeatmapPalmRejectionConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HeatmapPalmRejectionConfig } */
    this.config;
    /** @export { !chromeos.machineLearning.mojom.HeatmapPalmRejectionClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
    'MachineLearningService_LoadHeatmapPalmRejection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_LoadHeatmapPalmRejection_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadHeatmapPalmRejectionResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ParamsSpec.$,
    'MachineLearningService_REMOVED_4_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos.machineLearning.mojom.HandwritingRecognizerSpecSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_Params');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognizerSpec } */
    this.spec;
    /** @export { !chromeos.machineLearning.mojom.HandwritingRecognizerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
    'MachineLearningService_REMOVED_4_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.MachineLearningService_REMOVED_4_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.LoadModelResult } */
    this.result;
  }
};

