// chromeos/services/machine_learning/public/mojom/machine_learning_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/machine_learning_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var document_scanner$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/document_scanner.mojom', 'document_scanner.mojom.js');
  }
  var grammar_checker$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/grammar_checker.mojom', 'grammar_checker.mojom.js');
  }
  var handwriting_recognizer$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/handwriting_recognizer.mojom', 'handwriting_recognizer.mojom.js');
  }
  var heatmap_palm_rejection$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/heatmap_palm_rejection.mojom', 'heatmap_palm_rejection.mojom.js');
  }
  var image_content_annotation$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/image_content_annotation.mojom', 'image_content_annotation.mojom.js');
  }
  var model$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/model.mojom', 'model.mojom.js');
  }
  var soda$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/soda.mojom', 'soda.mojom.js');
  }
  var text_classifier$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/text_classifier.mojom', 'text_classifier.mojom.js');
  }
  var text_suggester$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/text_suggester.mojom', 'text_suggester.mojom.js');
  }
  var web_platform_handwriting$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.webPlatform.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/web_platform_handwriting.mojom', 'web_platform_handwriting.mojom.js');
  }


  var LoadModelResult = {};
  LoadModelResult.OK = 0;
  LoadModelResult.MODEL_SPEC_ERROR = 1;
  LoadModelResult.LOAD_MODEL_ERROR = 2;
  LoadModelResult.FEATURE_NOT_SUPPORTED_ERROR = 3;
  LoadModelResult.LANGUAGE_NOT_SUPPORTED_ERROR = 4;
  LoadModelResult.MIN_VALUE = 0;
  LoadModelResult.MAX_VALUE = 4;

  LoadModelResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  LoadModelResult.toKnownEnumValue = function(value) {
    return value;
  };

  LoadModelResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MachineLearningService_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_Clone_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_Clone_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadBuiltinModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadBuiltinModel_Params.prototype.initDefaults_ = function() {
    this.spec = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadBuiltinModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadBuiltinModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadBuiltinModel_Params.spec
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, model$.BuiltinModelSpec, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadBuiltinModel_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadBuiltinModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadBuiltinModel_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadBuiltinModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.spec =
        decoder.decodeStructPointer(model$.BuiltinModelSpec);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadBuiltinModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadBuiltinModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(model$.BuiltinModelSpec, val.spec);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadBuiltinModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadBuiltinModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadBuiltinModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadBuiltinModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadBuiltinModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadBuiltinModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadBuiltinModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadBuiltinModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadBuiltinModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadBuiltinModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadFlatBufferModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadFlatBufferModel_Params.prototype.initDefaults_ = function() {
    this.spec = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadFlatBufferModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadFlatBufferModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadFlatBufferModel_Params.spec
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, model$.FlatBufferModelSpec, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadFlatBufferModel_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadFlatBufferModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadFlatBufferModel_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadFlatBufferModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.spec =
        decoder.decodeStructPointer(model$.FlatBufferModelSpec);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadFlatBufferModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadFlatBufferModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(model$.FlatBufferModelSpec, val.spec);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadFlatBufferModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadFlatBufferModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadFlatBufferModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadFlatBufferModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadFlatBufferModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadFlatBufferModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadFlatBufferModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadFlatBufferModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadFlatBufferModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadFlatBufferModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadTextClassifier_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadTextClassifier_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadTextClassifier_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadTextClassifier_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadTextClassifier_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadTextClassifier_Params.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadTextClassifier_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadTextClassifier_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadTextClassifier_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadTextClassifier_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadTextClassifier_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadTextClassifier_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadTextClassifier_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadTextClassifier_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadTextClassifier_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadTextClassifier_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadTextClassifier_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadTextClassifier_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadTextClassifier_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadTextClassifier_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadHandwritingModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadHandwritingModel_Params.prototype.initDefaults_ = function() {
    this.spec = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadHandwritingModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadHandwritingModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadHandwritingModel_Params.spec
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, handwriting_recognizer$.HandwritingRecognizerSpec, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadHandwritingModel_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadHandwritingModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadHandwritingModel_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadHandwritingModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.spec =
        decoder.decodeStructPointer(handwriting_recognizer$.HandwritingRecognizerSpec);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadHandwritingModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadHandwritingModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(handwriting_recognizer$.HandwritingRecognizerSpec, val.spec);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadHandwritingModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadHandwritingModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadHandwritingModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadHandwritingModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadHandwritingModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, handwriting_recognizer$.LoadHandwritingModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadHandwritingModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadHandwritingModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadHandwritingModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(handwriting_recognizer$.LoadHandwritingModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadHandwritingModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadHandwritingModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadSpeechRecognizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadSpeechRecognizer_Params.prototype.initDefaults_ = function() {
    this.config = null;
    this.sodaClient = new soda$.SodaClientPtr();
    this.sodaRecognizer = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadSpeechRecognizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadSpeechRecognizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadSpeechRecognizer_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, soda$.SodaConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadSpeechRecognizer_Params.sodaClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadSpeechRecognizer_Params.sodaRecognizer
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadSpeechRecognizer_Params.encodedSize = codec.kStructHeaderSize + 24;

  MachineLearningService_LoadSpeechRecognizer_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadSpeechRecognizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(soda$.SodaConfig);
    val.sodaClient =
        decoder.decodeStruct(new codec.Interface(soda$.SodaClientPtr));
    val.sodaRecognizer =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadSpeechRecognizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadSpeechRecognizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(soda$.SodaConfig, val.config);
    encoder.encodeStruct(new codec.Interface(soda$.SodaClientPtr), val.sodaClient);
    encoder.encodeStruct(codec.InterfaceRequest, val.sodaRecognizer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadSpeechRecognizer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadSpeechRecognizer_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadSpeechRecognizer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadSpeechRecognizer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadSpeechRecognizer_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadSpeechRecognizer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadSpeechRecognizer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadSpeechRecognizer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadSpeechRecognizer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadSpeechRecognizer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadGrammarChecker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadGrammarChecker_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadGrammarChecker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadGrammarChecker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadGrammarChecker_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadGrammarChecker_Params.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadGrammarChecker_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadGrammarChecker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadGrammarChecker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadGrammarChecker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadGrammarChecker_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadGrammarChecker_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadGrammarChecker_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadGrammarChecker_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadGrammarChecker_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadGrammarChecker_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadGrammarChecker_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadGrammarChecker_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadGrammarChecker_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadGrammarChecker_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadTextSuggester_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadTextSuggester_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.spec = null;
  };
  MachineLearningService_LoadTextSuggester_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadTextSuggester_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 3, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadTextSuggester_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check MachineLearningService_LoadTextSuggester_Params.spec
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate MachineLearningService_LoadTextSuggester_Params.spec
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, text_suggester$.TextSuggesterSpec, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadTextSuggester_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadTextSuggester_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadTextSuggester_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 3) {
      val.spec =
          decoder.decodeStructPointer(text_suggester$.TextSuggesterSpec);
    } else {
      val.spec = null;
    }
    return val;
  };

  MachineLearningService_LoadTextSuggester_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadTextSuggester_Params.encodedSize);
    encoder.writeUint32(3);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(text_suggester$.TextSuggesterSpec, val.spec);
  };
  function MachineLearningService_LoadTextSuggester_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadTextSuggester_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadTextSuggester_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadTextSuggester_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadTextSuggester_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadTextSuggester_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadTextSuggester_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadTextSuggester_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadTextSuggester_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadTextSuggester_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadWebPlatformHandwritingModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadWebPlatformHandwritingModel_Params.prototype.initDefaults_ = function() {
    this.constraint = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadWebPlatformHandwritingModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadWebPlatformHandwritingModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadWebPlatformHandwritingModel_Params.constraint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, web_platform_handwriting$.HandwritingModelConstraint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadWebPlatformHandwritingModel_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadWebPlatformHandwritingModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadWebPlatformHandwritingModel_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadWebPlatformHandwritingModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.constraint =
        decoder.decodeStructPointer(web_platform_handwriting$.HandwritingModelConstraint);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadWebPlatformHandwritingModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadWebPlatformHandwritingModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(web_platform_handwriting$.HandwritingModelConstraint, val.constraint);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, handwriting_recognizer$.LoadHandwritingModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(handwriting_recognizer$.LoadHandwritingModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadDocumentScanner_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadDocumentScanner_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.config = null;
  };
  MachineLearningService_LoadDocumentScanner_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadDocumentScanner_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 6, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadDocumentScanner_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check MachineLearningService_LoadDocumentScanner_Params.config
    if (!messageValidator.isFieldInStructVersion(offset, 6))
      return validator.validationError.NONE;
    // validate MachineLearningService_LoadDocumentScanner_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, document_scanner$.DocumentScannerConfig, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadDocumentScanner_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadDocumentScanner_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadDocumentScanner_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 6) {
      val.config =
          decoder.decodeStructPointer(document_scanner$.DocumentScannerConfig);
    } else {
      val.config = null;
    }
    return val;
  };

  MachineLearningService_LoadDocumentScanner_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadDocumentScanner_Params.encodedSize);
    encoder.writeUint32(6);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(document_scanner$.DocumentScannerConfig, val.config);
  };
  function MachineLearningService_LoadDocumentScanner_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadDocumentScanner_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadDocumentScanner_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadDocumentScanner_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadDocumentScanner_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadDocumentScanner_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadDocumentScanner_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadDocumentScanner_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadDocumentScanner_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadDocumentScanner_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadImageAnnotator_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadImageAnnotator_Params.prototype.initDefaults_ = function() {
    this.config = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_LoadImageAnnotator_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadImageAnnotator_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadImageAnnotator_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, image_content_annotation$.ImageAnnotatorConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadImageAnnotator_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadImageAnnotator_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadImageAnnotator_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadImageAnnotator_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(image_content_annotation$.ImageAnnotatorConfig);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadImageAnnotator_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadImageAnnotator_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(image_content_annotation$.ImageAnnotatorConfig, val.config);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadImageAnnotator_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadImageAnnotator_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadImageAnnotator_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadImageAnnotator_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadImageAnnotator_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadImageAnnotator_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadImageAnnotator_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadImageAnnotator_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadImageAnnotator_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadImageAnnotator_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_LoadHeatmapPalmRejection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadHeatmapPalmRejection_Params.prototype.initDefaults_ = function() {
    this.config = null;
    this.client = new heatmap_palm_rejection$.HeatmapPalmRejectionClientPtr();
  };
  MachineLearningService_LoadHeatmapPalmRejection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadHeatmapPalmRejection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadHeatmapPalmRejection_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, heatmap_palm_rejection$.HeatmapPalmRejectionConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadHeatmapPalmRejection_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadHeatmapPalmRejection_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_LoadHeatmapPalmRejection_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadHeatmapPalmRejection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(heatmap_palm_rejection$.HeatmapPalmRejectionConfig);
    val.client =
        decoder.decodeStruct(new codec.Interface(heatmap_palm_rejection$.HeatmapPalmRejectionClientPtr));
    return val;
  };

  MachineLearningService_LoadHeatmapPalmRejection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadHeatmapPalmRejection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(heatmap_palm_rejection$.HeatmapPalmRejectionConfig, val.config);
    encoder.encodeStruct(new codec.Interface(heatmap_palm_rejection$.HeatmapPalmRejectionClientPtr), val.client);
  };
  function MachineLearningService_LoadHeatmapPalmRejection_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, heatmap_palm_rejection$.LoadHeatmapPalmRejectionResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_LoadHeatmapPalmRejection_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(heatmap_palm_rejection$.LoadHeatmapPalmRejectionResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_REMOVED_4_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_REMOVED_4_Params.prototype.initDefaults_ = function() {
    this.spec = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  MachineLearningService_REMOVED_4_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_REMOVED_4_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_REMOVED_4_Params.spec
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, handwriting_recognizer$.HandwritingRecognizerSpec, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_REMOVED_4_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_REMOVED_4_Params.encodedSize = codec.kStructHeaderSize + 16;

  MachineLearningService_REMOVED_4_Params.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_REMOVED_4_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.spec =
        decoder.decodeStructPointer(handwriting_recognizer$.HandwritingRecognizerSpec);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_REMOVED_4_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_REMOVED_4_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(handwriting_recognizer$.HandwritingRecognizerSpec, val.spec);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MachineLearningService_REMOVED_4_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MachineLearningService_REMOVED_4_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MachineLearningService_REMOVED_4_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MachineLearningService_REMOVED_4_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MachineLearningService_REMOVED_4_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MachineLearningService_REMOVED_4_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MachineLearningService_REMOVED_4_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MachineLearningService_REMOVED_4_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MachineLearningService_REMOVED_4_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MachineLearningService_REMOVED_4_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kMachineLearningService_Clone_Name = 5;
  var kMachineLearningService_LoadBuiltinModel_Name = 0;
  var kMachineLearningService_LoadFlatBufferModel_Name = 1;
  var kMachineLearningService_LoadTextClassifier_Name = 2;
  var kMachineLearningService_LoadHandwritingModel_Name = 3;
  var kMachineLearningService_LoadSpeechRecognizer_Name = 6;
  var kMachineLearningService_LoadGrammarChecker_Name = 7;
  var kMachineLearningService_LoadTextSuggester_Name = 8;
  var kMachineLearningService_LoadWebPlatformHandwritingModel_Name = 9;
  var kMachineLearningService_LoadDocumentScanner_Name = 10;
  var kMachineLearningService_LoadImageAnnotator_Name = 12;
  var kMachineLearningService_LoadHeatmapPalmRejection_Name = 13;
  var kMachineLearningService_REMOVED_4_Name = 4;

  function MachineLearningServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MachineLearningService,
                                                   handleOrPtrInfo);
  }

  function MachineLearningServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MachineLearningService, associatedInterfacePtrInfo);
  }

  MachineLearningServiceAssociatedPtr.prototype =
      Object.create(MachineLearningServicePtr.prototype);
  MachineLearningServiceAssociatedPtr.prototype.constructor =
      MachineLearningServiceAssociatedPtr;

  function MachineLearningServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  MachineLearningServicePtr.prototype.clone = function() {
    return MachineLearningServiceProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.clone = function(receiver) {
    var params_ = new MachineLearningService_Clone_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kMachineLearningService_Clone_Name,
        codec.align(MachineLearningService_Clone_Params.encodedSize));
    builder.encodeStruct(MachineLearningService_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MachineLearningServicePtr.prototype.loadBuiltinModel = function() {
    return MachineLearningServiceProxy.prototype.loadBuiltinModel
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadBuiltinModel = function(spec, receiver) {
    var params_ = new MachineLearningService_LoadBuiltinModel_Params();
    params_.spec = spec;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadBuiltinModel_Name,
          codec.align(MachineLearningService_LoadBuiltinModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadBuiltinModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadBuiltinModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadFlatBufferModel = function() {
    return MachineLearningServiceProxy.prototype.loadFlatBufferModel
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadFlatBufferModel = function(spec, receiver) {
    var params_ = new MachineLearningService_LoadFlatBufferModel_Params();
    params_.spec = spec;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadFlatBufferModel_Name,
          codec.align(MachineLearningService_LoadFlatBufferModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadFlatBufferModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadFlatBufferModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadTextClassifier = function() {
    return MachineLearningServiceProxy.prototype.loadTextClassifier
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadTextClassifier = function(receiver) {
    var params_ = new MachineLearningService_LoadTextClassifier_Params();
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadTextClassifier_Name,
          codec.align(MachineLearningService_LoadTextClassifier_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadTextClassifier_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadTextClassifier_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadHandwritingModel = function() {
    return MachineLearningServiceProxy.prototype.loadHandwritingModel
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadHandwritingModel = function(spec, receiver) {
    var params_ = new MachineLearningService_LoadHandwritingModel_Params();
    params_.spec = spec;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadHandwritingModel_Name,
          codec.align(MachineLearningService_LoadHandwritingModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadHandwritingModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadHandwritingModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadSpeechRecognizer = function() {
    return MachineLearningServiceProxy.prototype.loadSpeechRecognizer
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadSpeechRecognizer = function(config, sodaClient, sodaRecognizer) {
    var params_ = new MachineLearningService_LoadSpeechRecognizer_Params();
    params_.config = config;
    params_.sodaClient = sodaClient;
    params_.sodaRecognizer = sodaRecognizer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadSpeechRecognizer_Name,
          codec.align(MachineLearningService_LoadSpeechRecognizer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadSpeechRecognizer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadSpeechRecognizer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadGrammarChecker = function() {
    return MachineLearningServiceProxy.prototype.loadGrammarChecker
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadGrammarChecker = function(receiver) {
    var params_ = new MachineLearningService_LoadGrammarChecker_Params();
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadGrammarChecker_Name,
          codec.align(MachineLearningService_LoadGrammarChecker_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadGrammarChecker_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadGrammarChecker_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadTextSuggester = function() {
    return MachineLearningServiceProxy.prototype.loadTextSuggester
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadTextSuggester = function(receiver, spec) {
    var params_ = new MachineLearningService_LoadTextSuggester_Params();
    params_.receiver = receiver;
    params_.spec = spec;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadTextSuggester_Name,
          codec.align(MachineLearningService_LoadTextSuggester_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadTextSuggester_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadTextSuggester_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadWebPlatformHandwritingModel = function() {
    return MachineLearningServiceProxy.prototype.loadWebPlatformHandwritingModel
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadWebPlatformHandwritingModel = function(constraint, receiver) {
    var params_ = new MachineLearningService_LoadWebPlatformHandwritingModel_Params();
    params_.constraint = constraint;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadWebPlatformHandwritingModel_Name,
          codec.align(MachineLearningService_LoadWebPlatformHandwritingModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadWebPlatformHandwritingModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadDocumentScanner = function() {
    return MachineLearningServiceProxy.prototype.loadDocumentScanner
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadDocumentScanner = function(receiver, config) {
    var params_ = new MachineLearningService_LoadDocumentScanner_Params();
    params_.receiver = receiver;
    params_.config = config;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadDocumentScanner_Name,
          codec.align(MachineLearningService_LoadDocumentScanner_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadDocumentScanner_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadDocumentScanner_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadImageAnnotator = function() {
    return MachineLearningServiceProxy.prototype.loadImageAnnotator
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadImageAnnotator = function(config, receiver) {
    var params_ = new MachineLearningService_LoadImageAnnotator_Params();
    params_.config = config;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadImageAnnotator_Name,
          codec.align(MachineLearningService_LoadImageAnnotator_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadImageAnnotator_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadImageAnnotator_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.loadHeatmapPalmRejection = function() {
    return MachineLearningServiceProxy.prototype.loadHeatmapPalmRejection
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.loadHeatmapPalmRejection = function(config, client) {
    var params_ = new MachineLearningService_LoadHeatmapPalmRejection_Params();
    params_.config = config;
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_LoadHeatmapPalmRejection_Name,
          codec.align(MachineLearningService_LoadHeatmapPalmRejection_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_LoadHeatmapPalmRejection_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_LoadHeatmapPalmRejection_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MachineLearningServicePtr.prototype.rEMOVED4 = function() {
    return MachineLearningServiceProxy.prototype.rEMOVED4
        .apply(this.ptr.getProxy(), arguments);
  };

  MachineLearningServiceProxy.prototype.rEMOVED4 = function(spec, receiver) {
    var params_ = new MachineLearningService_REMOVED_4_Params();
    params_.spec = spec;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMachineLearningService_REMOVED_4_Name,
          codec.align(MachineLearningService_REMOVED_4_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MachineLearningService_REMOVED_4_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MachineLearningService_REMOVED_4_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MachineLearningServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  MachineLearningServiceStub.prototype.clone = function(receiver) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(receiver);
  }
  MachineLearningServiceStub.prototype.loadBuiltinModel = function(spec, receiver) {
    return this.delegate_ && this.delegate_.loadBuiltinModel && this.delegate_.loadBuiltinModel(spec, receiver);
  }
  MachineLearningServiceStub.prototype.loadFlatBufferModel = function(spec, receiver) {
    return this.delegate_ && this.delegate_.loadFlatBufferModel && this.delegate_.loadFlatBufferModel(spec, receiver);
  }
  MachineLearningServiceStub.prototype.loadTextClassifier = function(receiver) {
    return this.delegate_ && this.delegate_.loadTextClassifier && this.delegate_.loadTextClassifier(receiver);
  }
  MachineLearningServiceStub.prototype.loadHandwritingModel = function(spec, receiver) {
    return this.delegate_ && this.delegate_.loadHandwritingModel && this.delegate_.loadHandwritingModel(spec, receiver);
  }
  MachineLearningServiceStub.prototype.loadSpeechRecognizer = function(config, sodaClient, sodaRecognizer) {
    return this.delegate_ && this.delegate_.loadSpeechRecognizer && this.delegate_.loadSpeechRecognizer(config, sodaClient, sodaRecognizer);
  }
  MachineLearningServiceStub.prototype.loadGrammarChecker = function(receiver) {
    return this.delegate_ && this.delegate_.loadGrammarChecker && this.delegate_.loadGrammarChecker(receiver);
  }
  MachineLearningServiceStub.prototype.loadTextSuggester = function(receiver, spec) {
    return this.delegate_ && this.delegate_.loadTextSuggester && this.delegate_.loadTextSuggester(receiver, spec);
  }
  MachineLearningServiceStub.prototype.loadWebPlatformHandwritingModel = function(constraint, receiver) {
    return this.delegate_ && this.delegate_.loadWebPlatformHandwritingModel && this.delegate_.loadWebPlatformHandwritingModel(constraint, receiver);
  }
  MachineLearningServiceStub.prototype.loadDocumentScanner = function(receiver, config) {
    return this.delegate_ && this.delegate_.loadDocumentScanner && this.delegate_.loadDocumentScanner(receiver, config);
  }
  MachineLearningServiceStub.prototype.loadImageAnnotator = function(config, receiver) {
    return this.delegate_ && this.delegate_.loadImageAnnotator && this.delegate_.loadImageAnnotator(config, receiver);
  }
  MachineLearningServiceStub.prototype.loadHeatmapPalmRejection = function(config, client) {
    return this.delegate_ && this.delegate_.loadHeatmapPalmRejection && this.delegate_.loadHeatmapPalmRejection(config, client);
  }
  MachineLearningServiceStub.prototype.rEMOVED4 = function(spec, receiver) {
    return this.delegate_ && this.delegate_.rEMOVED4 && this.delegate_.rEMOVED4(spec, receiver);
  }

  MachineLearningServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMachineLearningService_Clone_Name:
      var params = reader.decodeStruct(MachineLearningService_Clone_Params);
      this.clone(params.receiver);
      return true;
    default:
      return false;
    }
  };

  MachineLearningServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMachineLearningService_LoadBuiltinModel_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadBuiltinModel_Params);
      this.loadBuiltinModel(params.spec, params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadBuiltinModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadBuiltinModel_Name,
            codec.align(MachineLearningService_LoadBuiltinModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadBuiltinModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadFlatBufferModel_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadFlatBufferModel_Params);
      this.loadFlatBufferModel(params.spec, params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadFlatBufferModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadFlatBufferModel_Name,
            codec.align(MachineLearningService_LoadFlatBufferModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadFlatBufferModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadTextClassifier_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadTextClassifier_Params);
      this.loadTextClassifier(params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadTextClassifier_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadTextClassifier_Name,
            codec.align(MachineLearningService_LoadTextClassifier_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadTextClassifier_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadHandwritingModel_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadHandwritingModel_Params);
      this.loadHandwritingModel(params.spec, params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadHandwritingModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadHandwritingModel_Name,
            codec.align(MachineLearningService_LoadHandwritingModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadHandwritingModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadSpeechRecognizer_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadSpeechRecognizer_Params);
      this.loadSpeechRecognizer(params.config, params.sodaClient, params.sodaRecognizer).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadSpeechRecognizer_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadSpeechRecognizer_Name,
            codec.align(MachineLearningService_LoadSpeechRecognizer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadSpeechRecognizer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadGrammarChecker_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadGrammarChecker_Params);
      this.loadGrammarChecker(params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadGrammarChecker_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadGrammarChecker_Name,
            codec.align(MachineLearningService_LoadGrammarChecker_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadGrammarChecker_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadTextSuggester_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadTextSuggester_Params);
      this.loadTextSuggester(params.receiver, params.spec).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadTextSuggester_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadTextSuggester_Name,
            codec.align(MachineLearningService_LoadTextSuggester_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadTextSuggester_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadWebPlatformHandwritingModel_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadWebPlatformHandwritingModel_Params);
      this.loadWebPlatformHandwritingModel(params.constraint, params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadWebPlatformHandwritingModel_Name,
            codec.align(MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadDocumentScanner_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadDocumentScanner_Params);
      this.loadDocumentScanner(params.receiver, params.config).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadDocumentScanner_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadDocumentScanner_Name,
            codec.align(MachineLearningService_LoadDocumentScanner_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadDocumentScanner_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadImageAnnotator_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadImageAnnotator_Params);
      this.loadImageAnnotator(params.config, params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadImageAnnotator_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadImageAnnotator_Name,
            codec.align(MachineLearningService_LoadImageAnnotator_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadImageAnnotator_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_LoadHeatmapPalmRejection_Name:
      var params = reader.decodeStruct(MachineLearningService_LoadHeatmapPalmRejection_Params);
      this.loadHeatmapPalmRejection(params.config, params.client).then(function(response) {
        var responseParams =
            new MachineLearningService_LoadHeatmapPalmRejection_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_LoadHeatmapPalmRejection_Name,
            codec.align(MachineLearningService_LoadHeatmapPalmRejection_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_LoadHeatmapPalmRejection_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMachineLearningService_REMOVED_4_Name:
      var params = reader.decodeStruct(MachineLearningService_REMOVED_4_Params);
      this.rEMOVED4(params.spec, params.receiver).then(function(response) {
        var responseParams =
            new MachineLearningService_REMOVED_4_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMachineLearningService_REMOVED_4_Name,
            codec.align(MachineLearningService_REMOVED_4_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MachineLearningService_REMOVED_4_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMachineLearningServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMachineLearningService_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MachineLearningService_Clone_Params;
      break;
      case kMachineLearningService_LoadBuiltinModel_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadBuiltinModel_Params;
      break;
      case kMachineLearningService_LoadFlatBufferModel_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadFlatBufferModel_Params;
      break;
      case kMachineLearningService_LoadTextClassifier_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadTextClassifier_Params;
      break;
      case kMachineLearningService_LoadHandwritingModel_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadHandwritingModel_Params;
      break;
      case kMachineLearningService_LoadSpeechRecognizer_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadSpeechRecognizer_Params;
      break;
      case kMachineLearningService_LoadGrammarChecker_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadGrammarChecker_Params;
      break;
      case kMachineLearningService_LoadTextSuggester_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadTextSuggester_Params;
      break;
      case kMachineLearningService_LoadWebPlatformHandwritingModel_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadWebPlatformHandwritingModel_Params;
      break;
      case kMachineLearningService_LoadDocumentScanner_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadDocumentScanner_Params;
      break;
      case kMachineLearningService_LoadImageAnnotator_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadImageAnnotator_Params;
      break;
      case kMachineLearningService_LoadHeatmapPalmRejection_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_LoadHeatmapPalmRejection_Params;
      break;
      case kMachineLearningService_REMOVED_4_Name:
        if (message.expectsResponse())
          paramsClass = MachineLearningService_REMOVED_4_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMachineLearningServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMachineLearningService_LoadBuiltinModel_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadBuiltinModel_ResponseParams;
        break;
      case kMachineLearningService_LoadFlatBufferModel_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadFlatBufferModel_ResponseParams;
        break;
      case kMachineLearningService_LoadTextClassifier_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadTextClassifier_ResponseParams;
        break;
      case kMachineLearningService_LoadHandwritingModel_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadHandwritingModel_ResponseParams;
        break;
      case kMachineLearningService_LoadSpeechRecognizer_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadSpeechRecognizer_ResponseParams;
        break;
      case kMachineLearningService_LoadGrammarChecker_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadGrammarChecker_ResponseParams;
        break;
      case kMachineLearningService_LoadTextSuggester_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadTextSuggester_ResponseParams;
        break;
      case kMachineLearningService_LoadWebPlatformHandwritingModel_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams;
        break;
      case kMachineLearningService_LoadDocumentScanner_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadDocumentScanner_ResponseParams;
        break;
      case kMachineLearningService_LoadImageAnnotator_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadImageAnnotator_ResponseParams;
        break;
      case kMachineLearningService_LoadHeatmapPalmRejection_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_LoadHeatmapPalmRejection_ResponseParams;
        break;
      case kMachineLearningService_REMOVED_4_Name:
        if (message.isResponse())
          paramsClass = MachineLearningService_REMOVED_4_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MachineLearningService = {
    name: 'chromeos.machine_learning.mojom.MachineLearningService',
    kVersion: 13,
    ptrClass: MachineLearningServicePtr,
    proxyClass: MachineLearningServiceProxy,
    stubClass: MachineLearningServiceStub,
    validateRequest: validateMachineLearningServiceRequest,
    validateResponse: validateMachineLearningServiceResponse,
  };
  MachineLearningServiceStub.prototype.validator = validateMachineLearningServiceRequest;
  MachineLearningServiceProxy.prototype.validator = validateMachineLearningServiceResponse;
  exports.LoadModelResult = LoadModelResult;
  exports.MachineLearningService = MachineLearningService;
  exports.MachineLearningServicePtr = MachineLearningServicePtr;
  exports.MachineLearningServiceAssociatedPtr = MachineLearningServiceAssociatedPtr;
})();