// chromeos/services/machine_learning/public/mojom/machine_learning_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  DocumentScannerRemote as chromeos_machineLearning_mojom_DocumentScannerRemote,
  DocumentScannerPendingReceiver as chromeos_machineLearning_mojom_DocumentScannerPendingReceiver,
  DocumentScannerConfig as chromeos_machineLearning_mojom_DocumentScannerConfig,
  DocumentScannerConfigSpec as chromeos_machineLearning_mojom_DocumentScannerConfigSpec
} from './document_scanner.mojom.m.js';

import {
  GrammarCheckerRemote as chromeos_machineLearning_mojom_GrammarCheckerRemote,
  GrammarCheckerPendingReceiver as chromeos_machineLearning_mojom_GrammarCheckerPendingReceiver
} from './grammar_checker.mojom.m.js';

import {
  LoadHandwritingModelResult as chromeos_machineLearning_mojom_LoadHandwritingModelResult,
  LoadHandwritingModelResultSpec as chromeos_machineLearning_mojom_LoadHandwritingModelResultSpec,
  HandwritingRecognizerRemote as chromeos_machineLearning_mojom_HandwritingRecognizerRemote,
  HandwritingRecognizerPendingReceiver as chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver,
  HandwritingRecognizerSpec as chromeos_machineLearning_mojom_HandwritingRecognizerSpec,
  HandwritingRecognizerSpecSpec as chromeos_machineLearning_mojom_HandwritingRecognizerSpecSpec
} from './handwriting_recognizer.mojom.m.js';

import {
  LoadHeatmapPalmRejectionResult as chromeos_machineLearning_mojom_LoadHeatmapPalmRejectionResult,
  LoadHeatmapPalmRejectionResultSpec as chromeos_machineLearning_mojom_LoadHeatmapPalmRejectionResultSpec,
  HeatmapPalmRejectionClientRemote as chromeos_machineLearning_mojom_HeatmapPalmRejectionClientRemote,
  HeatmapPalmRejectionClientPendingReceiver as chromeos_machineLearning_mojom_HeatmapPalmRejectionClientPendingReceiver,
  HeatmapPalmRejectionConfig as chromeos_machineLearning_mojom_HeatmapPalmRejectionConfig,
  HeatmapPalmRejectionConfigSpec as chromeos_machineLearning_mojom_HeatmapPalmRejectionConfigSpec
} from './heatmap_palm_rejection.mojom.m.js';

import {
  ImageContentAnnotatorRemote as chromeos_machineLearning_mojom_ImageContentAnnotatorRemote,
  ImageContentAnnotatorPendingReceiver as chromeos_machineLearning_mojom_ImageContentAnnotatorPendingReceiver,
  ImageAnnotatorConfig as chromeos_machineLearning_mojom_ImageAnnotatorConfig,
  ImageAnnotatorConfigSpec as chromeos_machineLearning_mojom_ImageAnnotatorConfigSpec
} from './image_content_annotation.mojom.m.js';

import {
  ModelRemote as chromeos_machineLearning_mojom_ModelRemote,
  ModelPendingReceiver as chromeos_machineLearning_mojom_ModelPendingReceiver,
  BuiltinModelSpec as chromeos_machineLearning_mojom_BuiltinModelSpec,
  BuiltinModelSpecSpec as chromeos_machineLearning_mojom_BuiltinModelSpecSpec,
  FlatBufferModelSpec as chromeos_machineLearning_mojom_FlatBufferModelSpec,
  FlatBufferModelSpecSpec as chromeos_machineLearning_mojom_FlatBufferModelSpecSpec
} from './model.mojom.m.js';

import {
  SodaClientRemote as chromeos_machineLearning_mojom_SodaClientRemote,
  SodaClientPendingReceiver as chromeos_machineLearning_mojom_SodaClientPendingReceiver,
  SodaRecognizerRemote as chromeos_machineLearning_mojom_SodaRecognizerRemote,
  SodaRecognizerPendingReceiver as chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver,
  SodaConfig as chromeos_machineLearning_mojom_SodaConfig,
  SodaConfigSpec as chromeos_machineLearning_mojom_SodaConfigSpec
} from './soda.mojom.m.js';

import {
  TextClassifierRemote as chromeos_machineLearning_mojom_TextClassifierRemote,
  TextClassifierPendingReceiver as chromeos_machineLearning_mojom_TextClassifierPendingReceiver
} from './text_classifier.mojom.m.js';

import {
  TextSuggesterRemote as chromeos_machineLearning_mojom_TextSuggesterRemote,
  TextSuggesterPendingReceiver as chromeos_machineLearning_mojom_TextSuggesterPendingReceiver,
  TextSuggesterSpec as chromeos_machineLearning_mojom_TextSuggesterSpec,
  TextSuggesterSpecSpec as chromeos_machineLearning_mojom_TextSuggesterSpecSpec
} from './text_suggester.mojom.m.js';

import {
  HandwritingRecognizerRemote as chromeos_machineLearning_webPlatform_mojom_HandwritingRecognizerRemote,
  HandwritingRecognizerPendingReceiver as chromeos_machineLearning_webPlatform_mojom_HandwritingRecognizerPendingReceiver,
  HandwritingModelConstraint as chromeos_machineLearning_webPlatform_mojom_HandwritingModelConstraint,
  HandwritingModelConstraintSpec as chromeos_machineLearning_webPlatform_mojom_HandwritingModelConstraintSpec
} from './web_platform_handwriting.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LoadModelResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LoadModelResult = {
  
  OK: 0,
  MODEL_SPEC_ERROR: 1,
  LOAD_MODEL_ERROR: 2,
  FEATURE_NOT_SUPPORTED_ERROR: 3,
  LANGUAGE_NOT_SUPPORTED_ERROR: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MachineLearningServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.MachineLearningService', scope);
  }
}

/** @interface */
export class MachineLearningServiceInterface {
  
  /**
   * @param { !MachineLearningServicePendingReceiver } receiver
   */

  clone(receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_BuiltinModelSpec } spec
   * @param { !chromeos_machineLearning_mojom_ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadBuiltinModel(spec, receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_FlatBufferModelSpec } spec
   * @param { !chromeos_machineLearning_mojom_ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadFlatBufferModel(spec, receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_TextClassifierPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadTextClassifier(receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerSpec } spec
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos_machineLearning_mojom_LoadHandwritingModelResult,
   *  }>}
   */

  loadHandwritingModel(spec, receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_SodaConfig } config
   * @param { !chromeos_machineLearning_mojom_SodaClientRemote } sodaClient
   * @param { !chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver } sodaRecognizer
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadSpeechRecognizer(config, sodaClient, sodaRecognizer) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_GrammarCheckerPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadGrammarChecker(receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_TextSuggesterPendingReceiver } receiver
   * @param { ?chromeos_machineLearning_mojom_TextSuggesterSpec } spec
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadTextSuggester(receiver, spec) {}
  
  /**
   * @param { !chromeos_machineLearning_webPlatform_mojom_HandwritingModelConstraint } constraint
   * @param { !chromeos_machineLearning_webPlatform_mojom_HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos_machineLearning_mojom_LoadHandwritingModelResult,
   *  }>}
   */

  loadWebPlatformHandwritingModel(constraint, receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_DocumentScannerPendingReceiver } receiver
   * @param { ?chromeos_machineLearning_mojom_DocumentScannerConfig } config
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadDocumentScanner(receiver, config) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_ImageAnnotatorConfig } config
   * @param { !chromeos_machineLearning_mojom_ImageContentAnnotatorPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadImageAnnotator(config, receiver) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_HeatmapPalmRejectionConfig } config
   * @param { !chromeos_machineLearning_mojom_HeatmapPalmRejectionClientRemote } client
   * @return {!Promise<{
        result: !chromeos_machineLearning_mojom_LoadHeatmapPalmRejectionResult,
   *  }>}
   */

  loadHeatmapPalmRejection(config, client) {}
  
  /**
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerSpec } spec
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  rEMOVED4(spec, receiver) {}
}

/**
 * @implements { MachineLearningServiceInterface }
 */
export class MachineLearningServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MachineLearningServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MachineLearningServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MachineLearningServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MachineLearningServicePendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        5,
        MachineLearningService_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_BuiltinModelSpec } spec
   * @param { !chromeos_machineLearning_mojom_ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadBuiltinModel(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        0,
        MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
        MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_FlatBufferModelSpec } spec
   * @param { !chromeos_machineLearning_mojom_ModelPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadFlatBufferModel(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        1,
        MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
        MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_TextClassifierPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadTextClassifier(
      receiver) {
    return this.proxy.sendMessage(
        2,
        MachineLearningService_LoadTextClassifier_ParamsSpec.$,
        MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerSpec } spec
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos_machineLearning_mojom_LoadHandwritingModelResult,
   *  }>}
   */

  loadHandwritingModel(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        3,
        MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
        MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_SodaConfig } config
   * @param { !chromeos_machineLearning_mojom_SodaClientRemote } sodaClient
   * @param { !chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver } sodaRecognizer
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadSpeechRecognizer(
      config,
      sodaClient,
      sodaRecognizer) {
    return this.proxy.sendMessage(
        6,
        MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
        MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
        [
          config,
          sodaClient,
          sodaRecognizer
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_GrammarCheckerPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadGrammarChecker(
      receiver) {
    return this.proxy.sendMessage(
        7,
        MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
        MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_TextSuggesterPendingReceiver } receiver
   * @param { ?chromeos_machineLearning_mojom_TextSuggesterSpec } spec
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadTextSuggester(
      receiver,
      spec) {
    return this.proxy.sendMessage(
        8,
        MachineLearningService_LoadTextSuggester_ParamsSpec.$,
        MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
        [
          receiver,
          spec
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_webPlatform_mojom_HandwritingModelConstraint } constraint
   * @param { !chromeos_machineLearning_webPlatform_mojom_HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos_machineLearning_mojom_LoadHandwritingModelResult,
   *  }>}
   */

  loadWebPlatformHandwritingModel(
      constraint,
      receiver) {
    return this.proxy.sendMessage(
        9,
        MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
        MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
        [
          constraint,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_DocumentScannerPendingReceiver } receiver
   * @param { ?chromeos_machineLearning_mojom_DocumentScannerConfig } config
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadDocumentScanner(
      receiver,
      config) {
    return this.proxy.sendMessage(
        10,
        MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
        MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
        [
          receiver,
          config
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_ImageAnnotatorConfig } config
   * @param { !chromeos_machineLearning_mojom_ImageContentAnnotatorPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadImageAnnotator(
      config,
      receiver) {
    return this.proxy.sendMessage(
        12,
        MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
        MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
        [
          config,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_HeatmapPalmRejectionConfig } config
   * @param { !chromeos_machineLearning_mojom_HeatmapPalmRejectionClientRemote } client
   * @return {!Promise<{
        result: !chromeos_machineLearning_mojom_LoadHeatmapPalmRejectionResult,
   *  }>}
   */

  loadHeatmapPalmRejection(
      config,
      client) {
    return this.proxy.sendMessage(
        13,
        MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
        MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
        [
          config,
          client
        ],
        false);
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerSpec } spec
   * @param { !chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver } receiver
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  rEMOVED4(
      spec,
      receiver) {
    return this.proxy.sendMessage(
        4,
        MachineLearningService_REMOVED_4_ParamsSpec.$,
        MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
        [
          spec,
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MachineLearningService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MachineLearningServiceReceiver {
  /**
   * @param {!MachineLearningServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MachineLearningServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MachineLearningServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MachineLearningServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        5,
        MachineLearningService_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        0,
        MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
        MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
        impl.loadBuiltinModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
        MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
        impl.loadFlatBufferModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MachineLearningService_LoadTextClassifier_ParamsSpec.$,
        MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
        impl.loadTextClassifier.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
        MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
        impl.loadHandwritingModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
        MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
        impl.loadSpeechRecognizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
        MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
        impl.loadGrammarChecker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MachineLearningService_LoadTextSuggester_ParamsSpec.$,
        MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
        impl.loadTextSuggester.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
        MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
        impl.loadWebPlatformHandwritingModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
        MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
        impl.loadDocumentScanner.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
        MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
        impl.loadImageAnnotator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
        MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
        impl.loadHeatmapPalmRejection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MachineLearningService_REMOVED_4_ParamsSpec.$,
        MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
        impl.rEMOVED4.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MachineLearningService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.MachineLearningService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MachineLearningServiceRemote}
   */
  static getRemote() {
    let remote = new MachineLearningServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MachineLearningService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MachineLearningServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MachineLearningServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MachineLearningServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MachineLearningService_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadBuiltinModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
        MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
        this.loadBuiltinModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadFlatBufferModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
        MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
        this.loadFlatBufferModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadTextClassifier =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MachineLearningService_LoadTextClassifier_ParamsSpec.$,
        MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
        this.loadTextClassifier.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadHandwritingModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
        MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
        this.loadHandwritingModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadSpeechRecognizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
        MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
        this.loadSpeechRecognizer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadGrammarChecker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
        MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
        this.loadGrammarChecker.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadTextSuggester =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MachineLearningService_LoadTextSuggester_ParamsSpec.$,
        MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
        this.loadTextSuggester.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadWebPlatformHandwritingModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
        MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
        this.loadWebPlatformHandwritingModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadDocumentScanner =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
        MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
        this.loadDocumentScanner.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadImageAnnotator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
        MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
        this.loadImageAnnotator.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadHeatmapPalmRejection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
        MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
        this.loadHeatmapPalmRejection.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED4 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MachineLearningService_REMOVED_4_ParamsSpec.$,
        MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
        this.rEMOVED4.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadBuiltinModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadBuiltinModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadFlatBufferModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadTextClassifier_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadTextClassifier_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadHandwritingModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadHandwritingModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadSpeechRecognizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadGrammarChecker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadGrammarChecker_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadTextSuggester_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadTextSuggester_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadDocumentScanner_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadDocumentScanner_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadImageAnnotator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadImageAnnotator_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_REMOVED_4_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MachineLearningService_REMOVED_4_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MachineLearningService_Clone_ParamsSpec.$,
    'MachineLearningService_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(MachineLearningServicePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_Clone_Params {
  constructor() {
    /** @type { !MachineLearningServicePendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadBuiltinModel_ParamsSpec.$,
    'MachineLearningService_LoadBuiltinModel_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos_machineLearning_mojom_BuiltinModelSpecSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_ModelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadBuiltinModel_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_BuiltinModelSpec } */
    this.spec;
    /** @type { !chromeos_machineLearning_mojom_ModelPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadBuiltinModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadBuiltinModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadBuiltinModel_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadFlatBufferModel_ParamsSpec.$,
    'MachineLearningService_LoadFlatBufferModel_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos_machineLearning_mojom_FlatBufferModelSpecSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_ModelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadFlatBufferModel_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_FlatBufferModelSpec } */
    this.spec;
    /** @type { !chromeos_machineLearning_mojom_ModelPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadFlatBufferModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadFlatBufferModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadFlatBufferModel_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadTextClassifier_ParamsSpec.$,
    'MachineLearningService_LoadTextClassifier_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_TextClassifierPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadTextClassifier_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_TextClassifierPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadTextClassifier_ResponseParamsSpec.$,
    'MachineLearningService_LoadTextClassifier_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadTextClassifier_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadHandwritingModel_ParamsSpec.$,
    'MachineLearningService_LoadHandwritingModel_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos_machineLearning_mojom_HandwritingRecognizerSpecSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadHandwritingModel_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_HandwritingRecognizerSpec } */
    this.spec;
    /** @type { !chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadHandwritingModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadHandwritingModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos_machineLearning_mojom_LoadHandwritingModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadHandwritingModel_ResponseParams {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_LoadHandwritingModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadSpeechRecognizer_ParamsSpec.$,
    'MachineLearningService_LoadSpeechRecognizer_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        chromeos_machineLearning_mojom_SodaConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sodaClient', 8,
        0,
        mojo.internal.InterfaceProxy(chromeos_machineLearning_mojom_SodaClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sodaRecognizer', 16,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MachineLearningService_LoadSpeechRecognizer_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_SodaConfig } */
    this.config;
    /** @type { !chromeos_machineLearning_mojom_SodaClientRemote } */
    this.sodaClient;
    /** @type { !chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver } */
    this.sodaRecognizer;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadSpeechRecognizer_ResponseParamsSpec.$,
    'MachineLearningService_LoadSpeechRecognizer_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadSpeechRecognizer_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadGrammarChecker_ParamsSpec.$,
    'MachineLearningService_LoadGrammarChecker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_GrammarCheckerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadGrammarChecker_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_GrammarCheckerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadGrammarChecker_ResponseParamsSpec.$,
    'MachineLearningService_LoadGrammarChecker_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadGrammarChecker_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadTextSuggester_ParamsSpec.$,
    'MachineLearningService_LoadTextSuggester_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_TextSuggesterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spec', 8,
        0,
        chromeos_machineLearning_mojom_TextSuggesterSpecSpec.$,
        null,
        true /* nullable */,
        3,
      ),
    ],
    [[0, 16],[3, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadTextSuggester_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_TextSuggesterPendingReceiver } */
    this.receiver;
    /** @type { (chromeos_machineLearning_mojom_TextSuggesterSpec|undefined) } */
    this.spec;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadTextSuggester_ResponseParamsSpec.$,
    'MachineLearningService_LoadTextSuggester_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadTextSuggester_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadWebPlatformHandwritingModel_ParamsSpec.$,
    'MachineLearningService_LoadWebPlatformHandwritingModel_Params',
    [
      mojo.internal.StructField(
        'constraint', 0,
        0,
        chromeos_machineLearning_webPlatform_mojom_HandwritingModelConstraintSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_webPlatform_mojom_HandwritingRecognizerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadWebPlatformHandwritingModel_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_webPlatform_mojom_HandwritingModelConstraint } */
    this.constraint;
    /** @type { !chromeos_machineLearning_webPlatform_mojom_HandwritingRecognizerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParamsSpec.$,
    'MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos_machineLearning_mojom_LoadHandwritingModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadWebPlatformHandwritingModel_ResponseParams {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_LoadHandwritingModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadDocumentScanner_ParamsSpec.$,
    'MachineLearningService_LoadDocumentScanner_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_DocumentScannerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        chromeos_machineLearning_mojom_DocumentScannerConfigSpec.$,
        null,
        true /* nullable */,
        6,
      ),
    ],
    [[0, 16],[6, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadDocumentScanner_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_DocumentScannerPendingReceiver } */
    this.receiver;
    /** @type { (chromeos_machineLearning_mojom_DocumentScannerConfig|undefined) } */
    this.config;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadDocumentScanner_ResponseParamsSpec.$,
    'MachineLearningService_LoadDocumentScanner_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadDocumentScanner_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadImageAnnotator_ParamsSpec.$,
    'MachineLearningService_LoadImageAnnotator_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        chromeos_machineLearning_mojom_ImageAnnotatorConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_ImageContentAnnotatorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadImageAnnotator_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_ImageAnnotatorConfig } */
    this.config;
    /** @type { !chromeos_machineLearning_mojom_ImageContentAnnotatorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadImageAnnotator_ResponseParamsSpec.$,
    'MachineLearningService_LoadImageAnnotator_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadImageAnnotator_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadHeatmapPalmRejection_ParamsSpec.$,
    'MachineLearningService_LoadHeatmapPalmRejection_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        chromeos_machineLearning_mojom_HeatmapPalmRejectionConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(chromeos_machineLearning_mojom_HeatmapPalmRejectionClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_LoadHeatmapPalmRejection_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_HeatmapPalmRejectionConfig } */
    this.config;
    /** @type { !chromeos_machineLearning_mojom_HeatmapPalmRejectionClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    MachineLearningService_LoadHeatmapPalmRejection_ResponseParamsSpec.$,
    'MachineLearningService_LoadHeatmapPalmRejection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos_machineLearning_mojom_LoadHeatmapPalmRejectionResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_LoadHeatmapPalmRejection_ResponseParams {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_LoadHeatmapPalmRejectionResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MachineLearningService_REMOVED_4_ParamsSpec.$,
    'MachineLearningService_REMOVED_4_Params',
    [
      mojo.internal.StructField(
        'spec', 0,
        0,
        chromeos_machineLearning_mojom_HandwritingRecognizerSpecSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MachineLearningService_REMOVED_4_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_HandwritingRecognizerSpec } */
    this.spec;
    /** @type { !chromeos_machineLearning_mojom_HandwritingRecognizerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MachineLearningService_REMOVED_4_ResponseParamsSpec.$,
    'MachineLearningService_REMOVED_4_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MachineLearningService_REMOVED_4_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}

