// chromeos/services/machine_learning/public/mojom/model.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('chromeos.machineLearning.mojom.GraphExecutor');




goog.provide('chromeos.machineLearning.mojom.BuiltinModelId');
goog.provide('chromeos.machineLearning.mojom.BuiltinModelIdSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.BuiltinModelIdSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.BuiltinModelId = {
  
  UNSUPPORTED_UNKNOWN: 0,
  TEST_MODEL: 1,
  UNSUPPORTED_SMART_DIM_20181115: 2,
  UNSUPPORTED_SMART_DIM_20190221: 3,
  UNSUPPORTED_TOP_CAT_20190722: 4,
  SMART_DIM_20190521: 5,
  UNSUPPORTED_SEARCH_RANKER_20190923: 6,
  UNSUPPORTED_ADAPTIVE_CHARGING_20211105: 7,
  UNSUPPORTED_PONCHO_PALM_REJECTION_20230213: 8,
  ADAPTIVE_CHARGING_20230314: 9,
  PONCHO_PALM_REJECTION_20230907: 10,
  PONCHO_PALM_REJECTION_20240313: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

goog.provide('chromeos.machineLearning.mojom.GpuDelegateApi');
goog.provide('chromeos.machineLearning.mojom.GpuDelegateApiSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.GpuDelegateApiSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.GpuDelegateApi = {
  
  UNKNOWN: 0,
  OPENGL: 1,
  OPENCL: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('chromeos.machineLearning.mojom.CreateGraphExecutorResult');
goog.provide('chromeos.machineLearning.mojom.CreateGraphExecutorResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.CreateGraphExecutorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.CreateGraphExecutorResult = {
  
  OK: 0,
  MODEL_INTERPRETATION_ERROR: 1,
  MEMORY_ALLOCATION_ERROR: 2,
  NNAPI_UNAVAILABLE: 3,
  NNAPI_USE_ERROR: 4,
  GPU_UNAVAILABLE: 5,
  GPU_USE_ERROR: 6,
  DELEGATE_CONFIG_ERROR: 7,
  NOT_FULLY_DELEGABLE: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};



goog.provide('chromeos.machineLearning.mojom.Model');
goog.provide('chromeos.machineLearning.mojom.ModelReceiver');
goog.provide('chromeos.machineLearning.mojom.ModelCallbackRouter');
goog.provide('chromeos.machineLearning.mojom.ModelInterface');
goog.provide('chromeos.machineLearning.mojom.ModelRemote');
goog.provide('chromeos.machineLearning.mojom.ModelPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.ModelPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.Model.$interfaceName,
        scope);
  }
};

/** @interface */
chromeos.machineLearning.mojom.ModelInterface = class {
  
  /**
   * @param { !chromeos.machineLearning.mojom.GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.CreateGraphExecutorResult,
   *  }>}
   */

  rEMOVED0(receiver) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.GraphExecutorOptions } options
   * @param { !chromeos.machineLearning.mojom.GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.CreateGraphExecutorResult,
   *  }>}
   */

  createGraphExecutor(options, receiver) {}
};

/**
 * @export
 * @implements { chromeos.machineLearning.mojom.ModelInterface }
 */
chromeos.machineLearning.mojom.ModelRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.ModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.ModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.ModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.CreateGraphExecutorResult,
   *  }>}
   */

  rEMOVED0(
      receiver) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.Model_REMOVED_0_ParamsSpec.$,
        chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParamsSpec.$,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.GraphExecutorOptions } options
   * @param { !chromeos.machineLearning.mojom.GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.CreateGraphExecutorResult,
   *  }>}
   */

  createGraphExecutor(
      options,
      receiver) {
    return this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ParamsSpec.$,
        chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParamsSpec.$,
        [
          options,
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Model
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.ModelReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.ModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.ModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.ModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.ModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.Model_REMOVED_0_ParamsSpec.$,
        chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParamsSpec.$,
        impl.rEMOVED0.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ParamsSpec.$,
        chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParamsSpec.$,
        impl.createGraphExecutor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.Model = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.Model";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.ModelRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.ModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Model
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.ModelCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.ModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.ModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED0 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.Model_REMOVED_0_ParamsSpec.$,
        chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParamsSpec.$,
        this.rEMOVED0.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createGraphExecutor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ParamsSpec.$,
        chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParamsSpec.$,
        this.createGraphExecutor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('chromeos.machineLearning.mojom.GraphExecutorOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GraphExecutorOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.BuiltinModelSpecSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.BuiltinModelSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.FlatBufferModelSpecSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.FlatBufferModelSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.Model_REMOVED_0_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.Model_REMOVED_0_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.GraphExecutorOptionsSpec.$,
    'GraphExecutorOptions',
    [
      mojo.internal.StructField(
        'useNnapi', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useGpu', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'gpuDelegateApi', 4,
        0,
        chromeos.machineLearning.mojom.GpuDelegateApiSpec.$,
        chromeos.machineLearning.mojom.GpuDelegateApi.OPENGL,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[1, 16],[2, 16],]);



goog.provide('chromeos.machineLearning.mojom.GraphExecutorOptions');

/** @record */
chromeos.machineLearning.mojom.GraphExecutorOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.useNnapi;
    /** @export { !boolean } */
    this.useGpu;
    /** @export { !chromeos.machineLearning.mojom.GpuDelegateApi } */
    this.gpuDelegateApi;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.BuiltinModelSpecSpec.$,
    'BuiltinModelSpec',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        chromeos.machineLearning.mojom.BuiltinModelIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.BuiltinModelSpec');

/** @record */
chromeos.machineLearning.mojom.BuiltinModelSpec = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.BuiltinModelId } */
    this.id;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.FlatBufferModelSpecSpec.$,
    'FlatBufferModelSpec',
    [
      mojo.internal.StructField(
        'modelString', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputs', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Int32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputs', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Int32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metricsModelName', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('chromeos.machineLearning.mojom.FlatBufferModelSpec');

/** @record */
chromeos.machineLearning.mojom.FlatBufferModelSpec = class {
  constructor() {
    /** @export { !string } */
    this.modelString;
    /** @export { !Object<!string, !number> } */
    this.inputs;
    /** @export { !Object<!string, !number> } */
    this.outputs;
    /** @export { !string } */
    this.metricsModelName;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.Model_REMOVED_0_ParamsSpec.$,
    'Model_REMOVED_0_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.GraphExecutorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.Model_REMOVED_0_Params');

/** @record */
chromeos.machineLearning.mojom.Model_REMOVED_0_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.GraphExecutorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParamsSpec.$,
    'Model_REMOVED_0_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.CreateGraphExecutorResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.Model_REMOVED_0_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.CreateGraphExecutorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ParamsSpec.$,
    'Model_CreateGraphExecutor_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        chromeos.machineLearning.mojom.GraphExecutorOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.machineLearning.mojom.GraphExecutorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.Model_CreateGraphExecutor_Params');

/** @record */
chromeos.machineLearning.mojom.Model_CreateGraphExecutor_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.GraphExecutorOptions } */
    this.options;
    /** @export { !chromeos.machineLearning.mojom.GraphExecutorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParamsSpec.$,
    'Model_CreateGraphExecutor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.CreateGraphExecutorResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.Model_CreateGraphExecutor_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.CreateGraphExecutorResult } */
    this.result;
  }
};

