// chromeos/services/machine_learning/public/mojom/model.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/model.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var graph_executor$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/graph_executor.mojom', 'graph_executor.mojom.js');
  }


  var BuiltinModelId = {};
  BuiltinModelId.UNSUPPORTED_UNKNOWN = 0;
  BuiltinModelId.TEST_MODEL = 1;
  BuiltinModelId.UNSUPPORTED_SMART_DIM_20181115 = 2;
  BuiltinModelId.UNSUPPORTED_SMART_DIM_20190221 = 3;
  BuiltinModelId.UNSUPPORTED_TOP_CAT_20190722 = 4;
  BuiltinModelId.SMART_DIM_20190521 = 5;
  BuiltinModelId.UNSUPPORTED_SEARCH_RANKER_20190923 = 6;
  BuiltinModelId.UNSUPPORTED_ADAPTIVE_CHARGING_20211105 = 7;
  BuiltinModelId.UNSUPPORTED_PONCHO_PALM_REJECTION_20230213 = 8;
  BuiltinModelId.ADAPTIVE_CHARGING_20230314 = 9;
  BuiltinModelId.PONCHO_PALM_REJECTION_20230907 = 10;
  BuiltinModelId.PONCHO_PALM_REJECTION_20240313 = 11;
  BuiltinModelId.MIN_VALUE = 0;
  BuiltinModelId.MAX_VALUE = 11;

  BuiltinModelId.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  BuiltinModelId.toKnownEnumValue = function(value) {
    return value;
  };

  BuiltinModelId.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var GpuDelegateApi = {};
  GpuDelegateApi.UNKNOWN = 0;
  GpuDelegateApi.OPENGL = 1;
  GpuDelegateApi.OPENCL = 2;
  GpuDelegateApi.MIN_VALUE = 0;
  GpuDelegateApi.MAX_VALUE = 2;
  GpuDelegateApi.DEFAULT_VALUE = 0;

  GpuDelegateApi.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  GpuDelegateApi.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  GpuDelegateApi.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CreateGraphExecutorResult = {};
  CreateGraphExecutorResult.OK = 0;
  CreateGraphExecutorResult.MODEL_INTERPRETATION_ERROR = 1;
  CreateGraphExecutorResult.MEMORY_ALLOCATION_ERROR = 2;
  CreateGraphExecutorResult.NNAPI_UNAVAILABLE = 3;
  CreateGraphExecutorResult.NNAPI_USE_ERROR = 4;
  CreateGraphExecutorResult.GPU_UNAVAILABLE = 5;
  CreateGraphExecutorResult.GPU_USE_ERROR = 6;
  CreateGraphExecutorResult.DELEGATE_CONFIG_ERROR = 7;
  CreateGraphExecutorResult.NOT_FULLY_DELEGABLE = 8;
  CreateGraphExecutorResult.MIN_VALUE = 0;
  CreateGraphExecutorResult.MAX_VALUE = 8;

  CreateGraphExecutorResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  CreateGraphExecutorResult.toKnownEnumValue = function(value) {
    return value;
  };

  CreateGraphExecutorResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GraphExecutorOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GraphExecutorOptions.prototype.initDefaults_ = function() {
    this.useNnapi = false;
    this.useGpu = false;
    this.gpuDelegateApi = GpuDelegateApi.OPENGL;
  };
  GraphExecutorOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GraphExecutorOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 1, numBytes: 16},
      {version: 2, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // version check GraphExecutorOptions.gpuDelegateApi
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate GraphExecutorOptions.gpuDelegateApi
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, GpuDelegateApi);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GraphExecutorOptions.encodedSize = codec.kStructHeaderSize + 8;

  GraphExecutorOptions.decode = function(decoder) {
    var packed;
    var val = new GraphExecutorOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.useNnapi = (packed >> 0) & 1 ? true : false;
    val.useGpu = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 2) {
      val.gpuDelegateApi =
          decoder.decodeStruct(new codec.Enum(GpuDelegateApi));
    } else {
      val.gpuDelegateApi = null;
    }
    return val;
  };

  GraphExecutorOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GraphExecutorOptions.encodedSize);
    encoder.writeUint32(2);
    packed = 0;
    packed |= (val.useNnapi & 1) << 0
    packed |= (val.useGpu & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.gpuDelegateApi);
  };
  function BuiltinModelSpec(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BuiltinModelSpec.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  BuiltinModelSpec.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BuiltinModelSpec.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BuiltinModelSpec.id
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BuiltinModelId);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BuiltinModelSpec.encodedSize = codec.kStructHeaderSize + 8;

  BuiltinModelSpec.decode = function(decoder) {
    var packed;
    var val = new BuiltinModelSpec();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(new codec.Enum(BuiltinModelId));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BuiltinModelSpec.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BuiltinModelSpec.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FlatBufferModelSpec(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FlatBufferModelSpec.prototype.initDefaults_ = function() {
    this.modelString = null;
    this.inputs = null;
    this.outputs = null;
    this.metricsModelName = null;
  };
  FlatBufferModelSpec.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FlatBufferModelSpec.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FlatBufferModelSpec.modelString
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FlatBufferModelSpec.inputs
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, codec.Int32, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FlatBufferModelSpec.outputs
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.String, codec.Int32, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FlatBufferModelSpec.metricsModelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FlatBufferModelSpec.encodedSize = codec.kStructHeaderSize + 32;

  FlatBufferModelSpec.decode = function(decoder) {
    var packed;
    var val = new FlatBufferModelSpec();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.modelString =
        decoder.decodeStruct(codec.String);
    val.inputs =
        decoder.decodeMapPointer(codec.String, codec.Int32);
    val.outputs =
        decoder.decodeMapPointer(codec.String, codec.Int32);
    val.metricsModelName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FlatBufferModelSpec.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FlatBufferModelSpec.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.modelString);
    encoder.encodeMapPointer(codec.String, codec.Int32, val.inputs);
    encoder.encodeMapPointer(codec.String, codec.Int32, val.outputs);
    encoder.encodeStruct(codec.String, val.metricsModelName);
  };
  function Model_REMOVED_0_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Model_REMOVED_0_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  Model_REMOVED_0_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Model_REMOVED_0_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Model_REMOVED_0_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Model_REMOVED_0_Params.encodedSize = codec.kStructHeaderSize + 8;

  Model_REMOVED_0_Params.decode = function(decoder) {
    var packed;
    var val = new Model_REMOVED_0_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Model_REMOVED_0_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Model_REMOVED_0_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Model_REMOVED_0_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Model_REMOVED_0_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  Model_REMOVED_0_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Model_REMOVED_0_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Model_REMOVED_0_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CreateGraphExecutorResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Model_REMOVED_0_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Model_REMOVED_0_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Model_REMOVED_0_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CreateGraphExecutorResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Model_REMOVED_0_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Model_REMOVED_0_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Model_CreateGraphExecutor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Model_CreateGraphExecutor_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  Model_CreateGraphExecutor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Model_CreateGraphExecutor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Model_CreateGraphExecutor_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GraphExecutorOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Model_CreateGraphExecutor_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Model_CreateGraphExecutor_Params.encodedSize = codec.kStructHeaderSize + 16;

  Model_CreateGraphExecutor_Params.decode = function(decoder) {
    var packed;
    var val = new Model_CreateGraphExecutor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(GraphExecutorOptions);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Model_CreateGraphExecutor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Model_CreateGraphExecutor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GraphExecutorOptions, val.options);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Model_CreateGraphExecutor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Model_CreateGraphExecutor_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  Model_CreateGraphExecutor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Model_CreateGraphExecutor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Model_CreateGraphExecutor_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CreateGraphExecutorResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Model_CreateGraphExecutor_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Model_CreateGraphExecutor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Model_CreateGraphExecutor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CreateGraphExecutorResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Model_CreateGraphExecutor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Model_CreateGraphExecutor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kModel_REMOVED_0_Name = 0;
  var kModel_CreateGraphExecutor_Name = 1;

  function ModelPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Model,
                                                   handleOrPtrInfo);
  }

  function ModelAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Model, associatedInterfacePtrInfo);
  }

  ModelAssociatedPtr.prototype =
      Object.create(ModelPtr.prototype);
  ModelAssociatedPtr.prototype.constructor =
      ModelAssociatedPtr;

  function ModelProxy(receiver) {
    this.receiver_ = receiver;
  }
  ModelPtr.prototype.rEMOVED0 = function() {
    return ModelProxy.prototype.rEMOVED0
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelProxy.prototype.rEMOVED0 = function(receiver) {
    var params_ = new Model_REMOVED_0_Params();
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kModel_REMOVED_0_Name,
          codec.align(Model_REMOVED_0_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Model_REMOVED_0_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Model_REMOVED_0_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ModelPtr.prototype.createGraphExecutor = function() {
    return ModelProxy.prototype.createGraphExecutor
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelProxy.prototype.createGraphExecutor = function(options, receiver) {
    var params_ = new Model_CreateGraphExecutor_Params();
    params_.options = options;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kModel_CreateGraphExecutor_Name,
          codec.align(Model_CreateGraphExecutor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Model_CreateGraphExecutor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Model_CreateGraphExecutor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ModelStub(delegate) {
    this.delegate_ = delegate;
  }
  ModelStub.prototype.rEMOVED0 = function(receiver) {
    return this.delegate_ && this.delegate_.rEMOVED0 && this.delegate_.rEMOVED0(receiver);
  }
  ModelStub.prototype.createGraphExecutor = function(options, receiver) {
    return this.delegate_ && this.delegate_.createGraphExecutor && this.delegate_.createGraphExecutor(options, receiver);
  }

  ModelStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ModelStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kModel_REMOVED_0_Name:
      var params = reader.decodeStruct(Model_REMOVED_0_Params);
      this.rEMOVED0(params.receiver).then(function(response) {
        var responseParams =
            new Model_REMOVED_0_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kModel_REMOVED_0_Name,
            codec.align(Model_REMOVED_0_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Model_REMOVED_0_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kModel_CreateGraphExecutor_Name:
      var params = reader.decodeStruct(Model_CreateGraphExecutor_Params);
      this.createGraphExecutor(params.options, params.receiver).then(function(response) {
        var responseParams =
            new Model_CreateGraphExecutor_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kModel_CreateGraphExecutor_Name,
            codec.align(Model_CreateGraphExecutor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Model_CreateGraphExecutor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateModelRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kModel_REMOVED_0_Name:
        if (message.expectsResponse())
          paramsClass = Model_REMOVED_0_Params;
      break;
      case kModel_CreateGraphExecutor_Name:
        if (message.expectsResponse())
          paramsClass = Model_CreateGraphExecutor_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateModelResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kModel_REMOVED_0_Name:
        if (message.isResponse())
          paramsClass = Model_REMOVED_0_ResponseParams;
        break;
      case kModel_CreateGraphExecutor_Name:
        if (message.isResponse())
          paramsClass = Model_CreateGraphExecutor_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var Model = {
    name: 'chromeos.machine_learning.mojom.Model',
    kVersion: 0,
    ptrClass: ModelPtr,
    proxyClass: ModelProxy,
    stubClass: ModelStub,
    validateRequest: validateModelRequest,
    validateResponse: validateModelResponse,
  };
  ModelStub.prototype.validator = validateModelRequest;
  ModelProxy.prototype.validator = validateModelResponse;
  exports.BuiltinModelId = BuiltinModelId;
  exports.GpuDelegateApi = GpuDelegateApi;
  exports.CreateGraphExecutorResult = CreateGraphExecutorResult;
  exports.GraphExecutorOptions = GraphExecutorOptions;
  exports.BuiltinModelSpec = BuiltinModelSpec;
  exports.FlatBufferModelSpec = FlatBufferModelSpec;
  exports.Model = Model;
  exports.ModelPtr = ModelPtr;
  exports.ModelAssociatedPtr = ModelAssociatedPtr;
})();