// chromeos/services/machine_learning/public/mojom/model.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  GraphExecutorRemote as chromeos_machineLearning_mojom_GraphExecutorRemote,
  GraphExecutorPendingReceiver as chromeos_machineLearning_mojom_GraphExecutorPendingReceiver
} from './graph_executor.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BuiltinModelIdSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BuiltinModelId = {
  
  UNSUPPORTED_UNKNOWN: 0,
  TEST_MODEL: 1,
  UNSUPPORTED_SMART_DIM_20181115: 2,
  UNSUPPORTED_SMART_DIM_20190221: 3,
  UNSUPPORTED_TOP_CAT_20190722: 4,
  SMART_DIM_20190521: 5,
  UNSUPPORTED_SEARCH_RANKER_20190923: 6,
  UNSUPPORTED_ADAPTIVE_CHARGING_20211105: 7,
  UNSUPPORTED_PONCHO_PALM_REJECTION_20230213: 8,
  ADAPTIVE_CHARGING_20230314: 9,
  PONCHO_PALM_REJECTION_20230907: 10,
  PONCHO_PALM_REJECTION_20240313: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GpuDelegateApiSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GpuDelegateApi = {
  
  UNKNOWN: 0,
  OPENGL: 1,
  OPENCL: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CreateGraphExecutorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CreateGraphExecutorResult = {
  
  OK: 0,
  MODEL_INTERPRETATION_ERROR: 1,
  MEMORY_ALLOCATION_ERROR: 2,
  NNAPI_UNAVAILABLE: 3,
  NNAPI_USE_ERROR: 4,
  GPU_UNAVAILABLE: 5,
  GPU_USE_ERROR: 6,
  DELEGATE_CONFIG_ERROR: 7,
  NOT_FULLY_DELEGABLE: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ModelPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.Model', scope);
  }
}

/** @interface */
export class ModelInterface {
  
  /**
   * @param { !chromeos_machineLearning_mojom_GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !CreateGraphExecutorResult,
   *  }>}
   */

  rEMOVED0(receiver) {}
  
  /**
   * @param { !GraphExecutorOptions } options
   * @param { !chromeos_machineLearning_mojom_GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !CreateGraphExecutorResult,
   *  }>}
   */

  createGraphExecutor(options, receiver) {}
}

/**
 * @implements { ModelInterface }
 */
export class ModelRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos_machineLearning_mojom_GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !CreateGraphExecutorResult,
   *  }>}
   */

  rEMOVED0(
      receiver) {
    return this.proxy.sendMessage(
        0,
        Model_REMOVED_0_ParamsSpec.$,
        Model_REMOVED_0_ResponseParamsSpec.$,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !GraphExecutorOptions } options
   * @param { !chromeos_machineLearning_mojom_GraphExecutorPendingReceiver } receiver
   * @return {!Promise<{
        result: !CreateGraphExecutorResult,
   *  }>}
   */

  createGraphExecutor(
      options,
      receiver) {
    return this.proxy.sendMessage(
        1,
        Model_CreateGraphExecutor_ParamsSpec.$,
        Model_CreateGraphExecutor_ResponseParamsSpec.$,
        [
          options,
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Model
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ModelReceiver {
  /**
   * @param {!ModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Model_REMOVED_0_ParamsSpec.$,
        Model_REMOVED_0_ResponseParamsSpec.$,
        impl.rEMOVED0.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Model_CreateGraphExecutor_ParamsSpec.$,
        Model_CreateGraphExecutor_ResponseParamsSpec.$,
        impl.createGraphExecutor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Model {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.Model";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ModelRemote}
   */
  static getRemote() {
    let remote = new ModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Model
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ModelCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED0 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Model_REMOVED_0_ParamsSpec.$,
        Model_REMOVED_0_ResponseParamsSpec.$,
        this.rEMOVED0.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createGraphExecutor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Model_CreateGraphExecutor_ParamsSpec.$,
        Model_CreateGraphExecutor_ResponseParamsSpec.$,
        this.createGraphExecutor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GraphExecutorOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BuiltinModelSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FlatBufferModelSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Model_REMOVED_0_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Model_REMOVED_0_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Model_CreateGraphExecutor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Model_CreateGraphExecutor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GraphExecutorOptionsSpec.$,
    'GraphExecutorOptions',
    [
      mojo.internal.StructField(
        'useNnapi', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useGpu', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'gpuDelegateApi', 4,
        0,
        GpuDelegateApiSpec.$,
        GpuDelegateApi.OPENGL,
        false /* nullable */,
        2,
      ),
    ],
    [[0, 16],[1, 16],[2, 16],]);



/**
 * @record
 */
export class GraphExecutorOptions {
  constructor() {
    /** @type { !boolean } */
    this.useNnapi;
    /** @type { !boolean } */
    this.useGpu;
    /** @type { !GpuDelegateApi } */
    this.gpuDelegateApi;
  }
}



mojo.internal.Struct(
    BuiltinModelSpecSpec.$,
    'BuiltinModelSpec',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        BuiltinModelIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BuiltinModelSpec {
  constructor() {
    /** @type { !BuiltinModelId } */
    this.id;
  }
}



mojo.internal.Struct(
    FlatBufferModelSpecSpec.$,
    'FlatBufferModelSpec',
    [
      mojo.internal.StructField(
        'modelString', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputs', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputs', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metricsModelName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FlatBufferModelSpec {
  constructor() {
    /** @type { !string } */
    this.modelString;
    /** @type { !Object<!string, !number> } */
    this.inputs;
    /** @type { !Object<!string, !number> } */
    this.outputs;
    /** @type { !string } */
    this.metricsModelName;
  }
}



mojo.internal.Struct(
    Model_REMOVED_0_ParamsSpec.$,
    'Model_REMOVED_0_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_GraphExecutorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Model_REMOVED_0_Params {
  constructor() {
    /** @type { !chromeos_machineLearning_mojom_GraphExecutorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    Model_REMOVED_0_ResponseParamsSpec.$,
    'Model_REMOVED_0_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CreateGraphExecutorResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Model_REMOVED_0_ResponseParams {
  constructor() {
    /** @type { !CreateGraphExecutorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    Model_CreateGraphExecutor_ParamsSpec.$,
    'Model_CreateGraphExecutor_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        GraphExecutorOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_GraphExecutorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Model_CreateGraphExecutor_Params {
  constructor() {
    /** @type { !GraphExecutorOptions } */
    this.options;
    /** @type { !chromeos_machineLearning_mojom_GraphExecutorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    Model_CreateGraphExecutor_ResponseParamsSpec.$,
    'Model_CreateGraphExecutor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CreateGraphExecutorResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Model_CreateGraphExecutor_ResponseParams {
  constructor() {
    /** @type { !CreateGraphExecutorResult } */
    this.result;
  }
}

