// chromeos/services/machine_learning/public/mojom/soda.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.Time');
goog.require('mojoBase.mojom.TimeDelta');




goog.provide('chromeos.machineLearning.mojom.OptionalBool');
goog.provide('chromeos.machineLearning.mojom.OptionalBoolSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.OptionalBoolSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.OptionalBool = {
  
  kUnknown: 0,
  kFalse: 1,
  kTrue: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('chromeos.machineLearning.mojom.SodaRecognitionMode');
goog.provide('chromeos.machineLearning.mojom.SodaRecognitionModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognitionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognitionMode = {
  
  kCaption: 0,
  kIme: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('chromeos.machineLearning.mojom.SpeakerDiarizationMode');
goog.provide('chromeos.machineLearning.mojom.SpeakerDiarizationModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.SpeakerDiarizationModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.SpeakerDiarizationMode = {
  
  kDiarizationUnspecified: 0,
  kSpeakerDiarizationModeOffDefault: 1,
  kSpeakerChangeDetection: 2,
  kSpeakerLabelDetection: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('chromeos.machineLearning.mojom.EndpointerType');
goog.provide('chromeos.machineLearning.mojom.EndpointerTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.EndpointerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.EndpointerType = {
  
  START_OF_SPEECH: 0,
  END_OF_SPEECH: 1,
  END_OF_AUDIO: 2,
  END_OF_UTTERANCE: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('chromeos.machineLearning.mojom.EndpointReason');
goog.provide('chromeos.machineLearning.mojom.EndpointReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.EndpointReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.EndpointReason = {
  
  ENDPOINT_UNKNOWN: 0,
  ENDPOINT_END_OF_SPEECH: 1,
  ENDPOINT_END_OF_UTTERANCE: 2,
  ENDPOINT_END_OF_AUDIO: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('chromeos.machineLearning.mojom.AsrSwitchResult');
goog.provide('chromeos.machineLearning.mojom.AsrSwitchResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.AsrSwitchResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.AsrSwitchResult = {
  
  DEFAULT_NO_SWITCH: 0,
  SWITCH_SUCCEEDED: 1,
  SWITCH_FAILED: 2,
  SWITCH_SKIPPED_NO_LP: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('chromeos.machineLearning.mojom.SodaClient');
goog.provide('chromeos.machineLearning.mojom.SodaClientReceiver');
goog.provide('chromeos.machineLearning.mojom.SodaClientCallbackRouter');
goog.provide('chromeos.machineLearning.mojom.SodaClientInterface');
goog.provide('chromeos.machineLearning.mojom.SodaClientRemote');
goog.provide('chromeos.machineLearning.mojom.SodaClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.SodaClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.SodaClient.$interfaceName,
        scope);
  }
};

/** @interface */
chromeos.machineLearning.mojom.SodaClientInterface = class {
  
  /**
   */

  onStart() {}
  
  /**
   */

  onStop() {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.SpeechRecognizerEvent } event
   */

  onSpeechRecognizerEvent(event) {}
};

/**
 * @export
 * @implements { chromeos.machineLearning.mojom.SodaClientInterface }
 */
chromeos.machineLearning.mojom.SodaClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.SodaClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.SodaClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.SodaClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onStart() {
    this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.SodaClient_OnStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onStop() {
    this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.SodaClient_OnStop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.SpeechRecognizerEvent } event
   */

  onSpeechRecognizerEvent(
      event) {
    this.proxy.sendMessage(
        2,
        chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SodaClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.SodaClientReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.SodaClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.SodaClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.SodaClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.SodaClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.SodaClient_OnStart_ParamsSpec.$,
        null,
        impl.onStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.SodaClient_OnStop_ParamsSpec.$,
        null,
        impl.onStop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
        null,
        impl.onSpeechRecognizerEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.SodaClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.SodaClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.SodaClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.SodaClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SodaClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.SodaClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.SodaClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.SodaClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.SodaClient_OnStart_ParamsSpec.$,
        null,
        this.onStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.SodaClient_OnStop_ParamsSpec.$,
        null,
        this.onStop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognizerEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
        null,
        this.onSpeechRecognizerEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('chromeos.machineLearning.mojom.SodaRecognizer');
goog.provide('chromeos.machineLearning.mojom.SodaRecognizerReceiver');
goog.provide('chromeos.machineLearning.mojom.SodaRecognizerCallbackRouter');
goog.provide('chromeos.machineLearning.mojom.SodaRecognizerInterface');
goog.provide('chromeos.machineLearning.mojom.SodaRecognizerRemote');
goog.provide('chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.SodaRecognizer.$interfaceName,
        scope);
  }
};

/** @interface */
chromeos.machineLearning.mojom.SodaRecognizerInterface = class {
  
  /**
   * @param { !Array<!number> } audio
   */

  addAudio(audio) {}
  
  /**
   */

  stop() {}
  
  /**
   */

  start() {}
  
  /**
   */

  markDone() {}
};

/**
 * @export
 * @implements { chromeos.machineLearning.mojom.SodaRecognizerInterface }
 */
chromeos.machineLearning.mojom.SodaRecognizerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.SodaRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } audio
   */

  addAudio(
      audio) {
    this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_ParamsSpec.$,
        null,
        [
          audio
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.SodaRecognizer_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  start() {
    this.proxy.sendMessage(
        2,
        chromeos.machineLearning.mojom.SodaRecognizer_Start_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  markDone() {
    this.proxy.sendMessage(
        3,
        chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SodaRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizerReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.SodaRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.SodaRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.SodaRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.SodaRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_ParamsSpec.$,
        null,
        impl.addAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.SodaRecognizer_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.SodaRecognizer_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_ParamsSpec.$,
        null,
        impl.markDone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.SodaRecognizer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.SodaRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.SodaRecognizerRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.SodaRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SodaRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.SodaRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.SodaRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_ParamsSpec.$,
        null,
        this.addAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.SodaRecognizer_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.SodaRecognizer_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.markDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_ParamsSpec.$,
        null,
        this.markDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('chromeos.machineLearning.mojom.SodaMultilangConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaMultilangConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TimingInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TimingInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.EndpointerEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.EndpointerEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.HypothesisPartInResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.HypothesisPartInResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.PartialResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.PartialResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.FinalResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.FinalResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.AudioLevelEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.AudioLevelEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.LangIdEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.LangIdEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.LabelCorrectionEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.LabelCorrectionEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaClient_OnStart_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaClient_OnStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaClient_OnStop_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaClient_OnStop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_Stop_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizer_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_Start_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizer_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.SpeechRecognizerEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.SpeechRecognizerEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaMultilangConfigSpec.$,
    'SodaMultilangConfig',
    [
      mojo.internal.StructField(
        'rewindWhenSwitchingLanguage', 0,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localeToLanguagePackMap', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.SodaMultilangConfig');

/** @record */
chromeos.machineLearning.mojom.SodaMultilangConfig = class {
  constructor() {
    /** @export { !boolean } */
    this.rewindWhenSwitchingLanguage;
    /** @export { !Object<!string, !string> } */
    this.localeToLanguagePackMap;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaConfigSpec.$,
    'SodaConfig',
    [
      mojo.internal.StructField(
        'channelCount', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'apiKey', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'libraryDlcPath', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'languageDlcPath', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableFormatting', 32,
        0,
        chromeos.machineLearning.mojom.OptionalBoolSpec.$,
        chromeos.machineLearning.mojom.OptionalBool.kTrue,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recognitionMode', 36,
        0,
        chromeos.machineLearning.mojom.SodaRecognitionModeSpec.$,
        chromeos.machineLearning.mojom.SodaRecognitionMode.kCaption,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maskOffensiveWords', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'speakerChangeDetection', 40,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeLoggingOutput', 40,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multiLangConfig', 48,
        0,
        chromeos.machineLearning.mojom.SodaMultilangConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'speakerDiarizationMode', 44,
        0,
        chromeos.machineLearning.mojom.SpeakerDiarizationModeSpec.$,
        chromeos.machineLearning.mojom.SpeakerDiarizationMode.kSpeakerDiarizationModeOffDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxSpeakerCount', 56,
        0,
        mojo.internal.Uint32,
        2,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],[2, 48],[3, 48],[4, 56],[5, 56],[6, 56],[7, 64],[9, 72],]);



goog.provide('chromeos.machineLearning.mojom.SodaConfig');

/** @record */
chromeos.machineLearning.mojom.SodaConfig = class {
  constructor() {
    /** @export { !number } */
    this.channelCount;
    /** @export { !number } */
    this.sampleRate;
    /** @export { !string } */
    this.apiKey;
    /** @export { !string } */
    this.libraryDlcPath;
    /** @export { !string } */
    this.languageDlcPath;
    /** @export { !chromeos.machineLearning.mojom.OptionalBool } */
    this.enableFormatting;
    /** @export { !chromeos.machineLearning.mojom.SodaRecognitionMode } */
    this.recognitionMode;
    /** @export { !boolean } */
    this.maskOffensiveWords;
    /** @export { !boolean } */
    this.speakerChangeDetection;
    /** @export { !boolean } */
    this.includeLoggingOutput;
    /** @export { (chromeos.machineLearning.mojom.SodaMultilangConfig|undefined) } */
    this.multiLangConfig;
    /** @export { !chromeos.machineLearning.mojom.SpeakerDiarizationMode } */
    this.speakerDiarizationMode;
    /** @export { !number } */
    this.maxSpeakerCount;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TimingInfoSpec.$,
    'TimingInfo',
    [
      mojo.internal.StructField(
        'audioStartEpoch', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioStartTime', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'elapsedWallTime', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventEndTime', 24,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'latency', 32,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'normalizedLatency', 40,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wordAlignments', 48,
        0,
        mojo.internal.Array(mojoBase.mojom.TimeDeltaSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('chromeos.machineLearning.mojom.TimingInfo');

/** @record */
chromeos.machineLearning.mojom.TimingInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.audioStartEpoch;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.audioStartTime;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.elapsedWallTime;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.eventEndTime;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.latency;
    /** @export { !number } */
    this.normalizedLatency;
    /** @export { !Array<!mojoBase.mojom.TimeDelta> } */
    this.wordAlignments;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.EndpointerEventSpec.$,
    'EndpointerEvent',
    [
      mojo.internal.StructField(
        'endpointerType', 0,
        0,
        chromeos.machineLearning.mojom.EndpointerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timingEvent', 8,
        0,
        chromeos.machineLearning.mojom.TimingInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.EndpointerEvent');

/** @record */
chromeos.machineLearning.mojom.EndpointerEvent = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.EndpointerType } */
    this.endpointerType;
    /** @export { (chromeos.machineLearning.mojom.TimingInfo|undefined) } */
    this.timingEvent;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.HypothesisPartInResultSpec.$,
    'HypothesisPartInResult',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alignment', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'leading_space_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "leading_space_$value",
          originalFieldName: "leadingSpace",
        }
      ),
      mojo.internal.StructField(
        'leading_space_$value', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "leadingSpace",
        }
      ),
      mojo.internal.StructField(
        'speakerChange', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'speakerLabel', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[8, 32],[9, 40],]);



goog.provide('chromeos.machineLearning.mojom.HypothesisPartInResult');

/** @record */
chromeos.machineLearning.mojom.HypothesisPartInResult = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.text;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.alignment;
    /** @export { (boolean|undefined) } */
    this.leadingSpace;
    /** @export { !boolean } */
    this.speakerChange;
    /** @export { (string|undefined) } */
    this.speakerLabel;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.PartialResultSpec.$,
    'PartialResult',
    [
      mojo.internal.StructField(
        'partialText', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timingEvent', 8,
        0,
        chromeos.machineLearning.mojom.TimingInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hypothesisPart', 16,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.HypothesisPartInResultSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[9, 32],]);



goog.provide('chromeos.machineLearning.mojom.PartialResult');

/** @record */
chromeos.machineLearning.mojom.PartialResult = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.partialText;
    /** @export { (chromeos.machineLearning.mojom.TimingInfo|undefined) } */
    this.timingEvent;
    /** @export { (Array<!chromeos.machineLearning.mojom.HypothesisPartInResult>|undefined) } */
    this.hypothesisPart;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.FinalResultSpec.$,
    'FinalResult',
    [
      mojo.internal.StructField(
        'finalHypotheses', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpointReason', 8,
        0,
        chromeos.machineLearning.mojom.EndpointReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timingEvent', 16,
        0,
        chromeos.machineLearning.mojom.TimingInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hypothesisPart', 24,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.HypothesisPartInResultSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[1, 40],]);



goog.provide('chromeos.machineLearning.mojom.FinalResult');

/** @record */
chromeos.machineLearning.mojom.FinalResult = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.finalHypotheses;
    /** @export { !chromeos.machineLearning.mojom.EndpointReason } */
    this.endpointReason;
    /** @export { (chromeos.machineLearning.mojom.TimingInfo|undefined) } */
    this.timingEvent;
    /** @export { (Array<!chromeos.machineLearning.mojom.HypothesisPartInResult>|undefined) } */
    this.hypothesisPart;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.AudioLevelEventSpec.$,
    'AudioLevelEvent',
    [
      mojo.internal.StructField(
        'rms', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioLevel', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.AudioLevelEvent');

/** @record */
chromeos.machineLearning.mojom.AudioLevelEvent = class {
  constructor() {
    /** @export { !number } */
    this.rms;
    /** @export { !number } */
    this.audioLevel;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.LangIdEventSpec.$,
    'LangIdEvent',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'confidenceLevel', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'asrSwitchResult', 12,
        0,
        chromeos.machineLearning.mojom.AsrSwitchResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.LangIdEvent');

/** @record */
chromeos.machineLearning.mojom.LangIdEvent = class {
  constructor() {
    /** @export { !string } */
    this.language;
    /** @export { !number } */
    this.confidenceLevel;
    /** @export { !chromeos.machineLearning.mojom.AsrSwitchResult } */
    this.asrSwitchResult;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.LabelCorrectionEventSpec.$,
    'LabelCorrectionEvent',
    [
      mojo.internal.StructField(
        'hypothesisParts', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.HypothesisPartInResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.LabelCorrectionEvent');

/** @record */
chromeos.machineLearning.mojom.LabelCorrectionEvent = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.mojom.HypothesisPartInResult> } */
    this.hypothesisParts;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaClient_OnStart_ParamsSpec.$,
    'SodaClient_OnStart_Params',
    [
    ],
    [[0, 8],]);



goog.provide('chromeos.machineLearning.mojom.SodaClient_OnStart_Params');

/** @record */
chromeos.machineLearning.mojom.SodaClient_OnStart_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaClient_OnStop_ParamsSpec.$,
    'SodaClient_OnStop_Params',
    [
    ],
    [[0, 8],]);



goog.provide('chromeos.machineLearning.mojom.SodaClient_OnStop_Params');

/** @record */
chromeos.machineLearning.mojom.SodaClient_OnStop_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
    'SodaClient_OnSpeechRecognizerEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        chromeos.machineLearning.mojom.SpeechRecognizerEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_Params');

/** @record */
chromeos.machineLearning.mojom.SodaClient_OnSpeechRecognizerEvent_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.SpeechRecognizerEvent } */
    this.event;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_ParamsSpec.$,
    'SodaRecognizer_AddAudio_Params',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_Params');

/** @record */
chromeos.machineLearning.mojom.SodaRecognizer_AddAudio_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.audio;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaRecognizer_Stop_ParamsSpec.$,
    'SodaRecognizer_Stop_Params',
    [
    ],
    [[0, 8],]);



goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_Stop_Params');

/** @record */
chromeos.machineLearning.mojom.SodaRecognizer_Stop_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaRecognizer_Start_ParamsSpec.$,
    'SodaRecognizer_Start_Params',
    [
    ],
    [[0, 8],]);



goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_Start_Params');

/** @record */
chromeos.machineLearning.mojom.SodaRecognizer_Start_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_ParamsSpec.$,
    'SodaRecognizer_MarkDone_Params',
    [
    ],
    [[0, 8],]);



goog.provide('chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_Params');

/** @record */
chromeos.machineLearning.mojom.SodaRecognizer_MarkDone_Params = class {
  constructor() {
  }
};

goog.provide('chromeos.machineLearning.mojom.SpeechRecognizerEvent');


mojo.internal.Union(
    chromeos.machineLearning.mojom.SpeechRecognizerEventSpec.$, 'SpeechRecognizerEvent',
    {
      'audioEvent': {
        'ordinal': 0,
        'type': chromeos.machineLearning.mojom.AudioLevelEventSpec.$,
      },
      'partialResult': {
        'ordinal': 1,
        'type': chromeos.machineLearning.mojom.PartialResultSpec.$,
      },
      'endpointerEvent': {
        'ordinal': 2,
        'type': chromeos.machineLearning.mojom.EndpointerEventSpec.$,
      },
      'finalResult': {
        'ordinal': 3,
        'type': chromeos.machineLearning.mojom.FinalResultSpec.$,
      },
      'langidEvent': {
        'ordinal': 4,
        'type': chromeos.machineLearning.mojom.LangIdEventSpec.$,
      },
      'labelCorrectionEvent': {
        'ordinal': 5,
        'type': chromeos.machineLearning.mojom.LabelCorrectionEventSpec.$,
      },
    });

/**
 * @typedef { {
 *   audioEvent: (!chromeos.machineLearning.mojom.AudioLevelEvent|undefined),
 *   partialResult: (!chromeos.machineLearning.mojom.PartialResult|undefined),
 *   endpointerEvent: (!chromeos.machineLearning.mojom.EndpointerEvent|undefined),
 *   finalResult: (!chromeos.machineLearning.mojom.FinalResult|undefined),
 *   langidEvent: (!chromeos.machineLearning.mojom.LangIdEvent|undefined),
 *   labelCorrectionEvent: (!chromeos.machineLearning.mojom.LabelCorrectionEvent|undefined),
 * } }
 */
chromeos.machineLearning.mojom.SpeechRecognizerEvent;
