// chromeos/services/machine_learning/public/mojom/soda.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/soda.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var OptionalBool = {};
  OptionalBool.kUnknown = 0;
  OptionalBool.kFalse = 1;
  OptionalBool.kTrue = 2;
  OptionalBool.MIN_VALUE = 0;
  OptionalBool.MAX_VALUE = 2;
  OptionalBool.DEFAULT_VALUE = 0;

  OptionalBool.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  OptionalBool.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  OptionalBool.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SodaRecognitionMode = {};
  SodaRecognitionMode.kCaption = 0;
  SodaRecognitionMode.kIme = 1;
  SodaRecognitionMode.MIN_VALUE = 0;
  SodaRecognitionMode.MAX_VALUE = 1;
  SodaRecognitionMode.DEFAULT_VALUE = 0;

  SodaRecognitionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SodaRecognitionMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SodaRecognitionMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SpeakerDiarizationMode = {};
  SpeakerDiarizationMode.kDiarizationUnspecified = 0;
  SpeakerDiarizationMode.kSpeakerDiarizationModeOffDefault = 1;
  SpeakerDiarizationMode.kSpeakerChangeDetection = 2;
  SpeakerDiarizationMode.kSpeakerLabelDetection = 3;
  SpeakerDiarizationMode.MIN_VALUE = 0;
  SpeakerDiarizationMode.MAX_VALUE = 3;
  SpeakerDiarizationMode.DEFAULT_VALUE = 1;

  SpeakerDiarizationMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SpeakerDiarizationMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SpeakerDiarizationMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EndpointerType = {};
  EndpointerType.START_OF_SPEECH = 0;
  EndpointerType.END_OF_SPEECH = 1;
  EndpointerType.END_OF_AUDIO = 2;
  EndpointerType.END_OF_UTTERANCE = 3;
  EndpointerType.MIN_VALUE = 0;
  EndpointerType.MAX_VALUE = 3;

  EndpointerType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  EndpointerType.toKnownEnumValue = function(value) {
    return value;
  };

  EndpointerType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EndpointReason = {};
  EndpointReason.ENDPOINT_UNKNOWN = 0;
  EndpointReason.ENDPOINT_END_OF_SPEECH = 1;
  EndpointReason.ENDPOINT_END_OF_UTTERANCE = 2;
  EndpointReason.ENDPOINT_END_OF_AUDIO = 3;
  EndpointReason.MIN_VALUE = 0;
  EndpointReason.MAX_VALUE = 3;

  EndpointReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  EndpointReason.toKnownEnumValue = function(value) {
    return value;
  };

  EndpointReason.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AsrSwitchResult = {};
  AsrSwitchResult.DEFAULT_NO_SWITCH = 0;
  AsrSwitchResult.SWITCH_SUCCEEDED = 1;
  AsrSwitchResult.SWITCH_FAILED = 2;
  AsrSwitchResult.SWITCH_SKIPPED_NO_LP = 3;
  AsrSwitchResult.MIN_VALUE = 0;
  AsrSwitchResult.MAX_VALUE = 3;
  AsrSwitchResult.DEFAULT_VALUE = 0;

  AsrSwitchResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AsrSwitchResult.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AsrSwitchResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SodaMultilangConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaMultilangConfig.prototype.initDefaults_ = function() {
    this.rewindWhenSwitchingLanguage = true;
    this.localeToLanguagePackMap = null;
  };
  SodaMultilangConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaMultilangConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SodaMultilangConfig.localeToLanguagePackMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaMultilangConfig.encodedSize = codec.kStructHeaderSize + 16;

  SodaMultilangConfig.decode = function(decoder) {
    var packed;
    var val = new SodaMultilangConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.rewindWhenSwitchingLanguage = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localeToLanguagePackMap =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  SodaMultilangConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaMultilangConfig.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.rewindWhenSwitchingLanguage & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeMapPointer(codec.String, codec.String, val.localeToLanguagePackMap);
  };
  function SodaConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaConfig.prototype.initDefaults_ = function() {
    this.channelCount = 0;
    this.sampleRate = 0;
    this.apiKey = null;
    this.libraryDlcPath = null;
    this.languageDlcPath = null;
    this.enableFormatting = OptionalBool.kTrue;
    this.recognitionMode = SodaRecognitionMode.kCaption;
    this.maskOffensiveWords = false;
    this.speakerChangeDetection = false;
    this.includeLoggingOutput = false;
    this.speakerDiarizationMode = SpeakerDiarizationMode.kSpeakerDiarizationModeOffDefault;
    this.multiLangConfig = null;
    this.maxSpeakerCount = 2;
  };
  SodaConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40},
      {version: 2, numBytes: 48},
      {version: 3, numBytes: 48},
      {version: 4, numBytes: 56},
      {version: 5, numBytes: 56},
      {version: 6, numBytes: 56},
      {version: 7, numBytes: 64},
      {version: 9, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate SodaConfig.apiKey
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SodaConfig.libraryDlcPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SodaConfig.languageDlcPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check SodaConfig.enableFormatting
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate SodaConfig.enableFormatting
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, OptionalBool);
    if (err !== validator.validationError.NONE)
        return err;



    // version check SodaConfig.recognitionMode
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate SodaConfig.recognitionMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, SodaRecognitionMode);
    if (err !== validator.validationError.NONE)
        return err;






    // version check SodaConfig.multiLangConfig
    if (!messageValidator.isFieldInStructVersion(offset, 7))
      return validator.validationError.NONE;
    // validate SodaConfig.multiLangConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, SodaMultilangConfig, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check SodaConfig.speakerDiarizationMode
    if (!messageValidator.isFieldInStructVersion(offset, 9))
      return validator.validationError.NONE;
    // validate SodaConfig.speakerDiarizationMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 44, SpeakerDiarizationMode);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SodaConfig.encodedSize = codec.kStructHeaderSize + 64;

  SodaConfig.decode = function(decoder) {
    var packed;
    var val = new SodaConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.channelCount =
        decoder.decodeStruct(codec.Uint32);
    val.sampleRate =
        decoder.decodeStruct(codec.Uint32);
    val.apiKey =
        decoder.decodeStruct(codec.String);
    val.libraryDlcPath =
        decoder.decodeStruct(codec.String);
    val.languageDlcPath =
        decoder.decodeStruct(codec.String);
    if (version >= 2) {
      val.enableFormatting =
          decoder.decodeStruct(new codec.Enum(OptionalBool));
    } else {
      val.enableFormatting = null;
    }
    if (version >= 3) {
      val.recognitionMode =
          decoder.decodeStruct(new codec.Enum(SodaRecognitionMode));
    } else {
      val.recognitionMode = null;
    }
    packed = decoder.readUint8();
    val.maskOffensiveWords = (packed >> 0) & 1 ? true : false;
    val.speakerChangeDetection = (packed >> 1) & 1 ? true : false;
    val.includeLoggingOutput = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 9) {
      val.speakerDiarizationMode =
          decoder.decodeStruct(new codec.Enum(SpeakerDiarizationMode));
    } else {
      val.speakerDiarizationMode = null;
    }
    if (version >= 7) {
      val.multiLangConfig =
          decoder.decodeStructPointer(SodaMultilangConfig);
    } else {
      val.multiLangConfig = null;
    }
    if (version >= 9) {
      val.maxSpeakerCount =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.maxSpeakerCount = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SodaConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaConfig.encodedSize);
    encoder.writeUint32(9);
    encoder.encodeStruct(codec.Uint32, val.channelCount);
    encoder.encodeStruct(codec.Uint32, val.sampleRate);
    encoder.encodeStruct(codec.String, val.apiKey);
    encoder.encodeStruct(codec.String, val.libraryDlcPath);
    encoder.encodeStruct(codec.String, val.languageDlcPath);
    encoder.encodeStruct(codec.Int32, val.enableFormatting);
    encoder.encodeStruct(codec.Int32, val.recognitionMode);
    packed = 0;
    packed |= (val.maskOffensiveWords & 1) << 0
    packed |= (val.speakerChangeDetection & 1) << 1
    packed |= (val.includeLoggingOutput & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.speakerDiarizationMode);
    encoder.encodeStructPointer(SodaMultilangConfig, val.multiLangConfig);
    encoder.encodeStruct(codec.Uint32, val.maxSpeakerCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TimingInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TimingInfo.prototype.initDefaults_ = function() {
    this.audioStartEpoch = null;
    this.audioStartTime = null;
    this.elapsedWallTime = null;
    this.eventEndTime = null;
    this.latency = null;
    this.normalizedLatency = 0;
    this.wordAlignments = null;
  };
  TimingInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TimingInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.audioStartEpoch
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.audioStartTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.elapsedWallTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.eventEndTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.latency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TimingInfo.wordAlignments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(time$.TimeDelta), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TimingInfo.encodedSize = codec.kStructHeaderSize + 56;

  TimingInfo.decode = function(decoder) {
    var packed;
    var val = new TimingInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioStartEpoch =
        decoder.decodeStructPointer(time$.Time);
    val.audioStartTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.elapsedWallTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.eventEndTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.latency =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.normalizedLatency =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.wordAlignments =
        decoder.decodeArrayPointer(new codec.PointerTo(time$.TimeDelta));
    return val;
  };

  TimingInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TimingInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.audioStartEpoch);
    encoder.encodeStructPointer(time$.TimeDelta, val.audioStartTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.elapsedWallTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.eventEndTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.latency);
    encoder.encodeStruct(codec.Float, val.normalizedLatency);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(time$.TimeDelta), val.wordAlignments);
  };
  function EndpointerEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EndpointerEvent.prototype.initDefaults_ = function() {
    this.endpointerType = 0;
    this.timingEvent = null;
  };
  EndpointerEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EndpointerEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EndpointerEvent.endpointerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, EndpointerType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EndpointerEvent.timingEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, TimingInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EndpointerEvent.encodedSize = codec.kStructHeaderSize + 16;

  EndpointerEvent.decode = function(decoder) {
    var packed;
    var val = new EndpointerEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.endpointerType =
        decoder.decodeStruct(new codec.Enum(EndpointerType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timingEvent =
        decoder.decodeStructPointer(TimingInfo);
    return val;
  };

  EndpointerEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EndpointerEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.endpointerType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(TimingInfo, val.timingEvent);
  };
  function HypothesisPartInResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HypothesisPartInResult.prototype.initDefaults_ = function() {
    this.text = null;
    this.alignment = null;
    this.leading_space_$flag = false;
    this.leading_space_$value = false;
    this.speakerChange = false;
    this.speakerLabel = null;
  };
  HypothesisPartInResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HypothesisPartInResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 8, numBytes: 32},
      {version: 9, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HypothesisPartInResult.text
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HypothesisPartInResult.alignment
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;






    // version check HypothesisPartInResult.speakerLabel
    if (!messageValidator.isFieldInStructVersion(offset, 9))
      return validator.validationError.NONE;
    // validate HypothesisPartInResult.speakerLabel
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HypothesisPartInResult.encodedSize = codec.kStructHeaderSize + 32;

  HypothesisPartInResult.decode = function(decoder) {
    var packed;
    var val = new HypothesisPartInResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeArrayPointer(codec.String);
    val.alignment =
        decoder.decodeStructPointer(time$.TimeDelta);
    packed = decoder.readUint8();
    val.leading_space_$flag = (packed >> 0) & 1 ? true : false;
    val.leading_space_$value = (packed >> 1) & 1 ? true : false;
    val.speakerChange = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 9) {
      val.speakerLabel =
          decoder.decodeStruct(codec.String);
    } else {
      val.speakerLabel = null;
    }
    return val;
  };

  HypothesisPartInResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HypothesisPartInResult.encodedSize);
    encoder.writeUint32(9);
    encoder.encodeArrayPointer(codec.String, val.text);
    encoder.encodeStructPointer(time$.TimeDelta, val.alignment);
    packed = 0;
    packed |= (val.leading_space_$flag & 1) << 0
    packed |= (val.leading_space_$value & 1) << 1
    packed |= (val.speakerChange & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.speakerLabel);
  };
  function PartialResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PartialResult.prototype.initDefaults_ = function() {
    this.partialText = null;
    this.timingEvent = null;
    this.hypothesisPart = null;
  };
  PartialResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PartialResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 9, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PartialResult.partialText
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PartialResult.timingEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, TimingInfo, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check PartialResult.hypothesisPart
    if (!messageValidator.isFieldInStructVersion(offset, 9))
      return validator.validationError.NONE;
    // validate PartialResult.hypothesisPart
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(HypothesisPartInResult), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PartialResult.encodedSize = codec.kStructHeaderSize + 24;

  PartialResult.decode = function(decoder) {
    var packed;
    var val = new PartialResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.partialText =
        decoder.decodeArrayPointer(codec.String);
    val.timingEvent =
        decoder.decodeStructPointer(TimingInfo);
    if (version >= 9) {
      val.hypothesisPart =
          decoder.decodeArrayPointer(new codec.PointerTo(HypothesisPartInResult));
    } else {
      val.hypothesisPart = null;
    }
    return val;
  };

  PartialResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PartialResult.encodedSize);
    encoder.writeUint32(9);
    encoder.encodeArrayPointer(codec.String, val.partialText);
    encoder.encodeStructPointer(TimingInfo, val.timingEvent);
    encoder.encodeArrayPointer(new codec.PointerTo(HypothesisPartInResult), val.hypothesisPart);
  };
  function FinalResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FinalResult.prototype.initDefaults_ = function() {
    this.finalHypotheses = null;
    this.endpointReason = 0;
    this.timingEvent = null;
    this.hypothesisPart = null;
  };
  FinalResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FinalResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 1, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FinalResult.finalHypotheses
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FinalResult.endpointReason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, EndpointReason);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FinalResult.timingEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, TimingInfo, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check FinalResult.hypothesisPart
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate FinalResult.hypothesisPart
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(HypothesisPartInResult), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FinalResult.encodedSize = codec.kStructHeaderSize + 32;

  FinalResult.decode = function(decoder) {
    var packed;
    var val = new FinalResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.finalHypotheses =
        decoder.decodeArrayPointer(codec.String);
    val.endpointReason =
        decoder.decodeStruct(new codec.Enum(EndpointReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timingEvent =
        decoder.decodeStructPointer(TimingInfo);
    if (version >= 1) {
      val.hypothesisPart =
          decoder.decodeArrayPointer(new codec.PointerTo(HypothesisPartInResult));
    } else {
      val.hypothesisPart = null;
    }
    return val;
  };

  FinalResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FinalResult.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeArrayPointer(codec.String, val.finalHypotheses);
    encoder.encodeStruct(codec.Int32, val.endpointReason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(TimingInfo, val.timingEvent);
    encoder.encodeArrayPointer(new codec.PointerTo(HypothesisPartInResult), val.hypothesisPart);
  };
  function AudioLevelEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioLevelEvent.prototype.initDefaults_ = function() {
    this.rms = 0;
    this.audioLevel = 0;
  };
  AudioLevelEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioLevelEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AudioLevelEvent.encodedSize = codec.kStructHeaderSize + 8;

  AudioLevelEvent.decode = function(decoder) {
    var packed;
    var val = new AudioLevelEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rms =
        decoder.decodeStruct(codec.Float);
    val.audioLevel =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  AudioLevelEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioLevelEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.rms);
    encoder.encodeStruct(codec.Float, val.audioLevel);
  };
  function LangIdEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LangIdEvent.prototype.initDefaults_ = function() {
    this.language = null;
    this.confidenceLevel = 0;
    this.asrSwitchResult = 0;
  };
  LangIdEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LangIdEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LangIdEvent.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate LangIdEvent.asrSwitchResult
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AsrSwitchResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LangIdEvent.encodedSize = codec.kStructHeaderSize + 16;

  LangIdEvent.decode = function(decoder) {
    var packed;
    var val = new LangIdEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.language =
        decoder.decodeStruct(codec.String);
    val.confidenceLevel =
        decoder.decodeStruct(codec.Int32);
    val.asrSwitchResult =
        decoder.decodeStruct(new codec.Enum(AsrSwitchResult));
    return val;
  };

  LangIdEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LangIdEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.language);
    encoder.encodeStruct(codec.Int32, val.confidenceLevel);
    encoder.encodeStruct(codec.Int32, val.asrSwitchResult);
  };
  function LabelCorrectionEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LabelCorrectionEvent.prototype.initDefaults_ = function() {
    this.hypothesisParts = null;
  };
  LabelCorrectionEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LabelCorrectionEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LabelCorrectionEvent.hypothesisParts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(HypothesisPartInResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LabelCorrectionEvent.encodedSize = codec.kStructHeaderSize + 8;

  LabelCorrectionEvent.decode = function(decoder) {
    var packed;
    var val = new LabelCorrectionEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hypothesisParts =
        decoder.decodeArrayPointer(new codec.PointerTo(HypothesisPartInResult));
    return val;
  };

  LabelCorrectionEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LabelCorrectionEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(HypothesisPartInResult), val.hypothesisParts);
  };
  function SodaClient_OnStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaClient_OnStart_Params.prototype.initDefaults_ = function() {
  };
  SodaClient_OnStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaClient_OnStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaClient_OnStart_Params.encodedSize = codec.kStructHeaderSize + 0;

  SodaClient_OnStart_Params.decode = function(decoder) {
    var packed;
    var val = new SodaClient_OnStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SodaClient_OnStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaClient_OnStart_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SodaClient_OnStop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaClient_OnStop_Params.prototype.initDefaults_ = function() {
  };
  SodaClient_OnStop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaClient_OnStop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaClient_OnStop_Params.encodedSize = codec.kStructHeaderSize + 0;

  SodaClient_OnStop_Params.decode = function(decoder) {
    var packed;
    var val = new SodaClient_OnStop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SodaClient_OnStop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaClient_OnStop_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SodaClient_OnSpeechRecognizerEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaClient_OnSpeechRecognizerEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  SodaClient_OnSpeechRecognizerEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaClient_OnSpeechRecognizerEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SodaClient_OnSpeechRecognizerEvent_Params.event
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SpeechRecognizerEvent, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaClient_OnSpeechRecognizerEvent_Params.encodedSize = codec.kStructHeaderSize + 16;

  SodaClient_OnSpeechRecognizerEvent_Params.decode = function(decoder) {
    var packed;
    var val = new SodaClient_OnSpeechRecognizerEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStruct(SpeechRecognizerEvent);
    return val;
  };

  SodaClient_OnSpeechRecognizerEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaClient_OnSpeechRecognizerEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SpeechRecognizerEvent, val.event);
  };
  function SodaRecognizer_AddAudio_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaRecognizer_AddAudio_Params.prototype.initDefaults_ = function() {
    this.audio = null;
  };
  SodaRecognizer_AddAudio_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaRecognizer_AddAudio_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SodaRecognizer_AddAudio_Params.audio
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaRecognizer_AddAudio_Params.encodedSize = codec.kStructHeaderSize + 8;

  SodaRecognizer_AddAudio_Params.decode = function(decoder) {
    var packed;
    var val = new SodaRecognizer_AddAudio_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audio =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SodaRecognizer_AddAudio_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaRecognizer_AddAudio_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.audio);
  };
  function SodaRecognizer_Stop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaRecognizer_Stop_Params.prototype.initDefaults_ = function() {
  };
  SodaRecognizer_Stop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaRecognizer_Stop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaRecognizer_Stop_Params.encodedSize = codec.kStructHeaderSize + 0;

  SodaRecognizer_Stop_Params.decode = function(decoder) {
    var packed;
    var val = new SodaRecognizer_Stop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SodaRecognizer_Stop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaRecognizer_Stop_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SodaRecognizer_Start_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaRecognizer_Start_Params.prototype.initDefaults_ = function() {
  };
  SodaRecognizer_Start_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaRecognizer_Start_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaRecognizer_Start_Params.encodedSize = codec.kStructHeaderSize + 0;

  SodaRecognizer_Start_Params.decode = function(decoder) {
    var packed;
    var val = new SodaRecognizer_Start_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SodaRecognizer_Start_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaRecognizer_Start_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SodaRecognizer_MarkDone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SodaRecognizer_MarkDone_Params.prototype.initDefaults_ = function() {
  };
  SodaRecognizer_MarkDone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SodaRecognizer_MarkDone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SodaRecognizer_MarkDone_Params.encodedSize = codec.kStructHeaderSize + 0;

  SodaRecognizer_MarkDone_Params.decode = function(decoder) {
    var packed;
    var val = new SodaRecognizer_MarkDone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SodaRecognizer_MarkDone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SodaRecognizer_MarkDone_Params.encodedSize);
    encoder.writeUint32(0);
  };

  function SpeechRecognizerEvent(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SpeechRecognizerEvent.Tags = {
    audioEvent: 0,
    partialResult: 1,
    endpointerEvent: 2,
    finalResult: 3,
    langidEvent: 4,
    labelCorrectionEvent: 5,
  };

  SpeechRecognizerEvent.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SpeechRecognizerEvent.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "audioEvent",
        "partialResult",
        "endpointerEvent",
        "finalResult",
        "langidEvent",
        "labelCorrectionEvent",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SpeechRecognizerEvent member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SpeechRecognizerEvent.prototype, "audioEvent", {
    get: function() {
      if (this.$tag != SpeechRecognizerEvent.Tags.audioEvent) {
        throw new ReferenceError(
            "SpeechRecognizerEvent.audioEvent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SpeechRecognizerEvent.Tags.audioEvent;
      this.$data = value;
    }
  });
  Object.defineProperty(SpeechRecognizerEvent.prototype, "partialResult", {
    get: function() {
      if (this.$tag != SpeechRecognizerEvent.Tags.partialResult) {
        throw new ReferenceError(
            "SpeechRecognizerEvent.partialResult is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SpeechRecognizerEvent.Tags.partialResult;
      this.$data = value;
    }
  });
  Object.defineProperty(SpeechRecognizerEvent.prototype, "endpointerEvent", {
    get: function() {
      if (this.$tag != SpeechRecognizerEvent.Tags.endpointerEvent) {
        throw new ReferenceError(
            "SpeechRecognizerEvent.endpointerEvent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SpeechRecognizerEvent.Tags.endpointerEvent;
      this.$data = value;
    }
  });
  Object.defineProperty(SpeechRecognizerEvent.prototype, "finalResult", {
    get: function() {
      if (this.$tag != SpeechRecognizerEvent.Tags.finalResult) {
        throw new ReferenceError(
            "SpeechRecognizerEvent.finalResult is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SpeechRecognizerEvent.Tags.finalResult;
      this.$data = value;
    }
  });
  Object.defineProperty(SpeechRecognizerEvent.prototype, "langidEvent", {
    get: function() {
      if (this.$tag != SpeechRecognizerEvent.Tags.langidEvent) {
        throw new ReferenceError(
            "SpeechRecognizerEvent.langidEvent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SpeechRecognizerEvent.Tags.langidEvent;
      this.$data = value;
    }
  });
  Object.defineProperty(SpeechRecognizerEvent.prototype, "labelCorrectionEvent", {
    get: function() {
      if (this.$tag != SpeechRecognizerEvent.Tags.labelCorrectionEvent) {
        throw new ReferenceError(
            "SpeechRecognizerEvent.labelCorrectionEvent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SpeechRecognizerEvent.Tags.labelCorrectionEvent;
      this.$data = value;
    }
  });


    SpeechRecognizerEvent.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SpeechRecognizerEvent.Tags.audioEvent:
          encoder.encodeStructPointer(AudioLevelEvent, val.audioEvent);
          break;
        case SpeechRecognizerEvent.Tags.partialResult:
          encoder.encodeStructPointer(PartialResult, val.partialResult);
          break;
        case SpeechRecognizerEvent.Tags.endpointerEvent:
          encoder.encodeStructPointer(EndpointerEvent, val.endpointerEvent);
          break;
        case SpeechRecognizerEvent.Tags.finalResult:
          encoder.encodeStructPointer(FinalResult, val.finalResult);
          break;
        case SpeechRecognizerEvent.Tags.langidEvent:
          encoder.encodeStructPointer(LangIdEvent, val.langidEvent);
          break;
        case SpeechRecognizerEvent.Tags.labelCorrectionEvent:
          encoder.encodeStructPointer(LabelCorrectionEvent, val.labelCorrectionEvent);
          break;
      }
      encoder.align();
    };


    SpeechRecognizerEvent.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SpeechRecognizerEvent();
      var tag = decoder.readUint32();
      switch (tag) {
        case SpeechRecognizerEvent.Tags.audioEvent:
          result.audioEvent = decoder.decodeStructPointer(AudioLevelEvent);
          break;
        case SpeechRecognizerEvent.Tags.partialResult:
          result.partialResult = decoder.decodeStructPointer(PartialResult);
          break;
        case SpeechRecognizerEvent.Tags.endpointerEvent:
          result.endpointerEvent = decoder.decodeStructPointer(EndpointerEvent);
          break;
        case SpeechRecognizerEvent.Tags.finalResult:
          result.finalResult = decoder.decodeStructPointer(FinalResult);
          break;
        case SpeechRecognizerEvent.Tags.langidEvent:
          result.langidEvent = decoder.decodeStructPointer(LangIdEvent);
          break;
        case SpeechRecognizerEvent.Tags.labelCorrectionEvent:
          result.labelCorrectionEvent = decoder.decodeStructPointer(LabelCorrectionEvent);
          break;
      }
      decoder.align();

      return result;
    };


    SpeechRecognizerEvent.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SpeechRecognizerEvent.Tags.audioEvent:
          

    // validate SpeechRecognizerEvent.audioEvent
    err = messageValidator.validateStructPointer(data_offset, AudioLevelEvent, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SpeechRecognizerEvent.Tags.partialResult:
          

    // validate SpeechRecognizerEvent.partialResult
    err = messageValidator.validateStructPointer(data_offset, PartialResult, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SpeechRecognizerEvent.Tags.endpointerEvent:
          

    // validate SpeechRecognizerEvent.endpointerEvent
    err = messageValidator.validateStructPointer(data_offset, EndpointerEvent, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SpeechRecognizerEvent.Tags.finalResult:
          

    // validate SpeechRecognizerEvent.finalResult
    err = messageValidator.validateStructPointer(data_offset, FinalResult, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SpeechRecognizerEvent.Tags.langidEvent:
          

    // validate SpeechRecognizerEvent.langidEvent
    err = messageValidator.validateStructPointer(data_offset, LangIdEvent, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SpeechRecognizerEvent.Tags.labelCorrectionEvent:
          

    // validate SpeechRecognizerEvent.labelCorrectionEvent
    err = messageValidator.validateStructPointer(data_offset, LabelCorrectionEvent, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SpeechRecognizerEvent.encodedSize = 16;
  var kSodaClient_OnStart_Name = 0;
  var kSodaClient_OnStop_Name = 1;
  var kSodaClient_OnSpeechRecognizerEvent_Name = 2;

  function SodaClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SodaClient,
                                                   handleOrPtrInfo);
  }

  function SodaClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SodaClient, associatedInterfacePtrInfo);
  }

  SodaClientAssociatedPtr.prototype =
      Object.create(SodaClientPtr.prototype);
  SodaClientAssociatedPtr.prototype.constructor =
      SodaClientAssociatedPtr;

  function SodaClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SodaClientPtr.prototype.onStart = function() {
    return SodaClientProxy.prototype.onStart
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaClientProxy.prototype.onStart = function() {
    var params_ = new SodaClient_OnStart_Params();
    var builder = new codec.MessageV0Builder(
        kSodaClient_OnStart_Name,
        codec.align(SodaClient_OnStart_Params.encodedSize));
    builder.encodeStruct(SodaClient_OnStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SodaClientPtr.prototype.onStop = function() {
    return SodaClientProxy.prototype.onStop
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaClientProxy.prototype.onStop = function() {
    var params_ = new SodaClient_OnStop_Params();
    var builder = new codec.MessageV0Builder(
        kSodaClient_OnStop_Name,
        codec.align(SodaClient_OnStop_Params.encodedSize));
    builder.encodeStruct(SodaClient_OnStop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SodaClientPtr.prototype.onSpeechRecognizerEvent = function() {
    return SodaClientProxy.prototype.onSpeechRecognizerEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaClientProxy.prototype.onSpeechRecognizerEvent = function(event) {
    var params_ = new SodaClient_OnSpeechRecognizerEvent_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kSodaClient_OnSpeechRecognizerEvent_Name,
        codec.align(SodaClient_OnSpeechRecognizerEvent_Params.encodedSize));
    builder.encodeStruct(SodaClient_OnSpeechRecognizerEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SodaClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SodaClientStub.prototype.onStart = function() {
    return this.delegate_ && this.delegate_.onStart && this.delegate_.onStart();
  }
  SodaClientStub.prototype.onStop = function() {
    return this.delegate_ && this.delegate_.onStop && this.delegate_.onStop();
  }
  SodaClientStub.prototype.onSpeechRecognizerEvent = function(event) {
    return this.delegate_ && this.delegate_.onSpeechRecognizerEvent && this.delegate_.onSpeechRecognizerEvent(event);
  }

  SodaClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSodaClient_OnStart_Name:
      var params = reader.decodeStruct(SodaClient_OnStart_Params);
      this.onStart();
      return true;
    case kSodaClient_OnStop_Name:
      var params = reader.decodeStruct(SodaClient_OnStop_Params);
      this.onStop();
      return true;
    case kSodaClient_OnSpeechRecognizerEvent_Name:
      var params = reader.decodeStruct(SodaClient_OnSpeechRecognizerEvent_Params);
      this.onSpeechRecognizerEvent(params.event);
      return true;
    default:
      return false;
    }
  };

  SodaClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSodaClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSodaClient_OnStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaClient_OnStart_Params;
      break;
      case kSodaClient_OnStop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaClient_OnStop_Params;
      break;
      case kSodaClient_OnSpeechRecognizerEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaClient_OnSpeechRecognizerEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSodaClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SodaClient = {
    name: 'chromeos.machine_learning.mojom.SodaClient',
    kVersion: 0,
    ptrClass: SodaClientPtr,
    proxyClass: SodaClientProxy,
    stubClass: SodaClientStub,
    validateRequest: validateSodaClientRequest,
    validateResponse: null,
  };
  SodaClientStub.prototype.validator = validateSodaClientRequest;
  SodaClientProxy.prototype.validator = null;
  var kSodaRecognizer_AddAudio_Name = 0;
  var kSodaRecognizer_Stop_Name = 1;
  var kSodaRecognizer_Start_Name = 2;
  var kSodaRecognizer_MarkDone_Name = 3;

  function SodaRecognizerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SodaRecognizer,
                                                   handleOrPtrInfo);
  }

  function SodaRecognizerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SodaRecognizer, associatedInterfacePtrInfo);
  }

  SodaRecognizerAssociatedPtr.prototype =
      Object.create(SodaRecognizerPtr.prototype);
  SodaRecognizerAssociatedPtr.prototype.constructor =
      SodaRecognizerAssociatedPtr;

  function SodaRecognizerProxy(receiver) {
    this.receiver_ = receiver;
  }
  SodaRecognizerPtr.prototype.addAudio = function() {
    return SodaRecognizerProxy.prototype.addAudio
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaRecognizerProxy.prototype.addAudio = function(audio) {
    var params_ = new SodaRecognizer_AddAudio_Params();
    params_.audio = audio;
    var builder = new codec.MessageV0Builder(
        kSodaRecognizer_AddAudio_Name,
        codec.align(SodaRecognizer_AddAudio_Params.encodedSize));
    builder.encodeStruct(SodaRecognizer_AddAudio_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SodaRecognizerPtr.prototype.stop = function() {
    return SodaRecognizerProxy.prototype.stop
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaRecognizerProxy.prototype.stop = function() {
    var params_ = new SodaRecognizer_Stop_Params();
    var builder = new codec.MessageV0Builder(
        kSodaRecognizer_Stop_Name,
        codec.align(SodaRecognizer_Stop_Params.encodedSize));
    builder.encodeStruct(SodaRecognizer_Stop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SodaRecognizerPtr.prototype.start = function() {
    return SodaRecognizerProxy.prototype.start
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaRecognizerProxy.prototype.start = function() {
    var params_ = new SodaRecognizer_Start_Params();
    var builder = new codec.MessageV0Builder(
        kSodaRecognizer_Start_Name,
        codec.align(SodaRecognizer_Start_Params.encodedSize));
    builder.encodeStruct(SodaRecognizer_Start_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SodaRecognizerPtr.prototype.markDone = function() {
    return SodaRecognizerProxy.prototype.markDone
        .apply(this.ptr.getProxy(), arguments);
  };

  SodaRecognizerProxy.prototype.markDone = function() {
    var params_ = new SodaRecognizer_MarkDone_Params();
    var builder = new codec.MessageV0Builder(
        kSodaRecognizer_MarkDone_Name,
        codec.align(SodaRecognizer_MarkDone_Params.encodedSize));
    builder.encodeStruct(SodaRecognizer_MarkDone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SodaRecognizerStub(delegate) {
    this.delegate_ = delegate;
  }
  SodaRecognizerStub.prototype.addAudio = function(audio) {
    return this.delegate_ && this.delegate_.addAudio && this.delegate_.addAudio(audio);
  }
  SodaRecognizerStub.prototype.stop = function() {
    return this.delegate_ && this.delegate_.stop && this.delegate_.stop();
  }
  SodaRecognizerStub.prototype.start = function() {
    return this.delegate_ && this.delegate_.start && this.delegate_.start();
  }
  SodaRecognizerStub.prototype.markDone = function() {
    return this.delegate_ && this.delegate_.markDone && this.delegate_.markDone();
  }

  SodaRecognizerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSodaRecognizer_AddAudio_Name:
      var params = reader.decodeStruct(SodaRecognizer_AddAudio_Params);
      this.addAudio(params.audio);
      return true;
    case kSodaRecognizer_Stop_Name:
      var params = reader.decodeStruct(SodaRecognizer_Stop_Params);
      this.stop();
      return true;
    case kSodaRecognizer_Start_Name:
      var params = reader.decodeStruct(SodaRecognizer_Start_Params);
      this.start();
      return true;
    case kSodaRecognizer_MarkDone_Name:
      var params = reader.decodeStruct(SodaRecognizer_MarkDone_Params);
      this.markDone();
      return true;
    default:
      return false;
    }
  };

  SodaRecognizerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSodaRecognizerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSodaRecognizer_AddAudio_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaRecognizer_AddAudio_Params;
      break;
      case kSodaRecognizer_Stop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaRecognizer_Stop_Params;
      break;
      case kSodaRecognizer_Start_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaRecognizer_Start_Params;
      break;
      case kSodaRecognizer_MarkDone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SodaRecognizer_MarkDone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSodaRecognizerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SodaRecognizer = {
    name: 'chromeos.machine_learning.mojom.SodaRecognizer',
    kVersion: 0,
    ptrClass: SodaRecognizerPtr,
    proxyClass: SodaRecognizerProxy,
    stubClass: SodaRecognizerStub,
    validateRequest: validateSodaRecognizerRequest,
    validateResponse: null,
  };
  SodaRecognizerStub.prototype.validator = validateSodaRecognizerRequest;
  SodaRecognizerProxy.prototype.validator = null;
  exports.OptionalBool = OptionalBool;
  exports.SodaRecognitionMode = SodaRecognitionMode;
  exports.SpeakerDiarizationMode = SpeakerDiarizationMode;
  exports.EndpointerType = EndpointerType;
  exports.EndpointReason = EndpointReason;
  exports.AsrSwitchResult = AsrSwitchResult;
  exports.SodaMultilangConfig = SodaMultilangConfig;
  exports.SodaConfig = SodaConfig;
  exports.TimingInfo = TimingInfo;
  exports.EndpointerEvent = EndpointerEvent;
  exports.HypothesisPartInResult = HypothesisPartInResult;
  exports.PartialResult = PartialResult;
  exports.FinalResult = FinalResult;
  exports.AudioLevelEvent = AudioLevelEvent;
  exports.LangIdEvent = LangIdEvent;
  exports.LabelCorrectionEvent = LabelCorrectionEvent;
  exports.SpeechRecognizerEvent = SpeechRecognizerEvent;
  exports.SodaClient = SodaClient;
  exports.SodaClientPtr = SodaClientPtr;
  exports.SodaClientAssociatedPtr = SodaClientAssociatedPtr;
  exports.SodaRecognizer = SodaRecognizer;
  exports.SodaRecognizerPtr = SodaRecognizerPtr;
  exports.SodaRecognizerAssociatedPtr = SodaRecognizerAssociatedPtr;
})();