// chromeos/services/machine_learning/public/mojom/soda.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const OptionalBoolSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const OptionalBool = {
  
  kUnknown: 0,
  kFalse: 1,
  kTrue: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SodaRecognitionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SodaRecognitionMode = {
  
  kCaption: 0,
  kIme: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SpeakerDiarizationModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SpeakerDiarizationMode = {
  
  kDiarizationUnspecified: 0,
  kSpeakerDiarizationModeOffDefault: 1,
  kSpeakerChangeDetection: 2,
  kSpeakerLabelDetection: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EndpointerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EndpointerType = {
  
  START_OF_SPEECH: 0,
  END_OF_SPEECH: 1,
  END_OF_AUDIO: 2,
  END_OF_UTTERANCE: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EndpointReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EndpointReason = {
  
  ENDPOINT_UNKNOWN: 0,
  ENDPOINT_END_OF_SPEECH: 1,
  ENDPOINT_END_OF_UTTERANCE: 2,
  ENDPOINT_END_OF_AUDIO: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AsrSwitchResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AsrSwitchResult = {
  
  DEFAULT_NO_SWITCH: 0,
  SWITCH_SUCCEEDED: 1,
  SWITCH_FAILED: 2,
  SWITCH_SKIPPED_NO_LP: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SodaClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.SodaClient', scope);
  }
}

/** @interface */
export class SodaClientInterface {
  
  /**
   */

  onStart() {}
  
  /**
   */

  onStop() {}
  
  /**
   * @param { !SpeechRecognizerEvent } event
   */

  onSpeechRecognizerEvent(event) {}
}

/**
 * @implements { SodaClientInterface }
 */
export class SodaClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SodaClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SodaClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SodaClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onStart() {
    this.proxy.sendMessage(
        0,
        SodaClient_OnStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onStop() {
    this.proxy.sendMessage(
        1,
        SodaClient_OnStop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !SpeechRecognizerEvent } event
   */

  onSpeechRecognizerEvent(
      event) {
    this.proxy.sendMessage(
        2,
        SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SodaClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SodaClientReceiver {
  /**
   * @param {!SodaClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SodaClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SodaClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SodaClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SodaClient_OnStart_ParamsSpec.$,
        null,
        impl.onStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SodaClient_OnStop_ParamsSpec.$,
        null,
        impl.onStop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
        null,
        impl.onSpeechRecognizerEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SodaClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.SodaClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SodaClientRemote}
   */
  static getRemote() {
    let remote = new SodaClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SodaClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SodaClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SodaClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SodaClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SodaClient_OnStart_ParamsSpec.$,
        null,
        this.onStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SodaClient_OnStop_ParamsSpec.$,
        null,
        this.onStop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognizerEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
        null,
        this.onSpeechRecognizerEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SodaRecognizerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.SodaRecognizer', scope);
  }
}

/** @interface */
export class SodaRecognizerInterface {
  
  /**
   * @param { !Array<!number> } audio
   */

  addAudio(audio) {}
  
  /**
   */

  stop() {}
  
  /**
   */

  start() {}
  
  /**
   */

  markDone() {}
}

/**
 * @implements { SodaRecognizerInterface }
 */
export class SodaRecognizerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SodaRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SodaRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SodaRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } audio
   */

  addAudio(
      audio) {
    this.proxy.sendMessage(
        0,
        SodaRecognizer_AddAudio_ParamsSpec.$,
        null,
        [
          audio
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        1,
        SodaRecognizer_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  start() {
    this.proxy.sendMessage(
        2,
        SodaRecognizer_Start_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  markDone() {
    this.proxy.sendMessage(
        3,
        SodaRecognizer_MarkDone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SodaRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SodaRecognizerReceiver {
  /**
   * @param {!SodaRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SodaRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SodaRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SodaRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SodaRecognizer_AddAudio_ParamsSpec.$,
        null,
        impl.addAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SodaRecognizer_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SodaRecognizer_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SodaRecognizer_MarkDone_ParamsSpec.$,
        null,
        impl.markDone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SodaRecognizer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.SodaRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SodaRecognizerRemote}
   */
  static getRemote() {
    let remote = new SodaRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SodaRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SodaRecognizerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SodaRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SodaRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SodaRecognizer_AddAudio_ParamsSpec.$,
        null,
        this.addAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SodaRecognizer_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SodaRecognizer_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.markDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SodaRecognizer_MarkDone_ParamsSpec.$,
        null,
        this.markDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaMultilangConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TimingInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EndpointerEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HypothesisPartInResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PartialResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FinalResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLevelEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LangIdEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LabelCorrectionEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaClient_OnStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaClient_OnStop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaClient_OnSpeechRecognizerEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaRecognizer_AddAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaRecognizer_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaRecognizer_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SodaRecognizer_MarkDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SpeechRecognizerEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SodaMultilangConfigSpec.$,
    'SodaMultilangConfig',
    [
      mojo.internal.StructField(
        'rewindWhenSwitchingLanguage', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localeToLanguagePackMap', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SodaMultilangConfig {
  constructor() {
    /** @type { !boolean } */
    this.rewindWhenSwitchingLanguage;
    /** @type { !Object<!string, !string> } */
    this.localeToLanguagePackMap;
  }
}



mojo.internal.Struct(
    SodaConfigSpec.$,
    'SodaConfig',
    [
      mojo.internal.StructField(
        'channelCount', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'apiKey', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'libraryDlcPath', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'languageDlcPath', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableFormatting', 32,
        0,
        OptionalBoolSpec.$,
        OptionalBool.kTrue,
        false /* nullable */,
        2,
      ),
      mojo.internal.StructField(
        'recognitionMode', 36,
        0,
        SodaRecognitionModeSpec.$,
        SodaRecognitionMode.kCaption,
        false /* nullable */,
        3,
      ),
      mojo.internal.StructField(
        'maskOffensiveWords', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        4,
      ),
      mojo.internal.StructField(
        'speakerChangeDetection', 40,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        5,
      ),
      mojo.internal.StructField(
        'includeLoggingOutput', 40,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'multiLangConfig', 48,
        0,
        SodaMultilangConfigSpec.$,
        null,
        true /* nullable */,
        7,
      ),
      mojo.internal.StructField(
        'speakerDiarizationMode', 44,
        0,
        SpeakerDiarizationModeSpec.$,
        SpeakerDiarizationMode.kSpeakerDiarizationModeOffDefault,
        false /* nullable */,
        9,
      ),
      mojo.internal.StructField(
        'maxSpeakerCount', 56,
        0,
        mojo.internal.Uint32,
        2,
        false /* nullable */,
        9,
      ),
    ],
    [[0, 40],[2, 48],[3, 48],[4, 56],[5, 56],[6, 56],[7, 64],[9, 72],]);



/**
 * @record
 */
export class SodaConfig {
  constructor() {
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
    /** @type { !string } */
    this.apiKey;
    /** @type { !string } */
    this.libraryDlcPath;
    /** @type { !string } */
    this.languageDlcPath;
    /** @type { !OptionalBool } */
    this.enableFormatting;
    /** @type { !SodaRecognitionMode } */
    this.recognitionMode;
    /** @type { !boolean } */
    this.maskOffensiveWords;
    /** @type { !boolean } */
    this.speakerChangeDetection;
    /** @type { !boolean } */
    this.includeLoggingOutput;
    /** @type { (SodaMultilangConfig|undefined) } */
    this.multiLangConfig;
    /** @type { !SpeakerDiarizationMode } */
    this.speakerDiarizationMode;
    /** @type { !number } */
    this.maxSpeakerCount;
  }
}



mojo.internal.Struct(
    TimingInfoSpec.$,
    'TimingInfo',
    [
      mojo.internal.StructField(
        'audioStartEpoch', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioStartTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'elapsedWallTime', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventEndTime', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'latency', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'normalizedLatency', 40,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wordAlignments', 48,
        0,
        mojo.internal.Array(mojoBase_mojom_TimeDeltaSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class TimingInfo {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.audioStartEpoch;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.audioStartTime;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.elapsedWallTime;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.eventEndTime;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.latency;
    /** @type { !number } */
    this.normalizedLatency;
    /** @type { !Array<!mojoBase_mojom_TimeDelta> } */
    this.wordAlignments;
  }
}



mojo.internal.Struct(
    EndpointerEventSpec.$,
    'EndpointerEvent',
    [
      mojo.internal.StructField(
        'endpointerType', 0,
        0,
        EndpointerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingEvent', 8,
        0,
        TimingInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EndpointerEvent {
  constructor() {
    /** @type { !EndpointerType } */
    this.endpointerType;
    /** @type { (TimingInfo|undefined) } */
    this.timingEvent;
  }
}



mojo.internal.Struct(
    HypothesisPartInResultSpec.$,
    'HypothesisPartInResult',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alignment', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'leading_space_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        8,
        {
          isPrimary: true,
          linkedValueFieldName: "leading_space_$value",
          originalFieldName: "leadingSpace",
        }
      ),
      mojo.internal.StructField(
        'leading_space_$value', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        8,
        {
          isPrimary: false,
          originalFieldName: "leadingSpace",
        }
      ),
      mojo.internal.StructField(
        'speakerChange', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        9,
      ),
      mojo.internal.StructField(
        'speakerLabel', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        9,
      ),
    ],
    [[0, 24],[8, 32],[9, 40],]);



/**
 * @record
 */
export class HypothesisPartInResult {
  constructor() {
    /** @type { !Array<!string> } */
    this.text;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.alignment;
    /** @type { (boolean|undefined) } */
    this.leadingSpace;
    /** @type { !boolean } */
    this.speakerChange;
    /** @type { (string|undefined) } */
    this.speakerLabel;
  }
}



mojo.internal.Struct(
    PartialResultSpec.$,
    'PartialResult',
    [
      mojo.internal.StructField(
        'partialText', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingEvent', 8,
        0,
        TimingInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hypothesisPart', 16,
        0,
        mojo.internal.Array(HypothesisPartInResultSpec.$, false),
        null,
        true /* nullable */,
        9,
      ),
    ],
    [[0, 24],[9, 32],]);



/**
 * @record
 */
export class PartialResult {
  constructor() {
    /** @type { !Array<!string> } */
    this.partialText;
    /** @type { (TimingInfo|undefined) } */
    this.timingEvent;
    /** @type { (Array<!HypothesisPartInResult>|undefined) } */
    this.hypothesisPart;
  }
}



mojo.internal.Struct(
    FinalResultSpec.$,
    'FinalResult',
    [
      mojo.internal.StructField(
        'finalHypotheses', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpointReason', 8,
        0,
        EndpointReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingEvent', 16,
        0,
        TimingInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hypothesisPart', 24,
        0,
        mojo.internal.Array(HypothesisPartInResultSpec.$, false),
        null,
        true /* nullable */,
        1,
      ),
    ],
    [[0, 32],[1, 40],]);



/**
 * @record
 */
export class FinalResult {
  constructor() {
    /** @type { !Array<!string> } */
    this.finalHypotheses;
    /** @type { !EndpointReason } */
    this.endpointReason;
    /** @type { (TimingInfo|undefined) } */
    this.timingEvent;
    /** @type { (Array<!HypothesisPartInResult>|undefined) } */
    this.hypothesisPart;
  }
}



mojo.internal.Struct(
    AudioLevelEventSpec.$,
    'AudioLevelEvent',
    [
      mojo.internal.StructField(
        'rms', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioLevel', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioLevelEvent {
  constructor() {
    /** @type { !number } */
    this.rms;
    /** @type { !number } */
    this.audioLevel;
  }
}



mojo.internal.Struct(
    LangIdEventSpec.$,
    'LangIdEvent',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'confidenceLevel', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'asrSwitchResult', 12,
        0,
        AsrSwitchResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LangIdEvent {
  constructor() {
    /** @type { !string } */
    this.language;
    /** @type { !number } */
    this.confidenceLevel;
    /** @type { !AsrSwitchResult } */
    this.asrSwitchResult;
  }
}



mojo.internal.Struct(
    LabelCorrectionEventSpec.$,
    'LabelCorrectionEvent',
    [
      mojo.internal.StructField(
        'hypothesisParts', 0,
        0,
        mojo.internal.Array(HypothesisPartInResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LabelCorrectionEvent {
  constructor() {
    /** @type { !Array<!HypothesisPartInResult> } */
    this.hypothesisParts;
  }
}



mojo.internal.Struct(
    SodaClient_OnStart_ParamsSpec.$,
    'SodaClient_OnStart_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SodaClient_OnStart_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SodaClient_OnStop_ParamsSpec.$,
    'SodaClient_OnStop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SodaClient_OnStop_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$,
    'SodaClient_OnSpeechRecognizerEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        SpeechRecognizerEventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SodaClient_OnSpeechRecognizerEvent_Params {
  constructor() {
    /** @type { !SpeechRecognizerEvent } */
    this.event;
  }
}



mojo.internal.Struct(
    SodaRecognizer_AddAudio_ParamsSpec.$,
    'SodaRecognizer_AddAudio_Params',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SodaRecognizer_AddAudio_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.audio;
  }
}



mojo.internal.Struct(
    SodaRecognizer_Stop_ParamsSpec.$,
    'SodaRecognizer_Stop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SodaRecognizer_Stop_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SodaRecognizer_Start_ParamsSpec.$,
    'SodaRecognizer_Start_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SodaRecognizer_Start_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SodaRecognizer_MarkDone_ParamsSpec.$,
    'SodaRecognizer_MarkDone_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SodaRecognizer_MarkDone_Params {
  constructor() {
  }
}

mojo.internal.Union(
    SpeechRecognizerEventSpec.$, 'SpeechRecognizerEvent',
    {
      'audioEvent': {
        'ordinal': 0,
        'type': AudioLevelEventSpec.$,
      },
      'partialResult': {
        'ordinal': 1,
        'type': PartialResultSpec.$,
      },
      'endpointerEvent': {
        'ordinal': 2,
        'type': EndpointerEventSpec.$,
      },
      'finalResult': {
        'ordinal': 3,
        'type': FinalResultSpec.$,
      },
      'langidEvent': {
        'ordinal': 4,
        'type': LangIdEventSpec.$,
      },
      'labelCorrectionEvent': {
        'ordinal': 5,
        'type': LabelCorrectionEventSpec.$,
      },
    });

/**
 * @typedef { {
 *   audioEvent: (!AudioLevelEvent|undefined),
 *   partialResult: (!PartialResult|undefined),
 *   endpointerEvent: (!EndpointerEvent|undefined),
 *   finalResult: (!FinalResult|undefined),
 *   langidEvent: (!LangIdEvent|undefined),
 *   labelCorrectionEvent: (!LabelCorrectionEvent|undefined),
 * } }
 */
export const SpeechRecognizerEvent = {};
