// chromeos/services/machine_learning/public/mojom/tensor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/tensor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');



  function StringList(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StringList.prototype.initDefaults_ = function() {
    this.value = null;
  };
  StringList.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StringList.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StringList.value
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StringList.encodedSize = codec.kStructHeaderSize + 8;

  StringList.decode = function(decoder) {
    var packed;
    var val = new StringList();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  StringList.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StringList.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.value);
  };
  function FloatList(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FloatList.prototype.initDefaults_ = function() {
    this.value = null;
  };
  FloatList.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FloatList.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FloatList.value
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Double, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FloatList.encodedSize = codec.kStructHeaderSize + 8;

  FloatList.decode = function(decoder) {
    var packed;
    var val = new FloatList();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeArrayPointer(codec.Double);
    return val;
  };

  FloatList.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FloatList.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Double, val.value);
  };
  function Int64List(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Int64List.prototype.initDefaults_ = function() {
    this.value = null;
  };
  Int64List.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Int64List.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Int64List.value
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Int64, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Int64List.encodedSize = codec.kStructHeaderSize + 8;

  Int64List.decode = function(decoder) {
    var packed;
    var val = new Int64List();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeArrayPointer(codec.Int64);
    return val;
  };

  Int64List.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Int64List.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Int64, val.value);
  };
  function Tensor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Tensor.prototype.initDefaults_ = function() {
    this.data = null;
    this.shape = null;
  };
  Tensor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Tensor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Tensor.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ValueList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Tensor.shape
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, Int64List, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Tensor.encodedSize = codec.kStructHeaderSize + 24;

  Tensor.decode = function(decoder) {
    var packed;
    var val = new Tensor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(ValueList);
    val.shape =
        decoder.decodeStructPointer(Int64List);
    return val;
  };

  Tensor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Tensor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ValueList, val.data);
    encoder.encodeStructPointer(Int64List, val.shape);
  };

  function ValueList(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ValueList.Tags = {
    stringList: 0,
    floatList: 1,
    int64List: 2,
  };

  ValueList.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ValueList.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "stringList",
        "floatList",
        "int64List",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ValueList member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ValueList.prototype, "stringList", {
    get: function() {
      if (this.$tag != ValueList.Tags.stringList) {
        throw new ReferenceError(
            "ValueList.stringList is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ValueList.Tags.stringList;
      this.$data = value;
    }
  });
  Object.defineProperty(ValueList.prototype, "floatList", {
    get: function() {
      if (this.$tag != ValueList.Tags.floatList) {
        throw new ReferenceError(
            "ValueList.floatList is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ValueList.Tags.floatList;
      this.$data = value;
    }
  });
  Object.defineProperty(ValueList.prototype, "int64List", {
    get: function() {
      if (this.$tag != ValueList.Tags.int64List) {
        throw new ReferenceError(
            "ValueList.int64List is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ValueList.Tags.int64List;
      this.$data = value;
    }
  });


    ValueList.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ValueList.Tags.stringList:
          encoder.encodeStructPointer(StringList, val.stringList);
          break;
        case ValueList.Tags.floatList:
          encoder.encodeStructPointer(FloatList, val.floatList);
          break;
        case ValueList.Tags.int64List:
          encoder.encodeStructPointer(Int64List, val.int64List);
          break;
      }
      encoder.align();
    };


    ValueList.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ValueList();
      var tag = decoder.readUint32();
      switch (tag) {
        case ValueList.Tags.stringList:
          result.stringList = decoder.decodeStructPointer(StringList);
          break;
        case ValueList.Tags.floatList:
          result.floatList = decoder.decodeStructPointer(FloatList);
          break;
        case ValueList.Tags.int64List:
          result.int64List = decoder.decodeStructPointer(Int64List);
          break;
      }
      decoder.align();

      return result;
    };


    ValueList.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ValueList.Tags.stringList:
          

    // validate ValueList.stringList
    err = messageValidator.validateStructPointer(data_offset, StringList, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ValueList.Tags.floatList:
          

    // validate ValueList.floatList
    err = messageValidator.validateStructPointer(data_offset, FloatList, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ValueList.Tags.int64List:
          

    // validate ValueList.int64List
    err = messageValidator.validateStructPointer(data_offset, Int64List, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  ValueList.encodedSize = 16;
  exports.StringList = StringList;
  exports.FloatList = FloatList;
  exports.Int64List = Int64List;
  exports.Tensor = Tensor;
  exports.ValueList = ValueList;
})();