// chromeos/services/machine_learning/public/mojom/text_classifier.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.Time');




goog.provide('chromeos.machineLearning.mojom.AnnotationUsecase');
goog.provide('chromeos.machineLearning.mojom.AnnotationUsecaseSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.AnnotationUsecaseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.AnnotationUsecase = {
  
  ANNOTATION_USECASE_SMART: 0,
  ANNOTATION_USECASE_RAW: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('chromeos.machineLearning.mojom.TextClassifier');
goog.provide('chromeos.machineLearning.mojom.TextClassifierReceiver');
goog.provide('chromeos.machineLearning.mojom.TextClassifierCallbackRouter');
goog.provide('chromeos.machineLearning.mojom.TextClassifierInterface');
goog.provide('chromeos.machineLearning.mojom.TextClassifierRemote');
goog.provide('chromeos.machineLearning.mojom.TextClassifierPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifierPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.TextClassifier.$interfaceName,
        scope);
  }
};

/** @interface */
chromeos.machineLearning.mojom.TextClassifierInterface = class {
  
  /**
   * @param { !chromeos.machineLearning.mojom.TextAnnotationRequest } request
   * @return {!Promise<{
        outputs: !Array<!chromeos.machineLearning.mojom.TextAnnotation>,
   *  }>}
   */

  annotate(request) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        outputs: !Array<!chromeos.machineLearning.mojom.TextLanguage>,
   *  }>}
   */

  findLanguages(text) {}
  
  /**
   * @param { !chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequest } request
   * @return {!Promise<{
        outputs: !chromeos.machineLearning.mojom.CodepointSpan,
   *  }>}
   */

  rEMOVED1(request) {}
};

/**
 * @export
 * @implements { chromeos.machineLearning.mojom.TextClassifierInterface }
 */
chromeos.machineLearning.mojom.TextClassifierRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.TextClassifierPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.TextClassifierPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.TextClassifierPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.TextAnnotationRequest } request
   * @return {!Promise<{
        outputs: !Array<!chromeos.machineLearning.mojom.TextAnnotation>,
   *  }>}
   */

  annotate(
      request) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.TextClassifier_Annotate_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        outputs: !Array<!chromeos.machineLearning.mojom.TextLanguage>,
   *  }>}
   */

  findLanguages(
      text) {
    return this.proxy.sendMessage(
        2,
        chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequest } request
   * @return {!Promise<{
        outputs: !chromeos.machineLearning.mojom.CodepointSpan,
   *  }>}
   */

  rEMOVED1(
      request) {
    return this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextClassifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.TextClassifierReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.TextClassifierInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.TextClassifierRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.TextClassifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.TextClassifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.TextClassifier_Annotate_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParamsSpec.$,
        impl.annotate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParamsSpec.$,
        impl.findLanguages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParamsSpec.$,
        impl.rEMOVED1.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.TextClassifier = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.TextClassifier";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.TextClassifierRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.TextClassifierRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextClassifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.TextClassifierCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.TextClassifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.TextClassifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.annotate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.TextClassifier_Annotate_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParamsSpec.$,
        this.annotate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.findLanguages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParamsSpec.$,
        this.findLanguages.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED1 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParamsSpec.$,
        this.rEMOVED1.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('chromeos.machineLearning.mojom.TextEntitySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextEntitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextAnnotationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextAnnotationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextAnnotationRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextAnnotationRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.CodepointSpanSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.CodepointSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextLanguageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextLanguageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextClassifier_Annotate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifier_Annotate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.mojom.TextEntityDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.TextEntityDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextEntitySpec.$,
    'TextEntity',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'confidenceScore', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        chromeos.machineLearning.mojom.TextEntityDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('chromeos.machineLearning.mojom.TextEntity');

/** @record */
chromeos.machineLearning.mojom.TextEntity = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !number } */
    this.confidenceScore;
    /** @export { !chromeos.machineLearning.mojom.TextEntityData } */
    this.data;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextAnnotationSpec.$,
    'TextAnnotation',
    [
      mojo.internal.StructField(
        'startOffset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOffset', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entities', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.TextEntitySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.TextAnnotation');

/** @record */
chromeos.machineLearning.mojom.TextAnnotation = class {
  constructor() {
    /** @export { !number } */
    this.startOffset;
    /** @export { !number } */
    this.endOffset;
    /** @export { !Array<!chromeos.machineLearning.mojom.TextEntity> } */
    this.entities;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextAnnotationRequestSpec.$,
    'TextAnnotationRequest',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultLocales', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'detectedTextLanguageTags', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'annotationUsecase', 24,
        0,
        chromeos.machineLearning.mojom.AnnotationUsecaseSpec.$,
        chromeos.machineLearning.mojom.AnnotationUsecase.ANNOTATION_USECASE_SMART,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referenceTime', 32,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referenceTimezone', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enabledEntities', 48,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'triggerDictionaryOnBeginnerWords', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],[1, 64],]);



goog.provide('chromeos.machineLearning.mojom.TextAnnotationRequest');

/** @record */
chromeos.machineLearning.mojom.TextAnnotationRequest = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { (string|undefined) } */
    this.defaultLocales;
    /** @export { (string|undefined) } */
    this.detectedTextLanguageTags;
    /** @export { !chromeos.machineLearning.mojom.AnnotationUsecase } */
    this.annotationUsecase;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.referenceTime;
    /** @export { (string|undefined) } */
    this.referenceTimezone;
    /** @export { (Array<!string>|undefined) } */
    this.enabledEntities;
    /** @export { !boolean } */
    this.triggerDictionaryOnBeginnerWords;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.CodepointSpanSpec.$,
    'CodepointSpan',
    [
      mojo.internal.StructField(
        'startOffset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOffset', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.CodepointSpan');

/** @record */
chromeos.machineLearning.mojom.CodepointSpan = class {
  constructor() {
    /** @export { !number } */
    this.startOffset;
    /** @export { !number } */
    this.endOffset;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextLanguageSpec.$,
    'TextLanguage',
    [
      mojo.internal.StructField(
        'locale', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'confidence', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.mojom.TextLanguage');

/** @record */
chromeos.machineLearning.mojom.TextLanguage = class {
  constructor() {
    /** @export { !string } */
    this.locale;
    /** @export { !number } */
    this.confidence;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequestSpec.$,
    'REMOVED_TextSuggestSelectionRequest',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userSelection', 8,
        0,
        chromeos.machineLearning.mojom.CodepointSpanSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultLocales', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'detectedTextLanguageTags', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'annotationUsecase', 32,
        0,
        chromeos.machineLearning.mojom.AnnotationUsecaseSpec.$,
        chromeos.machineLearning.mojom.AnnotationUsecase.ANNOTATION_USECASE_SMART,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequest');

/** @record */
chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequest = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !chromeos.machineLearning.mojom.CodepointSpan } */
    this.userSelection;
    /** @export { (string|undefined) } */
    this.defaultLocales;
    /** @export { (string|undefined) } */
    this.detectedTextLanguageTags;
    /** @export { !chromeos.machineLearning.mojom.AnnotationUsecase } */
    this.annotationUsecase;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextClassifier_Annotate_ParamsSpec.$,
    'TextClassifier_Annotate_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        chromeos.machineLearning.mojom.TextAnnotationRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.TextClassifier_Annotate_Params');

/** @record */
chromeos.machineLearning.mojom.TextClassifier_Annotate_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.TextAnnotationRequest } */
    this.request;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParamsSpec.$,
    'TextClassifier_Annotate_ResponseParams',
    [
      mojo.internal.StructField(
        'outputs', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.TextAnnotationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.TextClassifier_Annotate_ResponseParams = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.mojom.TextAnnotation> } */
    this.outputs;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ParamsSpec.$,
    'TextClassifier_FindLanguages_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.TextClassifier_FindLanguages_Params');

/** @record */
chromeos.machineLearning.mojom.TextClassifier_FindLanguages_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParamsSpec.$,
    'TextClassifier_FindLanguages_ResponseParams',
    [
      mojo.internal.StructField(
        'outputs', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.TextLanguageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.TextClassifier_FindLanguages_ResponseParams = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.mojom.TextLanguage> } */
    this.outputs;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ParamsSpec.$,
    'TextClassifier_REMOVED_1_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_Params');

/** @record */
chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.REMOVED_TextSuggestSelectionRequest } */
    this.request;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParamsSpec.$,
    'TextClassifier_REMOVED_1_ResponseParams',
    [
      mojo.internal.StructField(
        'outputs', 0,
        0,
        chromeos.machineLearning.mojom.CodepointSpanSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParams');

/** @record */
chromeos.machineLearning.mojom.TextClassifier_REMOVED_1_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.CodepointSpan } */
    this.outputs;
  }
};

goog.provide('chromeos.machineLearning.mojom.TextEntityData');


mojo.internal.Union(
    chromeos.machineLearning.mojom.TextEntityDataSpec.$, 'TextEntityData',
    {
      'numericValue': {
        'ordinal': 0,
        'type': mojo.internal.Double,
      },
      'stringValue': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   numericValue: (!number|undefined),
 *   stringValue: (!string|undefined),
 * } }
 */
chromeos.machineLearning.mojom.TextEntityData;
