// chromeos/services/machine_learning/public/mojom/text_classifier.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/text_classifier.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var AnnotationUsecase = {};
  AnnotationUsecase.ANNOTATION_USECASE_SMART = 0;
  AnnotationUsecase.ANNOTATION_USECASE_RAW = 1;
  AnnotationUsecase.MIN_VALUE = 0;
  AnnotationUsecase.MAX_VALUE = 1;

  AnnotationUsecase.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AnnotationUsecase.toKnownEnumValue = function(value) {
    return value;
  };

  AnnotationUsecase.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TextEntity(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextEntity.prototype.initDefaults_ = function() {
    this.name = null;
    this.confidenceScore = 0;
    this.data = null;
  };
  TextEntity.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextEntity.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextEntity.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate TextEntity.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, TextEntityData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextEntity.encodedSize = codec.kStructHeaderSize + 32;

  TextEntity.decode = function(decoder) {
    var packed;
    var val = new TextEntity();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.confidenceScore =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeStruct(TextEntityData);
    return val;
  };

  TextEntity.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextEntity.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Float, val.confidenceScore);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(TextEntityData, val.data);
  };
  function TextAnnotation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextAnnotation.prototype.initDefaults_ = function() {
    this.startOffset = 0;
    this.endOffset = 0;
    this.entities = null;
  };
  TextAnnotation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextAnnotation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate TextAnnotation.entities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(TextEntity), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextAnnotation.encodedSize = codec.kStructHeaderSize + 16;

  TextAnnotation.decode = function(decoder) {
    var packed;
    var val = new TextAnnotation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startOffset =
        decoder.decodeStruct(codec.Uint32);
    val.endOffset =
        decoder.decodeStruct(codec.Uint32);
    val.entities =
        decoder.decodeArrayPointer(new codec.PointerTo(TextEntity));
    return val;
  };

  TextAnnotation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextAnnotation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.startOffset);
    encoder.encodeStruct(codec.Uint32, val.endOffset);
    encoder.encodeArrayPointer(new codec.PointerTo(TextEntity), val.entities);
  };
  function TextAnnotationRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextAnnotationRequest.prototype.initDefaults_ = function() {
    this.text = null;
    this.defaultLocales = null;
    this.detectedTextLanguageTags = null;
    this.annotationUsecase = AnnotationUsecase.ANNOTATION_USECASE_SMART;
    this.triggerDictionaryOnBeginnerWords = false;
    this.referenceTime = null;
    this.referenceTimezone = null;
    this.enabledEntities = null;
  };
  TextAnnotationRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextAnnotationRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64},
      {version: 1, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.defaultLocales
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.detectedTextLanguageTags
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.annotationUsecase
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, AnnotationUsecase);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.referenceTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.referenceTimezone
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAnnotationRequest.enabledEntities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TextAnnotationRequest.encodedSize = codec.kStructHeaderSize + 56;

  TextAnnotationRequest.decode = function(decoder) {
    var packed;
    var val = new TextAnnotationRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.defaultLocales =
        decoder.decodeStruct(codec.String);
    val.detectedTextLanguageTags =
        decoder.decodeStruct(codec.String);
    val.annotationUsecase =
        decoder.decodeStruct(new codec.Enum(AnnotationUsecase));
    packed = decoder.readUint8();
    val.triggerDictionaryOnBeginnerWords = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.referenceTime =
        decoder.decodeStructPointer(time$.Time);
    val.referenceTimezone =
        decoder.decodeStruct(codec.String);
    val.enabledEntities =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  TextAnnotationRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextAnnotationRequest.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.String, val.defaultLocales);
    encoder.encodeStruct(codec.String, val.detectedTextLanguageTags);
    encoder.encodeStruct(codec.Int32, val.annotationUsecase);
    packed = 0;
    packed |= (val.triggerDictionaryOnBeginnerWords & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.Time, val.referenceTime);
    encoder.encodeStruct(codec.String, val.referenceTimezone);
    encoder.encodeArrayPointer(codec.String, val.enabledEntities);
  };
  function CodepointSpan(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CodepointSpan.prototype.initDefaults_ = function() {
    this.startOffset = 0;
    this.endOffset = 0;
  };
  CodepointSpan.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CodepointSpan.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  CodepointSpan.encodedSize = codec.kStructHeaderSize + 8;

  CodepointSpan.decode = function(decoder) {
    var packed;
    var val = new CodepointSpan();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startOffset =
        decoder.decodeStruct(codec.Uint32);
    val.endOffset =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  CodepointSpan.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CodepointSpan.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.startOffset);
    encoder.encodeStruct(codec.Uint32, val.endOffset);
  };
  function TextLanguage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextLanguage.prototype.initDefaults_ = function() {
    this.locale = null;
    this.confidence = 0;
  };
  TextLanguage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextLanguage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextLanguage.locale
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TextLanguage.encodedSize = codec.kStructHeaderSize + 16;

  TextLanguage.decode = function(decoder) {
    var packed;
    var val = new TextLanguage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.locale =
        decoder.decodeStruct(codec.String);
    val.confidence =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextLanguage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextLanguage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.locale);
    encoder.encodeStruct(codec.Float, val.confidence);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function REMOVED_TextSuggestSelectionRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  REMOVED_TextSuggestSelectionRequest.prototype.initDefaults_ = function() {
    this.text = null;
    this.userSelection = null;
    this.defaultLocales = null;
    this.detectedTextLanguageTags = null;
    this.annotationUsecase = AnnotationUsecase.ANNOTATION_USECASE_SMART;
  };
  REMOVED_TextSuggestSelectionRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  REMOVED_TextSuggestSelectionRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate REMOVED_TextSuggestSelectionRequest.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate REMOVED_TextSuggestSelectionRequest.userSelection
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CodepointSpan, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate REMOVED_TextSuggestSelectionRequest.defaultLocales
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate REMOVED_TextSuggestSelectionRequest.detectedTextLanguageTags
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate REMOVED_TextSuggestSelectionRequest.annotationUsecase
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, AnnotationUsecase);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  REMOVED_TextSuggestSelectionRequest.encodedSize = codec.kStructHeaderSize + 40;

  REMOVED_TextSuggestSelectionRequest.decode = function(decoder) {
    var packed;
    var val = new REMOVED_TextSuggestSelectionRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.userSelection =
        decoder.decodeStructPointer(CodepointSpan);
    val.defaultLocales =
        decoder.decodeStruct(codec.String);
    val.detectedTextLanguageTags =
        decoder.decodeStruct(codec.String);
    val.annotationUsecase =
        decoder.decodeStruct(new codec.Enum(AnnotationUsecase));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  REMOVED_TextSuggestSelectionRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(REMOVED_TextSuggestSelectionRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStructPointer(CodepointSpan, val.userSelection);
    encoder.encodeStruct(codec.String, val.defaultLocales);
    encoder.encodeStruct(codec.String, val.detectedTextLanguageTags);
    encoder.encodeStruct(codec.Int32, val.annotationUsecase);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextClassifier_Annotate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextClassifier_Annotate_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  TextClassifier_Annotate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextClassifier_Annotate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextClassifier_Annotate_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TextAnnotationRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextClassifier_Annotate_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextClassifier_Annotate_Params.decode = function(decoder) {
    var packed;
    var val = new TextClassifier_Annotate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(TextAnnotationRequest);
    return val;
  };

  TextClassifier_Annotate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextClassifier_Annotate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TextAnnotationRequest, val.request);
  };
  function TextClassifier_Annotate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextClassifier_Annotate_ResponseParams.prototype.initDefaults_ = function() {
    this.outputs = null;
  };
  TextClassifier_Annotate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextClassifier_Annotate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextClassifier_Annotate_ResponseParams.outputs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(TextAnnotation), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextClassifier_Annotate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TextClassifier_Annotate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextClassifier_Annotate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outputs =
        decoder.decodeArrayPointer(new codec.PointerTo(TextAnnotation));
    return val;
  };

  TextClassifier_Annotate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextClassifier_Annotate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(TextAnnotation), val.outputs);
  };
  function TextClassifier_FindLanguages_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextClassifier_FindLanguages_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  TextClassifier_FindLanguages_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextClassifier_FindLanguages_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextClassifier_FindLanguages_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextClassifier_FindLanguages_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextClassifier_FindLanguages_Params.decode = function(decoder) {
    var packed;
    var val = new TextClassifier_FindLanguages_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TextClassifier_FindLanguages_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextClassifier_FindLanguages_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function TextClassifier_FindLanguages_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextClassifier_FindLanguages_ResponseParams.prototype.initDefaults_ = function() {
    this.outputs = null;
  };
  TextClassifier_FindLanguages_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextClassifier_FindLanguages_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextClassifier_FindLanguages_ResponseParams.outputs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(TextLanguage), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextClassifier_FindLanguages_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TextClassifier_FindLanguages_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextClassifier_FindLanguages_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outputs =
        decoder.decodeArrayPointer(new codec.PointerTo(TextLanguage));
    return val;
  };

  TextClassifier_FindLanguages_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextClassifier_FindLanguages_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(TextLanguage), val.outputs);
  };
  function TextClassifier_REMOVED_1_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextClassifier_REMOVED_1_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  TextClassifier_REMOVED_1_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextClassifier_REMOVED_1_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextClassifier_REMOVED_1_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, REMOVED_TextSuggestSelectionRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextClassifier_REMOVED_1_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextClassifier_REMOVED_1_Params.decode = function(decoder) {
    var packed;
    var val = new TextClassifier_REMOVED_1_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(REMOVED_TextSuggestSelectionRequest);
    return val;
  };

  TextClassifier_REMOVED_1_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextClassifier_REMOVED_1_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(REMOVED_TextSuggestSelectionRequest, val.request);
  };
  function TextClassifier_REMOVED_1_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextClassifier_REMOVED_1_ResponseParams.prototype.initDefaults_ = function() {
    this.outputs = null;
  };
  TextClassifier_REMOVED_1_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextClassifier_REMOVED_1_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextClassifier_REMOVED_1_ResponseParams.outputs
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CodepointSpan, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextClassifier_REMOVED_1_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TextClassifier_REMOVED_1_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextClassifier_REMOVED_1_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outputs =
        decoder.decodeStructPointer(CodepointSpan);
    return val;
  };

  TextClassifier_REMOVED_1_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextClassifier_REMOVED_1_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CodepointSpan, val.outputs);
  };

  function TextEntityData(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TextEntityData.Tags = {
    numericValue: 0,
    stringValue: 1,
  };

  TextEntityData.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TextEntityData.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "numericValue",
        "stringValue",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TextEntityData member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TextEntityData.prototype, "numericValue", {
    get: function() {
      if (this.$tag != TextEntityData.Tags.numericValue) {
        throw new ReferenceError(
            "TextEntityData.numericValue is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TextEntityData.Tags.numericValue;
      this.$data = value;
    }
  });
  Object.defineProperty(TextEntityData.prototype, "stringValue", {
    get: function() {
      if (this.$tag != TextEntityData.Tags.stringValue) {
        throw new ReferenceError(
            "TextEntityData.stringValue is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TextEntityData.Tags.stringValue;
      this.$data = value;
    }
  });


    TextEntityData.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TextEntityData.Tags.numericValue:
          encoder.encodeStruct(codec.Double, val.numericValue);
          break;
        case TextEntityData.Tags.stringValue:
          encoder.encodeStruct(codec.String, val.stringValue);
          break;
      }
      encoder.align();
    };


    TextEntityData.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TextEntityData();
      var tag = decoder.readUint32();
      switch (tag) {
        case TextEntityData.Tags.numericValue:
          result.numericValue = decoder.decodeStruct(codec.Double);
          break;
        case TextEntityData.Tags.stringValue:
          result.stringValue = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    TextEntityData.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TextEntityData.Tags.numericValue:
          

          break;
        case TextEntityData.Tags.stringValue:
          

    // validate TextEntityData.stringValue
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TextEntityData.encodedSize = 16;
  var kTextClassifier_Annotate_Name = 0;
  var kTextClassifier_FindLanguages_Name = 2;
  var kTextClassifier_REMOVED_1_Name = 1;

  function TextClassifierPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TextClassifier,
                                                   handleOrPtrInfo);
  }

  function TextClassifierAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TextClassifier, associatedInterfacePtrInfo);
  }

  TextClassifierAssociatedPtr.prototype =
      Object.create(TextClassifierPtr.prototype);
  TextClassifierAssociatedPtr.prototype.constructor =
      TextClassifierAssociatedPtr;

  function TextClassifierProxy(receiver) {
    this.receiver_ = receiver;
  }
  TextClassifierPtr.prototype.annotate = function() {
    return TextClassifierProxy.prototype.annotate
        .apply(this.ptr.getProxy(), arguments);
  };

  TextClassifierProxy.prototype.annotate = function(request) {
    var params_ = new TextClassifier_Annotate_Params();
    params_.request = request;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextClassifier_Annotate_Name,
          codec.align(TextClassifier_Annotate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextClassifier_Annotate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextClassifier_Annotate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  TextClassifierPtr.prototype.findLanguages = function() {
    return TextClassifierProxy.prototype.findLanguages
        .apply(this.ptr.getProxy(), arguments);
  };

  TextClassifierProxy.prototype.findLanguages = function(text) {
    var params_ = new TextClassifier_FindLanguages_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextClassifier_FindLanguages_Name,
          codec.align(TextClassifier_FindLanguages_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextClassifier_FindLanguages_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextClassifier_FindLanguages_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  TextClassifierPtr.prototype.rEMOVED1 = function() {
    return TextClassifierProxy.prototype.rEMOVED1
        .apply(this.ptr.getProxy(), arguments);
  };

  TextClassifierProxy.prototype.rEMOVED1 = function(request) {
    var params_ = new TextClassifier_REMOVED_1_Params();
    params_.request = request;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextClassifier_REMOVED_1_Name,
          codec.align(TextClassifier_REMOVED_1_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextClassifier_REMOVED_1_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextClassifier_REMOVED_1_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function TextClassifierStub(delegate) {
    this.delegate_ = delegate;
  }
  TextClassifierStub.prototype.annotate = function(request) {
    return this.delegate_ && this.delegate_.annotate && this.delegate_.annotate(request);
  }
  TextClassifierStub.prototype.findLanguages = function(text) {
    return this.delegate_ && this.delegate_.findLanguages && this.delegate_.findLanguages(text);
  }
  TextClassifierStub.prototype.rEMOVED1 = function(request) {
    return this.delegate_ && this.delegate_.rEMOVED1 && this.delegate_.rEMOVED1(request);
  }

  TextClassifierStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  TextClassifierStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextClassifier_Annotate_Name:
      var params = reader.decodeStruct(TextClassifier_Annotate_Params);
      this.annotate(params.request).then(function(response) {
        var responseParams =
            new TextClassifier_Annotate_ResponseParams();
        responseParams.outputs = response.outputs;
        var builder = new codec.MessageV1Builder(
            kTextClassifier_Annotate_Name,
            codec.align(TextClassifier_Annotate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextClassifier_Annotate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kTextClassifier_FindLanguages_Name:
      var params = reader.decodeStruct(TextClassifier_FindLanguages_Params);
      this.findLanguages(params.text).then(function(response) {
        var responseParams =
            new TextClassifier_FindLanguages_ResponseParams();
        responseParams.outputs = response.outputs;
        var builder = new codec.MessageV1Builder(
            kTextClassifier_FindLanguages_Name,
            codec.align(TextClassifier_FindLanguages_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextClassifier_FindLanguages_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kTextClassifier_REMOVED_1_Name:
      var params = reader.decodeStruct(TextClassifier_REMOVED_1_Params);
      this.rEMOVED1(params.request).then(function(response) {
        var responseParams =
            new TextClassifier_REMOVED_1_ResponseParams();
        responseParams.outputs = response.outputs;
        var builder = new codec.MessageV1Builder(
            kTextClassifier_REMOVED_1_Name,
            codec.align(TextClassifier_REMOVED_1_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextClassifier_REMOVED_1_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTextClassifierRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTextClassifier_Annotate_Name:
        if (message.expectsResponse())
          paramsClass = TextClassifier_Annotate_Params;
      break;
      case kTextClassifier_FindLanguages_Name:
        if (message.expectsResponse())
          paramsClass = TextClassifier_FindLanguages_Params;
      break;
      case kTextClassifier_REMOVED_1_Name:
        if (message.expectsResponse())
          paramsClass = TextClassifier_REMOVED_1_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTextClassifierResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTextClassifier_Annotate_Name:
        if (message.isResponse())
          paramsClass = TextClassifier_Annotate_ResponseParams;
        break;
      case kTextClassifier_FindLanguages_Name:
        if (message.isResponse())
          paramsClass = TextClassifier_FindLanguages_ResponseParams;
        break;
      case kTextClassifier_REMOVED_1_Name:
        if (message.isResponse())
          paramsClass = TextClassifier_REMOVED_1_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TextClassifier = {
    name: 'chromeos.machine_learning.mojom.TextClassifier',
    kVersion: 0,
    ptrClass: TextClassifierPtr,
    proxyClass: TextClassifierProxy,
    stubClass: TextClassifierStub,
    validateRequest: validateTextClassifierRequest,
    validateResponse: validateTextClassifierResponse,
  };
  TextClassifierStub.prototype.validator = validateTextClassifierRequest;
  TextClassifierProxy.prototype.validator = validateTextClassifierResponse;
  exports.AnnotationUsecase = AnnotationUsecase;
  exports.TextEntity = TextEntity;
  exports.TextAnnotation = TextAnnotation;
  exports.TextAnnotationRequest = TextAnnotationRequest;
  exports.CodepointSpan = CodepointSpan;
  exports.TextLanguage = TextLanguage;
  exports.REMOVED_TextSuggestSelectionRequest = REMOVED_TextSuggestSelectionRequest;
  exports.TextEntityData = TextEntityData;
  exports.TextClassifier = TextClassifier;
  exports.TextClassifierPtr = TextClassifierPtr;
  exports.TextClassifierAssociatedPtr = TextClassifierAssociatedPtr;
})();