// chromeos/services/machine_learning/public/mojom/text_classifier.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AnnotationUsecaseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AnnotationUsecase = {
  
  ANNOTATION_USECASE_SMART: 0,
  ANNOTATION_USECASE_RAW: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextClassifierPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.TextClassifier', scope);
  }
}

/** @interface */
export class TextClassifierInterface {
  
  /**
   * @param { !TextAnnotationRequest } request
   * @return {!Promise<{
        outputs: !Array<!TextAnnotation>,
   *  }>}
   */

  annotate(request) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        outputs: !Array<!TextLanguage>,
   *  }>}
   */

  findLanguages(text) {}
  
  /**
   * @param { !REMOVED_TextSuggestSelectionRequest } request
   * @return {!Promise<{
        outputs: !CodepointSpan,
   *  }>}
   */

  rEMOVED1(request) {}
}

/**
 * @implements { TextClassifierInterface }
 */
export class TextClassifierRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextClassifierPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextClassifierPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextClassifierPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TextAnnotationRequest } request
   * @return {!Promise<{
        outputs: !Array<!TextAnnotation>,
   *  }>}
   */

  annotate(
      request) {
    return this.proxy.sendMessage(
        0,
        TextClassifier_Annotate_ParamsSpec.$,
        TextClassifier_Annotate_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        outputs: !Array<!TextLanguage>,
   *  }>}
   */

  findLanguages(
      text) {
    return this.proxy.sendMessage(
        2,
        TextClassifier_FindLanguages_ParamsSpec.$,
        TextClassifier_FindLanguages_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !REMOVED_TextSuggestSelectionRequest } request
   * @return {!Promise<{
        outputs: !CodepointSpan,
   *  }>}
   */

  rEMOVED1(
      request) {
    return this.proxy.sendMessage(
        1,
        TextClassifier_REMOVED_1_ParamsSpec.$,
        TextClassifier_REMOVED_1_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextClassifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextClassifierReceiver {
  /**
   * @param {!TextClassifierInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextClassifierRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextClassifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextClassifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextClassifier_Annotate_ParamsSpec.$,
        TextClassifier_Annotate_ResponseParamsSpec.$,
        impl.annotate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TextClassifier_FindLanguages_ParamsSpec.$,
        TextClassifier_FindLanguages_ResponseParamsSpec.$,
        impl.findLanguages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TextClassifier_REMOVED_1_ParamsSpec.$,
        TextClassifier_REMOVED_1_ResponseParamsSpec.$,
        impl.rEMOVED1.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextClassifier {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.TextClassifier";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextClassifierRemote}
   */
  static getRemote() {
    let remote = new TextClassifierRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextClassifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextClassifierCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextClassifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextClassifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.annotate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextClassifier_Annotate_ParamsSpec.$,
        TextClassifier_Annotate_ResponseParamsSpec.$,
        this.annotate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.findLanguages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TextClassifier_FindLanguages_ParamsSpec.$,
        TextClassifier_FindLanguages_ResponseParamsSpec.$,
        this.findLanguages.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED1 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TextClassifier_REMOVED_1_ParamsSpec.$,
        TextClassifier_REMOVED_1_ResponseParamsSpec.$,
        this.rEMOVED1.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextEntitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextAnnotationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextAnnotationRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CodepointSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextLanguageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const REMOVED_TextSuggestSelectionRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextClassifier_Annotate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextClassifier_Annotate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextClassifier_FindLanguages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextClassifier_FindLanguages_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextClassifier_REMOVED_1_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextClassifier_REMOVED_1_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TextEntityDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TextEntitySpec.$,
    'TextEntity',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'confidenceScore', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        TextEntityDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TextEntity {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !number } */
    this.confidenceScore;
    /** @type { !TextEntityData } */
    this.data;
  }
}



mojo.internal.Struct(
    TextAnnotationSpec.$,
    'TextAnnotation',
    [
      mojo.internal.StructField(
        'startOffset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOffset', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entities', 8,
        0,
        mojo.internal.Array(TextEntitySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextAnnotation {
  constructor() {
    /** @type { !number } */
    this.startOffset;
    /** @type { !number } */
    this.endOffset;
    /** @type { !Array<!TextEntity> } */
    this.entities;
  }
}



mojo.internal.Struct(
    TextAnnotationRequestSpec.$,
    'TextAnnotationRequest',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultLocales', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'detectedTextLanguageTags', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'annotationUsecase', 24,
        0,
        AnnotationUsecaseSpec.$,
        AnnotationUsecase.ANNOTATION_USECASE_SMART,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referenceTime', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referenceTimezone', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enabledEntities', 48,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'triggerDictionaryOnBeginnerWords', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
      ),
    ],
    [[0, 64],[1, 64],]);



/**
 * @record
 */
export class TextAnnotationRequest {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { (string|undefined) } */
    this.defaultLocales;
    /** @type { (string|undefined) } */
    this.detectedTextLanguageTags;
    /** @type { !AnnotationUsecase } */
    this.annotationUsecase;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.referenceTime;
    /** @type { (string|undefined) } */
    this.referenceTimezone;
    /** @type { (Array<!string>|undefined) } */
    this.enabledEntities;
    /** @type { !boolean } */
    this.triggerDictionaryOnBeginnerWords;
  }
}



mojo.internal.Struct(
    CodepointSpanSpec.$,
    'CodepointSpan',
    [
      mojo.internal.StructField(
        'startOffset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOffset', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CodepointSpan {
  constructor() {
    /** @type { !number } */
    this.startOffset;
    /** @type { !number } */
    this.endOffset;
  }
}



mojo.internal.Struct(
    TextLanguageSpec.$,
    'TextLanguage',
    [
      mojo.internal.StructField(
        'locale', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'confidence', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextLanguage {
  constructor() {
    /** @type { !string } */
    this.locale;
    /** @type { !number } */
    this.confidence;
  }
}



mojo.internal.Struct(
    REMOVED_TextSuggestSelectionRequestSpec.$,
    'REMOVED_TextSuggestSelectionRequest',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userSelection', 8,
        0,
        CodepointSpanSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultLocales', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'detectedTextLanguageTags', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'annotationUsecase', 32,
        0,
        AnnotationUsecaseSpec.$,
        AnnotationUsecase.ANNOTATION_USECASE_SMART,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class REMOVED_TextSuggestSelectionRequest {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !CodepointSpan } */
    this.userSelection;
    /** @type { (string|undefined) } */
    this.defaultLocales;
    /** @type { (string|undefined) } */
    this.detectedTextLanguageTags;
    /** @type { !AnnotationUsecase } */
    this.annotationUsecase;
  }
}



mojo.internal.Struct(
    TextClassifier_Annotate_ParamsSpec.$,
    'TextClassifier_Annotate_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        TextAnnotationRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextClassifier_Annotate_Params {
  constructor() {
    /** @type { !TextAnnotationRequest } */
    this.request;
  }
}



mojo.internal.Struct(
    TextClassifier_Annotate_ResponseParamsSpec.$,
    'TextClassifier_Annotate_ResponseParams',
    [
      mojo.internal.StructField(
        'outputs', 0,
        0,
        mojo.internal.Array(TextAnnotationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextClassifier_Annotate_ResponseParams {
  constructor() {
    /** @type { !Array<!TextAnnotation> } */
    this.outputs;
  }
}



mojo.internal.Struct(
    TextClassifier_FindLanguages_ParamsSpec.$,
    'TextClassifier_FindLanguages_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextClassifier_FindLanguages_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    TextClassifier_FindLanguages_ResponseParamsSpec.$,
    'TextClassifier_FindLanguages_ResponseParams',
    [
      mojo.internal.StructField(
        'outputs', 0,
        0,
        mojo.internal.Array(TextLanguageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextClassifier_FindLanguages_ResponseParams {
  constructor() {
    /** @type { !Array<!TextLanguage> } */
    this.outputs;
  }
}



mojo.internal.Struct(
    TextClassifier_REMOVED_1_ParamsSpec.$,
    'TextClassifier_REMOVED_1_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        REMOVED_TextSuggestSelectionRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextClassifier_REMOVED_1_Params {
  constructor() {
    /** @type { !REMOVED_TextSuggestSelectionRequest } */
    this.request;
  }
}



mojo.internal.Struct(
    TextClassifier_REMOVED_1_ResponseParamsSpec.$,
    'TextClassifier_REMOVED_1_ResponseParams',
    [
      mojo.internal.StructField(
        'outputs', 0,
        0,
        CodepointSpanSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextClassifier_REMOVED_1_ResponseParams {
  constructor() {
    /** @type { !CodepointSpan } */
    this.outputs;
  }
}

mojo.internal.Union(
    TextEntityDataSpec.$, 'TextEntityData',
    {
      'numericValue': {
        'ordinal': 0,
        'type': mojo.internal.Double,
      },
      'stringValue': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   numericValue: (!number|undefined),
 *   stringValue: (!string|undefined),
 * } }
 */
export const TextEntityData = {};
