// chromeos/services/machine_learning/public/mojom/text_suggester.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.TextSuggestionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggestionMode = {
  
  kPrediction: 1,
  kCompletion: 2,
  MIN_VALUE: 1,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.MultiWordExperimentGroupSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.MultiWordExperimentGroup = {
  
  kDefault: 0,
  kGboard: 1,
  kGboardRelaxedA: 2,
  kGboardRelaxedB: 3,
  kGboardRelaxedC: 4,
  kGboardD: 5,
  kGboardE: 6,
  kGboardF: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.TextSuggester.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.TextSuggesterInterface }
 */
chromeos.machineLearning.mojom.TextSuggesterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.TextSuggesterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.TextSuggesterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.TextSuggesterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.TextSuggesterQuery } query
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.TextSuggesterResult,
   *  }>}
   */

  suggest(
      query) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.TextSuggester_Suggest_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextSuggester_Suggest_ResponseParamsSpec.$,
        [
          query
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSuggester
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.TextSuggesterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.TextSuggesterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.TextSuggesterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.TextSuggesterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.TextSuggester_Suggest_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextSuggester_Suggest_ResponseParamsSpec.$,
        impl.suggest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.TextSuggester = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.TextSuggester";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.TextSuggesterRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.TextSuggesterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextSuggester
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.TextSuggesterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.TextSuggesterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suggest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.TextSuggester_Suggest_ParamsSpec.$,
        chromeos.machineLearning.mojom.TextSuggester_Suggest_ResponseParamsSpec.$,
        this.suggest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.NextWordCompletionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.MultiWordSuggestionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggester_Suggest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggester_Suggest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.TextSuggestionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.NextWordCompletionCandidateSpec.$,
    'NextWordCompletionCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'normalizedScore', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.NextWordCompletionCandidate = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.normalizedScore;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextSuggesterQuerySpec.$,
    'TextSuggesterQuery',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nextWordCandidates', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.NextWordCompletionCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestionMode', 16,
        0,
        chromeos.machineLearning.mojom.TextSuggestionModeSpec.$,
        1,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[1, 32],]);





/** @record */
chromeos.machineLearning.mojom.TextSuggesterQuery = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !Array<!chromeos.machineLearning.mojom.NextWordCompletionCandidate> } */
    this.nextWordCandidates;
    /** @export { !chromeos.machineLearning.mojom.TextSuggestionMode } */
    this.suggestionMode;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.MultiWordSuggestionCandidateSpec.$,
    'MultiWordSuggestionCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'normalizedScore', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.MultiWordSuggestionCandidate = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.normalizedScore;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterResultSpec.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.TextSuggesterResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextSuggesterResultSpec.$,
    'TextSuggesterResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        chromeos.machineLearning.mojom.TextSuggesterResultSpec.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.TextSuggestionCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.TextSuggesterResult = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.TextSuggesterResult_Status } */
    this.status;
    /** @export { !Array<!chromeos.machineLearning.mojom.TextSuggestionCandidate> } */
    this.candidates;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextSuggesterSpecSpec.$,
    'TextSuggesterSpec',
    [
      mojo.internal.StructField(
        'multiWordExperiment', 0,
        0,
        chromeos.machineLearning.mojom.MultiWordExperimentGroupSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.TextSuggesterSpec = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.MultiWordExperimentGroup } */
    this.multiWordExperiment;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextSuggester_Suggest_ParamsSpec.$,
    'TextSuggester_Suggest_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        chromeos.machineLearning.mojom.TextSuggesterQuerySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.TextSuggester_Suggest_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.TextSuggesterQuery } */
    this.query;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.TextSuggester_Suggest_ResponseParamsSpec.$,
    'TextSuggester_Suggest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.TextSuggesterResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.TextSuggester_Suggest_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.TextSuggesterResult } */
    this.result;
  }
};



mojo.internal.Union(
    chromeos.machineLearning.mojom.TextSuggestionCandidateSpec.$, 'TextSuggestionCandidate',
    {
      'multiWord': {
        'ordinal': 0,
        'type': chromeos.machineLearning.mojom.MultiWordSuggestionCandidateSpec.$,
      },
    });

/**
 * @typedef { {
 *   multiWord: (!chromeos.machineLearning.mojom.MultiWordSuggestionCandidate|undefined),
 * } }
 */
chromeos.machineLearning.mojom.TextSuggestionCandidate;
