// chromeos/services/machine_learning/public/mojom/text_suggester.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/text_suggester.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');


  var TextSuggestionMode = {};
  TextSuggestionMode.kPrediction = 1;
  TextSuggestionMode.kCompletion = 2;
  TextSuggestionMode.MIN_VALUE = 1;
  TextSuggestionMode.MAX_VALUE = 2;
  TextSuggestionMode.DEFAULT_VALUE = 1;

  TextSuggestionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  TextSuggestionMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  TextSuggestionMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MultiWordExperimentGroup = {};
  MultiWordExperimentGroup.kDefault = 0;
  MultiWordExperimentGroup.kGboard = 1;
  MultiWordExperimentGroup.kGboardRelaxedA = 2;
  MultiWordExperimentGroup.kGboardRelaxedB = 3;
  MultiWordExperimentGroup.kGboardRelaxedC = 4;
  MultiWordExperimentGroup.kGboardD = 5;
  MultiWordExperimentGroup.kGboardE = 6;
  MultiWordExperimentGroup.kGboardF = 7;
  MultiWordExperimentGroup.MIN_VALUE = 0;
  MultiWordExperimentGroup.MAX_VALUE = 7;
  MultiWordExperimentGroup.DEFAULT_VALUE = 0;

  MultiWordExperimentGroup.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  MultiWordExperimentGroup.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  MultiWordExperimentGroup.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function NextWordCompletionCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NextWordCompletionCandidate.prototype.initDefaults_ = function() {
    this.text = null;
    this.normalizedScore = 0;
  };
  NextWordCompletionCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NextWordCompletionCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NextWordCompletionCandidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NextWordCompletionCandidate.encodedSize = codec.kStructHeaderSize + 16;

  NextWordCompletionCandidate.decode = function(decoder) {
    var packed;
    var val = new NextWordCompletionCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.normalizedScore =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NextWordCompletionCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NextWordCompletionCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Float, val.normalizedScore);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextSuggesterQuery(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSuggesterQuery.prototype.initDefaults_ = function() {
    this.text = null;
    this.nextWordCandidates = null;
    this.suggestionMode = 0;
  };
  TextSuggesterQuery.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSuggesterQuery.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 1, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggesterQuery.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggesterQuery.nextWordCandidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(NextWordCompletionCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check TextSuggesterQuery.suggestionMode
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate TextSuggesterQuery.suggestionMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, TextSuggestionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSuggesterQuery.encodedSize = codec.kStructHeaderSize + 24;

  TextSuggesterQuery.decode = function(decoder) {
    var packed;
    var val = new TextSuggesterQuery();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.nextWordCandidates =
        decoder.decodeArrayPointer(new codec.PointerTo(NextWordCompletionCandidate));
    if (version >= 1) {
      val.suggestionMode =
          decoder.decodeStruct(new codec.Enum(TextSuggestionMode));
    } else {
      val.suggestionMode = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextSuggesterQuery.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSuggesterQuery.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(NextWordCompletionCandidate), val.nextWordCandidates);
    encoder.encodeStruct(codec.Int32, val.suggestionMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MultiWordSuggestionCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MultiWordSuggestionCandidate.prototype.initDefaults_ = function() {
    this.text = null;
    this.normalizedScore = 0;
  };
  MultiWordSuggestionCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MultiWordSuggestionCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MultiWordSuggestionCandidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MultiWordSuggestionCandidate.encodedSize = codec.kStructHeaderSize + 16;

  MultiWordSuggestionCandidate.decode = function(decoder) {
    var packed;
    var val = new MultiWordSuggestionCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.normalizedScore =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MultiWordSuggestionCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MultiWordSuggestionCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Float, val.normalizedScore);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextSuggesterResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  TextSuggesterResult.Status = {};
  TextSuggesterResult.Status.OK = 0;
  TextSuggesterResult.Status.ERROR = 1;
  TextSuggesterResult.Status.MIN_VALUE = 0;
  TextSuggesterResult.Status.MAX_VALUE = 1;
  TextSuggesterResult.Status.DEFAULT_VALUE = 1;

  TextSuggesterResult.Status.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  TextSuggesterResult.Status.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  TextSuggesterResult.Status.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  TextSuggesterResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.candidates = null;
  };
  TextSuggesterResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSuggesterResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggesterResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, TextSuggesterResult.Status);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggesterResult.candidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, TextSuggestionCandidate, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSuggesterResult.encodedSize = codec.kStructHeaderSize + 16;

  TextSuggesterResult.decode = function(decoder) {
    var packed;
    var val = new TextSuggesterResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(TextSuggesterResult.Status));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.candidates =
        decoder.decodeArrayPointer(TextSuggestionCandidate);
    return val;
  };

  TextSuggesterResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSuggesterResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(TextSuggestionCandidate, val.candidates);
  };
  function TextSuggesterSpec(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSuggesterSpec.prototype.initDefaults_ = function() {
    this.multiWordExperiment = 0;
  };
  TextSuggesterSpec.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSuggesterSpec.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggesterSpec.multiWordExperiment
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MultiWordExperimentGroup);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSuggesterSpec.encodedSize = codec.kStructHeaderSize + 8;

  TextSuggesterSpec.decode = function(decoder) {
    var packed;
    var val = new TextSuggesterSpec();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.multiWordExperiment =
        decoder.decodeStruct(new codec.Enum(MultiWordExperimentGroup));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextSuggesterSpec.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSuggesterSpec.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.multiWordExperiment);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextSuggester_Suggest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSuggester_Suggest_Params.prototype.initDefaults_ = function() {
    this.query = null;
  };
  TextSuggester_Suggest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSuggester_Suggest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggester_Suggest_Params.query
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TextSuggesterQuery, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSuggester_Suggest_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextSuggester_Suggest_Params.decode = function(decoder) {
    var packed;
    var val = new TextSuggester_Suggest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.query =
        decoder.decodeStructPointer(TextSuggesterQuery);
    return val;
  };

  TextSuggester_Suggest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSuggester_Suggest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TextSuggesterQuery, val.query);
  };
  function TextSuggester_Suggest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSuggester_Suggest_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  TextSuggester_Suggest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSuggester_Suggest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSuggester_Suggest_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TextSuggesterResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSuggester_Suggest_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TextSuggester_Suggest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextSuggester_Suggest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(TextSuggesterResult);
    return val;
  };

  TextSuggester_Suggest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSuggester_Suggest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TextSuggesterResult, val.result);
  };

  function TextSuggestionCandidate(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TextSuggestionCandidate.Tags = {
    multiWord: 0,
  };

  TextSuggestionCandidate.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TextSuggestionCandidate.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "multiWord",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TextSuggestionCandidate member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TextSuggestionCandidate.prototype, "multiWord", {
    get: function() {
      if (this.$tag != TextSuggestionCandidate.Tags.multiWord) {
        throw new ReferenceError(
            "TextSuggestionCandidate.multiWord is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TextSuggestionCandidate.Tags.multiWord;
      this.$data = value;
    }
  });


    TextSuggestionCandidate.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TextSuggestionCandidate.Tags.multiWord:
          encoder.encodeStructPointer(MultiWordSuggestionCandidate, val.multiWord);
          break;
      }
      encoder.align();
    };


    TextSuggestionCandidate.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TextSuggestionCandidate();
      var tag = decoder.readUint32();
      switch (tag) {
        case TextSuggestionCandidate.Tags.multiWord:
          result.multiWord = decoder.decodeStructPointer(MultiWordSuggestionCandidate);
          break;
      }
      decoder.align();

      return result;
    };


    TextSuggestionCandidate.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TextSuggestionCandidate.Tags.multiWord:
          

    // validate TextSuggestionCandidate.multiWord
    err = messageValidator.validateStructPointer(data_offset, MultiWordSuggestionCandidate, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TextSuggestionCandidate.encodedSize = 16;
  var kTextSuggester_Suggest_Name = 0;

  function TextSuggesterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TextSuggester,
                                                   handleOrPtrInfo);
  }

  function TextSuggesterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TextSuggester, associatedInterfacePtrInfo);
  }

  TextSuggesterAssociatedPtr.prototype =
      Object.create(TextSuggesterPtr.prototype);
  TextSuggesterAssociatedPtr.prototype.constructor =
      TextSuggesterAssociatedPtr;

  function TextSuggesterProxy(receiver) {
    this.receiver_ = receiver;
  }
  TextSuggesterPtr.prototype.suggest = function() {
    return TextSuggesterProxy.prototype.suggest
        .apply(this.ptr.getProxy(), arguments);
  };

  TextSuggesterProxy.prototype.suggest = function(query) {
    var params_ = new TextSuggester_Suggest_Params();
    params_.query = query;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextSuggester_Suggest_Name,
          codec.align(TextSuggester_Suggest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextSuggester_Suggest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextSuggester_Suggest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function TextSuggesterStub(delegate) {
    this.delegate_ = delegate;
  }
  TextSuggesterStub.prototype.suggest = function(query) {
    return this.delegate_ && this.delegate_.suggest && this.delegate_.suggest(query);
  }

  TextSuggesterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  TextSuggesterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextSuggester_Suggest_Name:
      var params = reader.decodeStruct(TextSuggester_Suggest_Params);
      this.suggest(params.query).then(function(response) {
        var responseParams =
            new TextSuggester_Suggest_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kTextSuggester_Suggest_Name,
            codec.align(TextSuggester_Suggest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextSuggester_Suggest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTextSuggesterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTextSuggester_Suggest_Name:
        if (message.expectsResponse())
          paramsClass = TextSuggester_Suggest_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTextSuggesterResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTextSuggester_Suggest_Name:
        if (message.isResponse())
          paramsClass = TextSuggester_Suggest_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TextSuggester = {
    name: 'chromeos.machine_learning.mojom.TextSuggester',
    kVersion: 0,
    ptrClass: TextSuggesterPtr,
    proxyClass: TextSuggesterProxy,
    stubClass: TextSuggesterStub,
    validateRequest: validateTextSuggesterRequest,
    validateResponse: validateTextSuggesterResponse,
  };
  TextSuggesterStub.prototype.validator = validateTextSuggesterRequest;
  TextSuggesterProxy.prototype.validator = validateTextSuggesterResponse;
  exports.TextSuggestionMode = TextSuggestionMode;
  exports.MultiWordExperimentGroup = MultiWordExperimentGroup;
  exports.NextWordCompletionCandidate = NextWordCompletionCandidate;
  exports.TextSuggesterQuery = TextSuggesterQuery;
  exports.MultiWordSuggestionCandidate = MultiWordSuggestionCandidate;
  exports.TextSuggesterResult = TextSuggesterResult;
  exports.TextSuggesterSpec = TextSuggesterSpec;
  exports.TextSuggestionCandidate = TextSuggestionCandidate;
  exports.TextSuggester = TextSuggester;
  exports.TextSuggesterPtr = TextSuggesterPtr;
  exports.TextSuggesterAssociatedPtr = TextSuggesterAssociatedPtr;
})();