// chromeos/services/machine_learning/public/mojom/text_suggester.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextSuggestionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextSuggestionMode = {
  
  kPrediction: 1,
  kCompletion: 2,
  MIN_VALUE: 1,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MultiWordExperimentGroupSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MultiWordExperimentGroup = {
  
  kDefault: 0,
  kGboard: 1,
  kGboardRelaxedA: 2,
  kGboardRelaxedB: 3,
  kGboardRelaxedC: 4,
  kGboardD: 5,
  kGboardE: 6,
  kGboardF: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextSuggesterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.TextSuggester', scope);
  }
}

/** @interface */
export class TextSuggesterInterface {
  
  /**
   * @param { !TextSuggesterQuery } query
   * @return {!Promise<{
        result: !TextSuggesterResult,
   *  }>}
   */

  suggest(query) {}
}

/**
 * @implements { TextSuggesterInterface }
 */
export class TextSuggesterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextSuggesterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextSuggesterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextSuggesterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TextSuggesterQuery } query
   * @return {!Promise<{
        result: !TextSuggesterResult,
   *  }>}
   */

  suggest(
      query) {
    return this.proxy.sendMessage(
        0,
        TextSuggester_Suggest_ParamsSpec.$,
        TextSuggester_Suggest_ResponseParamsSpec.$,
        [
          query
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextSuggester
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSuggesterReceiver {
  /**
   * @param {!TextSuggesterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextSuggesterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextSuggesterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSuggesterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextSuggester_Suggest_ParamsSpec.$,
        TextSuggester_Suggest_ResponseParamsSpec.$,
        impl.suggest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextSuggester {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.TextSuggester";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextSuggesterRemote}
   */
  static getRemote() {
    let remote = new TextSuggesterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextSuggester
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSuggesterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextSuggesterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSuggesterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suggest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextSuggester_Suggest_ParamsSpec.$,
        TextSuggester_Suggest_ResponseParamsSpec.$,
        this.suggest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NextWordCompletionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggesterQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MultiWordSuggestionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggesterResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggesterSpecSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggester_Suggest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggester_Suggest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TextSuggestionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NextWordCompletionCandidateSpec.$,
    'NextWordCompletionCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'normalizedScore', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NextWordCompletionCandidate {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.normalizedScore;
  }
}



mojo.internal.Struct(
    TextSuggesterQuerySpec.$,
    'TextSuggesterQuery',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nextWordCandidates', 8,
        0,
        mojo.internal.Array(NextWordCompletionCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestionMode', 16,
        0,
        TextSuggestionModeSpec.$,
        1,
        false /* nullable */,
        1,
      ),
    ],
    [[0, 24],[1, 32],]);



/**
 * @record
 */
export class TextSuggesterQuery {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !Array<!NextWordCompletionCandidate> } */
    this.nextWordCandidates;
    /** @type { !TextSuggestionMode } */
    this.suggestionMode;
  }
}



mojo.internal.Struct(
    MultiWordSuggestionCandidateSpec.$,
    'MultiWordSuggestionCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'normalizedScore', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MultiWordSuggestionCandidate {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.normalizedScore;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextSuggesterResult_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextSuggesterResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    TextSuggesterResultSpec.$,
    'TextSuggesterResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        TextSuggesterResult_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(TextSuggestionCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextSuggesterResult {
  constructor() {
    /** @type { !TextSuggesterResult_Status } */
    this.status;
    /** @type { !Array<!TextSuggestionCandidate> } */
    this.candidates;
  }
}



mojo.internal.Struct(
    TextSuggesterSpecSpec.$,
    'TextSuggesterSpec',
    [
      mojo.internal.StructField(
        'multiWordExperiment', 0,
        0,
        MultiWordExperimentGroupSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggesterSpec {
  constructor() {
    /** @type { !MultiWordExperimentGroup } */
    this.multiWordExperiment;
  }
}



mojo.internal.Struct(
    TextSuggester_Suggest_ParamsSpec.$,
    'TextSuggester_Suggest_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        TextSuggesterQuerySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggester_Suggest_Params {
  constructor() {
    /** @type { !TextSuggesterQuery } */
    this.query;
  }
}



mojo.internal.Struct(
    TextSuggester_Suggest_ResponseParamsSpec.$,
    'TextSuggester_Suggest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        TextSuggesterResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggester_Suggest_ResponseParams {
  constructor() {
    /** @type { !TextSuggesterResult } */
    this.result;
  }
}

mojo.internal.Union(
    TextSuggestionCandidateSpec.$, 'TextSuggestionCandidate',
    {
      'multiWord': {
        'ordinal': 0,
        'type': MultiWordSuggestionCandidateSpec.$,
      },
    });

/**
 * @typedef { {
 *   multiWord: (!MultiWordSuggestionCandidate|undefined),
 * } }
 */
export const TextSuggestionCandidate = {};
