// chromeos/services/machine_learning/public/mojom/web_platform_handwriting.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('gfx.mojom.PointF');
goog.require('mojoBase.mojom.TimeDelta');






goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer');
goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerReceiver');
goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerCallbackRouter');
goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerInterface');
goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote');
goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer.$interfaceName,
        scope);
  }
};

/** @interface */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerInterface = class {
  
  /**
   * @param { !Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingStroke> } strokes
   * @param { !chromeos.machineLearning.webPlatform.mojom.HandwritingHints } hints
   * @return {!Promise<{
        prediction: ?Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingPrediction>,
   *  }>}
   */

  getPrediction(strokes, hints) {}
};

/**
 * @export
 * @implements { chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerInterface }
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingStroke> } strokes
   * @param { !chromeos.machineLearning.webPlatform.mojom.HandwritingHints } hints
   * @return {!Promise<{
        prediction: ?Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingPrediction>,
   *  }>}
   */

  getPrediction(
      strokes,
      hints) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ParamsSpec.$,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
        [
          strokes,
          hints
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerReceiver = class {
  /**
   * @param {!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ParamsSpec.$,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
        impl.getPrediction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.web_platform.mojom.HandwritingRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPrediction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ParamsSpec.$,
        chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
        this.getPrediction.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingPointSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingStrokeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingStrokeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegmentSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingSegmentSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingPredictionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingPredictionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingHintsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingHintsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraintSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingPointSpec.$,
    'HandwritingPoint',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        't', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingPoint');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingPoint = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.location;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.t;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingStrokeSpec.$,
    'HandwritingStroke',
    [
      mojo.internal.StructField(
        'points', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.webPlatform.mojom.HandwritingPointSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingStroke');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingStroke = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingPoint> } */
    this.points;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegmentSpec.$,
    'HandwritingDrawingSegment',
    [
      mojo.internal.StructField(
        'strokeIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beginPointIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endPointIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegment');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegment = class {
  constructor() {
    /** @export { !number } */
    this.strokeIndex;
    /** @export { !number } */
    this.beginPointIndex;
    /** @export { !number } */
    this.endPointIndex;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingSegmentSpec.$,
    'HandwritingSegment',
    [
      mojo.internal.StructField(
        'grapheme', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beginIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endIndex', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'drawingSegments', 16,
        0,
        mojo.internal.Array(chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegmentSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingSegment');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingSegment = class {
  constructor() {
    /** @export { !string } */
    this.grapheme;
    /** @export { !number } */
    this.beginIndex;
    /** @export { !number } */
    this.endIndex;
    /** @export { !Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingDrawingSegment> } */
    this.drawingSegments;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingPredictionSpec.$,
    'HandwritingPrediction',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'segmentationResult', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.webPlatform.mojom.HandwritingSegmentSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingPrediction');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingPrediction = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingSegment> } */
    this.segmentationResult;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingHintsSpec.$,
    'HandwritingHints',
    [
      mojo.internal.StructField(
        'recognitionType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deprecatedTextContext', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alternatives', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textContext', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],[1, 48],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingHints');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingHints = class {
  constructor() {
    /** @export { !string } */
    this.recognitionType;
    /** @export { !string } */
    this.inputType;
    /** @export { !string } */
    this.deprecatedTextContext;
    /** @export { !number } */
    this.alternatives;
    /** @export { (string|undefined) } */
    this.textContext;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraintSpec.$,
    'HandwritingModelConstraint',
    [
      mojo.internal.StructField(
        'languages', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraint');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingModelConstraint = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.languages;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ParamsSpec.$,
    'HandwritingRecognizer_GetPrediction_Params',
    [
      mojo.internal.StructField(
        'strokes', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.webPlatform.mojom.HandwritingStrokeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hints', 8,
        0,
        chromeos.machineLearning.webPlatform.mojom.HandwritingHintsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_Params');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_Params = class {
  constructor() {
    /** @export { !Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingStroke> } */
    this.strokes;
    /** @export { !chromeos.machineLearning.webPlatform.mojom.HandwritingHints } */
    this.hints;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
    'HandwritingRecognizer_GetPrediction_ResponseParams',
    [
      mojo.internal.StructField(
        'prediction', 0,
        0,
        mojo.internal.Array(chromeos.machineLearning.webPlatform.mojom.HandwritingPredictionSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParams');

/** @record */
chromeos.machineLearning.webPlatform.mojom.HandwritingRecognizer_GetPrediction_ResponseParams = class {
  constructor() {
    /** @export { (Array<!chromeos.machineLearning.webPlatform.mojom.HandwritingPrediction>|undefined) } */
    this.prediction;
  }
};

