// chromeos/services/machine_learning/public/mojom/web_platform_handwriting.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  PointF as gfx_mojom_PointF,
  PointFSpec as gfx_mojom_PointFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HandwritingRecognizerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.web_platform.mojom.HandwritingRecognizer', scope);
  }
}

/** @interface */
export class HandwritingRecognizerInterface {
  
  /**
   * @param { !Array<!HandwritingStroke> } strokes
   * @param { !HandwritingHints } hints
   * @return {!Promise<{
        prediction: ?Array<!HandwritingPrediction>,
   *  }>}
   */

  getPrediction(strokes, hints) {}
}

/**
 * @implements { HandwritingRecognizerInterface }
 */
export class HandwritingRecognizerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HandwritingRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HandwritingRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HandwritingRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!HandwritingStroke> } strokes
   * @param { !HandwritingHints } hints
   * @return {!Promise<{
        prediction: ?Array<!HandwritingPrediction>,
   *  }>}
   */

  getPrediction(
      strokes,
      hints) {
    return this.proxy.sendMessage(
        0,
        HandwritingRecognizer_GetPrediction_ParamsSpec.$,
        HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
        [
          strokes,
          hints
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HandwritingRecognizerReceiver {
  /**
   * @param {!HandwritingRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HandwritingRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HandwritingRecognizer_GetPrediction_ParamsSpec.$,
        HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
        impl.getPrediction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HandwritingRecognizer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.web_platform.mojom.HandwritingRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HandwritingRecognizerRemote}
   */
  static getRemote() {
    let remote = new HandwritingRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HandwritingRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HandwritingRecognizerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HandwritingRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HandwritingRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPrediction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HandwritingRecognizer_GetPrediction_ParamsSpec.$,
        HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
        this.getPrediction.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingStrokeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingDrawingSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingPredictionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingHintsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingModelConstraintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizer_GetPrediction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HandwritingRecognizer_GetPrediction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HandwritingPointSpec.$,
    'HandwritingPoint',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        't', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingPoint {
  constructor() {
    /** @type { !gfx_mojom_PointF } */
    this.location;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.t;
  }
}



mojo.internal.Struct(
    HandwritingStrokeSpec.$,
    'HandwritingStroke',
    [
      mojo.internal.StructField(
        'points', 0,
        0,
        mojo.internal.Array(HandwritingPointSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HandwritingStroke {
  constructor() {
    /** @type { !Array<!HandwritingPoint> } */
    this.points;
  }
}



mojo.internal.Struct(
    HandwritingDrawingSegmentSpec.$,
    'HandwritingDrawingSegment',
    [
      mojo.internal.StructField(
        'strokeIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'beginPointIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endPointIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingDrawingSegment {
  constructor() {
    /** @type { !number } */
    this.strokeIndex;
    /** @type { !number } */
    this.beginPointIndex;
    /** @type { !number } */
    this.endPointIndex;
  }
}



mojo.internal.Struct(
    HandwritingSegmentSpec.$,
    'HandwritingSegment',
    [
      mojo.internal.StructField(
        'grapheme', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'beginIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endIndex', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'drawingSegments', 16,
        0,
        mojo.internal.Array(HandwritingDrawingSegmentSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class HandwritingSegment {
  constructor() {
    /** @type { !string } */
    this.grapheme;
    /** @type { !number } */
    this.beginIndex;
    /** @type { !number } */
    this.endIndex;
    /** @type { !Array<!HandwritingDrawingSegment> } */
    this.drawingSegments;
  }
}



mojo.internal.Struct(
    HandwritingPredictionSpec.$,
    'HandwritingPrediction',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'segmentationResult', 8,
        0,
        mojo.internal.Array(HandwritingSegmentSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingPrediction {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !Array<!HandwritingSegment> } */
    this.segmentationResult;
  }
}



mojo.internal.Struct(
    HandwritingHintsSpec.$,
    'HandwritingHints',
    [
      mojo.internal.StructField(
        'recognitionType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputType', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deprecatedTextContext', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alternatives', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textContext', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        1,
      ),
    ],
    [[0, 40],[1, 48],]);



/**
 * @record
 */
export class HandwritingHints {
  constructor() {
    /** @type { !string } */
    this.recognitionType;
    /** @type { !string } */
    this.inputType;
    /** @type { !string } */
    this.deprecatedTextContext;
    /** @type { !number } */
    this.alternatives;
    /** @type { (string|undefined) } */
    this.textContext;
  }
}



mojo.internal.Struct(
    HandwritingModelConstraintSpec.$,
    'HandwritingModelConstraint',
    [
      mojo.internal.StructField(
        'languages', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HandwritingModelConstraint {
  constructor() {
    /** @type { !Array<!string> } */
    this.languages;
  }
}



mojo.internal.Struct(
    HandwritingRecognizer_GetPrediction_ParamsSpec.$,
    'HandwritingRecognizer_GetPrediction_Params',
    [
      mojo.internal.StructField(
        'strokes', 0,
        0,
        mojo.internal.Array(HandwritingStrokeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hints', 8,
        0,
        HandwritingHintsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HandwritingRecognizer_GetPrediction_Params {
  constructor() {
    /** @type { !Array<!HandwritingStroke> } */
    this.strokes;
    /** @type { !HandwritingHints } */
    this.hints;
  }
}



mojo.internal.Struct(
    HandwritingRecognizer_GetPrediction_ResponseParamsSpec.$,
    'HandwritingRecognizer_GetPrediction_ResponseParams',
    [
      mojo.internal.StructField(
        'prediction', 0,
        0,
        mojo.internal.Array(HandwritingPredictionSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HandwritingRecognizer_GetPrediction_ResponseParams {
  constructor() {
    /** @type { (Array<!HandwritingPrediction>|undefined) } */
    this.prediction;
  }
}

