// chromeos/services/tts/public/mojom/tts_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.tts.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.tts.mojom.TtsServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.tts.mojom.TtsService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.tts.mojom.TtsServiceInterface }
 */
chromeos.tts.mojom.TtsServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.tts.mojom.TtsServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.tts.mojom.TtsServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.tts.mojom.TtsServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.tts.mojom.GoogleTtsStreamPendingReceiver } receiver
   * @param { !media.mojom.AudioStreamFactoryRemote } streamFactory
   */

  bindGoogleTtsStream(
      receiver,
      streamFactory) {
    this.proxy.sendMessage(
        0,
        chromeos.tts.mojom.TtsService_BindGoogleTtsStream_ParamsSpec.$,
        null,
        [
          receiver,
          streamFactory
        ],
        false);
  }

  
  /**
   * @param { !chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver } receiver
   * @param { !media.mojom.AudioStreamFactoryRemote } streamFactory
   * @param { ?chromeos.tts.mojom.AudioParameters } desiredAudioParameters
   * @return {!Promise<{
        audioParameters: !chromeos.tts.mojom.AudioParameters,
   *  }>}
   */

  bindPlaybackTtsStream(
      receiver,
      streamFactory,
      desiredAudioParameters) {
    return this.proxy.sendMessage(
        1,
        chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ParamsSpec.$,
        chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
        [
          receiver,
          streamFactory,
          desiredAudioParameters
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TtsService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.tts.mojom.TtsServiceReceiver = class {
  /**
   * @param {!chromeos.tts.mojom.TtsServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.tts.mojom.TtsServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.tts.mojom.TtsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.TtsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.TtsService_BindGoogleTtsStream_ParamsSpec.$,
        null,
        impl.bindGoogleTtsStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ParamsSpec.$,
        chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
        impl.bindPlaybackTtsStream.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.tts.mojom.TtsService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.TtsService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.tts.mojom.TtsServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.tts.mojom.TtsServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TtsService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.tts.mojom.TtsServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.tts.mojom.TtsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.TtsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindGoogleTtsStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.TtsService_BindGoogleTtsStream_ParamsSpec.$,
        null,
        this.bindGoogleTtsStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindPlaybackTtsStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ParamsSpec.$,
        chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
        this.bindPlaybackTtsStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStreamPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.tts.mojom.GoogleTtsStream.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.tts.mojom.GoogleTtsStreamInterface }
 */
chromeos.tts.mojom.GoogleTtsStreamRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.tts.mojom.GoogleTtsStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.tts.mojom.GoogleTtsStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.tts.mojom.GoogleTtsStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } voiceName
   * @param { !Array<!number> } voiceBytes
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  installVoice(
      voiceName,
      voiceBytes) {
    return this.proxy.sendMessage(
        0,
        chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
        [
          voiceName,
          voiceBytes
        ],
        false);
  }

  
  /**
   * @param { !string } voiceName
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  selectVoice(
      voiceName) {
    return this.proxy.sendMessage(
        1,
        chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
        [
          voiceName
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } textJspb
   * @param { !Array<!number> } speakerParamsJspb
   * @return {!Promise<{
        eventObserver: !chromeos.tts.mojom.TtsEventObserverPendingReceiver,
   *  }>}
   */

  speak(
      textJspb,
      speakerParamsJspb) {
    return this.proxy.sendMessage(
        2,
        chromeos.tts.mojom.GoogleTtsStream_Speak_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_Speak_ResponseParamsSpec.$,
        [
          textJspb,
          speakerParamsJspb
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        3,
        chromeos.tts.mojom.GoogleTtsStream_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        4,
        chromeos.tts.mojom.GoogleTtsStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        5,
        chromeos.tts.mojom.GoogleTtsStream_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        6,
        chromeos.tts.mojom.GoogleTtsStream_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GoogleTtsStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.tts.mojom.GoogleTtsStreamReceiver = class {
  /**
   * @param {!chromeos.tts.mojom.GoogleTtsStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.tts.mojom.GoogleTtsStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.tts.mojom.GoogleTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.GoogleTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
        impl.installVoice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
        impl.selectVoice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.tts.mojom.GoogleTtsStream_Speak_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_Speak_ResponseParamsSpec.$,
        impl.speak.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeos.tts.mojom.GoogleTtsStream_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        chromeos.tts.mojom.GoogleTtsStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        chromeos.tts.mojom.GoogleTtsStream_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        chromeos.tts.mojom.GoogleTtsStream_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.tts.mojom.GoogleTtsStream = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.GoogleTtsStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.tts.mojom.GoogleTtsStreamRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.tts.mojom.GoogleTtsStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GoogleTtsStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.tts.mojom.GoogleTtsStreamCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.tts.mojom.GoogleTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.GoogleTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installVoice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
        this.installVoice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectVoice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
        this.selectVoice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speak =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.tts.mojom.GoogleTtsStream_Speak_ParamsSpec.$,
        chromeos.tts.mojom.GoogleTtsStream_Speak_ResponseParamsSpec.$,
        this.speak.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeos.tts.mojom.GoogleTtsStream_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        chromeos.tts.mojom.GoogleTtsStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        chromeos.tts.mojom.GoogleTtsStream_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        chromeos.tts.mojom.GoogleTtsStream_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.tts.mojom.PlaybackTtsStream.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.tts.mojom.PlaybackTtsStreamInterface }
 */
chromeos.tts.mojom.PlaybackTtsStreamRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        eventObserver: !chromeos.tts.mojom.TtsEventObserverPendingReceiver,
   *  }>}
   */

  play() {
    return this.proxy.sendMessage(
        0,
        chromeos.tts.mojom.PlaybackTtsStream_Play_ParamsSpec.$,
        chromeos.tts.mojom.PlaybackTtsStream_Play_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } framesBuffer
   * @param { !number } charIndex
   * @param { !boolean } lastBuffer
   */

  sendAudioBuffer(
      framesBuffer,
      charIndex,
      lastBuffer) {
    this.proxy.sendMessage(
        1,
        chromeos.tts.mojom.PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
        null,
        [
          framesBuffer,
          charIndex,
          lastBuffer
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        2,
        chromeos.tts.mojom.PlaybackTtsStream_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        3,
        chromeos.tts.mojom.PlaybackTtsStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        4,
        chromeos.tts.mojom.PlaybackTtsStream_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        5,
        chromeos.tts.mojom.PlaybackTtsStream_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PlaybackTtsStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStreamReceiver = class {
  /**
   * @param {!chromeos.tts.mojom.PlaybackTtsStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.tts.mojom.PlaybackTtsStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.tts.mojom.PlaybackTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.PlaybackTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.PlaybackTtsStream_Play_ParamsSpec.$,
        chromeos.tts.mojom.PlaybackTtsStream_Play_ResponseParamsSpec.$,
        impl.play.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
        null,
        impl.sendAudioBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.tts.mojom.PlaybackTtsStream_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeos.tts.mojom.PlaybackTtsStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        chromeos.tts.mojom.PlaybackTtsStream_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        chromeos.tts.mojom.PlaybackTtsStream_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.tts.mojom.PlaybackTtsStream = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.PlaybackTtsStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.tts.mojom.PlaybackTtsStreamRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.tts.mojom.PlaybackTtsStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PlaybackTtsStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStreamCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.tts.mojom.PlaybackTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.PlaybackTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.play =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.PlaybackTtsStream_Play_ParamsSpec.$,
        chromeos.tts.mojom.PlaybackTtsStream_Play_ResponseParamsSpec.$,
        this.play.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendAudioBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
        null,
        this.sendAudioBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.tts.mojom.PlaybackTtsStream_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeos.tts.mojom.PlaybackTtsStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        chromeos.tts.mojom.PlaybackTtsStream_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        chromeos.tts.mojom.PlaybackTtsStream_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.tts.mojom.TtsEventObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.tts.mojom.TtsEventObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.tts.mojom.TtsEventObserverInterface }
 */
chromeos.tts.mojom.TtsEventObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.tts.mojom.TtsEventObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.tts.mojom.TtsEventObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.tts.mojom.TtsEventObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onStart() {
    this.proxy.sendMessage(
        0,
        chromeos.tts.mojom.TtsEventObserver_OnStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } charIndex
   */

  onTimepoint(
      charIndex) {
    this.proxy.sendMessage(
        1,
        chromeos.tts.mojom.TtsEventObserver_OnTimepoint_ParamsSpec.$,
        null,
        [
          charIndex
        ],
        false);
  }

  
  /**
   */

  onEnd() {
    this.proxy.sendMessage(
        2,
        chromeos.tts.mojom.TtsEventObserver_OnEnd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onError() {
    this.proxy.sendMessage(
        3,
        chromeos.tts.mojom.TtsEventObserver_OnError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TtsEventObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.tts.mojom.TtsEventObserverReceiver = class {
  /**
   * @param {!chromeos.tts.mojom.TtsEventObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.tts.mojom.TtsEventObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.tts.mojom.TtsEventObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.TtsEventObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.TtsEventObserver_OnStart_ParamsSpec.$,
        null,
        impl.onStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.TtsEventObserver_OnTimepoint_ParamsSpec.$,
        null,
        impl.onTimepoint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.tts.mojom.TtsEventObserver_OnEnd_ParamsSpec.$,
        null,
        impl.onEnd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeos.tts.mojom.TtsEventObserver_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.tts.mojom.TtsEventObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.TtsEventObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.tts.mojom.TtsEventObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.tts.mojom.TtsEventObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TtsEventObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.tts.mojom.TtsEventObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.tts.mojom.TtsEventObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.tts.mojom.TtsEventObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.tts.mojom.TtsEventObserver_OnStart_ParamsSpec.$,
        null,
        this.onStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTimepoint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.tts.mojom.TtsEventObserver_OnTimepoint_ParamsSpec.$,
        null,
        this.onTimepoint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.tts.mojom.TtsEventObserver_OnEnd_ParamsSpec.$,
        null,
        this.onEnd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeos.tts.mojom.TtsEventObserver_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.AudioParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsService_BindGoogleTtsStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_Speak_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_Speak_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.GoogleTtsStream_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_Play_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_Play_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_SendAudioBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.PlaybackTtsStream_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsEventObserver_OnStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsEventObserver_OnTimepoint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsEventObserver_OnEnd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.tts.mojom.TtsEventObserver_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.tts.mojom.AudioParametersSpec.$,
    'AudioParameters',
    [
      mojo.internal.StructField(
        'sampleRate', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bufferSize', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.AudioParameters = class {
  constructor() {
    /** @export { !number } */
    this.sampleRate;
    /** @export { !number } */
    this.bufferSize;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsService_BindGoogleTtsStream_ParamsSpec.$,
    'TtsService_BindGoogleTtsStream_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.tts.mojom.GoogleTtsStreamPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamFactory', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.AudioStreamFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.tts.mojom.TtsService_BindGoogleTtsStream_Params = class {
  constructor() {
    /** @export { !chromeos.tts.mojom.GoogleTtsStreamPendingReceiver } */
    this.receiver;
    /** @export { !media.mojom.AudioStreamFactoryRemote } */
    this.streamFactory;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ParamsSpec.$,
    'TtsService_BindPlaybackTtsStream_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamFactory', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.AudioStreamFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'desiredAudioParameters', 16,
        0,
        chromeos.tts.mojom.AudioParametersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_Params = class {
  constructor() {
    /** @export { !chromeos.tts.mojom.PlaybackTtsStreamPendingReceiver } */
    this.receiver;
    /** @export { !media.mojom.AudioStreamFactoryRemote } */
    this.streamFactory;
    /** @export { (chromeos.tts.mojom.AudioParameters|undefined) } */
    this.desiredAudioParameters;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
    'TtsService_BindPlaybackTtsStream_ResponseParams',
    [
      mojo.internal.StructField(
        'audioParameters', 0,
        0,
        chromeos.tts.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.TtsService_BindPlaybackTtsStream_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.tts.mojom.AudioParameters } */
    this.audioParameters;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ParamsSpec.$,
    'GoogleTtsStream_InstallVoice_Params',
    [
      mojo.internal.StructField(
        'voiceName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'voiceBytes', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_InstallVoice_Params = class {
  constructor() {
    /** @export { !string } */
    this.voiceName;
    /** @export { !Array<!number> } */
    this.voiceBytes;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
    'GoogleTtsStream_InstallVoice_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_InstallVoice_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ParamsSpec.$,
    'GoogleTtsStream_SelectVoice_Params',
    [
      mojo.internal.StructField(
        'voiceName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_SelectVoice_Params = class {
  constructor() {
    /** @export { !string } */
    this.voiceName;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
    'GoogleTtsStream_SelectVoice_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_SelectVoice_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_Speak_ParamsSpec.$,
    'GoogleTtsStream_Speak_Params',
    [
      mojo.internal.StructField(
        'textJspb', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'speakerParamsJspb', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_Speak_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.textJspb;
    /** @export { !Array<!number> } */
    this.speakerParamsJspb;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_Speak_ResponseParamsSpec.$,
    'GoogleTtsStream_Speak_ResponseParams',
    [
      mojo.internal.StructField(
        'eventObserver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.tts.mojom.TtsEventObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_Speak_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.tts.mojom.TtsEventObserverPendingReceiver } */
    this.eventObserver;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_Stop_ParamsSpec.$,
    'GoogleTtsStream_Stop_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_Stop_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_SetVolume_ParamsSpec.$,
    'GoogleTtsStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_SetVolume_Params = class {
  constructor() {
    /** @export { !number } */
    this.volume;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_Pause_ParamsSpec.$,
    'GoogleTtsStream_Pause_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_Pause_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.GoogleTtsStream_Resume_ParamsSpec.$,
    'GoogleTtsStream_Resume_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.GoogleTtsStream_Resume_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_Play_ParamsSpec.$,
    'PlaybackTtsStream_Play_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_Play_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_Play_ResponseParamsSpec.$,
    'PlaybackTtsStream_Play_ResponseParams',
    [
      mojo.internal.StructField(
        'eventObserver', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.tts.mojom.TtsEventObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_Play_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.tts.mojom.TtsEventObserverPendingReceiver } */
    this.eventObserver;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
    'PlaybackTtsStream_SendAudioBuffer_Params',
    [
      mojo.internal.StructField(
        'framesBuffer', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'charIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastBuffer', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_SendAudioBuffer_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.framesBuffer;
    /** @export { !number } */
    this.charIndex;
    /** @export { !boolean } */
    this.lastBuffer;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_Stop_ParamsSpec.$,
    'PlaybackTtsStream_Stop_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_Stop_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_SetVolume_ParamsSpec.$,
    'PlaybackTtsStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_SetVolume_Params = class {
  constructor() {
    /** @export { !number } */
    this.volume;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_Pause_ParamsSpec.$,
    'PlaybackTtsStream_Pause_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_Pause_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.PlaybackTtsStream_Resume_ParamsSpec.$,
    'PlaybackTtsStream_Resume_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.PlaybackTtsStream_Resume_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsEventObserver_OnStart_ParamsSpec.$,
    'TtsEventObserver_OnStart_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.TtsEventObserver_OnStart_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsEventObserver_OnTimepoint_ParamsSpec.$,
    'TtsEventObserver_OnTimepoint_Params',
    [
      mojo.internal.StructField(
        'charIndex', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.tts.mojom.TtsEventObserver_OnTimepoint_Params = class {
  constructor() {
    /** @export { !number } */
    this.charIndex;
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsEventObserver_OnEnd_ParamsSpec.$,
    'TtsEventObserver_OnEnd_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.TtsEventObserver_OnEnd_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.tts.mojom.TtsEventObserver_OnError_ParamsSpec.$,
    'TtsEventObserver_OnError_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.tts.mojom.TtsEventObserver_OnError_Params = class {
  constructor() {
  }
};

