// chromeos/services/tts/public/mojom/tts_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/tts/public/mojom/tts_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.tts.mojom');
  var audio_stream_factory$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_stream_factory.mojom', '../../../../../media/mojo/mojom/audio_stream_factory.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../../../sandbox/policy/mojom/context.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../../../sandbox/policy/mojom/sandbox.mojom.js');
  }



  function AudioParameters(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioParameters.prototype.initDefaults_ = function() {
    this.sampleRate = 0;
    this.bufferSize = 0;
  };
  AudioParameters.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioParameters.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AudioParameters.encodedSize = codec.kStructHeaderSize + 8;

  AudioParameters.decode = function(decoder) {
    var packed;
    var val = new AudioParameters();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sampleRate =
        decoder.decodeStruct(codec.Int32);
    val.bufferSize =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  AudioParameters.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioParameters.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
    encoder.encodeStruct(codec.Int32, val.bufferSize);
  };
  function TtsService_BindGoogleTtsStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsService_BindGoogleTtsStream_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.streamFactory = new audio_stream_factory$.AudioStreamFactoryPtr();
  };
  TtsService_BindGoogleTtsStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsService_BindGoogleTtsStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsService_BindGoogleTtsStream_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsService_BindGoogleTtsStream_Params.streamFactory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsService_BindGoogleTtsStream_Params.encodedSize = codec.kStructHeaderSize + 16;

  TtsService_BindGoogleTtsStream_Params.decode = function(decoder) {
    var packed;
    var val = new TtsService_BindGoogleTtsStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.streamFactory =
        decoder.decodeStruct(new codec.Interface(audio_stream_factory$.AudioStreamFactoryPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TtsService_BindGoogleTtsStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsService_BindGoogleTtsStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.Interface(audio_stream_factory$.AudioStreamFactoryPtr), val.streamFactory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TtsService_BindPlaybackTtsStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsService_BindPlaybackTtsStream_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.streamFactory = new audio_stream_factory$.AudioStreamFactoryPtr();
    this.desiredAudioParameters = null;
  };
  TtsService_BindPlaybackTtsStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsService_BindPlaybackTtsStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsService_BindPlaybackTtsStream_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsService_BindPlaybackTtsStream_Params.streamFactory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsService_BindPlaybackTtsStream_Params.desiredAudioParameters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AudioParameters, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsService_BindPlaybackTtsStream_Params.encodedSize = codec.kStructHeaderSize + 24;

  TtsService_BindPlaybackTtsStream_Params.decode = function(decoder) {
    var packed;
    var val = new TtsService_BindPlaybackTtsStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.streamFactory =
        decoder.decodeStruct(new codec.Interface(audio_stream_factory$.AudioStreamFactoryPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.desiredAudioParameters =
        decoder.decodeStructPointer(AudioParameters);
    return val;
  };

  TtsService_BindPlaybackTtsStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsService_BindPlaybackTtsStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.Interface(audio_stream_factory$.AudioStreamFactoryPtr), val.streamFactory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AudioParameters, val.desiredAudioParameters);
  };
  function TtsService_BindPlaybackTtsStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsService_BindPlaybackTtsStream_ResponseParams.prototype.initDefaults_ = function() {
    this.audioParameters = null;
  };
  TtsService_BindPlaybackTtsStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsService_BindPlaybackTtsStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsService_BindPlaybackTtsStream_ResponseParams.audioParameters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsService_BindPlaybackTtsStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TtsService_BindPlaybackTtsStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TtsService_BindPlaybackTtsStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioParameters =
        decoder.decodeStructPointer(AudioParameters);
    return val;
  };

  TtsService_BindPlaybackTtsStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsService_BindPlaybackTtsStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AudioParameters, val.audioParameters);
  };
  function GoogleTtsStream_InstallVoice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_InstallVoice_Params.prototype.initDefaults_ = function() {
    this.voiceName = null;
    this.voiceBytes = null;
  };
  GoogleTtsStream_InstallVoice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_InstallVoice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GoogleTtsStream_InstallVoice_Params.voiceName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GoogleTtsStream_InstallVoice_Params.voiceBytes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_InstallVoice_Params.encodedSize = codec.kStructHeaderSize + 16;

  GoogleTtsStream_InstallVoice_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_InstallVoice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.voiceName =
        decoder.decodeStruct(codec.String);
    val.voiceBytes =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  GoogleTtsStream_InstallVoice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_InstallVoice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.voiceName);
    encoder.encodeArrayPointer(codec.Uint8, val.voiceBytes);
  };
  function GoogleTtsStream_InstallVoice_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_InstallVoice_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  GoogleTtsStream_InstallVoice_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_InstallVoice_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GoogleTtsStream_InstallVoice_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  GoogleTtsStream_InstallVoice_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_InstallVoice_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GoogleTtsStream_InstallVoice_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_InstallVoice_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GoogleTtsStream_SelectVoice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_SelectVoice_Params.prototype.initDefaults_ = function() {
    this.voiceName = null;
  };
  GoogleTtsStream_SelectVoice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_SelectVoice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GoogleTtsStream_SelectVoice_Params.voiceName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_SelectVoice_Params.encodedSize = codec.kStructHeaderSize + 8;

  GoogleTtsStream_SelectVoice_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_SelectVoice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.voiceName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  GoogleTtsStream_SelectVoice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_SelectVoice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.voiceName);
  };
  function GoogleTtsStream_SelectVoice_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_SelectVoice_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  GoogleTtsStream_SelectVoice_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_SelectVoice_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GoogleTtsStream_SelectVoice_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  GoogleTtsStream_SelectVoice_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_SelectVoice_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GoogleTtsStream_SelectVoice_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_SelectVoice_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GoogleTtsStream_Speak_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_Speak_Params.prototype.initDefaults_ = function() {
    this.textJspb = null;
    this.speakerParamsJspb = null;
  };
  GoogleTtsStream_Speak_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_Speak_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GoogleTtsStream_Speak_Params.textJspb
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GoogleTtsStream_Speak_Params.speakerParamsJspb
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_Speak_Params.encodedSize = codec.kStructHeaderSize + 16;

  GoogleTtsStream_Speak_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_Speak_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textJspb =
        decoder.decodeArrayPointer(codec.Uint8);
    val.speakerParamsJspb =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  GoogleTtsStream_Speak_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_Speak_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.textJspb);
    encoder.encodeArrayPointer(codec.Uint8, val.speakerParamsJspb);
  };
  function GoogleTtsStream_Speak_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_Speak_ResponseParams.prototype.initDefaults_ = function() {
    this.eventObserver = new bindings.InterfaceRequest();
  };
  GoogleTtsStream_Speak_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_Speak_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GoogleTtsStream_Speak_ResponseParams.eventObserver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_Speak_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  GoogleTtsStream_Speak_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_Speak_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventObserver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GoogleTtsStream_Speak_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_Speak_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.eventObserver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GoogleTtsStream_Stop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_Stop_Params.prototype.initDefaults_ = function() {
  };
  GoogleTtsStream_Stop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_Stop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_Stop_Params.encodedSize = codec.kStructHeaderSize + 0;

  GoogleTtsStream_Stop_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_Stop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  GoogleTtsStream_Stop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_Stop_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function GoogleTtsStream_SetVolume_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_SetVolume_Params.prototype.initDefaults_ = function() {
    this.volume = 0;
  };
  GoogleTtsStream_SetVolume_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_SetVolume_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GoogleTtsStream_SetVolume_Params.encodedSize = codec.kStructHeaderSize + 8;

  GoogleTtsStream_SetVolume_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_SetVolume_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.volume =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GoogleTtsStream_SetVolume_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_SetVolume_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.volume);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GoogleTtsStream_Pause_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_Pause_Params.prototype.initDefaults_ = function() {
  };
  GoogleTtsStream_Pause_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_Pause_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_Pause_Params.encodedSize = codec.kStructHeaderSize + 0;

  GoogleTtsStream_Pause_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_Pause_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  GoogleTtsStream_Pause_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_Pause_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function GoogleTtsStream_Resume_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GoogleTtsStream_Resume_Params.prototype.initDefaults_ = function() {
  };
  GoogleTtsStream_Resume_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GoogleTtsStream_Resume_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GoogleTtsStream_Resume_Params.encodedSize = codec.kStructHeaderSize + 0;

  GoogleTtsStream_Resume_Params.decode = function(decoder) {
    var packed;
    var val = new GoogleTtsStream_Resume_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  GoogleTtsStream_Resume_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GoogleTtsStream_Resume_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PlaybackTtsStream_Play_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_Play_Params.prototype.initDefaults_ = function() {
  };
  PlaybackTtsStream_Play_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_Play_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlaybackTtsStream_Play_Params.encodedSize = codec.kStructHeaderSize + 0;

  PlaybackTtsStream_Play_Params.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_Play_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PlaybackTtsStream_Play_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_Play_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PlaybackTtsStream_Play_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_Play_ResponseParams.prototype.initDefaults_ = function() {
    this.eventObserver = new bindings.InterfaceRequest();
  };
  PlaybackTtsStream_Play_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_Play_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PlaybackTtsStream_Play_ResponseParams.eventObserver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlaybackTtsStream_Play_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PlaybackTtsStream_Play_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_Play_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventObserver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PlaybackTtsStream_Play_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_Play_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.eventObserver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PlaybackTtsStream_SendAudioBuffer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_SendAudioBuffer_Params.prototype.initDefaults_ = function() {
    this.framesBuffer = null;
    this.charIndex = 0;
    this.lastBuffer = false;
  };
  PlaybackTtsStream_SendAudioBuffer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_SendAudioBuffer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PlaybackTtsStream_SendAudioBuffer_Params.framesBuffer
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Float, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  PlaybackTtsStream_SendAudioBuffer_Params.encodedSize = codec.kStructHeaderSize + 16;

  PlaybackTtsStream_SendAudioBuffer_Params.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_SendAudioBuffer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.framesBuffer =
        decoder.decodeArrayPointer(codec.Float);
    val.charIndex =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.lastBuffer = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PlaybackTtsStream_SendAudioBuffer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_SendAudioBuffer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Float, val.framesBuffer);
    encoder.encodeStruct(codec.Int32, val.charIndex);
    packed = 0;
    packed |= (val.lastBuffer & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PlaybackTtsStream_Stop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_Stop_Params.prototype.initDefaults_ = function() {
  };
  PlaybackTtsStream_Stop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_Stop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlaybackTtsStream_Stop_Params.encodedSize = codec.kStructHeaderSize + 0;

  PlaybackTtsStream_Stop_Params.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_Stop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PlaybackTtsStream_Stop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_Stop_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PlaybackTtsStream_SetVolume_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_SetVolume_Params.prototype.initDefaults_ = function() {
    this.volume = 0;
  };
  PlaybackTtsStream_SetVolume_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_SetVolume_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PlaybackTtsStream_SetVolume_Params.encodedSize = codec.kStructHeaderSize + 8;

  PlaybackTtsStream_SetVolume_Params.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_SetVolume_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.volume =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PlaybackTtsStream_SetVolume_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_SetVolume_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.volume);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PlaybackTtsStream_Pause_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_Pause_Params.prototype.initDefaults_ = function() {
  };
  PlaybackTtsStream_Pause_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_Pause_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlaybackTtsStream_Pause_Params.encodedSize = codec.kStructHeaderSize + 0;

  PlaybackTtsStream_Pause_Params.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_Pause_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PlaybackTtsStream_Pause_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_Pause_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PlaybackTtsStream_Resume_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaybackTtsStream_Resume_Params.prototype.initDefaults_ = function() {
  };
  PlaybackTtsStream_Resume_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaybackTtsStream_Resume_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlaybackTtsStream_Resume_Params.encodedSize = codec.kStructHeaderSize + 0;

  PlaybackTtsStream_Resume_Params.decode = function(decoder) {
    var packed;
    var val = new PlaybackTtsStream_Resume_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PlaybackTtsStream_Resume_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaybackTtsStream_Resume_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function TtsEventObserver_OnStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsEventObserver_OnStart_Params.prototype.initDefaults_ = function() {
  };
  TtsEventObserver_OnStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsEventObserver_OnStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsEventObserver_OnStart_Params.encodedSize = codec.kStructHeaderSize + 0;

  TtsEventObserver_OnStart_Params.decode = function(decoder) {
    var packed;
    var val = new TtsEventObserver_OnStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  TtsEventObserver_OnStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsEventObserver_OnStart_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function TtsEventObserver_OnTimepoint_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsEventObserver_OnTimepoint_Params.prototype.initDefaults_ = function() {
    this.charIndex = 0;
  };
  TtsEventObserver_OnTimepoint_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsEventObserver_OnTimepoint_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TtsEventObserver_OnTimepoint_Params.encodedSize = codec.kStructHeaderSize + 8;

  TtsEventObserver_OnTimepoint_Params.decode = function(decoder) {
    var packed;
    var val = new TtsEventObserver_OnTimepoint_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.charIndex =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TtsEventObserver_OnTimepoint_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsEventObserver_OnTimepoint_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.charIndex);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TtsEventObserver_OnEnd_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsEventObserver_OnEnd_Params.prototype.initDefaults_ = function() {
  };
  TtsEventObserver_OnEnd_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsEventObserver_OnEnd_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsEventObserver_OnEnd_Params.encodedSize = codec.kStructHeaderSize + 0;

  TtsEventObserver_OnEnd_Params.decode = function(decoder) {
    var packed;
    var val = new TtsEventObserver_OnEnd_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  TtsEventObserver_OnEnd_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsEventObserver_OnEnd_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function TtsEventObserver_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsEventObserver_OnError_Params.prototype.initDefaults_ = function() {
  };
  TtsEventObserver_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsEventObserver_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsEventObserver_OnError_Params.encodedSize = codec.kStructHeaderSize + 0;

  TtsEventObserver_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new TtsEventObserver_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  TtsEventObserver_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsEventObserver_OnError_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kTtsService_BindGoogleTtsStream_Name = 0;
  var kTtsService_BindPlaybackTtsStream_Name = 1;

  function TtsServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TtsService,
                                                   handleOrPtrInfo);
  }

  function TtsServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TtsService, associatedInterfacePtrInfo);
  }

  TtsServiceAssociatedPtr.prototype =
      Object.create(TtsServicePtr.prototype);
  TtsServiceAssociatedPtr.prototype.constructor =
      TtsServiceAssociatedPtr;

  function TtsServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  TtsServicePtr.prototype.bindGoogleTtsStream = function() {
    return TtsServiceProxy.prototype.bindGoogleTtsStream
        .apply(this.ptr.getProxy(), arguments);
  };

  TtsServiceProxy.prototype.bindGoogleTtsStream = function(receiver, streamFactory) {
    var params_ = new TtsService_BindGoogleTtsStream_Params();
    params_.receiver = receiver;
    params_.streamFactory = streamFactory;
    var builder = new codec.MessageV0Builder(
        kTtsService_BindGoogleTtsStream_Name,
        codec.align(TtsService_BindGoogleTtsStream_Params.encodedSize));
    builder.encodeStruct(TtsService_BindGoogleTtsStream_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TtsServicePtr.prototype.bindPlaybackTtsStream = function() {
    return TtsServiceProxy.prototype.bindPlaybackTtsStream
        .apply(this.ptr.getProxy(), arguments);
  };

  TtsServiceProxy.prototype.bindPlaybackTtsStream = function(receiver, streamFactory, desiredAudioParameters) {
    var params_ = new TtsService_BindPlaybackTtsStream_Params();
    params_.receiver = receiver;
    params_.streamFactory = streamFactory;
    params_.desiredAudioParameters = desiredAudioParameters;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTtsService_BindPlaybackTtsStream_Name,
          codec.align(TtsService_BindPlaybackTtsStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TtsService_BindPlaybackTtsStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TtsService_BindPlaybackTtsStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function TtsServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  TtsServiceStub.prototype.bindGoogleTtsStream = function(receiver, streamFactory) {
    return this.delegate_ && this.delegate_.bindGoogleTtsStream && this.delegate_.bindGoogleTtsStream(receiver, streamFactory);
  }
  TtsServiceStub.prototype.bindPlaybackTtsStream = function(receiver, streamFactory, desiredAudioParameters) {
    return this.delegate_ && this.delegate_.bindPlaybackTtsStream && this.delegate_.bindPlaybackTtsStream(receiver, streamFactory, desiredAudioParameters);
  }

  TtsServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTtsService_BindGoogleTtsStream_Name:
      var params = reader.decodeStruct(TtsService_BindGoogleTtsStream_Params);
      this.bindGoogleTtsStream(params.receiver, params.streamFactory);
      return true;
    default:
      return false;
    }
  };

  TtsServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTtsService_BindPlaybackTtsStream_Name:
      var params = reader.decodeStruct(TtsService_BindPlaybackTtsStream_Params);
      this.bindPlaybackTtsStream(params.receiver, params.streamFactory, params.desiredAudioParameters).then(function(response) {
        var responseParams =
            new TtsService_BindPlaybackTtsStream_ResponseParams();
        responseParams.audioParameters = response.audioParameters;
        var builder = new codec.MessageV1Builder(
            kTtsService_BindPlaybackTtsStream_Name,
            codec.align(TtsService_BindPlaybackTtsStream_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TtsService_BindPlaybackTtsStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTtsServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTtsService_BindGoogleTtsStream_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TtsService_BindGoogleTtsStream_Params;
      break;
      case kTtsService_BindPlaybackTtsStream_Name:
        if (message.expectsResponse())
          paramsClass = TtsService_BindPlaybackTtsStream_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTtsServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTtsService_BindPlaybackTtsStream_Name:
        if (message.isResponse())
          paramsClass = TtsService_BindPlaybackTtsStream_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TtsService = {
    name: 'chromeos.tts.mojom.TtsService',
    kVersion: 0,
    ptrClass: TtsServicePtr,
    proxyClass: TtsServiceProxy,
    stubClass: TtsServiceStub,
    validateRequest: validateTtsServiceRequest,
    validateResponse: validateTtsServiceResponse,
  };
  TtsServiceStub.prototype.validator = validateTtsServiceRequest;
  TtsServiceProxy.prototype.validator = validateTtsServiceResponse;
  var kGoogleTtsStream_InstallVoice_Name = 0;
  var kGoogleTtsStream_SelectVoice_Name = 1;
  var kGoogleTtsStream_Speak_Name = 2;
  var kGoogleTtsStream_Stop_Name = 3;
  var kGoogleTtsStream_SetVolume_Name = 4;
  var kGoogleTtsStream_Pause_Name = 5;
  var kGoogleTtsStream_Resume_Name = 6;

  function GoogleTtsStreamPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(GoogleTtsStream,
                                                   handleOrPtrInfo);
  }

  function GoogleTtsStreamAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        GoogleTtsStream, associatedInterfacePtrInfo);
  }

  GoogleTtsStreamAssociatedPtr.prototype =
      Object.create(GoogleTtsStreamPtr.prototype);
  GoogleTtsStreamAssociatedPtr.prototype.constructor =
      GoogleTtsStreamAssociatedPtr;

  function GoogleTtsStreamProxy(receiver) {
    this.receiver_ = receiver;
  }
  GoogleTtsStreamPtr.prototype.installVoice = function() {
    return GoogleTtsStreamProxy.prototype.installVoice
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.installVoice = function(voiceName, voiceBytes) {
    var params_ = new GoogleTtsStream_InstallVoice_Params();
    params_.voiceName = voiceName;
    params_.voiceBytes = voiceBytes;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kGoogleTtsStream_InstallVoice_Name,
          codec.align(GoogleTtsStream_InstallVoice_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(GoogleTtsStream_InstallVoice_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(GoogleTtsStream_InstallVoice_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  GoogleTtsStreamPtr.prototype.selectVoice = function() {
    return GoogleTtsStreamProxy.prototype.selectVoice
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.selectVoice = function(voiceName) {
    var params_ = new GoogleTtsStream_SelectVoice_Params();
    params_.voiceName = voiceName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kGoogleTtsStream_SelectVoice_Name,
          codec.align(GoogleTtsStream_SelectVoice_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(GoogleTtsStream_SelectVoice_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(GoogleTtsStream_SelectVoice_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  GoogleTtsStreamPtr.prototype.speak = function() {
    return GoogleTtsStreamProxy.prototype.speak
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.speak = function(textJspb, speakerParamsJspb) {
    var params_ = new GoogleTtsStream_Speak_Params();
    params_.textJspb = textJspb;
    params_.speakerParamsJspb = speakerParamsJspb;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kGoogleTtsStream_Speak_Name,
          codec.align(GoogleTtsStream_Speak_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(GoogleTtsStream_Speak_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(GoogleTtsStream_Speak_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  GoogleTtsStreamPtr.prototype.stop = function() {
    return GoogleTtsStreamProxy.prototype.stop
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.stop = function() {
    var params_ = new GoogleTtsStream_Stop_Params();
    var builder = new codec.MessageV0Builder(
        kGoogleTtsStream_Stop_Name,
        codec.align(GoogleTtsStream_Stop_Params.encodedSize));
    builder.encodeStruct(GoogleTtsStream_Stop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  GoogleTtsStreamPtr.prototype.setVolume = function() {
    return GoogleTtsStreamProxy.prototype.setVolume
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.setVolume = function(volume) {
    var params_ = new GoogleTtsStream_SetVolume_Params();
    params_.volume = volume;
    var builder = new codec.MessageV0Builder(
        kGoogleTtsStream_SetVolume_Name,
        codec.align(GoogleTtsStream_SetVolume_Params.encodedSize));
    builder.encodeStruct(GoogleTtsStream_SetVolume_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  GoogleTtsStreamPtr.prototype.pause = function() {
    return GoogleTtsStreamProxy.prototype.pause
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.pause = function() {
    var params_ = new GoogleTtsStream_Pause_Params();
    var builder = new codec.MessageV0Builder(
        kGoogleTtsStream_Pause_Name,
        codec.align(GoogleTtsStream_Pause_Params.encodedSize));
    builder.encodeStruct(GoogleTtsStream_Pause_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  GoogleTtsStreamPtr.prototype.resume = function() {
    return GoogleTtsStreamProxy.prototype.resume
        .apply(this.ptr.getProxy(), arguments);
  };

  GoogleTtsStreamProxy.prototype.resume = function() {
    var params_ = new GoogleTtsStream_Resume_Params();
    var builder = new codec.MessageV0Builder(
        kGoogleTtsStream_Resume_Name,
        codec.align(GoogleTtsStream_Resume_Params.encodedSize));
    builder.encodeStruct(GoogleTtsStream_Resume_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function GoogleTtsStreamStub(delegate) {
    this.delegate_ = delegate;
  }
  GoogleTtsStreamStub.prototype.installVoice = function(voiceName, voiceBytes) {
    return this.delegate_ && this.delegate_.installVoice && this.delegate_.installVoice(voiceName, voiceBytes);
  }
  GoogleTtsStreamStub.prototype.selectVoice = function(voiceName) {
    return this.delegate_ && this.delegate_.selectVoice && this.delegate_.selectVoice(voiceName);
  }
  GoogleTtsStreamStub.prototype.speak = function(textJspb, speakerParamsJspb) {
    return this.delegate_ && this.delegate_.speak && this.delegate_.speak(textJspb, speakerParamsJspb);
  }
  GoogleTtsStreamStub.prototype.stop = function() {
    return this.delegate_ && this.delegate_.stop && this.delegate_.stop();
  }
  GoogleTtsStreamStub.prototype.setVolume = function(volume) {
    return this.delegate_ && this.delegate_.setVolume && this.delegate_.setVolume(volume);
  }
  GoogleTtsStreamStub.prototype.pause = function() {
    return this.delegate_ && this.delegate_.pause && this.delegate_.pause();
  }
  GoogleTtsStreamStub.prototype.resume = function() {
    return this.delegate_ && this.delegate_.resume && this.delegate_.resume();
  }

  GoogleTtsStreamStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kGoogleTtsStream_Stop_Name:
      var params = reader.decodeStruct(GoogleTtsStream_Stop_Params);
      this.stop();
      return true;
    case kGoogleTtsStream_SetVolume_Name:
      var params = reader.decodeStruct(GoogleTtsStream_SetVolume_Params);
      this.setVolume(params.volume);
      return true;
    case kGoogleTtsStream_Pause_Name:
      var params = reader.decodeStruct(GoogleTtsStream_Pause_Params);
      this.pause();
      return true;
    case kGoogleTtsStream_Resume_Name:
      var params = reader.decodeStruct(GoogleTtsStream_Resume_Params);
      this.resume();
      return true;
    default:
      return false;
    }
  };

  GoogleTtsStreamStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kGoogleTtsStream_InstallVoice_Name:
      var params = reader.decodeStruct(GoogleTtsStream_InstallVoice_Params);
      this.installVoice(params.voiceName, params.voiceBytes).then(function(response) {
        var responseParams =
            new GoogleTtsStream_InstallVoice_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kGoogleTtsStream_InstallVoice_Name,
            codec.align(GoogleTtsStream_InstallVoice_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(GoogleTtsStream_InstallVoice_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kGoogleTtsStream_SelectVoice_Name:
      var params = reader.decodeStruct(GoogleTtsStream_SelectVoice_Params);
      this.selectVoice(params.voiceName).then(function(response) {
        var responseParams =
            new GoogleTtsStream_SelectVoice_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kGoogleTtsStream_SelectVoice_Name,
            codec.align(GoogleTtsStream_SelectVoice_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(GoogleTtsStream_SelectVoice_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kGoogleTtsStream_Speak_Name:
      var params = reader.decodeStruct(GoogleTtsStream_Speak_Params);
      this.speak(params.textJspb, params.speakerParamsJspb).then(function(response) {
        var responseParams =
            new GoogleTtsStream_Speak_ResponseParams();
        responseParams.eventObserver = response.eventObserver;
        var builder = new codec.MessageV1Builder(
            kGoogleTtsStream_Speak_Name,
            codec.align(GoogleTtsStream_Speak_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(GoogleTtsStream_Speak_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateGoogleTtsStreamRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kGoogleTtsStream_InstallVoice_Name:
        if (message.expectsResponse())
          paramsClass = GoogleTtsStream_InstallVoice_Params;
      break;
      case kGoogleTtsStream_SelectVoice_Name:
        if (message.expectsResponse())
          paramsClass = GoogleTtsStream_SelectVoice_Params;
      break;
      case kGoogleTtsStream_Speak_Name:
        if (message.expectsResponse())
          paramsClass = GoogleTtsStream_Speak_Params;
      break;
      case kGoogleTtsStream_Stop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GoogleTtsStream_Stop_Params;
      break;
      case kGoogleTtsStream_SetVolume_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GoogleTtsStream_SetVolume_Params;
      break;
      case kGoogleTtsStream_Pause_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GoogleTtsStream_Pause_Params;
      break;
      case kGoogleTtsStream_Resume_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GoogleTtsStream_Resume_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateGoogleTtsStreamResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kGoogleTtsStream_InstallVoice_Name:
        if (message.isResponse())
          paramsClass = GoogleTtsStream_InstallVoice_ResponseParams;
        break;
      case kGoogleTtsStream_SelectVoice_Name:
        if (message.isResponse())
          paramsClass = GoogleTtsStream_SelectVoice_ResponseParams;
        break;
      case kGoogleTtsStream_Speak_Name:
        if (message.isResponse())
          paramsClass = GoogleTtsStream_Speak_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var GoogleTtsStream = {
    name: 'chromeos.tts.mojom.GoogleTtsStream',
    kVersion: 0,
    ptrClass: GoogleTtsStreamPtr,
    proxyClass: GoogleTtsStreamProxy,
    stubClass: GoogleTtsStreamStub,
    validateRequest: validateGoogleTtsStreamRequest,
    validateResponse: validateGoogleTtsStreamResponse,
  };
  GoogleTtsStreamStub.prototype.validator = validateGoogleTtsStreamRequest;
  GoogleTtsStreamProxy.prototype.validator = validateGoogleTtsStreamResponse;
  var kPlaybackTtsStream_Play_Name = 0;
  var kPlaybackTtsStream_SendAudioBuffer_Name = 1;
  var kPlaybackTtsStream_Stop_Name = 2;
  var kPlaybackTtsStream_SetVolume_Name = 3;
  var kPlaybackTtsStream_Pause_Name = 4;
  var kPlaybackTtsStream_Resume_Name = 5;

  function PlaybackTtsStreamPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PlaybackTtsStream,
                                                   handleOrPtrInfo);
  }

  function PlaybackTtsStreamAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PlaybackTtsStream, associatedInterfacePtrInfo);
  }

  PlaybackTtsStreamAssociatedPtr.prototype =
      Object.create(PlaybackTtsStreamPtr.prototype);
  PlaybackTtsStreamAssociatedPtr.prototype.constructor =
      PlaybackTtsStreamAssociatedPtr;

  function PlaybackTtsStreamProxy(receiver) {
    this.receiver_ = receiver;
  }
  PlaybackTtsStreamPtr.prototype.play = function() {
    return PlaybackTtsStreamProxy.prototype.play
        .apply(this.ptr.getProxy(), arguments);
  };

  PlaybackTtsStreamProxy.prototype.play = function() {
    var params_ = new PlaybackTtsStream_Play_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPlaybackTtsStream_Play_Name,
          codec.align(PlaybackTtsStream_Play_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PlaybackTtsStream_Play_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PlaybackTtsStream_Play_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PlaybackTtsStreamPtr.prototype.sendAudioBuffer = function() {
    return PlaybackTtsStreamProxy.prototype.sendAudioBuffer
        .apply(this.ptr.getProxy(), arguments);
  };

  PlaybackTtsStreamProxy.prototype.sendAudioBuffer = function(framesBuffer, charIndex, lastBuffer) {
    var params_ = new PlaybackTtsStream_SendAudioBuffer_Params();
    params_.framesBuffer = framesBuffer;
    params_.charIndex = charIndex;
    params_.lastBuffer = lastBuffer;
    var builder = new codec.MessageV0Builder(
        kPlaybackTtsStream_SendAudioBuffer_Name,
        codec.align(PlaybackTtsStream_SendAudioBuffer_Params.encodedSize));
    builder.encodeStruct(PlaybackTtsStream_SendAudioBuffer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PlaybackTtsStreamPtr.prototype.stop = function() {
    return PlaybackTtsStreamProxy.prototype.stop
        .apply(this.ptr.getProxy(), arguments);
  };

  PlaybackTtsStreamProxy.prototype.stop = function() {
    var params_ = new PlaybackTtsStream_Stop_Params();
    var builder = new codec.MessageV0Builder(
        kPlaybackTtsStream_Stop_Name,
        codec.align(PlaybackTtsStream_Stop_Params.encodedSize));
    builder.encodeStruct(PlaybackTtsStream_Stop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PlaybackTtsStreamPtr.prototype.setVolume = function() {
    return PlaybackTtsStreamProxy.prototype.setVolume
        .apply(this.ptr.getProxy(), arguments);
  };

  PlaybackTtsStreamProxy.prototype.setVolume = function(volume) {
    var params_ = new PlaybackTtsStream_SetVolume_Params();
    params_.volume = volume;
    var builder = new codec.MessageV0Builder(
        kPlaybackTtsStream_SetVolume_Name,
        codec.align(PlaybackTtsStream_SetVolume_Params.encodedSize));
    builder.encodeStruct(PlaybackTtsStream_SetVolume_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PlaybackTtsStreamPtr.prototype.pause = function() {
    return PlaybackTtsStreamProxy.prototype.pause
        .apply(this.ptr.getProxy(), arguments);
  };

  PlaybackTtsStreamProxy.prototype.pause = function() {
    var params_ = new PlaybackTtsStream_Pause_Params();
    var builder = new codec.MessageV0Builder(
        kPlaybackTtsStream_Pause_Name,
        codec.align(PlaybackTtsStream_Pause_Params.encodedSize));
    builder.encodeStruct(PlaybackTtsStream_Pause_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PlaybackTtsStreamPtr.prototype.resume = function() {
    return PlaybackTtsStreamProxy.prototype.resume
        .apply(this.ptr.getProxy(), arguments);
  };

  PlaybackTtsStreamProxy.prototype.resume = function() {
    var params_ = new PlaybackTtsStream_Resume_Params();
    var builder = new codec.MessageV0Builder(
        kPlaybackTtsStream_Resume_Name,
        codec.align(PlaybackTtsStream_Resume_Params.encodedSize));
    builder.encodeStruct(PlaybackTtsStream_Resume_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PlaybackTtsStreamStub(delegate) {
    this.delegate_ = delegate;
  }
  PlaybackTtsStreamStub.prototype.play = function() {
    return this.delegate_ && this.delegate_.play && this.delegate_.play();
  }
  PlaybackTtsStreamStub.prototype.sendAudioBuffer = function(framesBuffer, charIndex, lastBuffer) {
    return this.delegate_ && this.delegate_.sendAudioBuffer && this.delegate_.sendAudioBuffer(framesBuffer, charIndex, lastBuffer);
  }
  PlaybackTtsStreamStub.prototype.stop = function() {
    return this.delegate_ && this.delegate_.stop && this.delegate_.stop();
  }
  PlaybackTtsStreamStub.prototype.setVolume = function(volume) {
    return this.delegate_ && this.delegate_.setVolume && this.delegate_.setVolume(volume);
  }
  PlaybackTtsStreamStub.prototype.pause = function() {
    return this.delegate_ && this.delegate_.pause && this.delegate_.pause();
  }
  PlaybackTtsStreamStub.prototype.resume = function() {
    return this.delegate_ && this.delegate_.resume && this.delegate_.resume();
  }

  PlaybackTtsStreamStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPlaybackTtsStream_SendAudioBuffer_Name:
      var params = reader.decodeStruct(PlaybackTtsStream_SendAudioBuffer_Params);
      this.sendAudioBuffer(params.framesBuffer, params.charIndex, params.lastBuffer);
      return true;
    case kPlaybackTtsStream_Stop_Name:
      var params = reader.decodeStruct(PlaybackTtsStream_Stop_Params);
      this.stop();
      return true;
    case kPlaybackTtsStream_SetVolume_Name:
      var params = reader.decodeStruct(PlaybackTtsStream_SetVolume_Params);
      this.setVolume(params.volume);
      return true;
    case kPlaybackTtsStream_Pause_Name:
      var params = reader.decodeStruct(PlaybackTtsStream_Pause_Params);
      this.pause();
      return true;
    case kPlaybackTtsStream_Resume_Name:
      var params = reader.decodeStruct(PlaybackTtsStream_Resume_Params);
      this.resume();
      return true;
    default:
      return false;
    }
  };

  PlaybackTtsStreamStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPlaybackTtsStream_Play_Name:
      var params = reader.decodeStruct(PlaybackTtsStream_Play_Params);
      this.play().then(function(response) {
        var responseParams =
            new PlaybackTtsStream_Play_ResponseParams();
        responseParams.eventObserver = response.eventObserver;
        var builder = new codec.MessageV1Builder(
            kPlaybackTtsStream_Play_Name,
            codec.align(PlaybackTtsStream_Play_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PlaybackTtsStream_Play_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePlaybackTtsStreamRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPlaybackTtsStream_Play_Name:
        if (message.expectsResponse())
          paramsClass = PlaybackTtsStream_Play_Params;
      break;
      case kPlaybackTtsStream_SendAudioBuffer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlaybackTtsStream_SendAudioBuffer_Params;
      break;
      case kPlaybackTtsStream_Stop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlaybackTtsStream_Stop_Params;
      break;
      case kPlaybackTtsStream_SetVolume_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlaybackTtsStream_SetVolume_Params;
      break;
      case kPlaybackTtsStream_Pause_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlaybackTtsStream_Pause_Params;
      break;
      case kPlaybackTtsStream_Resume_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlaybackTtsStream_Resume_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePlaybackTtsStreamResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPlaybackTtsStream_Play_Name:
        if (message.isResponse())
          paramsClass = PlaybackTtsStream_Play_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PlaybackTtsStream = {
    name: 'chromeos.tts.mojom.PlaybackTtsStream',
    kVersion: 0,
    ptrClass: PlaybackTtsStreamPtr,
    proxyClass: PlaybackTtsStreamProxy,
    stubClass: PlaybackTtsStreamStub,
    validateRequest: validatePlaybackTtsStreamRequest,
    validateResponse: validatePlaybackTtsStreamResponse,
  };
  PlaybackTtsStreamStub.prototype.validator = validatePlaybackTtsStreamRequest;
  PlaybackTtsStreamProxy.prototype.validator = validatePlaybackTtsStreamResponse;
  var kTtsEventObserver_OnStart_Name = 0;
  var kTtsEventObserver_OnTimepoint_Name = 1;
  var kTtsEventObserver_OnEnd_Name = 2;
  var kTtsEventObserver_OnError_Name = 3;

  function TtsEventObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TtsEventObserver,
                                                   handleOrPtrInfo);
  }

  function TtsEventObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TtsEventObserver, associatedInterfacePtrInfo);
  }

  TtsEventObserverAssociatedPtr.prototype =
      Object.create(TtsEventObserverPtr.prototype);
  TtsEventObserverAssociatedPtr.prototype.constructor =
      TtsEventObserverAssociatedPtr;

  function TtsEventObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  TtsEventObserverPtr.prototype.onStart = function() {
    return TtsEventObserverProxy.prototype.onStart
        .apply(this.ptr.getProxy(), arguments);
  };

  TtsEventObserverProxy.prototype.onStart = function() {
    var params_ = new TtsEventObserver_OnStart_Params();
    var builder = new codec.MessageV0Builder(
        kTtsEventObserver_OnStart_Name,
        codec.align(TtsEventObserver_OnStart_Params.encodedSize));
    builder.encodeStruct(TtsEventObserver_OnStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TtsEventObserverPtr.prototype.onTimepoint = function() {
    return TtsEventObserverProxy.prototype.onTimepoint
        .apply(this.ptr.getProxy(), arguments);
  };

  TtsEventObserverProxy.prototype.onTimepoint = function(charIndex) {
    var params_ = new TtsEventObserver_OnTimepoint_Params();
    params_.charIndex = charIndex;
    var builder = new codec.MessageV0Builder(
        kTtsEventObserver_OnTimepoint_Name,
        codec.align(TtsEventObserver_OnTimepoint_Params.encodedSize));
    builder.encodeStruct(TtsEventObserver_OnTimepoint_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TtsEventObserverPtr.prototype.onEnd = function() {
    return TtsEventObserverProxy.prototype.onEnd
        .apply(this.ptr.getProxy(), arguments);
  };

  TtsEventObserverProxy.prototype.onEnd = function() {
    var params_ = new TtsEventObserver_OnEnd_Params();
    var builder = new codec.MessageV0Builder(
        kTtsEventObserver_OnEnd_Name,
        codec.align(TtsEventObserver_OnEnd_Params.encodedSize));
    builder.encodeStruct(TtsEventObserver_OnEnd_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TtsEventObserverPtr.prototype.onError = function() {
    return TtsEventObserverProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  TtsEventObserverProxy.prototype.onError = function() {
    var params_ = new TtsEventObserver_OnError_Params();
    var builder = new codec.MessageV0Builder(
        kTtsEventObserver_OnError_Name,
        codec.align(TtsEventObserver_OnError_Params.encodedSize));
    builder.encodeStruct(TtsEventObserver_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TtsEventObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  TtsEventObserverStub.prototype.onStart = function() {
    return this.delegate_ && this.delegate_.onStart && this.delegate_.onStart();
  }
  TtsEventObserverStub.prototype.onTimepoint = function(charIndex) {
    return this.delegate_ && this.delegate_.onTimepoint && this.delegate_.onTimepoint(charIndex);
  }
  TtsEventObserverStub.prototype.onEnd = function() {
    return this.delegate_ && this.delegate_.onEnd && this.delegate_.onEnd();
  }
  TtsEventObserverStub.prototype.onError = function() {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError();
  }

  TtsEventObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTtsEventObserver_OnStart_Name:
      var params = reader.decodeStruct(TtsEventObserver_OnStart_Params);
      this.onStart();
      return true;
    case kTtsEventObserver_OnTimepoint_Name:
      var params = reader.decodeStruct(TtsEventObserver_OnTimepoint_Params);
      this.onTimepoint(params.charIndex);
      return true;
    case kTtsEventObserver_OnEnd_Name:
      var params = reader.decodeStruct(TtsEventObserver_OnEnd_Params);
      this.onEnd();
      return true;
    case kTtsEventObserver_OnError_Name:
      var params = reader.decodeStruct(TtsEventObserver_OnError_Params);
      this.onError();
      return true;
    default:
      return false;
    }
  };

  TtsEventObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateTtsEventObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTtsEventObserver_OnStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TtsEventObserver_OnStart_Params;
      break;
      case kTtsEventObserver_OnTimepoint_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TtsEventObserver_OnTimepoint_Params;
      break;
      case kTtsEventObserver_OnEnd_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TtsEventObserver_OnEnd_Params;
      break;
      case kTtsEventObserver_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TtsEventObserver_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTtsEventObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var TtsEventObserver = {
    name: 'chromeos.tts.mojom.TtsEventObserver',
    kVersion: 0,
    ptrClass: TtsEventObserverPtr,
    proxyClass: TtsEventObserverProxy,
    stubClass: TtsEventObserverStub,
    validateRequest: validateTtsEventObserverRequest,
    validateResponse: null,
  };
  TtsEventObserverStub.prototype.validator = validateTtsEventObserverRequest;
  TtsEventObserverProxy.prototype.validator = null;
  exports.AudioParameters = AudioParameters;
  exports.TtsService = TtsService;
  exports.TtsServicePtr = TtsServicePtr;
  exports.TtsServiceAssociatedPtr = TtsServiceAssociatedPtr;
  exports.GoogleTtsStream = GoogleTtsStream;
  exports.GoogleTtsStreamPtr = GoogleTtsStreamPtr;
  exports.GoogleTtsStreamAssociatedPtr = GoogleTtsStreamAssociatedPtr;
  exports.PlaybackTtsStream = PlaybackTtsStream;
  exports.PlaybackTtsStreamPtr = PlaybackTtsStreamPtr;
  exports.PlaybackTtsStreamAssociatedPtr = PlaybackTtsStreamAssociatedPtr;
  exports.TtsEventObserver = TtsEventObserver;
  exports.TtsEventObserverPtr = TtsEventObserverPtr;
  exports.TtsEventObserverAssociatedPtr = TtsEventObserverAssociatedPtr;
})();