// chromeos/services/tts/public/mojom/tts_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AudioStreamFactoryRemote as media_mojom_AudioStreamFactoryRemote,
  AudioStreamFactoryPendingReceiver as media_mojom_AudioStreamFactoryPendingReceiver
} from '../../../../../media/mojo/mojom/audio_stream_factory.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TtsServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.tts.mojom.TtsService', scope);
  }
}

/** @interface */
export class TtsServiceInterface {
  
  /**
   * @param { !GoogleTtsStreamPendingReceiver } receiver
   * @param { !media_mojom_AudioStreamFactoryRemote } streamFactory
   */

  bindGoogleTtsStream(receiver, streamFactory) {}
  
  /**
   * @param { !PlaybackTtsStreamPendingReceiver } receiver
   * @param { !media_mojom_AudioStreamFactoryRemote } streamFactory
   * @param { ?AudioParameters } desiredAudioParameters
   * @return {!Promise<{
        audioParameters: !AudioParameters,
   *  }>}
   */

  bindPlaybackTtsStream(receiver, streamFactory, desiredAudioParameters) {}
}

/**
 * @implements { TtsServiceInterface }
 */
export class TtsServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TtsServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TtsServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TtsServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !GoogleTtsStreamPendingReceiver } receiver
   * @param { !media_mojom_AudioStreamFactoryRemote } streamFactory
   */

  bindGoogleTtsStream(
      receiver,
      streamFactory) {
    this.proxy.sendMessage(
        0,
        TtsService_BindGoogleTtsStream_ParamsSpec.$,
        null,
        [
          receiver,
          streamFactory
        ],
        false);
  }

  
  /**
   * @param { !PlaybackTtsStreamPendingReceiver } receiver
   * @param { !media_mojom_AudioStreamFactoryRemote } streamFactory
   * @param { ?AudioParameters } desiredAudioParameters
   * @return {!Promise<{
        audioParameters: !AudioParameters,
   *  }>}
   */

  bindPlaybackTtsStream(
      receiver,
      streamFactory,
      desiredAudioParameters) {
    return this.proxy.sendMessage(
        1,
        TtsService_BindPlaybackTtsStream_ParamsSpec.$,
        TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
        [
          receiver,
          streamFactory,
          desiredAudioParameters
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TtsService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TtsServiceReceiver {
  /**
   * @param {!TtsServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TtsServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TtsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TtsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TtsService_BindGoogleTtsStream_ParamsSpec.$,
        null,
        impl.bindGoogleTtsStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TtsService_BindPlaybackTtsStream_ParamsSpec.$,
        TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
        impl.bindPlaybackTtsStream.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TtsService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.TtsService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TtsServiceRemote}
   */
  static getRemote() {
    let remote = new TtsServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TtsService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TtsServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TtsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TtsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindGoogleTtsStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TtsService_BindGoogleTtsStream_ParamsSpec.$,
        null,
        this.bindGoogleTtsStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindPlaybackTtsStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TtsService_BindPlaybackTtsStream_ParamsSpec.$,
        TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
        this.bindPlaybackTtsStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GoogleTtsStreamPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.tts.mojom.GoogleTtsStream', scope);
  }
}

/** @interface */
export class GoogleTtsStreamInterface {
  
  /**
   * @param { !string } voiceName
   * @param { !Array<!number> } voiceBytes
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  installVoice(voiceName, voiceBytes) {}
  
  /**
   * @param { !string } voiceName
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  selectVoice(voiceName) {}
  
  /**
   * @param { !Array<!number> } textJspb
   * @param { !Array<!number> } speakerParamsJspb
   * @return {!Promise<{
        eventObserver: !TtsEventObserverPendingReceiver,
   *  }>}
   */

  speak(textJspb, speakerParamsJspb) {}
  
  /**
   */

  stop() {}
  
  /**
   * @param { !number } volume
   */

  setVolume(volume) {}
  
  /**
   */

  pause() {}
  
  /**
   */

  resume() {}
}

/**
 * @implements { GoogleTtsStreamInterface }
 */
export class GoogleTtsStreamRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GoogleTtsStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GoogleTtsStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GoogleTtsStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } voiceName
   * @param { !Array<!number> } voiceBytes
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  installVoice(
      voiceName,
      voiceBytes) {
    return this.proxy.sendMessage(
        0,
        GoogleTtsStream_InstallVoice_ParamsSpec.$,
        GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
        [
          voiceName,
          voiceBytes
        ],
        false);
  }

  
  /**
   * @param { !string } voiceName
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  selectVoice(
      voiceName) {
    return this.proxy.sendMessage(
        1,
        GoogleTtsStream_SelectVoice_ParamsSpec.$,
        GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
        [
          voiceName
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } textJspb
   * @param { !Array<!number> } speakerParamsJspb
   * @return {!Promise<{
        eventObserver: !TtsEventObserverPendingReceiver,
   *  }>}
   */

  speak(
      textJspb,
      speakerParamsJspb) {
    return this.proxy.sendMessage(
        2,
        GoogleTtsStream_Speak_ParamsSpec.$,
        GoogleTtsStream_Speak_ResponseParamsSpec.$,
        [
          textJspb,
          speakerParamsJspb
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        3,
        GoogleTtsStream_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        4,
        GoogleTtsStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        5,
        GoogleTtsStream_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        6,
        GoogleTtsStream_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GoogleTtsStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GoogleTtsStreamReceiver {
  /**
   * @param {!GoogleTtsStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GoogleTtsStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GoogleTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GoogleTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GoogleTtsStream_InstallVoice_ParamsSpec.$,
        GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
        impl.installVoice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GoogleTtsStream_SelectVoice_ParamsSpec.$,
        GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
        impl.selectVoice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        GoogleTtsStream_Speak_ParamsSpec.$,
        GoogleTtsStream_Speak_ResponseParamsSpec.$,
        impl.speak.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        GoogleTtsStream_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        GoogleTtsStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        GoogleTtsStream_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        GoogleTtsStream_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GoogleTtsStream {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.GoogleTtsStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GoogleTtsStreamRemote}
   */
  static getRemote() {
    let remote = new GoogleTtsStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GoogleTtsStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GoogleTtsStreamCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GoogleTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GoogleTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installVoice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GoogleTtsStream_InstallVoice_ParamsSpec.$,
        GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
        this.installVoice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectVoice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GoogleTtsStream_SelectVoice_ParamsSpec.$,
        GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
        this.selectVoice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speak =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        GoogleTtsStream_Speak_ParamsSpec.$,
        GoogleTtsStream_Speak_ResponseParamsSpec.$,
        this.speak.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        GoogleTtsStream_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        GoogleTtsStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        GoogleTtsStream_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        GoogleTtsStream_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PlaybackTtsStreamPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.tts.mojom.PlaybackTtsStream', scope);
  }
}

/** @interface */
export class PlaybackTtsStreamInterface {
  
  /**
   * @return {!Promise<{
        eventObserver: !TtsEventObserverPendingReceiver,
   *  }>}
   */

  play() {}
  
  /**
   * @param { !Array<!number> } framesBuffer
   * @param { !number } charIndex
   * @param { !boolean } lastBuffer
   */

  sendAudioBuffer(framesBuffer, charIndex, lastBuffer) {}
  
  /**
   */

  stop() {}
  
  /**
   * @param { !number } volume
   */

  setVolume(volume) {}
  
  /**
   */

  pause() {}
  
  /**
   */

  resume() {}
}

/**
 * @implements { PlaybackTtsStreamInterface }
 */
export class PlaybackTtsStreamRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PlaybackTtsStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PlaybackTtsStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PlaybackTtsStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        eventObserver: !TtsEventObserverPendingReceiver,
   *  }>}
   */

  play() {
    return this.proxy.sendMessage(
        0,
        PlaybackTtsStream_Play_ParamsSpec.$,
        PlaybackTtsStream_Play_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } framesBuffer
   * @param { !number } charIndex
   * @param { !boolean } lastBuffer
   */

  sendAudioBuffer(
      framesBuffer,
      charIndex,
      lastBuffer) {
    this.proxy.sendMessage(
        1,
        PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
        null,
        [
          framesBuffer,
          charIndex,
          lastBuffer
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        2,
        PlaybackTtsStream_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        3,
        PlaybackTtsStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        4,
        PlaybackTtsStream_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        5,
        PlaybackTtsStream_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PlaybackTtsStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlaybackTtsStreamReceiver {
  /**
   * @param {!PlaybackTtsStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PlaybackTtsStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PlaybackTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlaybackTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PlaybackTtsStream_Play_ParamsSpec.$,
        PlaybackTtsStream_Play_ResponseParamsSpec.$,
        impl.play.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
        null,
        impl.sendAudioBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PlaybackTtsStream_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PlaybackTtsStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PlaybackTtsStream_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PlaybackTtsStream_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PlaybackTtsStream {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.PlaybackTtsStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PlaybackTtsStreamRemote}
   */
  static getRemote() {
    let remote = new PlaybackTtsStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PlaybackTtsStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlaybackTtsStreamCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PlaybackTtsStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlaybackTtsStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.play =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PlaybackTtsStream_Play_ParamsSpec.$,
        PlaybackTtsStream_Play_ResponseParamsSpec.$,
        this.play.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendAudioBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
        null,
        this.sendAudioBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PlaybackTtsStream_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PlaybackTtsStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PlaybackTtsStream_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PlaybackTtsStream_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TtsEventObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.tts.mojom.TtsEventObserver', scope);
  }
}

/** @interface */
export class TtsEventObserverInterface {
  
  /**
   */

  onStart() {}
  
  /**
   * @param { !number } charIndex
   */

  onTimepoint(charIndex) {}
  
  /**
   */

  onEnd() {}
  
  /**
   */

  onError() {}
}

/**
 * @implements { TtsEventObserverInterface }
 */
export class TtsEventObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TtsEventObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TtsEventObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TtsEventObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onStart() {
    this.proxy.sendMessage(
        0,
        TtsEventObserver_OnStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } charIndex
   */

  onTimepoint(
      charIndex) {
    this.proxy.sendMessage(
        1,
        TtsEventObserver_OnTimepoint_ParamsSpec.$,
        null,
        [
          charIndex
        ],
        false);
  }

  
  /**
   */

  onEnd() {
    this.proxy.sendMessage(
        2,
        TtsEventObserver_OnEnd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onError() {
    this.proxy.sendMessage(
        3,
        TtsEventObserver_OnError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TtsEventObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TtsEventObserverReceiver {
  /**
   * @param {!TtsEventObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TtsEventObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TtsEventObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TtsEventObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TtsEventObserver_OnStart_ParamsSpec.$,
        null,
        impl.onStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TtsEventObserver_OnTimepoint_ParamsSpec.$,
        null,
        impl.onTimepoint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TtsEventObserver_OnEnd_ParamsSpec.$,
        null,
        impl.onEnd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        TtsEventObserver_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TtsEventObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.tts.mojom.TtsEventObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TtsEventObserverRemote}
   */
  static getRemote() {
    let remote = new TtsEventObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TtsEventObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TtsEventObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TtsEventObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TtsEventObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TtsEventObserver_OnStart_ParamsSpec.$,
        null,
        this.onStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTimepoint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TtsEventObserver_OnTimepoint_ParamsSpec.$,
        null,
        this.onTimepoint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TtsEventObserver_OnEnd_ParamsSpec.$,
        null,
        this.onEnd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TtsEventObserver_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsService_BindGoogleTtsStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsService_BindPlaybackTtsStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsService_BindPlaybackTtsStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_InstallVoice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_InstallVoice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_SelectVoice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_SelectVoice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_Speak_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_Speak_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GoogleTtsStream_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_Play_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_Play_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_SendAudioBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackTtsStream_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsEventObserver_OnStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsEventObserver_OnTimepoint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsEventObserver_OnEnd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsEventObserver_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioParametersSpec.$,
    'AudioParameters',
    [
      mojo.internal.StructField(
        'sampleRate', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferSize', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioParameters {
  constructor() {
    /** @type { !number } */
    this.sampleRate;
    /** @type { !number } */
    this.bufferSize;
  }
}



mojo.internal.Struct(
    TtsService_BindGoogleTtsStream_ParamsSpec.$,
    'TtsService_BindGoogleTtsStream_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(GoogleTtsStreamPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamFactory', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioStreamFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TtsService_BindGoogleTtsStream_Params {
  constructor() {
    /** @type { !GoogleTtsStreamPendingReceiver } */
    this.receiver;
    /** @type { !media_mojom_AudioStreamFactoryRemote } */
    this.streamFactory;
  }
}



mojo.internal.Struct(
    TtsService_BindPlaybackTtsStream_ParamsSpec.$,
    'TtsService_BindPlaybackTtsStream_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(PlaybackTtsStreamPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamFactory', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioStreamFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'desiredAudioParameters', 16,
        0,
        AudioParametersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TtsService_BindPlaybackTtsStream_Params {
  constructor() {
    /** @type { !PlaybackTtsStreamPendingReceiver } */
    this.receiver;
    /** @type { !media_mojom_AudioStreamFactoryRemote } */
    this.streamFactory;
    /** @type { (AudioParameters|undefined) } */
    this.desiredAudioParameters;
  }
}



mojo.internal.Struct(
    TtsService_BindPlaybackTtsStream_ResponseParamsSpec.$,
    'TtsService_BindPlaybackTtsStream_ResponseParams',
    [
      mojo.internal.StructField(
        'audioParameters', 0,
        0,
        AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TtsService_BindPlaybackTtsStream_ResponseParams {
  constructor() {
    /** @type { !AudioParameters } */
    this.audioParameters;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_InstallVoice_ParamsSpec.$,
    'GoogleTtsStream_InstallVoice_Params',
    [
      mojo.internal.StructField(
        'voiceName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'voiceBytes', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GoogleTtsStream_InstallVoice_Params {
  constructor() {
    /** @type { !string } */
    this.voiceName;
    /** @type { !Array<!number> } */
    this.voiceBytes;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_InstallVoice_ResponseParamsSpec.$,
    'GoogleTtsStream_InstallVoice_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GoogleTtsStream_InstallVoice_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_SelectVoice_ParamsSpec.$,
    'GoogleTtsStream_SelectVoice_Params',
    [
      mojo.internal.StructField(
        'voiceName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GoogleTtsStream_SelectVoice_Params {
  constructor() {
    /** @type { !string } */
    this.voiceName;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_SelectVoice_ResponseParamsSpec.$,
    'GoogleTtsStream_SelectVoice_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GoogleTtsStream_SelectVoice_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_Speak_ParamsSpec.$,
    'GoogleTtsStream_Speak_Params',
    [
      mojo.internal.StructField(
        'textJspb', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'speakerParamsJspb', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GoogleTtsStream_Speak_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.textJspb;
    /** @type { !Array<!number> } */
    this.speakerParamsJspb;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_Speak_ResponseParamsSpec.$,
    'GoogleTtsStream_Speak_ResponseParams',
    [
      mojo.internal.StructField(
        'eventObserver', 0,
        0,
        mojo.internal.InterfaceRequest(TtsEventObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GoogleTtsStream_Speak_ResponseParams {
  constructor() {
    /** @type { !TtsEventObserverPendingReceiver } */
    this.eventObserver;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_Stop_ParamsSpec.$,
    'GoogleTtsStream_Stop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class GoogleTtsStream_Stop_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    GoogleTtsStream_SetVolume_ParamsSpec.$,
    'GoogleTtsStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GoogleTtsStream_SetVolume_Params {
  constructor() {
    /** @type { !number } */
    this.volume;
  }
}



mojo.internal.Struct(
    GoogleTtsStream_Pause_ParamsSpec.$,
    'GoogleTtsStream_Pause_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class GoogleTtsStream_Pause_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    GoogleTtsStream_Resume_ParamsSpec.$,
    'GoogleTtsStream_Resume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class GoogleTtsStream_Resume_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_Play_ParamsSpec.$,
    'PlaybackTtsStream_Play_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackTtsStream_Play_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_Play_ResponseParamsSpec.$,
    'PlaybackTtsStream_Play_ResponseParams',
    [
      mojo.internal.StructField(
        'eventObserver', 0,
        0,
        mojo.internal.InterfaceRequest(TtsEventObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlaybackTtsStream_Play_ResponseParams {
  constructor() {
    /** @type { !TtsEventObserverPendingReceiver } */
    this.eventObserver;
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_SendAudioBuffer_ParamsSpec.$,
    'PlaybackTtsStream_SendAudioBuffer_Params',
    [
      mojo.internal.StructField(
        'framesBuffer', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'charIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastBuffer', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PlaybackTtsStream_SendAudioBuffer_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.framesBuffer;
    /** @type { !number } */
    this.charIndex;
    /** @type { !boolean } */
    this.lastBuffer;
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_Stop_ParamsSpec.$,
    'PlaybackTtsStream_Stop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackTtsStream_Stop_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_SetVolume_ParamsSpec.$,
    'PlaybackTtsStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlaybackTtsStream_SetVolume_Params {
  constructor() {
    /** @type { !number } */
    this.volume;
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_Pause_ParamsSpec.$,
    'PlaybackTtsStream_Pause_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackTtsStream_Pause_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackTtsStream_Resume_ParamsSpec.$,
    'PlaybackTtsStream_Resume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackTtsStream_Resume_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TtsEventObserver_OnStart_ParamsSpec.$,
    'TtsEventObserver_OnStart_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TtsEventObserver_OnStart_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TtsEventObserver_OnTimepoint_ParamsSpec.$,
    'TtsEventObserver_OnTimepoint_Params',
    [
      mojo.internal.StructField(
        'charIndex', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TtsEventObserver_OnTimepoint_Params {
  constructor() {
    /** @type { !number } */
    this.charIndex;
  }
}



mojo.internal.Struct(
    TtsEventObserver_OnEnd_ParamsSpec.$,
    'TtsEventObserver_OnEnd_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TtsEventObserver_OnEnd_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TtsEventObserver_OnError_ParamsSpec.$,
    'TtsEventObserver_OnError_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TtsEventObserver_OnError_Params {
  constructor() {
  }
}

