// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{ContainerSpec as tabsApi_mojom_ContainerSpec,TabSpec as tabsApi_mojom_TabSpec}from"./tab_strip_api_data_model.mojom-webui.js";import{OnCollectionCreatedEventSpec as tabsApi_mojom_OnCollectionCreatedEventSpec,OnDataChangedEventSpec as tabsApi_mojom_OnDataChangedEventSpec,OnNodeMovedEventSpec as tabsApi_mojom_OnNodeMovedEventSpec,OnTabsClosedEventSpec as tabsApi_mojom_OnTabsClosedEventSpec,OnTabsCreatedEventSpec as tabsApi_mojom_OnTabsCreatedEventSpec}from"./tab_strip_api_events.mojom-webui.js";import{NodeIdSpec as tabsApi_mojom_NodeIdSpec,PositionSpec as tabsApi_mojom_PositionSpec}from"./tab_strip_api_types.mojom-webui.js";import{EmptySpec as mojoBase_mojom_EmptySpec}from"//resources/mojo/mojo/public/mojom/base/empty.mojom-webui.js";import{ErrorSpec as mojoBase_mojom_ErrorSpec}from"//resources/mojo/mojo/public/mojom/base/error.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export class TabStripServicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tabs_api.mojom.TabStripService",scope)}}export class TabStripServiceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(TabStripServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getTabs(){return this.proxy.sendMessage(0,TabStripService_GetTabs_ParamsSpec.$,TabStripService_GetTabs_ResponseParamsSpec.$,[],true)}getTab(id){return this.proxy.sendMessage(1,TabStripService_GetTab_ParamsSpec.$,TabStripService_GetTab_ResponseParamsSpec.$,[id],true)}createTabAt(pos,url){return this.proxy.sendMessage(2,TabStripService_CreateTabAt_ParamsSpec.$,TabStripService_CreateTabAt_ResponseParamsSpec.$,[pos,url],true)}closeTabs(id){return this.proxy.sendMessage(3,TabStripService_CloseTabs_ParamsSpec.$,TabStripService_CloseTabs_ResponseParamsSpec.$,[id],true)}activateTab(id){return this.proxy.sendMessage(4,TabStripService_ActivateTab_ParamsSpec.$,TabStripService_ActivateTab_ResponseParamsSpec.$,[id],true)}setSelectedTabs(selection,tabToActivate){return this.proxy.sendMessage(5,TabStripService_SetSelectedTabs_ParamsSpec.$,TabStripService_SetSelectedTabs_ResponseParamsSpec.$,[selection,tabToActivate],true)}moveNode(id,position){return this.proxy.sendMessage(6,TabStripService_MoveNode_ParamsSpec.$,TabStripService_MoveNode_ResponseParamsSpec.$,[id,position],true)}}export class TabStripServiceReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabStripServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,TabStripService_GetTabs_ParamsSpec.$,TabStripService_GetTabs_ResponseParamsSpec.$,impl.getTabs.bind(impl),true);this.helper_internal_.registerHandler(1,TabStripService_GetTab_ParamsSpec.$,TabStripService_GetTab_ResponseParamsSpec.$,impl.getTab.bind(impl),true);this.helper_internal_.registerHandler(2,TabStripService_CreateTabAt_ParamsSpec.$,TabStripService_CreateTabAt_ResponseParamsSpec.$,impl.createTabAt.bind(impl),true);this.helper_internal_.registerHandler(3,TabStripService_CloseTabs_ParamsSpec.$,TabStripService_CloseTabs_ResponseParamsSpec.$,impl.closeTabs.bind(impl),true);this.helper_internal_.registerHandler(4,TabStripService_ActivateTab_ParamsSpec.$,TabStripService_ActivateTab_ResponseParamsSpec.$,impl.activateTab.bind(impl),true);this.helper_internal_.registerHandler(5,TabStripService_SetSelectedTabs_ParamsSpec.$,TabStripService_SetSelectedTabs_ResponseParamsSpec.$,impl.setSelectedTabs.bind(impl),true);this.helper_internal_.registerHandler(6,TabStripService_MoveNode_ParamsSpec.$,TabStripService_MoveNode_ResponseParamsSpec.$,impl.moveNode.bind(impl),true);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class TabStripService{static get $interfaceName(){return"tabs_api.mojom.TabStripService"}static getRemote(){let remote=new TabStripServiceRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class TabStripServiceCallbackRouter{helper_internal_;$;router_;getTabs;getTab;createTabAt;closeTabs;activateTab;setSelectedTabs;moveNode;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabStripServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getTabs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,TabStripService_GetTabs_ParamsSpec.$,TabStripService_GetTabs_ResponseParamsSpec.$,this.getTabs.createReceiverHandler(true),true);this.getTab=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,TabStripService_GetTab_ParamsSpec.$,TabStripService_GetTab_ResponseParamsSpec.$,this.getTab.createReceiverHandler(true),true);this.createTabAt=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,TabStripService_CreateTabAt_ParamsSpec.$,TabStripService_CreateTabAt_ResponseParamsSpec.$,this.createTabAt.createReceiverHandler(true),true);this.closeTabs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,TabStripService_CloseTabs_ParamsSpec.$,TabStripService_CloseTabs_ResponseParamsSpec.$,this.closeTabs.createReceiverHandler(true),true);this.activateTab=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,TabStripService_ActivateTab_ParamsSpec.$,TabStripService_ActivateTab_ResponseParamsSpec.$,this.activateTab.createReceiverHandler(true),true);this.setSelectedTabs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,TabStripService_SetSelectedTabs_ParamsSpec.$,TabStripService_SetSelectedTabs_ResponseParamsSpec.$,this.setSelectedTabs.createReceiverHandler(true),true);this.moveNode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,TabStripService_MoveNode_ParamsSpec.$,TabStripService_MoveNode_ResponseParamsSpec.$,this.moveNode.createReceiverHandler(true),true);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class TabsObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tabs_api.mojom.TabsObserver",scope)}}export class TabsObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(TabsObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onTabEvents(events){this.proxy.sendMessage(0,TabsObserver_OnTabEvents_ParamsSpec.$,null,[events],false)}}export class TabsObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabsObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,TabsObserver_OnTabEvents_ParamsSpec.$,null,impl.onTabEvents.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class TabsObserver{static get $interfaceName(){return"tabs_api.mojom.TabsObserver"}static getRemote(){let remote=new TabsObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class TabsObserverCallbackRouter{helper_internal_;$;router_;onTabEvents;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabsObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onTabEvents=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,TabsObserver_OnTabEvents_ParamsSpec.$,null,this.onTabEvents.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const TabsSnapshotSpec={$:{}};export const TabStripService_GetTabs_ParamsSpec={$:{}};export const TabStripService_GetTabs_ResponseParamsSpec={$:{}};export const TabStripService_GetTab_ParamsSpec={$:{}};export const TabStripService_GetTab_ResponseParamsSpec={$:{}};export const TabStripService_CreateTabAt_ParamsSpec={$:{}};export const TabStripService_CreateTabAt_ResponseParamsSpec={$:{}};export const TabStripService_CloseTabs_ParamsSpec={$:{}};export const TabStripService_CloseTabs_ResponseParamsSpec={$:{}};export const TabStripService_ActivateTab_ParamsSpec={$:{}};export const TabStripService_ActivateTab_ResponseParamsSpec={$:{}};export const TabStripService_SetSelectedTabs_ParamsSpec={$:{}};export const TabStripService_SetSelectedTabs_ResponseParamsSpec={$:{}};export const TabStripService_MoveNode_ParamsSpec={$:{}};export const TabStripService_MoveNode_ResponseParamsSpec={$:{}};export const TabsObserver_OnTabEvents_ParamsSpec={$:{}};export const TabsEventSpec={$:{}};export const TabStripService_GetTabs_ResponseParam_ResultSpec={$:{}};export const TabStripService_GetTab_ResponseParam_ResultSpec={$:{}};export const TabStripService_CreateTabAt_ResponseParam_ResultSpec={$:{}};export const TabStripService_CloseTabs_ResponseParam_ResultSpec={$:{}};export const TabStripService_ActivateTab_ResponseParam_ResultSpec={$:{}};export const TabStripService_SetSelectedTabs_ResponseParam_ResultSpec={$:{}};export const TabStripService_MoveNode_ResponseParam_ResultSpec={$:{}};mojo.internal.Struct(TabsSnapshotSpec.$,"TabsSnapshot",[mojo.internal.StructField("tabStrip",0,0,tabsApi_mojom_ContainerSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("stream",8,0,mojo.internal.AssociatedInterfaceRequest(TabsObserverPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_GetTabs_ParamsSpec.$,"TabStripService_GetTabs_Params",[],[[0,8]]);mojo.internal.Struct(TabStripService_GetTabs_ResponseParamsSpec.$,"TabStripService_GetTabs_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_GetTabs_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_GetTab_ParamsSpec.$,"TabStripService_GetTab_Params",[mojo.internal.StructField("id",0,0,tabsApi_mojom_NodeIdSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TabStripService_GetTab_ResponseParamsSpec.$,"TabStripService_GetTab_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_GetTab_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_CreateTabAt_ParamsSpec.$,"TabStripService_CreateTabAt_Params",[mojo.internal.StructField("pos",0,0,tabsApi_mojom_PositionSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_CreateTabAt_ResponseParamsSpec.$,"TabStripService_CreateTabAt_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_CreateTabAt_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_CloseTabs_ParamsSpec.$,"TabStripService_CloseTabs_Params",[mojo.internal.StructField("id",0,0,mojo.internal.Array(tabsApi_mojom_NodeIdSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TabStripService_CloseTabs_ResponseParamsSpec.$,"TabStripService_CloseTabs_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_CloseTabs_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_ActivateTab_ParamsSpec.$,"TabStripService_ActivateTab_Params",[mojo.internal.StructField("id",0,0,tabsApi_mojom_NodeIdSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TabStripService_ActivateTab_ResponseParamsSpec.$,"TabStripService_ActivateTab_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_ActivateTab_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_SetSelectedTabs_ParamsSpec.$,"TabStripService_SetSelectedTabs_Params",[mojo.internal.StructField("selection",0,0,mojo.internal.Array(tabsApi_mojom_NodeIdSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("tabToActivate",8,0,tabsApi_mojom_NodeIdSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_SetSelectedTabs_ResponseParamsSpec.$,"TabStripService_SetSelectedTabs_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_SetSelectedTabs_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_MoveNode_ParamsSpec.$,"TabStripService_MoveNode_Params",[mojo.internal.StructField("id",0,0,tabsApi_mojom_NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("position",8,0,tabsApi_mojom_PositionSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripService_MoveNode_ResponseParamsSpec.$,"TabStripService_MoveNode_ResponseParams",[mojo.internal.StructField("result",0,0,TabStripService_MoveNode_ResponseParam_ResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabsObserver_OnTabEvents_ParamsSpec.$,"TabsObserver_OnTabEvents_Params",[mojo.internal.StructField("events",0,0,mojo.internal.Array(TabsEventSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(TabsEventSpec.$,"TabsEvent",{tabsCreatedEvent:{ordinal:0,type:tabsApi_mojom_OnTabsCreatedEventSpec.$},tabsClosedEvent:{ordinal:1,type:tabsApi_mojom_OnTabsClosedEventSpec.$},nodeMovedEvent:{ordinal:2,type:tabsApi_mojom_OnNodeMovedEventSpec.$},dataChangedEvent:{ordinal:3,type:tabsApi_mojom_OnDataChangedEventSpec.$},collectionCreatedEvent:{ordinal:4,type:tabsApi_mojom_OnCollectionCreatedEventSpec.$}});export var TabsEventFieldTags;(function(TabsEventFieldTags){TabsEventFieldTags[TabsEventFieldTags["TABS_CREATED_EVENT"]=0]="TABS_CREATED_EVENT";TabsEventFieldTags[TabsEventFieldTags["TABS_CLOSED_EVENT"]=1]="TABS_CLOSED_EVENT";TabsEventFieldTags[TabsEventFieldTags["NODE_MOVED_EVENT"]=2]="NODE_MOVED_EVENT";TabsEventFieldTags[TabsEventFieldTags["DATA_CHANGED_EVENT"]=3]="DATA_CHANGED_EVENT";TabsEventFieldTags[TabsEventFieldTags["COLLECTION_CREATED_EVENT"]=4]="COLLECTION_CREATED_EVENT"})(TabsEventFieldTags||(TabsEventFieldTags={}));export function whichTabsEvent(u){if(u.tabsCreatedEvent!==null&&u.tabsCreatedEvent!==undefined){return TabsEventFieldTags.TABS_CREATED_EVENT}if(u.tabsClosedEvent!==null&&u.tabsClosedEvent!==undefined){return TabsEventFieldTags.TABS_CLOSED_EVENT}if(u.nodeMovedEvent!==null&&u.nodeMovedEvent!==undefined){return TabsEventFieldTags.NODE_MOVED_EVENT}if(u.dataChangedEvent!==null&&u.dataChangedEvent!==undefined){return TabsEventFieldTags.DATA_CHANGED_EVENT}if(u.collectionCreatedEvent!==null&&u.collectionCreatedEvent!==undefined){return TabsEventFieldTags.COLLECTION_CREATED_EVENT}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_GetTabs_ResponseParam_ResultSpec.$,"TabStripService_GetTabs_ResponseParam_Result",{success:{ordinal:0,type:TabsSnapshotSpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_GetTabs_ResponseParam_ResultFieldTags;(function(TabStripService_GetTabs_ResponseParam_ResultFieldTags){TabStripService_GetTabs_ResponseParam_ResultFieldTags[TabStripService_GetTabs_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_GetTabs_ResponseParam_ResultFieldTags[TabStripService_GetTabs_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_GetTabs_ResponseParam_ResultFieldTags||(TabStripService_GetTabs_ResponseParam_ResultFieldTags={}));export function whichTabStripService_GetTabs_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_GetTabs_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_GetTabs_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_GetTab_ResponseParam_ResultSpec.$,"TabStripService_GetTab_ResponseParam_Result",{success:{ordinal:0,type:tabsApi_mojom_TabSpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_GetTab_ResponseParam_ResultFieldTags;(function(TabStripService_GetTab_ResponseParam_ResultFieldTags){TabStripService_GetTab_ResponseParam_ResultFieldTags[TabStripService_GetTab_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_GetTab_ResponseParam_ResultFieldTags[TabStripService_GetTab_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_GetTab_ResponseParam_ResultFieldTags||(TabStripService_GetTab_ResponseParam_ResultFieldTags={}));export function whichTabStripService_GetTab_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_GetTab_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_GetTab_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_CreateTabAt_ResponseParam_ResultSpec.$,"TabStripService_CreateTabAt_ResponseParam_Result",{success:{ordinal:0,type:tabsApi_mojom_TabSpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_CreateTabAt_ResponseParam_ResultFieldTags;(function(TabStripService_CreateTabAt_ResponseParam_ResultFieldTags){TabStripService_CreateTabAt_ResponseParam_ResultFieldTags[TabStripService_CreateTabAt_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_CreateTabAt_ResponseParam_ResultFieldTags[TabStripService_CreateTabAt_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_CreateTabAt_ResponseParam_ResultFieldTags||(TabStripService_CreateTabAt_ResponseParam_ResultFieldTags={}));export function whichTabStripService_CreateTabAt_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_CreateTabAt_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_CreateTabAt_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_CloseTabs_ResponseParam_ResultSpec.$,"TabStripService_CloseTabs_ResponseParam_Result",{success:{ordinal:0,type:mojoBase_mojom_EmptySpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_CloseTabs_ResponseParam_ResultFieldTags;(function(TabStripService_CloseTabs_ResponseParam_ResultFieldTags){TabStripService_CloseTabs_ResponseParam_ResultFieldTags[TabStripService_CloseTabs_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_CloseTabs_ResponseParam_ResultFieldTags[TabStripService_CloseTabs_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_CloseTabs_ResponseParam_ResultFieldTags||(TabStripService_CloseTabs_ResponseParam_ResultFieldTags={}));export function whichTabStripService_CloseTabs_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_CloseTabs_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_CloseTabs_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_ActivateTab_ResponseParam_ResultSpec.$,"TabStripService_ActivateTab_ResponseParam_Result",{success:{ordinal:0,type:mojoBase_mojom_EmptySpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_ActivateTab_ResponseParam_ResultFieldTags;(function(TabStripService_ActivateTab_ResponseParam_ResultFieldTags){TabStripService_ActivateTab_ResponseParam_ResultFieldTags[TabStripService_ActivateTab_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_ActivateTab_ResponseParam_ResultFieldTags[TabStripService_ActivateTab_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_ActivateTab_ResponseParam_ResultFieldTags||(TabStripService_ActivateTab_ResponseParam_ResultFieldTags={}));export function whichTabStripService_ActivateTab_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_ActivateTab_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_ActivateTab_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_SetSelectedTabs_ResponseParam_ResultSpec.$,"TabStripService_SetSelectedTabs_ResponseParam_Result",{success:{ordinal:0,type:mojoBase_mojom_EmptySpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags;(function(TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags){TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags[TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags[TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags||(TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags={}));export function whichTabStripService_SetSelectedTabs_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabStripService_MoveNode_ResponseParam_ResultSpec.$,"TabStripService_MoveNode_ResponseParam_Result",{success:{ordinal:0,type:mojoBase_mojom_EmptySpec.$},failure:{ordinal:1,type:mojoBase_mojom_ErrorSpec.$}});export var TabStripService_MoveNode_ResponseParam_ResultFieldTags;(function(TabStripService_MoveNode_ResponseParam_ResultFieldTags){TabStripService_MoveNode_ResponseParam_ResultFieldTags[TabStripService_MoveNode_ResponseParam_ResultFieldTags["SUCCESS"]=0]="SUCCESS";TabStripService_MoveNode_ResponseParam_ResultFieldTags[TabStripService_MoveNode_ResponseParam_ResultFieldTags["FAILURE"]=1]="FAILURE"})(TabStripService_MoveNode_ResponseParam_ResultFieldTags||(TabStripService_MoveNode_ResponseParam_ResultFieldTags={}));export function whichTabStripService_MoveNode_ResponseParam_Result(u){if(u.success!==null&&u.success!==undefined){return TabStripService_MoveNode_ResponseParam_ResultFieldTags.SUCCESS}if(u.failure!==null&&u.failure!==undefined){return TabStripService_MoveNode_ResponseParam_ResultFieldTags.FAILURE}throw new Error("no union field has been set, this is an illegal state")}