// components/chromeos_camera/common/dmabuf.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/chromeos_camera/common/dmabuf.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeosCamera.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', '../../../media/mojo/mojom/media_types.mojom.js');
  }



  function DmaBufPlane(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DmaBufPlane.prototype.initDefaults_ = function() {
    this.fdHandle = null;
    this.stride = 0;
    this.offset = 0;
    this.size = 0;
  };
  DmaBufPlane.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DmaBufPlane.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DmaBufPlane.fdHandle
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  DmaBufPlane.encodedSize = codec.kStructHeaderSize + 16;

  DmaBufPlane.decode = function(decoder) {
    var packed;
    var val = new DmaBufPlane();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fdHandle =
        decoder.decodeStruct(codec.Handle);
    val.stride =
        decoder.decodeStruct(codec.Int32);
    val.offset =
        decoder.decodeStruct(codec.Uint32);
    val.size =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  DmaBufPlane.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DmaBufPlane.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.fdHandle);
    encoder.encodeStruct(codec.Int32, val.stride);
    encoder.encodeStruct(codec.Uint32, val.offset);
    encoder.encodeStruct(codec.Uint32, val.size);
  };
  function DmaBufVideoFrame(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DmaBufVideoFrame.prototype.initDefaults_ = function() {
    this.format = 0;
    this.codedWidth = 0;
    this.codedHeight = 0;
    this.hasModifier = false;
    this.planes = null;
    this.modifier = 0;
  };
  DmaBufVideoFrame.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DmaBufVideoFrame.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 1, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DmaBufVideoFrame.format
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.VideoPixelFormat);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DmaBufVideoFrame.planes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(DmaBufPlane), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  DmaBufVideoFrame.encodedSize = codec.kStructHeaderSize + 32;

  DmaBufVideoFrame.decode = function(decoder) {
    var packed;
    var val = new DmaBufVideoFrame();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.format =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoPixelFormat));
    val.codedWidth =
        decoder.decodeStruct(codec.Uint32);
    val.codedHeight =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.hasModifier = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.planes =
        decoder.decodeArrayPointer(new codec.PointerTo(DmaBufPlane));
    if (version >= 1) {
      val.modifier =
          decoder.decodeStruct(codec.Uint64);
    } else {
      val.modifier = null;
    }
    return val;
  };

  DmaBufVideoFrame.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DmaBufVideoFrame.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.Int32, val.format);
    encoder.encodeStruct(codec.Uint32, val.codedWidth);
    encoder.encodeStruct(codec.Uint32, val.codedHeight);
    packed = 0;
    packed |= (val.hasModifier & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(DmaBufPlane), val.planes);
    encoder.encodeStruct(codec.Uint64, val.modifier);
  };
  exports.DmaBufPlane = DmaBufPlane;
  exports.DmaBufVideoFrame = DmaBufVideoFrame;
})();