// components/chromeos_camera/common/jpeg_encode_accelerator.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeosCamera.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeosCamera.mojom.EncodeStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeosCamera.mojom.EncodeStatus = {
  
  ENCODE_OK: 0,
  HW_JPEG_ENCODE_NOT_SUPPORTED: 1,
  THREAD_CREATION_FAILED: 2,
  INVALID_ARGUMENT: 3,
  INACCESSIBLE_OUTPUT_BUFFER: 4,
  PARSE_IMAGE_FAILED: 5,
  PLATFORM_FAILURE: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAcceleratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeosCamera.mojom.JpegEncodeAccelerator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeosCamera.mojom.JpegEncodeAcceleratorInterface }
 */
chromeosCamera.mojom.JpegEncodeAcceleratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeosCamera.mojom.JpegEncodeAcceleratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeosCamera.mojom.JpegEncodeAcceleratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeosCamera.mojom.JpegEncodeAcceleratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize() {
    return this.proxy.sendMessage(
        0,
        chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } taskId
   * @param { !MojoHandle } inputFd
   * @param { !number } inputBufferSize
   * @param { !number } codedSizeWidth
   * @param { !number } codedSizeHeight
   * @param { !MojoHandle } exifFd
   * @param { !number } exifBufferSize
   * @param { !MojoHandle } outputFd
   * @param { !number } outputBufferSize
   * @return {!Promise<{
        taskId: !number,
        encodedBufferSize: !number,
        status: !chromeosCamera.mojom.EncodeStatus,
   *  }>}
   */

  encodeWithFD(
      taskId,
      inputFd,
      inputBufferSize,
      codedSizeWidth,
      codedSizeHeight,
      exifFd,
      exifBufferSize,
      outputFd,
      outputBufferSize) {
    return this.proxy.sendMessage(
        1,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
        [
          taskId,
          inputFd,
          inputBufferSize,
          codedSizeWidth,
          codedSizeHeight,
          exifFd,
          exifBufferSize,
          outputFd,
          outputBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } taskId
   * @param { !number } inputFormat
   * @param { !Array<!chromeosCamera.mojom.DmaBufPlane> } inputPlanes
   * @param { !Array<!chromeosCamera.mojom.DmaBufPlane> } outputPlanes
   * @param { !MojoHandle } exifHandle
   * @param { !number } exifBufferSize
   * @param { !number } codedSizeWidth
   * @param { !number } codedSizeHeight
   * @param { !number } quality
   * @param { !boolean } hasInputModifier
   * @param { !bigint } inputModifier
   * @return {!Promise<{
        encodedBufferSize: !number,
        status: !chromeosCamera.mojom.EncodeStatus,
   *  }>}
   */

  encodeWithDmaBuf(
      taskId,
      inputFormat,
      inputPlanes,
      outputPlanes,
      exifHandle,
      exifBufferSize,
      codedSizeWidth,
      codedSizeHeight,
      quality,
      hasInputModifier,
      inputModifier) {
    return this.proxy.sendMessage(
        2,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
        [
          taskId,
          inputFormat,
          inputPlanes,
          outputPlanes,
          exifHandle,
          exifBufferSize,
          codedSizeWidth,
          codedSizeHeight,
          quality,
          hasInputModifier,
          inputModifier
        ],
        false);
  }
};

/**
 * An object which receives request messages for the JpegEncodeAccelerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeosCamera.mojom.JpegEncodeAcceleratorReceiver = class {
  /**
   * @param {!chromeosCamera.mojom.JpegEncodeAcceleratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeosCamera.mojom.JpegEncodeAcceleratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeosCamera.mojom.JpegEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeosCamera.mojom.JpegEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
        impl.encodeWithFD.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
        impl.encodeWithDmaBuf.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos_camera.mojom.JpegEncodeAccelerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeosCamera.mojom.JpegEncodeAcceleratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeosCamera.mojom.JpegEncodeAcceleratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the JpegEncodeAccelerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeosCamera.mojom.JpegEncodeAcceleratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeosCamera.mojom.JpegEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeosCamera.mojom.JpegEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encodeWithFD =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
        this.encodeWithFD.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encodeWithDmaBuf =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
        chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
        this.encodeWithDmaBuf.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ParamsSpec.$,
    'JpegEncodeAccelerator_Initialize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
    'JpegEncodeAccelerator_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeosCamera.mojom.JpegEncodeAccelerator_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithFD_Params',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputFd', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputBufferSize', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSizeWidth', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSizeHeight', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exifFd', 20,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exifBufferSize', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputFd', 28,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputBufferSize', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_Params = class {
  constructor() {
    /** @export { !number } */
    this.taskId;
    /** @export { !MojoHandle } */
    this.inputFd;
    /** @export { !number } */
    this.inputBufferSize;
    /** @export { !number } */
    this.codedSizeWidth;
    /** @export { !number } */
    this.codedSizeHeight;
    /** @export { !MojoHandle } */
    this.exifFd;
    /** @export { !number } */
    this.exifBufferSize;
    /** @export { !MojoHandle } */
    this.outputFd;
    /** @export { !number } */
    this.outputBufferSize;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithFD_ResponseParams',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodedBufferSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        chromeosCamera.mojom.EncodeStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithFD_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.taskId;
    /** @export { !number } */
    this.encodedBufferSize;
    /** @export { !chromeosCamera.mojom.EncodeStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithDmaBuf_Params',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputFormat', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputPlanes', 8,
        0,
        mojo.internal.Array(chromeosCamera.mojom.DmaBufPlaneSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputPlanes', 16,
        0,
        mojo.internal.Array(chromeosCamera.mojom.DmaBufPlaneSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exifHandle', 24,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exifBufferSize', 28,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSizeWidth', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSizeHeight', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quality', 40,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasInputModifier', 44,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputModifier', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],[1, 64],]);





/** @record */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_Params = class {
  constructor() {
    /** @export { !number } */
    this.taskId;
    /** @export { !number } */
    this.inputFormat;
    /** @export { !Array<!chromeosCamera.mojom.DmaBufPlane> } */
    this.inputPlanes;
    /** @export { !Array<!chromeosCamera.mojom.DmaBufPlane> } */
    this.outputPlanes;
    /** @export { !MojoHandle } */
    this.exifHandle;
    /** @export { !number } */
    this.exifBufferSize;
    /** @export { !number } */
    this.codedSizeWidth;
    /** @export { !number } */
    this.codedSizeHeight;
    /** @export { !number } */
    this.quality;
    /** @export { !boolean } */
    this.hasInputModifier;
    /** @export { !bigint } */
    this.inputModifier;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams',
    [
      mojo.internal.StructField(
        'encodedBufferSize', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 4,
        0,
        chromeosCamera.mojom.EncodeStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeosCamera.mojom.JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.encodedBufferSize;
    /** @export { !chromeosCamera.mojom.EncodeStatus } */
    this.status;
  }
};

