// components/chromeos_camera/common/jpeg_encode_accelerator.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/chromeos_camera/common/jpeg_encode_accelerator.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeosCamera.mojom');
  var dmabuf$ =
      mojo.internal.exposeNamespace('chromeosCamera.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/chromeos_camera/common/dmabuf.mojom', 'dmabuf.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', '../../../media/mojo/mojom/media_types.mojom.js');
  }


  var EncodeStatus = {};
  EncodeStatus.ENCODE_OK = 0;
  EncodeStatus.HW_JPEG_ENCODE_NOT_SUPPORTED = 1;
  EncodeStatus.THREAD_CREATION_FAILED = 2;
  EncodeStatus.INVALID_ARGUMENT = 3;
  EncodeStatus.INACCESSIBLE_OUTPUT_BUFFER = 4;
  EncodeStatus.PARSE_IMAGE_FAILED = 5;
  EncodeStatus.PLATFORM_FAILURE = 6;
  EncodeStatus.MIN_VALUE = 0;
  EncodeStatus.MAX_VALUE = 6;

  EncodeStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  EncodeStatus.toKnownEnumValue = function(value) {
    return value;
  };

  EncodeStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function JpegEncodeAccelerator_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JpegEncodeAccelerator_Initialize_Params.prototype.initDefaults_ = function() {
  };
  JpegEncodeAccelerator_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JpegEncodeAccelerator_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JpegEncodeAccelerator_Initialize_Params.encodedSize = codec.kStructHeaderSize + 0;

  JpegEncodeAccelerator_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new JpegEncodeAccelerator_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  JpegEncodeAccelerator_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JpegEncodeAccelerator_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function JpegEncodeAccelerator_Initialize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JpegEncodeAccelerator_Initialize_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  JpegEncodeAccelerator_Initialize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JpegEncodeAccelerator_Initialize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  JpegEncodeAccelerator_Initialize_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  JpegEncodeAccelerator_Initialize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new JpegEncodeAccelerator_Initialize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  JpegEncodeAccelerator_Initialize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JpegEncodeAccelerator_Initialize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function JpegEncodeAccelerator_EncodeWithFD_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JpegEncodeAccelerator_EncodeWithFD_Params.prototype.initDefaults_ = function() {
    this.taskId = 0;
    this.inputFd = null;
    this.inputBufferSize = 0;
    this.codedSizeWidth = 0;
    this.codedSizeHeight = 0;
    this.exifFd = null;
    this.exifBufferSize = 0;
    this.outputFd = null;
    this.outputBufferSize = 0;
  };
  JpegEncodeAccelerator_EncodeWithFD_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JpegEncodeAccelerator_EncodeWithFD_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate JpegEncodeAccelerator_EncodeWithFD_Params.inputFd
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;





    // validate JpegEncodeAccelerator_EncodeWithFD_Params.exifFd
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 20, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate JpegEncodeAccelerator_EncodeWithFD_Params.outputFd
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 28, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  JpegEncodeAccelerator_EncodeWithFD_Params.encodedSize = codec.kStructHeaderSize + 40;

  JpegEncodeAccelerator_EncodeWithFD_Params.decode = function(decoder) {
    var packed;
    var val = new JpegEncodeAccelerator_EncodeWithFD_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.taskId =
        decoder.decodeStruct(codec.Int32);
    val.inputFd =
        decoder.decodeStruct(codec.Handle);
    val.inputBufferSize =
        decoder.decodeStruct(codec.Uint32);
    val.codedSizeWidth =
        decoder.decodeStruct(codec.Int32);
    val.codedSizeHeight =
        decoder.decodeStruct(codec.Int32);
    val.exifFd =
        decoder.decodeStruct(codec.Handle);
    val.exifBufferSize =
        decoder.decodeStruct(codec.Uint32);
    val.outputFd =
        decoder.decodeStruct(codec.Handle);
    val.outputBufferSize =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  JpegEncodeAccelerator_EncodeWithFD_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JpegEncodeAccelerator_EncodeWithFD_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.taskId);
    encoder.encodeStruct(codec.Handle, val.inputFd);
    encoder.encodeStruct(codec.Uint32, val.inputBufferSize);
    encoder.encodeStruct(codec.Int32, val.codedSizeWidth);
    encoder.encodeStruct(codec.Int32, val.codedSizeHeight);
    encoder.encodeStruct(codec.Handle, val.exifFd);
    encoder.encodeStruct(codec.Uint32, val.exifBufferSize);
    encoder.encodeStruct(codec.Handle, val.outputFd);
    encoder.encodeStruct(codec.Uint32, val.outputBufferSize);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function JpegEncodeAccelerator_EncodeWithFD_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JpegEncodeAccelerator_EncodeWithFD_ResponseParams.prototype.initDefaults_ = function() {
    this.taskId = 0;
    this.encodedBufferSize = 0;
    this.status = 0;
  };
  JpegEncodeAccelerator_EncodeWithFD_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JpegEncodeAccelerator_EncodeWithFD_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate JpegEncodeAccelerator_EncodeWithFD_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, EncodeStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JpegEncodeAccelerator_EncodeWithFD_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  JpegEncodeAccelerator_EncodeWithFD_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new JpegEncodeAccelerator_EncodeWithFD_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.taskId =
        decoder.decodeStruct(codec.Int32);
    val.encodedBufferSize =
        decoder.decodeStruct(codec.Uint32);
    val.status =
        decoder.decodeStruct(new codec.Enum(EncodeStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  JpegEncodeAccelerator_EncodeWithFD_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JpegEncodeAccelerator_EncodeWithFD_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.taskId);
    encoder.encodeStruct(codec.Uint32, val.encodedBufferSize);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function JpegEncodeAccelerator_EncodeWithDmaBuf_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JpegEncodeAccelerator_EncodeWithDmaBuf_Params.prototype.initDefaults_ = function() {
    this.taskId = 0;
    this.inputFormat = 0;
    this.inputPlanes = null;
    this.outputPlanes = null;
    this.exifHandle = null;
    this.exifBufferSize = 0;
    this.codedSizeWidth = 0;
    this.codedSizeHeight = 0;
    this.quality = 0;
    this.hasInputModifier = false;
    this.inputModifier = 0;
  };
  JpegEncodeAccelerator_EncodeWithDmaBuf_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JpegEncodeAccelerator_EncodeWithDmaBuf_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56},
      {version: 1, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate JpegEncodeAccelerator_EncodeWithDmaBuf_Params.inputPlanes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(dmabuf$.DmaBufPlane), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JpegEncodeAccelerator_EncodeWithDmaBuf_Params.outputPlanes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(dmabuf$.DmaBufPlane), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JpegEncodeAccelerator_EncodeWithDmaBuf_Params.exifHandle
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  JpegEncodeAccelerator_EncodeWithDmaBuf_Params.encodedSize = codec.kStructHeaderSize + 56;

  JpegEncodeAccelerator_EncodeWithDmaBuf_Params.decode = function(decoder) {
    var packed;
    var val = new JpegEncodeAccelerator_EncodeWithDmaBuf_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.taskId =
        decoder.decodeStruct(codec.Int32);
    val.inputFormat =
        decoder.decodeStruct(codec.Uint32);
    val.inputPlanes =
        decoder.decodeArrayPointer(new codec.PointerTo(dmabuf$.DmaBufPlane));
    val.outputPlanes =
        decoder.decodeArrayPointer(new codec.PointerTo(dmabuf$.DmaBufPlane));
    val.exifHandle =
        decoder.decodeStruct(codec.Handle);
    val.exifBufferSize =
        decoder.decodeStruct(codec.Uint32);
    val.codedSizeWidth =
        decoder.decodeStruct(codec.Int32);
    val.codedSizeHeight =
        decoder.decodeStruct(codec.Int32);
    val.quality =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.hasInputModifier = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 1) {
      val.inputModifier =
          decoder.decodeStruct(codec.Uint64);
    } else {
      val.inputModifier = null;
    }
    return val;
  };

  JpegEncodeAccelerator_EncodeWithDmaBuf_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JpegEncodeAccelerator_EncodeWithDmaBuf_Params.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.Int32, val.taskId);
    encoder.encodeStruct(codec.Uint32, val.inputFormat);
    encoder.encodeArrayPointer(new codec.PointerTo(dmabuf$.DmaBufPlane), val.inputPlanes);
    encoder.encodeArrayPointer(new codec.PointerTo(dmabuf$.DmaBufPlane), val.outputPlanes);
    encoder.encodeStruct(codec.Handle, val.exifHandle);
    encoder.encodeStruct(codec.Uint32, val.exifBufferSize);
    encoder.encodeStruct(codec.Int32, val.codedSizeWidth);
    encoder.encodeStruct(codec.Int32, val.codedSizeHeight);
    encoder.encodeStruct(codec.Int32, val.quality);
    packed = 0;
    packed |= (val.hasInputModifier & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.inputModifier);
  };
  function JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.prototype.initDefaults_ = function() {
    this.encodedBufferSize = 0;
    this.status = 0;
  };
  JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, EncodeStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encodedBufferSize =
        decoder.decodeStruct(codec.Uint32);
    val.status =
        decoder.decodeStruct(new codec.Enum(EncodeStatus));
    return val;
  };

  JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.encodedBufferSize);
    encoder.encodeStruct(codec.Int32, val.status);
  };
  var kJpegEncodeAccelerator_Initialize_Name = 0;
  var kJpegEncodeAccelerator_EncodeWithFD_Name = 1;
  var kJpegEncodeAccelerator_EncodeWithDmaBuf_Name = 2;

  function JpegEncodeAcceleratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(JpegEncodeAccelerator,
                                                   handleOrPtrInfo);
  }

  function JpegEncodeAcceleratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        JpegEncodeAccelerator, associatedInterfacePtrInfo);
  }

  JpegEncodeAcceleratorAssociatedPtr.prototype =
      Object.create(JpegEncodeAcceleratorPtr.prototype);
  JpegEncodeAcceleratorAssociatedPtr.prototype.constructor =
      JpegEncodeAcceleratorAssociatedPtr;

  function JpegEncodeAcceleratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  JpegEncodeAcceleratorPtr.prototype.initialize = function() {
    return JpegEncodeAcceleratorProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  JpegEncodeAcceleratorProxy.prototype.initialize = function() {
    var params_ = new JpegEncodeAccelerator_Initialize_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kJpegEncodeAccelerator_Initialize_Name,
          codec.align(JpegEncodeAccelerator_Initialize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(JpegEncodeAccelerator_Initialize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(JpegEncodeAccelerator_Initialize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  JpegEncodeAcceleratorPtr.prototype.encodeWithFD = function() {
    return JpegEncodeAcceleratorProxy.prototype.encodeWithFD
        .apply(this.ptr.getProxy(), arguments);
  };

  JpegEncodeAcceleratorProxy.prototype.encodeWithFD = function(taskId, inputFd, inputBufferSize, codedSizeWidth, codedSizeHeight, exifFd, exifBufferSize, outputFd, outputBufferSize) {
    var params_ = new JpegEncodeAccelerator_EncodeWithFD_Params();
    params_.taskId = taskId;
    params_.inputFd = inputFd;
    params_.inputBufferSize = inputBufferSize;
    params_.codedSizeWidth = codedSizeWidth;
    params_.codedSizeHeight = codedSizeHeight;
    params_.exifFd = exifFd;
    params_.exifBufferSize = exifBufferSize;
    params_.outputFd = outputFd;
    params_.outputBufferSize = outputBufferSize;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kJpegEncodeAccelerator_EncodeWithFD_Name,
          codec.align(JpegEncodeAccelerator_EncodeWithFD_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(JpegEncodeAccelerator_EncodeWithFD_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(JpegEncodeAccelerator_EncodeWithFD_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  JpegEncodeAcceleratorPtr.prototype.encodeWithDmaBuf = function() {
    return JpegEncodeAcceleratorProxy.prototype.encodeWithDmaBuf
        .apply(this.ptr.getProxy(), arguments);
  };

  JpegEncodeAcceleratorProxy.prototype.encodeWithDmaBuf = function(taskId, inputFormat, inputPlanes, outputPlanes, exifHandle, exifBufferSize, codedSizeWidth, codedSizeHeight, quality, hasInputModifier, inputModifier) {
    var params_ = new JpegEncodeAccelerator_EncodeWithDmaBuf_Params();
    params_.taskId = taskId;
    params_.inputFormat = inputFormat;
    params_.inputPlanes = inputPlanes;
    params_.outputPlanes = outputPlanes;
    params_.exifHandle = exifHandle;
    params_.exifBufferSize = exifBufferSize;
    params_.codedSizeWidth = codedSizeWidth;
    params_.codedSizeHeight = codedSizeHeight;
    params_.quality = quality;
    params_.hasInputModifier = hasInputModifier;
    params_.inputModifier = inputModifier;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kJpegEncodeAccelerator_EncodeWithDmaBuf_Name,
          codec.align(JpegEncodeAccelerator_EncodeWithDmaBuf_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(JpegEncodeAccelerator_EncodeWithDmaBuf_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function JpegEncodeAcceleratorStub(delegate) {
    this.delegate_ = delegate;
  }
  JpegEncodeAcceleratorStub.prototype.initialize = function() {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize();
  }
  JpegEncodeAcceleratorStub.prototype.encodeWithFD = function(taskId, inputFd, inputBufferSize, codedSizeWidth, codedSizeHeight, exifFd, exifBufferSize, outputFd, outputBufferSize) {
    return this.delegate_ && this.delegate_.encodeWithFD && this.delegate_.encodeWithFD(taskId, inputFd, inputBufferSize, codedSizeWidth, codedSizeHeight, exifFd, exifBufferSize, outputFd, outputBufferSize);
  }
  JpegEncodeAcceleratorStub.prototype.encodeWithDmaBuf = function(taskId, inputFormat, inputPlanes, outputPlanes, exifHandle, exifBufferSize, codedSizeWidth, codedSizeHeight, quality, hasInputModifier, inputModifier) {
    return this.delegate_ && this.delegate_.encodeWithDmaBuf && this.delegate_.encodeWithDmaBuf(taskId, inputFormat, inputPlanes, outputPlanes, exifHandle, exifBufferSize, codedSizeWidth, codedSizeHeight, quality, hasInputModifier, inputModifier);
  }

  JpegEncodeAcceleratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  JpegEncodeAcceleratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kJpegEncodeAccelerator_Initialize_Name:
      var params = reader.decodeStruct(JpegEncodeAccelerator_Initialize_Params);
      this.initialize().then(function(response) {
        var responseParams =
            new JpegEncodeAccelerator_Initialize_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kJpegEncodeAccelerator_Initialize_Name,
            codec.align(JpegEncodeAccelerator_Initialize_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(JpegEncodeAccelerator_Initialize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kJpegEncodeAccelerator_EncodeWithFD_Name:
      var params = reader.decodeStruct(JpegEncodeAccelerator_EncodeWithFD_Params);
      this.encodeWithFD(params.taskId, params.inputFd, params.inputBufferSize, params.codedSizeWidth, params.codedSizeHeight, params.exifFd, params.exifBufferSize, params.outputFd, params.outputBufferSize).then(function(response) {
        var responseParams =
            new JpegEncodeAccelerator_EncodeWithFD_ResponseParams();
        responseParams.taskId = response.taskId;
        responseParams.encodedBufferSize = response.encodedBufferSize;
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kJpegEncodeAccelerator_EncodeWithFD_Name,
            codec.align(JpegEncodeAccelerator_EncodeWithFD_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(JpegEncodeAccelerator_EncodeWithFD_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kJpegEncodeAccelerator_EncodeWithDmaBuf_Name:
      var params = reader.decodeStruct(JpegEncodeAccelerator_EncodeWithDmaBuf_Params);
      this.encodeWithDmaBuf(params.taskId, params.inputFormat, params.inputPlanes, params.outputPlanes, params.exifHandle, params.exifBufferSize, params.codedSizeWidth, params.codedSizeHeight, params.quality, params.hasInputModifier, params.inputModifier).then(function(response) {
        var responseParams =
            new JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams();
        responseParams.encodedBufferSize = response.encodedBufferSize;
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kJpegEncodeAccelerator_EncodeWithDmaBuf_Name,
            codec.align(JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateJpegEncodeAcceleratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kJpegEncodeAccelerator_Initialize_Name:
        if (message.expectsResponse())
          paramsClass = JpegEncodeAccelerator_Initialize_Params;
      break;
      case kJpegEncodeAccelerator_EncodeWithFD_Name:
        if (message.expectsResponse())
          paramsClass = JpegEncodeAccelerator_EncodeWithFD_Params;
      break;
      case kJpegEncodeAccelerator_EncodeWithDmaBuf_Name:
        if (message.expectsResponse())
          paramsClass = JpegEncodeAccelerator_EncodeWithDmaBuf_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateJpegEncodeAcceleratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kJpegEncodeAccelerator_Initialize_Name:
        if (message.isResponse())
          paramsClass = JpegEncodeAccelerator_Initialize_ResponseParams;
        break;
      case kJpegEncodeAccelerator_EncodeWithFD_Name:
        if (message.isResponse())
          paramsClass = JpegEncodeAccelerator_EncodeWithFD_ResponseParams;
        break;
      case kJpegEncodeAccelerator_EncodeWithDmaBuf_Name:
        if (message.isResponse())
          paramsClass = JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var JpegEncodeAccelerator = {
    name: 'chromeos_camera.mojom.JpegEncodeAccelerator',
    kVersion: 1,
    ptrClass: JpegEncodeAcceleratorPtr,
    proxyClass: JpegEncodeAcceleratorProxy,
    stubClass: JpegEncodeAcceleratorStub,
    validateRequest: validateJpegEncodeAcceleratorRequest,
    validateResponse: validateJpegEncodeAcceleratorResponse,
  };
  JpegEncodeAcceleratorStub.prototype.validator = validateJpegEncodeAcceleratorRequest;
  JpegEncodeAcceleratorProxy.prototype.validator = validateJpegEncodeAcceleratorResponse;
  exports.EncodeStatus = EncodeStatus;
  exports.JpegEncodeAccelerator = JpegEncodeAccelerator;
  exports.JpegEncodeAcceleratorPtr = JpegEncodeAcceleratorPtr;
  exports.JpegEncodeAcceleratorAssociatedPtr = JpegEncodeAcceleratorAssociatedPtr;
})();