// components/chromeos_camera/common/jpeg_encode_accelerator.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  DmaBufPlane as chromeosCamera_mojom_DmaBufPlane,
  DmaBufPlaneSpec as chromeosCamera_mojom_DmaBufPlaneSpec
} from './dmabuf.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EncodeStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EncodeStatus = {
  
  ENCODE_OK: 0,
  HW_JPEG_ENCODE_NOT_SUPPORTED: 1,
  THREAD_CREATION_FAILED: 2,
  INVALID_ARGUMENT: 3,
  INACCESSIBLE_OUTPUT_BUFFER: 4,
  PARSE_IMAGE_FAILED: 5,
  PLATFORM_FAILURE: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class JpegEncodeAcceleratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos_camera.mojom.JpegEncodeAccelerator', scope);
  }
}

/** @interface */
export class JpegEncodeAcceleratorInterface {
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize() {}
  
  /**
   * @param { !number } taskId
   * @param { !MojoHandle } inputFd
   * @param { !number } inputBufferSize
   * @param { !number } codedSizeWidth
   * @param { !number } codedSizeHeight
   * @param { !MojoHandle } exifFd
   * @param { !number } exifBufferSize
   * @param { !MojoHandle } outputFd
   * @param { !number } outputBufferSize
   * @return {!Promise<{
        taskId: !number,
        encodedBufferSize: !number,
        status: !EncodeStatus,
   *  }>}
   */

  encodeWithFD(taskId, inputFd, inputBufferSize, codedSizeWidth, codedSizeHeight, exifFd, exifBufferSize, outputFd, outputBufferSize) {}
  
  /**
   * @param { !number } taskId
   * @param { !number } inputFormat
   * @param { !Array<!chromeosCamera_mojom_DmaBufPlane> } inputPlanes
   * @param { !Array<!chromeosCamera_mojom_DmaBufPlane> } outputPlanes
   * @param { !MojoHandle } exifHandle
   * @param { !number } exifBufferSize
   * @param { !number } codedSizeWidth
   * @param { !number } codedSizeHeight
   * @param { !number } quality
   * @param { !boolean } hasInputModifier
   * @param { !bigint } inputModifier
   * @return {!Promise<{
        encodedBufferSize: !number,
        status: !EncodeStatus,
   *  }>}
   */

  encodeWithDmaBuf(taskId, inputFormat, inputPlanes, outputPlanes, exifHandle, exifBufferSize, codedSizeWidth, codedSizeHeight, quality, hasInputModifier, inputModifier) {}
}

/**
 * @implements { JpegEncodeAcceleratorInterface }
 */
export class JpegEncodeAcceleratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!JpegEncodeAcceleratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          JpegEncodeAcceleratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!JpegEncodeAcceleratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize() {
    return this.proxy.sendMessage(
        0,
        JpegEncodeAccelerator_Initialize_ParamsSpec.$,
        JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } taskId
   * @param { !MojoHandle } inputFd
   * @param { !number } inputBufferSize
   * @param { !number } codedSizeWidth
   * @param { !number } codedSizeHeight
   * @param { !MojoHandle } exifFd
   * @param { !number } exifBufferSize
   * @param { !MojoHandle } outputFd
   * @param { !number } outputBufferSize
   * @return {!Promise<{
        taskId: !number,
        encodedBufferSize: !number,
        status: !EncodeStatus,
   *  }>}
   */

  encodeWithFD(
      taskId,
      inputFd,
      inputBufferSize,
      codedSizeWidth,
      codedSizeHeight,
      exifFd,
      exifBufferSize,
      outputFd,
      outputBufferSize) {
    return this.proxy.sendMessage(
        1,
        JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
        JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
        [
          taskId,
          inputFd,
          inputBufferSize,
          codedSizeWidth,
          codedSizeHeight,
          exifFd,
          exifBufferSize,
          outputFd,
          outputBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } taskId
   * @param { !number } inputFormat
   * @param { !Array<!chromeosCamera_mojom_DmaBufPlane> } inputPlanes
   * @param { !Array<!chromeosCamera_mojom_DmaBufPlane> } outputPlanes
   * @param { !MojoHandle } exifHandle
   * @param { !number } exifBufferSize
   * @param { !number } codedSizeWidth
   * @param { !number } codedSizeHeight
   * @param { !number } quality
   * @param { !boolean } hasInputModifier
   * @param { !bigint } inputModifier
   * @return {!Promise<{
        encodedBufferSize: !number,
        status: !EncodeStatus,
   *  }>}
   */

  encodeWithDmaBuf(
      taskId,
      inputFormat,
      inputPlanes,
      outputPlanes,
      exifHandle,
      exifBufferSize,
      codedSizeWidth,
      codedSizeHeight,
      quality,
      hasInputModifier,
      inputModifier) {
    return this.proxy.sendMessage(
        2,
        JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
        JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
        [
          taskId,
          inputFormat,
          inputPlanes,
          outputPlanes,
          exifHandle,
          exifBufferSize,
          codedSizeWidth,
          codedSizeHeight,
          quality,
          hasInputModifier,
          inputModifier
        ],
        false);
  }
}

/**
 * An object which receives request messages for the JpegEncodeAccelerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class JpegEncodeAcceleratorReceiver {
  /**
   * @param {!JpegEncodeAcceleratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!JpegEncodeAcceleratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        JpegEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!JpegEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        JpegEncodeAccelerator_Initialize_ParamsSpec.$,
        JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
        JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
        impl.encodeWithFD.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
        JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
        impl.encodeWithDmaBuf.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class JpegEncodeAccelerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos_camera.mojom.JpegEncodeAccelerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!JpegEncodeAcceleratorRemote}
   */
  static getRemote() {
    let remote = new JpegEncodeAcceleratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the JpegEncodeAccelerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class JpegEncodeAcceleratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      JpegEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!JpegEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        JpegEncodeAccelerator_Initialize_ParamsSpec.$,
        JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encodeWithFD =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
        JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
        this.encodeWithFD.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encodeWithDmaBuf =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
        JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
        this.encodeWithDmaBuf.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JpegEncodeAccelerator_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JpegEncodeAccelerator_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JpegEncodeAccelerator_EncodeWithFD_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    JpegEncodeAccelerator_Initialize_ParamsSpec.$,
    'JpegEncodeAccelerator_Initialize_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class JpegEncodeAccelerator_Initialize_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    JpegEncodeAccelerator_Initialize_ResponseParamsSpec.$,
    'JpegEncodeAccelerator_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class JpegEncodeAccelerator_Initialize_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    JpegEncodeAccelerator_EncodeWithFD_ParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithFD_Params',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputFd', 4,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputBufferSize', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSizeWidth', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSizeHeight', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exifFd', 20,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exifBufferSize', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputFd', 28,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputBufferSize', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class JpegEncodeAccelerator_EncodeWithFD_Params {
  constructor() {
    /** @type { !number } */
    this.taskId;
    /** @type { !MojoHandle } */
    this.inputFd;
    /** @type { !number } */
    this.inputBufferSize;
    /** @type { !number } */
    this.codedSizeWidth;
    /** @type { !number } */
    this.codedSizeHeight;
    /** @type { !MojoHandle } */
    this.exifFd;
    /** @type { !number } */
    this.exifBufferSize;
    /** @type { !MojoHandle } */
    this.outputFd;
    /** @type { !number } */
    this.outputBufferSize;
  }
}



mojo.internal.Struct(
    JpegEncodeAccelerator_EncodeWithFD_ResponseParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithFD_ResponseParams',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedBufferSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        EncodeStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class JpegEncodeAccelerator_EncodeWithFD_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.taskId;
    /** @type { !number } */
    this.encodedBufferSize;
    /** @type { !EncodeStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    JpegEncodeAccelerator_EncodeWithDmaBuf_ParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithDmaBuf_Params',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputFormat', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputPlanes', 8,
        0,
        mojo.internal.Array(chromeosCamera_mojom_DmaBufPlaneSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputPlanes', 16,
        0,
        mojo.internal.Array(chromeosCamera_mojom_DmaBufPlaneSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exifHandle', 24,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exifBufferSize', 28,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSizeWidth', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSizeHeight', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quality', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasInputModifier', 44,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'inputModifier', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        1,
      ),
    ],
    [[0, 56],[1, 64],]);



/**
 * @record
 */
export class JpegEncodeAccelerator_EncodeWithDmaBuf_Params {
  constructor() {
    /** @type { !number } */
    this.taskId;
    /** @type { !number } */
    this.inputFormat;
    /** @type { !Array<!chromeosCamera_mojom_DmaBufPlane> } */
    this.inputPlanes;
    /** @type { !Array<!chromeosCamera_mojom_DmaBufPlane> } */
    this.outputPlanes;
    /** @type { !MojoHandle } */
    this.exifHandle;
    /** @type { !number } */
    this.exifBufferSize;
    /** @type { !number } */
    this.codedSizeWidth;
    /** @type { !number } */
    this.codedSizeHeight;
    /** @type { !number } */
    this.quality;
    /** @type { !boolean } */
    this.hasInputModifier;
    /** @type { !bigint } */
    this.inputModifier;
  }
}



mojo.internal.Struct(
    JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParamsSpec.$,
    'JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams',
    [
      mojo.internal.StructField(
        'encodedBufferSize', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 4,
        0,
        EncodeStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class JpegEncodeAccelerator_EncodeWithDmaBuf_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.encodedBufferSize;
    /** @type { !EncodeStatus } */
    this.status;
  }
}

