// components/chromeos_camera/common/mjpeg_decode_accelerator.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeosCamera.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeosCamera.mojom.DecodeErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeosCamera.mojom.DecodeError = {
  
  NO_ERRORS: 0,
  INVALID_ARGUMENT: 1,
  UNREADABLE_INPUT: 2,
  PARSE_JPEG_FAILED: 3,
  UNSUPPORTED_JPEG: 4,
  PLATFORM_FAILURE: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAcceleratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeosCamera.mojom.MjpegDecodeAccelerator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeosCamera.mojom.MjpegDecodeAcceleratorInterface }
 */
chromeosCamera.mojom.MjpegDecodeAcceleratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeosCamera.mojom.MjpegDecodeAcceleratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeosCamera.mojom.MjpegDecodeAcceleratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeosCamera.mojom.MjpegDecodeAcceleratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize() {
    return this.proxy.sendMessage(
        0,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !chromeosCamera.mojom.BitstreamBuffer } inputBuffer
   * @param { !gfx.mojom.Size } codedSize
   * @param { !MojoHandle } outputHandle
   * @param { !number } outputBufferSize
   * @return {!Promise<{
        bitstreamBufferId: !number,
        error: !chromeosCamera.mojom.DecodeError,
   *  }>}
   */

  decode(
      inputBuffer,
      codedSize,
      outputHandle,
      outputBufferSize) {
    return this.proxy.sendMessage(
        1,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
        [
          inputBuffer,
          codedSize,
          outputHandle,
          outputBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } taskId
   * @param { !MojoHandle } srcDmabufFd
   * @param { !number } srcSize
   * @param { !number } srcOffset
   * @param { !chromeosCamera.mojom.DmaBufVideoFrame } dstFrame
   * @return {!Promise<{
        error: !chromeosCamera.mojom.DecodeError,
   *  }>}
   */

  decodeWithDmaBuf(
      taskId,
      srcDmabufFd,
      srcSize,
      srcOffset,
      dstFrame) {
    return this.proxy.sendMessage(
        3,
        chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
        [
          taskId,
          srcDmabufFd,
          srcSize,
          srcOffset,
          dstFrame
        ],
        false);
  }

  
  /**
   */

  uninitialize() {
    this.proxy.sendMessage(
        4,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MjpegDecodeAccelerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAcceleratorReceiver = class {
  /**
   * @param {!chromeosCamera.mojom.MjpegDecodeAcceleratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeosCamera.mojom.MjpegDecodeAcceleratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeosCamera.mojom.MjpegDecodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeosCamera.mojom.MjpegDecodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
        impl.decode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
        impl.decodeWithDmaBuf.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
        null,
        impl.uninitialize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos_camera.mojom.MjpegDecodeAccelerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeosCamera.mojom.MjpegDecodeAcceleratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeosCamera.mojom.MjpegDecodeAcceleratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MjpegDecodeAccelerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAcceleratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeosCamera.mojom.MjpegDecodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeosCamera.mojom.MjpegDecodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
        this.decode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decodeWithDmaBuf =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
        chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
        this.decodeWithDmaBuf.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.uninitialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        chromeosCamera.mojom.MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
        null,
        this.uninitialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.BitstreamBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeosCamera.mojom.MjpegDecodeAccelerator_Uninitialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeosCamera.mojom.BitstreamBufferSpec.$,
    'BitstreamBuffer',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'memoryHandle', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timestamp', 24,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyId', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'iv', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subsamples', 48,
        0,
        mojo.internal.Array(media.mojom.SubsampleEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
chromeosCamera.mojom.BitstreamBuffer = class {
  constructor() {
    /** @export { !number } */
    this.id;
    /** @export { !MojoHandle } */
    this.memoryHandle;
    /** @export { !number } */
    this.size;
    /** @export { !bigint } */
    this.offset;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timestamp;
    /** @export { !string } */
    this.keyId;
    /** @export { !string } */
    this.iv;
    /** @export { !Array<!media.mojom.SubsampleEntry> } */
    this.subsamples;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
    'MjpegDecodeAccelerator_Initialize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
    'MjpegDecodeAccelerator_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ParamsSpec.$,
    'MjpegDecodeAccelerator_Decode_Params',
    [
      mojo.internal.StructField(
        'inputBuffer', 0,
        0,
        chromeosCamera.mojom.BitstreamBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputHandle', 16,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputBufferSize', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_Params = class {
  constructor() {
    /** @export { !chromeosCamera.mojom.BitstreamBuffer } */
    this.inputBuffer;
    /** @export { !gfx.mojom.Size } */
    this.codedSize;
    /** @export { !MojoHandle } */
    this.outputHandle;
    /** @export { !number } */
    this.outputBufferSize;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
    'MjpegDecodeAccelerator_Decode_ResponseParams',
    [
      mojo.internal.StructField(
        'bitstreamBufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 4,
        0,
        chromeosCamera.mojom.DecodeErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_Decode_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.bitstreamBufferId;
    /** @export { !chromeosCamera.mojom.DecodeError } */
    this.error;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
    'MjpegDecodeAccelerator_DecodeWithDmaBuf_Params',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcDmabufFd', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcSize', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcOffset', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dstFrame', 16,
        0,
        chromeosCamera.mojom.DmaBufVideoFrameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_Params = class {
  constructor() {
    /** @export { !number } */
    this.taskId;
    /** @export { !MojoHandle } */
    this.srcDmabufFd;
    /** @export { !number } */
    this.srcSize;
    /** @export { !number } */
    this.srcOffset;
    /** @export { !chromeosCamera.mojom.DmaBufVideoFrame } */
    this.dstFrame;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
    'MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        chromeosCamera.mojom.DecodeErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams = class {
  constructor() {
    /** @export { !chromeosCamera.mojom.DecodeError } */
    this.error;
  }
};



mojo.internal.Struct(
    chromeosCamera.mojom.MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
    'MjpegDecodeAccelerator_Uninitialize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeosCamera.mojom.MjpegDecodeAccelerator_Uninitialize_Params = class {
  constructor() {
  }
};

