// components/chromeos_camera/common/mjpeg_decode_accelerator.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/chromeos_camera/common/mjpeg_decode_accelerator.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeosCamera.mojom');
  var dmabuf$ =
      mojo.internal.exposeNamespace('chromeosCamera.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/chromeos_camera/common/dmabuf.mojom', 'dmabuf.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', '../../../media/mojo/mojom/media_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var DecodeError = {};
  DecodeError.NO_ERRORS = 0;
  DecodeError.INVALID_ARGUMENT = 1;
  DecodeError.UNREADABLE_INPUT = 2;
  DecodeError.PARSE_JPEG_FAILED = 3;
  DecodeError.UNSUPPORTED_JPEG = 4;
  DecodeError.PLATFORM_FAILURE = 5;
  DecodeError.MIN_VALUE = 0;
  DecodeError.MAX_VALUE = 5;

  DecodeError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  DecodeError.toKnownEnumValue = function(value) {
    return value;
  };

  DecodeError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function BitstreamBuffer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitstreamBuffer.prototype.initDefaults_ = function() {
    this.id = 0;
    this.memoryHandle = null;
    this.size = 0;
    this.offset = 0;
    this.timestamp = null;
    this.keyId = null;
    this.iv = null;
    this.subsamples = null;
  };
  BitstreamBuffer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitstreamBuffer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BitstreamBuffer.memoryHandle
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate BitstreamBuffer.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitstreamBuffer.keyId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitstreamBuffer.iv
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitstreamBuffer.subsamples
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(media_types$.SubsampleEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitstreamBuffer.encodedSize = codec.kStructHeaderSize + 56;

  BitstreamBuffer.decode = function(decoder) {
    var packed;
    var val = new BitstreamBuffer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.memoryHandle =
        decoder.decodeStruct(codec.Handle);
    val.size =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.offset =
        decoder.decodeStruct(codec.Int64);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.keyId =
        decoder.decodeStruct(codec.String);
    val.iv =
        decoder.decodeStruct(codec.String);
    val.subsamples =
        decoder.decodeArrayPointer(new codec.PointerTo(media_types$.SubsampleEntry));
    return val;
  };

  BitstreamBuffer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitstreamBuffer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Handle, val.memoryHandle);
    encoder.encodeStruct(codec.Uint32, val.size);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.offset);
    encoder.encodeStructPointer(time$.TimeDelta, val.timestamp);
    encoder.encodeStruct(codec.String, val.keyId);
    encoder.encodeStruct(codec.String, val.iv);
    encoder.encodeArrayPointer(new codec.PointerTo(media_types$.SubsampleEntry), val.subsamples);
  };
  function MjpegDecodeAccelerator_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_Initialize_Params.prototype.initDefaults_ = function() {
  };
  MjpegDecodeAccelerator_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_Initialize_Params.encodedSize = codec.kStructHeaderSize + 0;

  MjpegDecodeAccelerator_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MjpegDecodeAccelerator_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MjpegDecodeAccelerator_Initialize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_Initialize_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  MjpegDecodeAccelerator_Initialize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_Initialize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_Initialize_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MjpegDecodeAccelerator_Initialize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_Initialize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MjpegDecodeAccelerator_Initialize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_Initialize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MjpegDecodeAccelerator_Decode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_Decode_Params.prototype.initDefaults_ = function() {
    this.inputBuffer = null;
    this.codedSize = null;
    this.outputHandle = null;
    this.outputBufferSize = 0;
  };
  MjpegDecodeAccelerator_Decode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_Decode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MjpegDecodeAccelerator_Decode_Params.inputBuffer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, BitstreamBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MjpegDecodeAccelerator_Decode_Params.codedSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MjpegDecodeAccelerator_Decode_Params.outputHandle
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_Decode_Params.encodedSize = codec.kStructHeaderSize + 24;

  MjpegDecodeAccelerator_Decode_Params.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_Decode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputBuffer =
        decoder.decodeStructPointer(BitstreamBuffer);
    val.codedSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.outputHandle =
        decoder.decodeStruct(codec.Handle);
    val.outputBufferSize =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  MjpegDecodeAccelerator_Decode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_Decode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(BitstreamBuffer, val.inputBuffer);
    encoder.encodeStructPointer(geometry$.Size, val.codedSize);
    encoder.encodeStruct(codec.Handle, val.outputHandle);
    encoder.encodeStruct(codec.Uint32, val.outputBufferSize);
  };
  function MjpegDecodeAccelerator_Decode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_Decode_ResponseParams.prototype.initDefaults_ = function() {
    this.bitstreamBufferId = 0;
    this.error = 0;
  };
  MjpegDecodeAccelerator_Decode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_Decode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MjpegDecodeAccelerator_Decode_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, DecodeError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_Decode_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MjpegDecodeAccelerator_Decode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_Decode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitstreamBufferId =
        decoder.decodeStruct(codec.Int32);
    val.error =
        decoder.decodeStruct(new codec.Enum(DecodeError));
    return val;
  };

  MjpegDecodeAccelerator_Decode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_Decode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.bitstreamBufferId);
    encoder.encodeStruct(codec.Int32, val.error);
  };
  function MjpegDecodeAccelerator_DecodeWithDmaBuf_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.prototype.initDefaults_ = function() {
    this.taskId = 0;
    this.srcDmabufFd = null;
    this.srcSize = 0;
    this.srcOffset = 0;
    this.dstFrame = null;
  };
  MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.srcDmabufFd
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.dstFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, dmabuf$.DmaBufVideoFrame, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.encodedSize = codec.kStructHeaderSize + 24;

  MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_DecodeWithDmaBuf_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.taskId =
        decoder.decodeStruct(codec.Int32);
    val.srcDmabufFd =
        decoder.decodeStruct(codec.Handle);
    val.srcSize =
        decoder.decodeStruct(codec.Uint32);
    val.srcOffset =
        decoder.decodeStruct(codec.Uint32);
    val.dstFrame =
        decoder.decodeStructPointer(dmabuf$.DmaBufVideoFrame);
    return val;
  };

  MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.taskId);
    encoder.encodeStruct(codec.Handle, val.srcDmabufFd);
    encoder.encodeStruct(codec.Uint32, val.srcSize);
    encoder.encodeStruct(codec.Uint32, val.srcOffset);
    encoder.encodeStructPointer(dmabuf$.DmaBufVideoFrame, val.dstFrame);
  };
  function MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
  };
  MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DecodeError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(DecodeError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MjpegDecodeAccelerator_Uninitialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MjpegDecodeAccelerator_Uninitialize_Params.prototype.initDefaults_ = function() {
  };
  MjpegDecodeAccelerator_Uninitialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MjpegDecodeAccelerator_Uninitialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MjpegDecodeAccelerator_Uninitialize_Params.encodedSize = codec.kStructHeaderSize + 0;

  MjpegDecodeAccelerator_Uninitialize_Params.decode = function(decoder) {
    var packed;
    var val = new MjpegDecodeAccelerator_Uninitialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MjpegDecodeAccelerator_Uninitialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MjpegDecodeAccelerator_Uninitialize_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kMjpegDecodeAccelerator_Initialize_Name = 0;
  var kMjpegDecodeAccelerator_Decode_Name = 1;
  var kMjpegDecodeAccelerator_DecodeWithDmaBuf_Name = 3;
  var kMjpegDecodeAccelerator_Uninitialize_Name = 4;

  function MjpegDecodeAcceleratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MjpegDecodeAccelerator,
                                                   handleOrPtrInfo);
  }

  function MjpegDecodeAcceleratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MjpegDecodeAccelerator, associatedInterfacePtrInfo);
  }

  MjpegDecodeAcceleratorAssociatedPtr.prototype =
      Object.create(MjpegDecodeAcceleratorPtr.prototype);
  MjpegDecodeAcceleratorAssociatedPtr.prototype.constructor =
      MjpegDecodeAcceleratorAssociatedPtr;

  function MjpegDecodeAcceleratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  MjpegDecodeAcceleratorPtr.prototype.initialize = function() {
    return MjpegDecodeAcceleratorProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  MjpegDecodeAcceleratorProxy.prototype.initialize = function() {
    var params_ = new MjpegDecodeAccelerator_Initialize_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMjpegDecodeAccelerator_Initialize_Name,
          codec.align(MjpegDecodeAccelerator_Initialize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MjpegDecodeAccelerator_Initialize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MjpegDecodeAccelerator_Initialize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MjpegDecodeAcceleratorPtr.prototype.decode = function() {
    return MjpegDecodeAcceleratorProxy.prototype.decode
        .apply(this.ptr.getProxy(), arguments);
  };

  MjpegDecodeAcceleratorProxy.prototype.decode = function(inputBuffer, codedSize, outputHandle, outputBufferSize) {
    var params_ = new MjpegDecodeAccelerator_Decode_Params();
    params_.inputBuffer = inputBuffer;
    params_.codedSize = codedSize;
    params_.outputHandle = outputHandle;
    params_.outputBufferSize = outputBufferSize;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMjpegDecodeAccelerator_Decode_Name,
          codec.align(MjpegDecodeAccelerator_Decode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MjpegDecodeAccelerator_Decode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MjpegDecodeAccelerator_Decode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MjpegDecodeAcceleratorPtr.prototype.decodeWithDmaBuf = function() {
    return MjpegDecodeAcceleratorProxy.prototype.decodeWithDmaBuf
        .apply(this.ptr.getProxy(), arguments);
  };

  MjpegDecodeAcceleratorProxy.prototype.decodeWithDmaBuf = function(taskId, srcDmabufFd, srcSize, srcOffset, dstFrame) {
    var params_ = new MjpegDecodeAccelerator_DecodeWithDmaBuf_Params();
    params_.taskId = taskId;
    params_.srcDmabufFd = srcDmabufFd;
    params_.srcSize = srcSize;
    params_.srcOffset = srcOffset;
    params_.dstFrame = dstFrame;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMjpegDecodeAccelerator_DecodeWithDmaBuf_Name,
          codec.align(MjpegDecodeAccelerator_DecodeWithDmaBuf_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MjpegDecodeAccelerator_DecodeWithDmaBuf_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MjpegDecodeAcceleratorPtr.prototype.uninitialize = function() {
    return MjpegDecodeAcceleratorProxy.prototype.uninitialize
        .apply(this.ptr.getProxy(), arguments);
  };

  MjpegDecodeAcceleratorProxy.prototype.uninitialize = function() {
    var params_ = new MjpegDecodeAccelerator_Uninitialize_Params();
    var builder = new codec.MessageV0Builder(
        kMjpegDecodeAccelerator_Uninitialize_Name,
        codec.align(MjpegDecodeAccelerator_Uninitialize_Params.encodedSize));
    builder.encodeStruct(MjpegDecodeAccelerator_Uninitialize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MjpegDecodeAcceleratorStub(delegate) {
    this.delegate_ = delegate;
  }
  MjpegDecodeAcceleratorStub.prototype.initialize = function() {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize();
  }
  MjpegDecodeAcceleratorStub.prototype.decode = function(inputBuffer, codedSize, outputHandle, outputBufferSize) {
    return this.delegate_ && this.delegate_.decode && this.delegate_.decode(inputBuffer, codedSize, outputHandle, outputBufferSize);
  }
  MjpegDecodeAcceleratorStub.prototype.decodeWithDmaBuf = function(taskId, srcDmabufFd, srcSize, srcOffset, dstFrame) {
    return this.delegate_ && this.delegate_.decodeWithDmaBuf && this.delegate_.decodeWithDmaBuf(taskId, srcDmabufFd, srcSize, srcOffset, dstFrame);
  }
  MjpegDecodeAcceleratorStub.prototype.uninitialize = function() {
    return this.delegate_ && this.delegate_.uninitialize && this.delegate_.uninitialize();
  }

  MjpegDecodeAcceleratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMjpegDecodeAccelerator_Uninitialize_Name:
      var params = reader.decodeStruct(MjpegDecodeAccelerator_Uninitialize_Params);
      this.uninitialize();
      return true;
    default:
      return false;
    }
  };

  MjpegDecodeAcceleratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMjpegDecodeAccelerator_Initialize_Name:
      var params = reader.decodeStruct(MjpegDecodeAccelerator_Initialize_Params);
      this.initialize().then(function(response) {
        var responseParams =
            new MjpegDecodeAccelerator_Initialize_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kMjpegDecodeAccelerator_Initialize_Name,
            codec.align(MjpegDecodeAccelerator_Initialize_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MjpegDecodeAccelerator_Initialize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMjpegDecodeAccelerator_Decode_Name:
      var params = reader.decodeStruct(MjpegDecodeAccelerator_Decode_Params);
      this.decode(params.inputBuffer, params.codedSize, params.outputHandle, params.outputBufferSize).then(function(response) {
        var responseParams =
            new MjpegDecodeAccelerator_Decode_ResponseParams();
        responseParams.bitstreamBufferId = response.bitstreamBufferId;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMjpegDecodeAccelerator_Decode_Name,
            codec.align(MjpegDecodeAccelerator_Decode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MjpegDecodeAccelerator_Decode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMjpegDecodeAccelerator_DecodeWithDmaBuf_Name:
      var params = reader.decodeStruct(MjpegDecodeAccelerator_DecodeWithDmaBuf_Params);
      this.decodeWithDmaBuf(params.taskId, params.srcDmabufFd, params.srcSize, params.srcOffset, params.dstFrame).then(function(response) {
        var responseParams =
            new MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMjpegDecodeAccelerator_DecodeWithDmaBuf_Name,
            codec.align(MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMjpegDecodeAcceleratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMjpegDecodeAccelerator_Initialize_Name:
        if (message.expectsResponse())
          paramsClass = MjpegDecodeAccelerator_Initialize_Params;
      break;
      case kMjpegDecodeAccelerator_Decode_Name:
        if (message.expectsResponse())
          paramsClass = MjpegDecodeAccelerator_Decode_Params;
      break;
      case kMjpegDecodeAccelerator_DecodeWithDmaBuf_Name:
        if (message.expectsResponse())
          paramsClass = MjpegDecodeAccelerator_DecodeWithDmaBuf_Params;
      break;
      case kMjpegDecodeAccelerator_Uninitialize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MjpegDecodeAccelerator_Uninitialize_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMjpegDecodeAcceleratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMjpegDecodeAccelerator_Initialize_Name:
        if (message.isResponse())
          paramsClass = MjpegDecodeAccelerator_Initialize_ResponseParams;
        break;
      case kMjpegDecodeAccelerator_Decode_Name:
        if (message.isResponse())
          paramsClass = MjpegDecodeAccelerator_Decode_ResponseParams;
        break;
      case kMjpegDecodeAccelerator_DecodeWithDmaBuf_Name:
        if (message.isResponse())
          paramsClass = MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MjpegDecodeAccelerator = {
    name: 'chromeos_camera.mojom.MjpegDecodeAccelerator',
    kVersion: 0,
    ptrClass: MjpegDecodeAcceleratorPtr,
    proxyClass: MjpegDecodeAcceleratorProxy,
    stubClass: MjpegDecodeAcceleratorStub,
    validateRequest: validateMjpegDecodeAcceleratorRequest,
    validateResponse: validateMjpegDecodeAcceleratorResponse,
  };
  MjpegDecodeAcceleratorStub.prototype.validator = validateMjpegDecodeAcceleratorRequest;
  MjpegDecodeAcceleratorProxy.prototype.validator = validateMjpegDecodeAcceleratorResponse;
  exports.DecodeError = DecodeError;
  exports.BitstreamBuffer = BitstreamBuffer;
  exports.MjpegDecodeAccelerator = MjpegDecodeAccelerator;
  exports.MjpegDecodeAcceleratorPtr = MjpegDecodeAcceleratorPtr;
  exports.MjpegDecodeAcceleratorAssociatedPtr = MjpegDecodeAcceleratorAssociatedPtr;
})();