// components/chromeos_camera/common/mjpeg_decode_accelerator.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  SubsampleEntry as media_mojom_SubsampleEntry,
  SubsampleEntrySpec as media_mojom_SubsampleEntrySpec
} from '../../../media/mojo/mojom/media_types.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  DmaBufVideoFrame as chromeosCamera_mojom_DmaBufVideoFrame,
  DmaBufVideoFrameSpec as chromeosCamera_mojom_DmaBufVideoFrameSpec
} from './dmabuf.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DecodeErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DecodeError = {
  
  NO_ERRORS: 0,
  INVALID_ARGUMENT: 1,
  UNREADABLE_INPUT: 2,
  PARSE_JPEG_FAILED: 3,
  UNSUPPORTED_JPEG: 4,
  PLATFORM_FAILURE: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MjpegDecodeAcceleratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos_camera.mojom.MjpegDecodeAccelerator', scope);
  }
}

/** @interface */
export class MjpegDecodeAcceleratorInterface {
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize() {}
  
  /**
   * @param { !BitstreamBuffer } inputBuffer
   * @param { !gfx_mojom_Size } codedSize
   * @param { !MojoHandle } outputHandle
   * @param { !number } outputBufferSize
   * @return {!Promise<{
        bitstreamBufferId: !number,
        error: !DecodeError,
   *  }>}
   */

  decode(inputBuffer, codedSize, outputHandle, outputBufferSize) {}
  
  /**
   * @param { !number } taskId
   * @param { !MojoHandle } srcDmabufFd
   * @param { !number } srcSize
   * @param { !number } srcOffset
   * @param { !chromeosCamera_mojom_DmaBufVideoFrame } dstFrame
   * @return {!Promise<{
        error: !DecodeError,
   *  }>}
   */

  decodeWithDmaBuf(taskId, srcDmabufFd, srcSize, srcOffset, dstFrame) {}
  
  /**
   */

  uninitialize() {}
}

/**
 * @implements { MjpegDecodeAcceleratorInterface }
 */
export class MjpegDecodeAcceleratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MjpegDecodeAcceleratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MjpegDecodeAcceleratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MjpegDecodeAcceleratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize() {
    return this.proxy.sendMessage(
        0,
        MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
        MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !BitstreamBuffer } inputBuffer
   * @param { !gfx_mojom_Size } codedSize
   * @param { !MojoHandle } outputHandle
   * @param { !number } outputBufferSize
   * @return {!Promise<{
        bitstreamBufferId: !number,
        error: !DecodeError,
   *  }>}
   */

  decode(
      inputBuffer,
      codedSize,
      outputHandle,
      outputBufferSize) {
    return this.proxy.sendMessage(
        1,
        MjpegDecodeAccelerator_Decode_ParamsSpec.$,
        MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
        [
          inputBuffer,
          codedSize,
          outputHandle,
          outputBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } taskId
   * @param { !MojoHandle } srcDmabufFd
   * @param { !number } srcSize
   * @param { !number } srcOffset
   * @param { !chromeosCamera_mojom_DmaBufVideoFrame } dstFrame
   * @return {!Promise<{
        error: !DecodeError,
   *  }>}
   */

  decodeWithDmaBuf(
      taskId,
      srcDmabufFd,
      srcSize,
      srcOffset,
      dstFrame) {
    return this.proxy.sendMessage(
        3,
        MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
        MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
        [
          taskId,
          srcDmabufFd,
          srcSize,
          srcOffset,
          dstFrame
        ],
        false);
  }

  
  /**
   */

  uninitialize() {
    this.proxy.sendMessage(
        4,
        MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MjpegDecodeAccelerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MjpegDecodeAcceleratorReceiver {
  /**
   * @param {!MjpegDecodeAcceleratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MjpegDecodeAcceleratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MjpegDecodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MjpegDecodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
        MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MjpegDecodeAccelerator_Decode_ParamsSpec.$,
        MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
        impl.decode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
        MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
        impl.decodeWithDmaBuf.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
        null,
        impl.uninitialize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MjpegDecodeAccelerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos_camera.mojom.MjpegDecodeAccelerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MjpegDecodeAcceleratorRemote}
   */
  static getRemote() {
    let remote = new MjpegDecodeAcceleratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MjpegDecodeAccelerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MjpegDecodeAcceleratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MjpegDecodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MjpegDecodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
        MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MjpegDecodeAccelerator_Decode_ParamsSpec.$,
        MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
        this.decode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decodeWithDmaBuf =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
        MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
        this.decodeWithDmaBuf.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.uninitialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
        null,
        this.uninitialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BitstreamBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_Decode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_Decode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MjpegDecodeAccelerator_Uninitialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BitstreamBufferSpec.$,
    'BitstreamBuffer',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'memoryHandle', 4,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offset', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyId', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iv', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subsamples', 48,
        0,
        mojo.internal.Array(media_mojom_SubsampleEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class BitstreamBuffer {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !MojoHandle } */
    this.memoryHandle;
    /** @type { !number } */
    this.size;
    /** @type { !bigint } */
    this.offset;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timestamp;
    /** @type { !string } */
    this.keyId;
    /** @type { !string } */
    this.iv;
    /** @type { !Array<!media_mojom_SubsampleEntry> } */
    this.subsamples;
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_Initialize_ParamsSpec.$,
    'MjpegDecodeAccelerator_Initialize_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_Initialize_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_Initialize_ResponseParamsSpec.$,
    'MjpegDecodeAccelerator_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_Initialize_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_Decode_ParamsSpec.$,
    'MjpegDecodeAccelerator_Decode_Params',
    [
      mojo.internal.StructField(
        'inputBuffer', 0,
        0,
        BitstreamBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputHandle', 16,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputBufferSize', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_Decode_Params {
  constructor() {
    /** @type { !BitstreamBuffer } */
    this.inputBuffer;
    /** @type { !gfx_mojom_Size } */
    this.codedSize;
    /** @type { !MojoHandle } */
    this.outputHandle;
    /** @type { !number } */
    this.outputBufferSize;
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_Decode_ResponseParamsSpec.$,
    'MjpegDecodeAccelerator_Decode_ResponseParams',
    [
      mojo.internal.StructField(
        'bitstreamBufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 4,
        0,
        DecodeErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_Decode_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.bitstreamBufferId;
    /** @type { !DecodeError } */
    this.error;
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_DecodeWithDmaBuf_ParamsSpec.$,
    'MjpegDecodeAccelerator_DecodeWithDmaBuf_Params',
    [
      mojo.internal.StructField(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcDmabufFd', 4,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcSize', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcOffset', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dstFrame', 16,
        0,
        chromeosCamera_mojom_DmaBufVideoFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_DecodeWithDmaBuf_Params {
  constructor() {
    /** @type { !number } */
    this.taskId;
    /** @type { !MojoHandle } */
    this.srcDmabufFd;
    /** @type { !number } */
    this.srcSize;
    /** @type { !number } */
    this.srcOffset;
    /** @type { !chromeosCamera_mojom_DmaBufVideoFrame } */
    this.dstFrame;
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParamsSpec.$,
    'MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        DecodeErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_DecodeWithDmaBuf_ResponseParams {
  constructor() {
    /** @type { !DecodeError } */
    this.error;
  }
}



mojo.internal.Struct(
    MjpegDecodeAccelerator_Uninitialize_ParamsSpec.$,
    'MjpegDecodeAccelerator_Uninitialize_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MjpegDecodeAccelerator_Uninitialize_Params {
  constructor() {
  }
}

