// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$,getRequiredElement}from"chrome://resources/js/util.js";import{HistoryClustersInternalsBrowserProxy}from"./history_clusters_internals_browser_proxy.js";const logMessages=[];function dumpFileWithJsonContents(contents,filename){const blob=new Blob([contents],{type:"application/json"});const url=URL.createObjectURL(blob);const a=document.createElement("a");a.setAttribute("href",url);a.setAttribute("download",filename);a.click()}function onLogMessagesDump(){const data=logMessages.join("\n");dumpFileWithJsonContents(data,"history_clusters_internals_logs_dump.json")}function onContextClustersDumpRequest(){getProxy().getHandler().getContextClustersJson().then(onContextClustersJsonReady)}function onContextClustersJsonReady(resp){const data=resp.contextClustersJson;const filename="history_context_clusters_dump.json";dumpFileWithJsonContents(data,filename)}function getProxy(){return HistoryClustersInternalsBrowserProxy.getInstance()}function onPrintKeywordBagState(){getProxy().getHandler().printKeywordBagStateToLogMessages()}function initialize(){const logMessageContainer=$("log-message-container");getRequiredElement("log-messages-dump").addEventListener("click",onLogMessagesDump);getRequiredElement("context-clusters-dump").addEventListener("click",onContextClustersDumpRequest);getRequiredElement("print-keyword-bag-state").addEventListener("click",onPrintKeywordBagState);getProxy().getCallbackRouter().onLogMessageAdded.addListener((message=>{logMessages.push(message);if(logMessageContainer){const logmessage=logMessageContainer.insertRow();const cell=logmessage.insertCell();cell.innerHTML=window.trustedTypes.emptyHTML;const pre=document.createElement("pre");pre.textContent=message;cell.appendChild(pre)}}))}document.addEventListener("DOMContentLoaded",initialize);