// components/ip_protection/mojom/core.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  ProxyChain as network_mojom_ProxyChain,
  ProxyChainSpec as network_mojom_ProxyChainSpec
} from '../../../services/network/public/mojom/network_param.mojom.m.js';

import {
  CoreControlTestRemote as ipProtection_mojom_CoreControlTestRemote,
  CoreControlTestPendingReceiver as ipProtection_mojom_CoreControlTestPendingReceiver
} from './core_test.mojom.m.js';

import {
  ProxyLayer as ipProtection_mojom_ProxyLayer,
  ProxyLayerSpec as ipProtection_mojom_ProxyLayerSpec,
  BlindSignedAuthToken as ipProtection_mojom_BlindSignedAuthToken,
  BlindSignedAuthTokenSpec as ipProtection_mojom_BlindSignedAuthTokenSpec,
  GeoHint as ipProtection_mojom_GeoHint,
  GeoHintSpec as ipProtection_mojom_GeoHintSpec,
  TryGetProbabilisticRevealTokensOutcome as ipProtection_mojom_TryGetProbabilisticRevealTokensOutcome,
  TryGetProbabilisticRevealTokensOutcomeSpec as ipProtection_mojom_TryGetProbabilisticRevealTokensOutcomeSpec,
  TryGetProbabilisticRevealTokensResult as ipProtection_mojom_TryGetProbabilisticRevealTokensResult,
  TryGetProbabilisticRevealTokensResultSpec as ipProtection_mojom_TryGetProbabilisticRevealTokensResultSpec
} from './data_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CoreControlPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ip_protection.mojom.CoreControl', scope);
  }
}

/** @interface */
export class CoreControlInterface {
  
  /**
   */

  authTokensMayBeAvailable() {}
  
  /**
   * @param { !boolean } value
   */

  setIpProtectionEnabled(value) {}
  
  /**
   * @param { !ipProtection_mojom_CoreControlTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(receiver) {}
}

/**
 * @implements { CoreControlInterface }
 */
export class CoreControlRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CoreControlPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CoreControlPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CoreControlPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  authTokensMayBeAvailable() {
    this.proxy.sendMessage(
        0,
        CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  setIpProtectionEnabled(
      value) {
    this.proxy.sendMessage(
        1,
        CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !ipProtection_mojom_CoreControlTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(
      receiver) {
    this.proxy.sendMessage(
        2,
        CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CoreControl
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CoreControlReceiver {
  /**
   * @param {!CoreControlInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CoreControlRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CoreControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoreControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
        null,
        impl.authTokensMayBeAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
        null,
        impl.setIpProtectionEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        impl.bindTestInterfaceForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CoreControl {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ip_protection.mojom.CoreControl";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CoreControlRemote}
   */
  static getRemote() {
    let remote = new CoreControlRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CoreControl
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CoreControlCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CoreControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoreControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.authTokensMayBeAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
        null,
        this.authTokensMayBeAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIpProtectionEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
        null,
        this.setIpProtectionEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindTestInterfaceForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        this.bindTestInterfaceForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CoreHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ip_protection.mojom.CoreHost', scope);
  }
}

/** @interface */
export class CoreHostInterface {
  
  /**
   * @param { !number } batchSize
   * @param { !ipProtection_mojom_ProxyLayer } proxyLayer
   * @return {!Promise<{
        bsaTokens: ?Array<!ipProtection_mojom_BlindSignedAuthToken>,
        tryAgainAfter: ?mojoBase_mojom_Time,
   *  }>}
   */

  tryGetAuthTokens(batchSize, proxyLayer) {}
  
  /**
   * @return {!Promise<{
        proxyList: ?Array<!network_mojom_ProxyChain>,
        geoHint: ?ipProtection_mojom_GeoHint,
   *  }>}
   */

  getProxyConfig() {}
  
  /**
   * @return {!Promise<{
        outcome: ?ipProtection_mojom_TryGetProbabilisticRevealTokensOutcome,
        result: !ipProtection_mojom_TryGetProbabilisticRevealTokensResult,
   *  }>}
   */

  tryGetProbabilisticRevealTokens() {}
  
  /**
   * @param { !ipProtection_mojom_ProxyLayer } proxyLayer
   * @param { !Array<!ipProtection_mojom_BlindSignedAuthToken> } tokens
   */

  recycleTokens(proxyLayer, tokens) {}
}

/**
 * @implements { CoreHostInterface }
 */
export class CoreHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CoreHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CoreHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CoreHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } batchSize
   * @param { !ipProtection_mojom_ProxyLayer } proxyLayer
   * @return {!Promise<{
        bsaTokens: ?Array<!ipProtection_mojom_BlindSignedAuthToken>,
        tryAgainAfter: ?mojoBase_mojom_Time,
   *  }>}
   */

  tryGetAuthTokens(
      batchSize,
      proxyLayer) {
    return this.proxy.sendMessage(
        0,
        CoreHost_TryGetAuthTokens_ParamsSpec.$,
        CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
        [
          batchSize,
          proxyLayer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        proxyList: ?Array<!network_mojom_ProxyChain>,
        geoHint: ?ipProtection_mojom_GeoHint,
   *  }>}
   */

  getProxyConfig() {
    return this.proxy.sendMessage(
        1,
        CoreHost_GetProxyConfig_ParamsSpec.$,
        CoreHost_GetProxyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        outcome: ?ipProtection_mojom_TryGetProbabilisticRevealTokensOutcome,
        result: !ipProtection_mojom_TryGetProbabilisticRevealTokensResult,
   *  }>}
   */

  tryGetProbabilisticRevealTokens() {
    return this.proxy.sendMessage(
        2,
        CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
        CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !ipProtection_mojom_ProxyLayer } proxyLayer
   * @param { !Array<!ipProtection_mojom_BlindSignedAuthToken> } tokens
   */

  recycleTokens(
      proxyLayer,
      tokens) {
    this.proxy.sendMessage(
        3,
        CoreHost_RecycleTokens_ParamsSpec.$,
        null,
        [
          proxyLayer,
          tokens
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CoreHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CoreHostReceiver {
  /**
   * @param {!CoreHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CoreHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CoreHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoreHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CoreHost_TryGetAuthTokens_ParamsSpec.$,
        CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
        impl.tryGetAuthTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CoreHost_GetProxyConfig_ParamsSpec.$,
        CoreHost_GetProxyConfig_ResponseParamsSpec.$,
        impl.getProxyConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
        CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
        impl.tryGetProbabilisticRevealTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CoreHost_RecycleTokens_ParamsSpec.$,
        null,
        impl.recycleTokens.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CoreHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ip_protection.mojom.CoreHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CoreHostRemote}
   */
  static getRemote() {
    let remote = new CoreHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CoreHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CoreHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CoreHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoreHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.tryGetAuthTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CoreHost_TryGetAuthTokens_ParamsSpec.$,
        CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
        this.tryGetAuthTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getProxyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CoreHost_GetProxyConfig_ParamsSpec.$,
        CoreHost_GetProxyConfig_ResponseParamsSpec.$,
        this.getProxyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.tryGetProbabilisticRevealTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
        CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
        this.tryGetProbabilisticRevealTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recycleTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CoreHost_RecycleTokens_ParamsSpec.$,
        null,
        this.recycleTokens.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControl_AuthTokensMayBeAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControl_SetIpProtectionEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControl_BindTestInterfaceForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_TryGetAuthTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_TryGetAuthTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_GetProxyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_GetProxyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreHost_RecycleTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
    'CoreControl_AuthTokensMayBeAvailable_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CoreControl_AuthTokensMayBeAvailable_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
    'CoreControl_SetIpProtectionEnabled_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreControl_SetIpProtectionEnabled_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
    'CoreControl_BindTestInterfaceForTesting_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ipProtection_mojom_CoreControlTestPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreControl_BindTestInterfaceForTesting_Params {
  constructor() {
    /** @type { !ipProtection_mojom_CoreControlTestPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    CoreHost_TryGetAuthTokens_ParamsSpec.$,
    'CoreHost_TryGetAuthTokens_Params',
    [
      mojo.internal.StructField(
        'batchSize', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyLayer', 4,
        0,
        ipProtection_mojom_ProxyLayerSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreHost_TryGetAuthTokens_Params {
  constructor() {
    /** @type { !number } */
    this.batchSize;
    /** @type { !ipProtection_mojom_ProxyLayer } */
    this.proxyLayer;
  }
}



mojo.internal.Struct(
    CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
    'CoreHost_TryGetAuthTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'bsaTokens', 0,
        0,
        mojo.internal.Array(ipProtection_mojom_BlindSignedAuthTokenSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tryAgainAfter', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoreHost_TryGetAuthTokens_ResponseParams {
  constructor() {
    /** @type { (Array<!ipProtection_mojom_BlindSignedAuthToken>|undefined) } */
    this.bsaTokens;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.tryAgainAfter;
  }
}



mojo.internal.Struct(
    CoreHost_GetProxyConfig_ParamsSpec.$,
    'CoreHost_GetProxyConfig_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CoreHost_GetProxyConfig_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CoreHost_GetProxyConfig_ResponseParamsSpec.$,
    'CoreHost_GetProxyConfig_ResponseParams',
    [
      mojo.internal.StructField(
        'proxyList', 0,
        0,
        mojo.internal.Array(network_mojom_ProxyChainSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'geoHint', 8,
        0,
        ipProtection_mojom_GeoHintSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoreHost_GetProxyConfig_ResponseParams {
  constructor() {
    /** @type { (Array<!network_mojom_ProxyChain>|undefined) } */
    this.proxyList;
    /** @type { (ipProtection_mojom_GeoHint|undefined) } */
    this.geoHint;
  }
}



mojo.internal.Struct(
    CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
    'CoreHost_TryGetProbabilisticRevealTokens_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CoreHost_TryGetProbabilisticRevealTokens_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
    'CoreHost_TryGetProbabilisticRevealTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        ipProtection_mojom_TryGetProbabilisticRevealTokensOutcomeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        ipProtection_mojom_TryGetProbabilisticRevealTokensResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoreHost_TryGetProbabilisticRevealTokens_ResponseParams {
  constructor() {
    /** @type { (ipProtection_mojom_TryGetProbabilisticRevealTokensOutcome|undefined) } */
    this.outcome;
    /** @type { !ipProtection_mojom_TryGetProbabilisticRevealTokensResult } */
    this.result;
  }
}



mojo.internal.Struct(
    CoreHost_RecycleTokens_ParamsSpec.$,
    'CoreHost_RecycleTokens_Params',
    [
      mojo.internal.StructField(
        'proxyLayer', 0,
        0,
        ipProtection_mojom_ProxyLayerSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tokens', 8,
        0,
        mojo.internal.Array(ipProtection_mojom_BlindSignedAuthTokenSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoreHost_RecycleTokens_Params {
  constructor() {
    /** @type { !ipProtection_mojom_ProxyLayer } */
    this.proxyLayer;
    /** @type { !Array<!ipProtection_mojom_BlindSignedAuthToken> } */
    this.tokens;
  }
}

