// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"./policy_precedence_row.js";import"./policy_row.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{getRequiredElement}from"chrome://resources/js/util.js";import{getTemplate}from"./policy_table.html.js";var SortButtonsField;(function(SortButtonsField){SortButtonsField["POLICY_NAME"]="name";SortButtonsField["POLICY_SOURCE"]="source";SortButtonsField["POLICY_SCOPE"]="scope";SortButtonsField["POLICY_LEVEL"]="level";SortButtonsField["POLICY_STATUS"]="status"})(SortButtonsField||(SortButtonsField={}));var SortOrder;(function(SortOrder){SortOrder[SortOrder["ASCENDING"]=1]="ASCENDING";SortOrder[SortOrder["DESCENDING"]=-1]="DESCENDING"})(SortOrder||(SortOrder={}));export class PolicyTableElement extends CustomElement{static get template(){return getTemplate()}dataModel;filterPattern="";mostRecentSortOrder=SortOrder.ASCENDING;mostRecentSortedColumn=SortButtonsField.POLICY_NAME;updateDataModel(dataModel){this.dataModel=dataModel;this.update()}addEventListeners(){for(const field of Object.values(SortButtonsField)){const sortUpButton=this.getRequiredElement(`#${field}-sort-up`);const sortDownButton=this.getRequiredElement(`#${field}-sort-down`);sortUpButton.onclick=()=>this.update(SortOrder.ASCENDING,field);sortDownButton.onclick=()=>this.update(SortOrder.DESCENDING,field)}}update(order=this.mostRecentSortOrder,field=this.mostRecentSortedColumn){for(const column of Object.values(SortButtonsField)){const sortHeader=this.getRequiredElement(`.${column}`);if(column===field){const sortOrder=order===SortOrder.ASCENDING?"ascending":"descending";sortHeader.setAttribute("aria-sort",sortOrder)}else{sortHeader.setAttribute("aria-sort","none")}}const mainContent=this.getRequiredElement(".main");const policies=this.shadowRoot.querySelectorAll(".policy-data");this.getRequiredElement(".header").textContent=this.dataModel.name;this.getRequiredElement(".id").textContent=this.dataModel.id||null;this.getRequiredElement(".id").hidden=!this.dataModel.id;policies.forEach((row=>mainContent.removeChild(row)));this.dataModel.policies.sort(((a,b)=>{this.mostRecentSortOrder=order;this.mostRecentSortedColumn=field;if(a.value!==undefined&&b.value!==undefined||a.value===b.value){if(a.link!==undefined&&b.link!==undefined){if(field!==SortButtonsField.POLICY_NAME&&a[field]===b[field]){return order*(a[SortButtonsField.POLICY_NAME]>b[SortButtonsField.POLICY_NAME]?1:-1)}return order*(a[field]>b[field]?1:-1)}return a.link!==undefined?-1:1}return a.value!==undefined?-1:1})).forEach((policy=>{const policyRow=document.createElement("policy-row");policyRow.initialize(policy);mainContent.appendChild(policyRow)}));this.filter();if(this.dataModel.name==="Policy Precedence"){const precedenceRowOld=this.shadowRoot.querySelectorAll(".policy-precedence-data");precedenceRowOld.forEach((row=>mainContent.removeChild(row)));if(this.dataModel.precedenceOrder!=null){const precedenceRow=document.createElement("policy-precedence-row");precedenceRow.initialize(this.dataModel.precedenceOrder);mainContent.appendChild(precedenceRow)}}}setFilterPattern(pattern){this.filterPattern=pattern.toLowerCase();this.filter()}filter(){const showUnset=getRequiredElement("show-unset").checked;const policies=this.shadowRoot.querySelectorAll(".policy-data");for(let i=0;i<policies.length;i++){const policyDisplay=policies[i];policyDisplay.hidden=policyDisplay.policy.value===undefined&&!showUnset||policyDisplay.policy.name.toLowerCase().indexOf(this.filterPattern)===-1}this.getRequiredElement(".no-policy").hidden=!!this.shadowRoot.querySelector(".policy-data:not([hidden])")}}customElements.define("policy-table",PolicyTableElement);