// content/test/data/web_ui_ts_test.test-mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { MappedDictSpec as content_mojom_MappedDictSpec } from './web_ui_ts_test_other_types.test-mojom-webui.js';
import { StringWrapperRemote as content_mojom_StringWrapperRemote, TsCacheItemSpec as content_mojom_TsCacheItemSpec } from './web_ui_ts_test_types.test-mojom-webui.js';
import { JsErrorSpec as mojoBase_mojom_JsErrorSpec } from '//resources/mojo/mojo/public/mojom/base/jserror.mojom-webui.js';
import { JSTimeSpec as mojoBase_mojom_JSTimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import { SimpleMappedTypeDataView, } from './web_ui_ts_test.test-mojom-converters.js';
import { OptionalTypemapDataView, } from './web_ui_ts_test.test-mojom-converters.js';
import { NestedMappedTypeDataView, } from './web_ui_ts_test.test-mojom-converters.js';
import { StringDictDataView, } from './web_ui_ts_test.test-mojom-converters.js';
import { TypeWithNestedEnumDataView, } from './web_ui_ts_test.test-mojom-converters.js';
import { SimpleTypeConverter } from './web_ui_mojo_ts_test_simple_converter.js';
import { OptionalTypemapConverter } from './web_ui_mojo_ts_test_converters.js';
import { NestedTypeConverter } from './web_ui_mojo_ts_test_converters.js';
import { StringDictConverter } from './web_ui_mojo_ts_test_converters.js';
import { TypeWithNestedEnumConverter } from './web_ui_mojo_ts_test_converters.js';
export const TestEnumSpec = { $: mojo.internal.Enum() };
export var TestEnum;
(function (TestEnum) {
    TestEnum[TestEnum["MIN_VALUE"] = 0] = "MIN_VALUE";
    TestEnum[TestEnum["MAX_VALUE"] = 1] = "MAX_VALUE";
    TestEnum[TestEnum["kOne"] = 0] = "kOne";
    TestEnum[TestEnum["kTwo"] = 1] = "kTwo";
})(TestEnum || (TestEnum = {}));
export const TypemappedEnumSpec = { $: mojo.internal.Enum() };
export var TypemappedEnum;
(function (TypemappedEnum) {
    TypemappedEnum[TypemappedEnum["MIN_VALUE"] = 0] = "MIN_VALUE";
    TypemappedEnum[TypemappedEnum["MAX_VALUE"] = 1] = "MAX_VALUE";
    TypemappedEnum[TypemappedEnum["kNothing"] = 0] = "kNothing";
    TypemappedEnum[TypemappedEnum["kSomething"] = 1] = "kSomething";
})(TypemappedEnum || (TypemappedEnum = {}));
export class TestAssociatedClientPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'content.mojom.TestAssociatedClient', scope);
    }
}
export class TestAssociatedClientRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TestAssociatedClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    blockUntilBound() {
        this.proxy.sendMessage(0, TestAssociatedClient_BlockUntilBound_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the TestAssociatedClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TestAssociatedClientReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TestAssociatedClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TestAssociatedClient_BlockUntilBound_ParamsSpec.$, null, impl.blockUntilBound.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TestAssociatedClient {
    static get $interfaceName() {
        return "content.mojom.TestAssociatedClient";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TestAssociatedClientRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TestAssociatedClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TestAssociatedClientCallbackRouter {
    helper_internal_;
    $;
    router_;
    blockUntilBound;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TestAssociatedClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.blockUntilBound =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TestAssociatedClient_BlockUntilBound_ParamsSpec.$, null, this.blockUntilBound.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class WebUITsMojoTestCachePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'content.mojom.WebUITsMojoTestCache', scope);
    }
}
export class WebUITsMojoTestCacheRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WebUITsMojoTestCachePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    put(url, contents) {
        this.proxy.sendMessage(0, WebUITsMojoTestCache_Put_ParamsSpec.$, null, [
            url,
            contents
        ], false);
    }
    getAll() {
        return this.proxy.sendMessage(1, WebUITsMojoTestCache_GetAll_ParamsSpec.$, WebUITsMojoTestCache_GetAll_ResponseParamsSpec.$, [], false);
    }
    echo(optionalBool, optionalUint8, optionalEnum, optionalNumerics, optionalBools, optionalInts, optionalEnums, boolMap, intMap, enumMap, simpleMappedType, nestedMappedType, otherMappedType) {
        return this.proxy.sendMessage(2, WebUITsMojoTestCache_Echo_ParamsSpec.$, WebUITsMojoTestCache_Echo_ResponseParamsSpec.$, [
            optionalBool,
            optionalUint8,
            optionalEnum,
            optionalNumerics,
            optionalBools,
            optionalInts,
            optionalEnums,
            boolMap,
            intMap,
            enumMap,
            simpleMappedType,
            nestedMappedType,
            otherMappedType
        ], false);
    }
    echoTypemaps(time, token) {
        return this.proxy.sendMessage(3, WebUITsMojoTestCache_EchoTypemaps_ParamsSpec.$, WebUITsMojoTestCache_EchoTypemaps_ResponseParamsSpec.$, [
            time,
            token
        ], false);
    }
    echoOptionalTypemaps(container) {
        return this.proxy.sendMessage(4, WebUITsMojoTestCache_EchoOptionalTypemaps_ParamsSpec.$, WebUITsMojoTestCache_EchoOptionalTypemaps_ResponseParamsSpec.$, [
            container
        ], false);
    }
    addStringWrapper(stringWrapper) {
        this.proxy.sendMessage(5, WebUITsMojoTestCache_AddStringWrapper_ParamsSpec.$, null, [
            stringWrapper
        ], false);
    }
    getStringWrapperList() {
        return this.proxy.sendMessage(6, WebUITsMojoTestCache_GetStringWrapperList_ParamsSpec.$, WebUITsMojoTestCache_GetStringWrapperList_ResponseParamsSpec.$, [], false);
    }
    getAssociatedReceiver() {
        return this.proxy.sendMessage(7, WebUITsMojoTestCache_GetAssociatedReceiver_ParamsSpec.$, WebUITsMojoTestCache_GetAssociatedReceiver_ResponseParamsSpec.$, [], false);
    }
    ping() {
        return this.proxy.sendMessage(8, WebUITsMojoTestCache_Ping_ParamsSpec.$, WebUITsMojoTestCache_Ping_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the WebUITsMojoTestCache
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebUITsMojoTestCacheReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebUITsMojoTestCacheRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WebUITsMojoTestCache_Put_ParamsSpec.$, null, impl.put.bind(impl), false);
        this.helper_internal_.registerHandler(1, WebUITsMojoTestCache_GetAll_ParamsSpec.$, WebUITsMojoTestCache_GetAll_ResponseParamsSpec.$, impl.getAll.bind(impl), false);
        this.helper_internal_.registerHandler(2, WebUITsMojoTestCache_Echo_ParamsSpec.$, WebUITsMojoTestCache_Echo_ResponseParamsSpec.$, impl.echo.bind(impl), false);
        this.helper_internal_.registerHandler(3, WebUITsMojoTestCache_EchoTypemaps_ParamsSpec.$, WebUITsMojoTestCache_EchoTypemaps_ResponseParamsSpec.$, impl.echoTypemaps.bind(impl), false);
        this.helper_internal_.registerHandler(4, WebUITsMojoTestCache_EchoOptionalTypemaps_ParamsSpec.$, WebUITsMojoTestCache_EchoOptionalTypemaps_ResponseParamsSpec.$, impl.echoOptionalTypemaps.bind(impl), false);
        this.helper_internal_.registerHandler(5, WebUITsMojoTestCache_AddStringWrapper_ParamsSpec.$, null, impl.addStringWrapper.bind(impl), false);
        this.helper_internal_.registerHandler(6, WebUITsMojoTestCache_GetStringWrapperList_ParamsSpec.$, WebUITsMojoTestCache_GetStringWrapperList_ResponseParamsSpec.$, impl.getStringWrapperList.bind(impl), false);
        this.helper_internal_.registerHandler(7, WebUITsMojoTestCache_GetAssociatedReceiver_ParamsSpec.$, WebUITsMojoTestCache_GetAssociatedReceiver_ResponseParamsSpec.$, impl.getAssociatedReceiver.bind(impl), false);
        this.helper_internal_.registerHandler(8, WebUITsMojoTestCache_Ping_ParamsSpec.$, WebUITsMojoTestCache_Ping_ResponseParamsSpec.$, impl.ping.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WebUITsMojoTestCache {
    static get $interfaceName() {
        return "content.mojom.WebUITsMojoTestCache";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WebUITsMojoTestCacheRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WebUITsMojoTestCache
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebUITsMojoTestCacheCallbackRouter {
    helper_internal_;
    $;
    router_;
    put;
    getAll;
    echo;
    echoTypemaps;
    echoOptionalTypemaps;
    addStringWrapper;
    getStringWrapperList;
    getAssociatedReceiver;
    ping;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebUITsMojoTestCacheRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.put =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WebUITsMojoTestCache_Put_ParamsSpec.$, null, this.put.createReceiverHandler(false /* expectsResponse */), false);
        this.getAll =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WebUITsMojoTestCache_GetAll_ParamsSpec.$, WebUITsMojoTestCache_GetAll_ResponseParamsSpec.$, this.getAll.createReceiverHandler(true /* expectsResponse */), false);
        this.echo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WebUITsMojoTestCache_Echo_ParamsSpec.$, WebUITsMojoTestCache_Echo_ResponseParamsSpec.$, this.echo.createReceiverHandler(true /* expectsResponse */), false);
        this.echoTypemaps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WebUITsMojoTestCache_EchoTypemaps_ParamsSpec.$, WebUITsMojoTestCache_EchoTypemaps_ResponseParamsSpec.$, this.echoTypemaps.createReceiverHandler(true /* expectsResponse */), false);
        this.echoOptionalTypemaps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WebUITsMojoTestCache_EchoOptionalTypemaps_ParamsSpec.$, WebUITsMojoTestCache_EchoOptionalTypemaps_ResponseParamsSpec.$, this.echoOptionalTypemaps.createReceiverHandler(true /* expectsResponse */), false);
        this.addStringWrapper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WebUITsMojoTestCache_AddStringWrapper_ParamsSpec.$, null, this.addStringWrapper.createReceiverHandler(false /* expectsResponse */), false);
        this.getStringWrapperList =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WebUITsMojoTestCache_GetStringWrapperList_ParamsSpec.$, WebUITsMojoTestCache_GetStringWrapperList_ResponseParamsSpec.$, this.getStringWrapperList.createReceiverHandler(true /* expectsResponse */), false);
        this.getAssociatedReceiver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, WebUITsMojoTestCache_GetAssociatedReceiver_ParamsSpec.$, WebUITsMojoTestCache_GetAssociatedReceiver_ResponseParamsSpec.$, this.getAssociatedReceiver.createReceiverHandler(true /* expectsResponse */), false);
        this.ping =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, WebUITsMojoTestCache_Ping_ParamsSpec.$, WebUITsMojoTestCache_Ping_ResponseParamsSpec.$, this.ping.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MojoResultTestPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'content.mojom.MojoResultTest', scope);
    }
}
export class MojoResultTestRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MojoResultTestPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    testResult() {
        return this.proxy.sendMessage(0, MojoResultTest_TestResult_ParamsSpec.$, MojoResultTest_TestResult_ResponseParamsSpec.$, [], true);
    }
}
;
/**
 * An object which receives request messages for the MojoResultTest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MojoResultTestReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MojoResultTestRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MojoResultTest_TestResult_ParamsSpec.$, MojoResultTest_TestResult_ResponseParamsSpec.$, impl.testResult.bind(impl), true);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MojoResultTest {
    static get $interfaceName() {
        return "content.mojom.MojoResultTest";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MojoResultTestRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MojoResultTest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MojoResultTestCallbackRouter {
    helper_internal_;
    $;
    router_;
    testResult;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MojoResultTestRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.testResult =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MojoResultTest_TestResult_ParamsSpec.$, MojoResultTest_TestResult_ResponseParamsSpec.$, this.testResult.createReceiverHandler(true /* expectsResponse */), true);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TestMoreTypemapPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'content.mojom.TestMoreTypemap', scope);
    }
}
export class TestMoreTypemapRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TestMoreTypemapPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    testNestedEnum(req) {
        return this.proxy.sendMessage(0, TestMoreTypemap_TestNestedEnum_ParamsSpec.$, TestMoreTypemap_TestNestedEnum_ResponseParamsSpec.$, [
            req
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TestMoreTypemap
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TestMoreTypemapReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TestMoreTypemapRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TestMoreTypemap_TestNestedEnum_ParamsSpec.$, TestMoreTypemap_TestNestedEnum_ResponseParamsSpec.$, impl.testNestedEnum.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TestMoreTypemap {
    static get $interfaceName() {
        return "content.mojom.TestMoreTypemap";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TestMoreTypemapRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TestMoreTypemap
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TestMoreTypemapCallbackRouter {
    helper_internal_;
    $;
    router_;
    testNestedEnum;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TestMoreTypemapRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.testNestedEnum =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TestMoreTypemap_TestNestedEnum_ParamsSpec.$, TestMoreTypemap_TestNestedEnum_ResponseParamsSpec.$, this.testNestedEnum.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const OptionalNumericsStructSpec = { $: {} };
export const SimpleMappedTypeSpec = { $: {} };
export const OptionalTypemapSpec = { $: {} };
export const NestedMappedTypeSpec = { $: {} };
export const StringDictSpec = { $: {} };
export const ResultSpec = { $: {} };
export const TypeWithNestedEnumSpec = { $: {} };
export const TestAssociatedClient_BlockUntilBound_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_Put_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_GetAll_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_GetAll_ResponseParamsSpec = { $: {} };
export const WebUITsMojoTestCache_Echo_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_Echo_ResponseParamsSpec = { $: {} };
export const WebUITsMojoTestCache_EchoTypemaps_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_EchoTypemaps_ResponseParamsSpec = { $: {} };
export const WebUITsMojoTestCache_EchoOptionalTypemaps_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_EchoOptionalTypemaps_ResponseParamsSpec = { $: {} };
export const WebUITsMojoTestCache_AddStringWrapper_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_GetStringWrapperList_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_GetStringWrapperList_ResponseParamsSpec = { $: {} };
export const WebUITsMojoTestCache_GetAssociatedReceiver_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_GetAssociatedReceiver_ResponseParamsSpec = { $: {} };
export const WebUITsMojoTestCache_Ping_ParamsSpec = { $: {} };
export const WebUITsMojoTestCache_Ping_ResponseParamsSpec = { $: {} };
export const MojoResultTest_TestResult_ParamsSpec = { $: {} };
export const MojoResultTest_TestResult_ResponseParamsSpec = { $: {} };
export const TestMoreTypemap_TestNestedEnum_ParamsSpec = { $: {} };
export const TestMoreTypemap_TestNestedEnum_ResponseParamsSpec = { $: {} };
export const UnionSpec = { $: {} };
export const ExtensibleUnionSpec = { $: {} };
export const MojoResultTest_TestResult_ResponseParam_ResultSpec = { $: {} };
mojo.internal.Struct(OptionalNumericsStructSpec.$, 'OptionalNumericsStruct', [
    mojo.internal.StructField('optional_bool_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_bool_$value",
        originalFieldName: "optionalBool",
    }, undefined),
    mojo.internal.StructField('optional_bool_$value', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalBool",
    }, undefined),
    mojo.internal.StructField('optional_uint8_$flag', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_uint8_$value",
        originalFieldName: "optionalUint8",
    }, undefined),
    mojo.internal.StructField('optional_uint8_$value', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalUint8",
    }, undefined),
    mojo.internal.StructField('optional_enum_$flag', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_enum_$value",
        originalFieldName: "optionalEnum",
    }, undefined),
    mojo.internal.StructField('optional_enum_$value', 4, 0, TestEnumSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalEnum",
    }, undefined),
], [[0, 16],]);
const converterForSimpleMappedType = new SimpleTypeConverter();
mojo.internal.TypemappedStruct(SimpleMappedTypeSpec.$, 'SimpleMappedType', SimpleMappedTypeDataView, converterForSimpleMappedType, [
    mojo.internal.StructField('value', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, ((value) => converterForSimpleMappedType.value(value))),
], [[0, 16],]);
const converterForOptionalTypemap = new OptionalTypemapConverter();
mojo.internal.TypemappedStruct(OptionalTypemapSpec.$, 'OptionalTypemap', OptionalTypemapDataView, converterForOptionalTypemap, [
    mojo.internal.StructField('optional_int_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_int_$value",
        originalFieldName: "optionalInt",
    }, ((value) => converterForOptionalTypemap.optionalInt(value) !== null)),
    mojo.internal.StructField('optional_int_$value', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalInt",
    }, ((value) => converterForOptionalTypemap.optionalInt(value))),
    mojo.internal.StructField('bools', 8, 0, mojo.internal.Array(mojo.internal.Bool, true), null, false /* nullable */, 0, undefined, ((value) => converterForOptionalTypemap.bools(value))),
    mojo.internal.StructField('optionalMap', 16, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.Bool, true), null, false /* nullable */, 0, undefined, ((value) => converterForOptionalTypemap.optionalMap(value))),
], [[0, 32],]);
const converterForNestedMappedType = new NestedTypeConverter();
mojo.internal.TypemappedStruct(NestedMappedTypeSpec.$, 'NestedMappedType', NestedMappedTypeDataView, converterForNestedMappedType, [
    mojo.internal.StructField('nested', 0, 0, NestedMappedTypeSpec.$, null, true /* nullable */, 0, undefined, ((value) => converterForNestedMappedType.nested(value))),
], [[0, 16],]);
const converterForStringDict = new StringDictConverter();
mojo.internal.TypemappedStruct(StringDictSpec.$, 'StringDict', StringDictDataView, converterForStringDict, [
    mojo.internal.StructField('data', 0, 0, content_mojom_MappedDictSpec.$, null, false /* nullable */, 0, undefined, ((value) => converterForStringDict.data(value))),
], [[0, 16],]);
mojo.internal.Struct(ResultSpec.$, 'Result', [
    mojo.internal.StructField('secretMessage', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
export const TypeWithNestedEnum_EnumSpec = { $: mojo.internal.Enum() };
export var TypeWithNestedEnum_Enum;
(function (TypeWithNestedEnum_Enum) {
    TypeWithNestedEnum_Enum[TypeWithNestedEnum_Enum["MIN_VALUE"] = 0] = "MIN_VALUE";
    TypeWithNestedEnum_Enum[TypeWithNestedEnum_Enum["MAX_VALUE"] = 1] = "MAX_VALUE";
    TypeWithNestedEnum_Enum[TypeWithNestedEnum_Enum["kWhatever"] = 0] = "kWhatever";
    TypeWithNestedEnum_Enum[TypeWithNestedEnum_Enum["kToTest"] = 1] = "kToTest";
})(TypeWithNestedEnum_Enum || (TypeWithNestedEnum_Enum = {}));
const converterForTypeWithNestedEnum = new TypeWithNestedEnumConverter();
mojo.internal.TypemappedStruct(TypeWithNestedEnumSpec.$, 'TypeWithNestedEnum', TypeWithNestedEnumDataView, converterForTypeWithNestedEnum, [
    mojo.internal.StructField('someField', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, ((value) => converterForTypeWithNestedEnum.someField(value))),
], [[0, 16],]);
mojo.internal.Struct(TestAssociatedClient_BlockUntilBound_ParamsSpec.$, 'TestAssociatedClient_BlockUntilBound_Params', [], [[0, 8],]);
mojo.internal.Struct(WebUITsMojoTestCache_Put_ParamsSpec.$, 'WebUITsMojoTestCache_Put_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contents', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebUITsMojoTestCache_GetAll_ParamsSpec.$, 'WebUITsMojoTestCache_GetAll_Params', [], [[0, 8],]);
mojo.internal.Struct(WebUITsMojoTestCache_GetAll_ResponseParamsSpec.$, 'WebUITsMojoTestCache_GetAll_ResponseParams', [
    mojo.internal.StructField('items', 0, 0, mojo.internal.Array(content_mojom_TsCacheItemSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebUITsMojoTestCache_Echo_ParamsSpec.$, 'WebUITsMojoTestCache_Echo_Params', [
    mojo.internal.StructField('optional_bool_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_bool_$value",
        originalFieldName: "optionalBool",
    }, undefined),
    mojo.internal.StructField('optional_bool_$value', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalBool",
    }, undefined),
    mojo.internal.StructField('optional_uint8_$flag', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_uint8_$value",
        originalFieldName: "optionalUint8",
    }, undefined),
    mojo.internal.StructField('optional_uint8_$value', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalUint8",
    }, undefined),
    mojo.internal.StructField('optional_enum_$flag', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_enum_$value",
        originalFieldName: "optionalEnum",
    }, undefined),
    mojo.internal.StructField('optional_enum_$value', 4, 0, TestEnumSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalEnum",
    }, undefined),
    mojo.internal.StructField('optionalNumerics', 8, 0, OptionalNumericsStructSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optionalBools', 16, 0, mojo.internal.Array(mojo.internal.Bool, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optionalInts', 24, 0, mojo.internal.Array(mojo.internal.Uint32, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optionalEnums', 32, 0, mojo.internal.Array(TestEnumSpec.$, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('boolMap', 40, 0, mojo.internal.Map(mojo.internal.Int32, mojo.internal.Bool, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('intMap', 48, 0, mojo.internal.Map(mojo.internal.Int32, mojo.internal.Int32, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enumMap', 56, 0, mojo.internal.Map(mojo.internal.Int32, TestEnumSpec.$, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('simpleMappedType', 64, 0, SimpleMappedTypeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nestedMappedType', 72, 0, NestedMappedTypeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('otherMappedType', 80, 0, StringDictSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 96],]);
mojo.internal.Struct(WebUITsMojoTestCache_Echo_ResponseParamsSpec.$, 'WebUITsMojoTestCache_Echo_ResponseParams', [
    mojo.internal.StructField('optional_bool_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_bool_$value",
        originalFieldName: "optionalBool",
    }, undefined),
    mojo.internal.StructField('optional_bool_$value', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalBool",
    }, undefined),
    mojo.internal.StructField('optional_uint8_$flag', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_uint8_$value",
        originalFieldName: "optionalUint8",
    }, undefined),
    mojo.internal.StructField('optional_uint8_$value', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalUint8",
    }, undefined),
    mojo.internal.StructField('optional_enum_$flag', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "optional_enum_$value",
        originalFieldName: "optionalEnum",
    }, undefined),
    mojo.internal.StructField('optional_enum_$value', 4, 0, TestEnumSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "optionalEnum",
    }, undefined),
    mojo.internal.StructField('optionalNumerics', 8, 0, OptionalNumericsStructSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optionalBools', 16, 0, mojo.internal.Array(mojo.internal.Bool, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optionalInts', 24, 0, mojo.internal.Array(mojo.internal.Uint32, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optionalEnums', 32, 0, mojo.internal.Array(TestEnumSpec.$, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('boolMap', 40, 0, mojo.internal.Map(mojo.internal.Int32, mojo.internal.Bool, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('intMap', 48, 0, mojo.internal.Map(mojo.internal.Int32, mojo.internal.Int32, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enumMap', 56, 0, mojo.internal.Map(mojo.internal.Int32, TestEnumSpec.$, true), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('simpleMappedType', 64, 0, SimpleMappedTypeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nestedMappedType', 72, 0, NestedMappedTypeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('otherMappedType', 80, 0, StringDictSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 96],]);
mojo.internal.Struct(WebUITsMojoTestCache_EchoTypemaps_ParamsSpec.$, 'WebUITsMojoTestCache_EchoTypemaps_Params', [
    mojo.internal.StructField('time', 0, 0, mojoBase_mojom_JSTimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('token', 8, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebUITsMojoTestCache_EchoTypemaps_ResponseParamsSpec.$, 'WebUITsMojoTestCache_EchoTypemaps_ResponseParams', [
    mojo.internal.StructField('time', 0, 0, mojoBase_mojom_JSTimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('token', 8, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebUITsMojoTestCache_EchoOptionalTypemaps_ParamsSpec.$, 'WebUITsMojoTestCache_EchoOptionalTypemaps_Params', [
    mojo.internal.StructField('container', 0, 0, OptionalTypemapSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebUITsMojoTestCache_EchoOptionalTypemaps_ResponseParamsSpec.$, 'WebUITsMojoTestCache_EchoOptionalTypemaps_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, OptionalTypemapSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebUITsMojoTestCache_AddStringWrapper_ParamsSpec.$, 'WebUITsMojoTestCache_AddStringWrapper_Params', [
    mojo.internal.StructField('stringWrapper', 0, 0, mojo.internal.InterfaceProxy(content_mojom_StringWrapperRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebUITsMojoTestCache_GetStringWrapperList_ParamsSpec.$, 'WebUITsMojoTestCache_GetStringWrapperList_Params', [], [[0, 8],]);
mojo.internal.Struct(WebUITsMojoTestCache_GetStringWrapperList_ResponseParamsSpec.$, 'WebUITsMojoTestCache_GetStringWrapperList_ResponseParams', [
    mojo.internal.StructField('stringWrapperList', 0, 0, mojo.internal.Array(mojo.internal.InterfaceProxy(content_mojom_StringWrapperRemote), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebUITsMojoTestCache_GetAssociatedReceiver_ParamsSpec.$, 'WebUITsMojoTestCache_GetAssociatedReceiver_Params', [], [[0, 8],]);
mojo.internal.Struct(WebUITsMojoTestCache_GetAssociatedReceiver_ResponseParamsSpec.$, 'WebUITsMojoTestCache_GetAssociatedReceiver_ResponseParams', [
    mojo.internal.StructField('client', 0, 0, mojo.internal.AssociatedInterfaceRequest(TestAssociatedClientPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebUITsMojoTestCache_Ping_ParamsSpec.$, 'WebUITsMojoTestCache_Ping_Params', [], [[0, 8],]);
mojo.internal.Struct(WebUITsMojoTestCache_Ping_ResponseParamsSpec.$, 'WebUITsMojoTestCache_Ping_ResponseParams', [
    mojo.internal.StructField('ping', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MojoResultTest_TestResult_ParamsSpec.$, 'MojoResultTest_TestResult_Params', [], [[0, 8],]);
mojo.internal.Struct(MojoResultTest_TestResult_ResponseParamsSpec.$, 'MojoResultTest_TestResult_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, MojoResultTest_TestResult_ResponseParam_ResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(TestMoreTypemap_TestNestedEnum_ParamsSpec.$, 'TestMoreTypemap_TestNestedEnum_Params', [
    mojo.internal.StructField('req', 0, 0, TypeWithNestedEnumSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TestMoreTypemap_TestNestedEnum_ResponseParamsSpec.$, 'TestMoreTypemap_TestNestedEnum_ResponseParams', [
    mojo.internal.StructField('res', 0, 0, TypeWithNestedEnumSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(UnionSpec.$, 'Union', {
    'one': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
    },
    'two': {
        'ordinal': 1,
        'type': mojo.internal.Uint64,
    },
    'three': {
        'ordinal': 2,
        'type': mojo.internal.String,
    },
});
export var UnionFieldTags;
(function (UnionFieldTags) {
    UnionFieldTags[UnionFieldTags["ONE"] = 0] = "ONE";
    UnionFieldTags[UnionFieldTags["TWO"] = 1] = "TWO";
    UnionFieldTags[UnionFieldTags["THREE"] = 2] = "THREE";
})(UnionFieldTags || (UnionFieldTags = {}));
export function whichUnion(u) {
    if (u.one !== null && u.one !== undefined) {
        return UnionFieldTags.ONE;
    }
    if (u.two !== null && u.two !== undefined) {
        return UnionFieldTags.TWO;
    }
    if (u.three !== null && u.three !== undefined) {
        return UnionFieldTags.THREE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(ExtensibleUnionSpec.$, 'ExtensibleUnion', {
    'foo': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
    },
});
export var ExtensibleUnionFieldTags;
(function (ExtensibleUnionFieldTags) {
    ExtensibleUnionFieldTags[ExtensibleUnionFieldTags["FOO"] = 0] = "FOO";
})(ExtensibleUnionFieldTags || (ExtensibleUnionFieldTags = {}));
export function whichExtensibleUnion(u) {
    if (u.foo !== null && u.foo !== undefined) {
        return ExtensibleUnionFieldTags.FOO;
    }
    return ExtensibleUnionFieldTags.FOO;
}
mojo.internal.Union(MojoResultTest_TestResult_ResponseParam_ResultSpec.$, 'MojoResultTest_TestResult_ResponseParam_Result', {
    'success': {
        'ordinal': 0,
        'type': ResultSpec.$,
    },
    'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_JsErrorSpec.$,
    },
});
export var MojoResultTest_TestResult_ResponseParam_ResultFieldTags;
(function (MojoResultTest_TestResult_ResponseParam_ResultFieldTags) {
    MojoResultTest_TestResult_ResponseParam_ResultFieldTags[MojoResultTest_TestResult_ResponseParam_ResultFieldTags["SUCCESS"] = 0] = "SUCCESS";
    MojoResultTest_TestResult_ResponseParam_ResultFieldTags[MojoResultTest_TestResult_ResponseParam_ResultFieldTags["FAILURE"] = 1] = "FAILURE";
})(MojoResultTest_TestResult_ResponseParam_ResultFieldTags || (MojoResultTest_TestResult_ResponseParam_ResultFieldTags = {}));
export function whichMojoResultTest_TestResult_ResponseParam_Result(u) {
    if (u.success !== null && u.success !== undefined) {
        return MojoResultTest_TestResult_ResponseParam_ResultFieldTags.SUCCESS;
    }
    if (u.failure !== null && u.failure !== undefined) {
        return MojoResultTest_TestResult_ResponseParam_ResultFieldTags.FAILURE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
