// content/web_test/common/web_test.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('content.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.WebTestRenderFramePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.WebTestRenderFrame.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { content.mojom.WebTestRenderFrameInterface }
 */
content.mojom.WebTestRenderFrameRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.WebTestRenderFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.WebTestRenderFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.WebTestRenderFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise}
   */

  synchronouslyCompositeAfterTest() {
    return this.proxy.sendMessage(
        0,
        content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
        content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        frameLayoutDump: !string,
   *  }>}
   */

  dumpFrameLayout() {
    return this.proxy.sendMessage(
        1,
        content.mojom.WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
        content.mojom.WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.WebTestRunTestConfiguration } config
   * @param { !boolean } startingTest
   */

  setTestConfiguration(
      config,
      startingTest) {
    this.proxy.sendMessage(
        2,
        content.mojom.WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
        null,
        [
          config,
          startingTest
        ],
        false);
  }

  
  /**
   */

  onDeactivated() {
    this.proxy.sendMessage(
        3,
        content.mojom.WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onReactivated() {
    this.proxy.sendMessage(
        4,
        content.mojom.WebTestRenderFrame_OnReactivated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  blockTestUntilStart() {
    this.proxy.sendMessage(
        5,
        content.mojom.WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  startTest() {
    this.proxy.sendMessage(
        6,
        content.mojom.WebTestRenderFrame_StartTest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setupRendererProcessForNonTestWindow() {
    this.proxy.sendMessage(
        7,
        content.mojom.WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.DictionaryValue } changedLayoutTestRuntimeFlags
   */

  replicateWebTestRuntimeFlagsChanges(
      changedLayoutTestRuntimeFlags) {
    this.proxy.sendMessage(
        8,
        content.mojom.WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
        null,
        [
          changedLayoutTestRuntimeFlags
        ],
        false);
  }

  
  /**
   */

  testFinishedFromSecondaryRenderer() {
    this.proxy.sendMessage(
        9,
        content.mojom.WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resetRendererAfterWebTest() {
    this.proxy.sendMessage(
        10,
        content.mojom.WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.WorkItem } workItem
   */

  processWorkItem(
      workItem) {
    this.proxy.sendMessage(
        11,
        content.mojom.WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
        null,
        [
          workItem
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.DictionaryValue } workQueueStates
   */

  replicateWorkQueueStates(
      workQueueStates) {
    this.proxy.sendMessage(
        12,
        content.mojom.WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
        null,
        [
          workQueueStates
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebTestRenderFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.WebTestRenderFrameReceiver = class {
  /**
   * @param {!content.mojom.WebTestRenderFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.WebTestRenderFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.WebTestRenderFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.WebTestRenderFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
        content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
        impl.synchronouslyCompositeAfterTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        content.mojom.WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
        content.mojom.WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
        impl.dumpFrameLayout.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        content.mojom.WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
        null,
        impl.setTestConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        content.mojom.WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
        null,
        impl.onDeactivated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        content.mojom.WebTestRenderFrame_OnReactivated_ParamsSpec.$,
        null,
        impl.onReactivated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        content.mojom.WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
        null,
        impl.blockTestUntilStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        content.mojom.WebTestRenderFrame_StartTest_ParamsSpec.$,
        null,
        impl.startTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        content.mojom.WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
        null,
        impl.setupRendererProcessForNonTestWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        content.mojom.WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
        null,
        impl.replicateWebTestRuntimeFlagsChanges.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        content.mojom.WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
        null,
        impl.testFinishedFromSecondaryRenderer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        content.mojom.WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
        null,
        impl.resetRendererAfterWebTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        content.mojom.WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
        null,
        impl.processWorkItem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        content.mojom.WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
        null,
        impl.replicateWorkQueueStates.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.WebTestRenderFrame = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.WebTestRenderFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.WebTestRenderFrameRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.WebTestRenderFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebTestRenderFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.WebTestRenderFrameCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.WebTestRenderFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.WebTestRenderFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.synchronouslyCompositeAfterTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
        content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
        this.synchronouslyCompositeAfterTest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dumpFrameLayout =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        content.mojom.WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
        content.mojom.WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
        this.dumpFrameLayout.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTestConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        content.mojom.WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
        null,
        this.setTestConfiguration.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeactivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        content.mojom.WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
        null,
        this.onDeactivated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReactivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        content.mojom.WebTestRenderFrame_OnReactivated_ParamsSpec.$,
        null,
        this.onReactivated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blockTestUntilStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        content.mojom.WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
        null,
        this.blockTestUntilStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        content.mojom.WebTestRenderFrame_StartTest_ParamsSpec.$,
        null,
        this.startTest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupRendererProcessForNonTestWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        content.mojom.WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
        null,
        this.setupRendererProcessForNonTestWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replicateWebTestRuntimeFlagsChanges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        content.mojom.WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
        null,
        this.replicateWebTestRuntimeFlagsChanges.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.testFinishedFromSecondaryRenderer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        content.mojom.WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
        null,
        this.testFinishedFromSecondaryRenderer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetRendererAfterWebTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        content.mojom.WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
        null,
        this.resetRendererAfterWebTest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processWorkItem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        content.mojom.WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
        null,
        this.processWorkItem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replicateWorkQueueStates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        content.mojom.WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
        null,
        this.replicateWorkQueueStates.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.WebTestControlHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.WebTestControlHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { content.mojom.WebTestControlHostInterface }
 */
content.mojom.WebTestControlHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.WebTestControlHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.WebTestControlHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.WebTestControlHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !content.mojom.WebTestRendererDumpResult } result
   * @param { !boolean } captureNavigationHistory
   * @param { !boolean } capturePixels
   */

  initiateCaptureDump(
      result,
      captureNavigationHistory,
      capturePixels) {
    this.proxy.sendMessage(
        0,
        content.mojom.WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
        null,
        [
          result,
          captureNavigationHistory,
          capturePixels
        ],
        false);
  }

  
  /**
   */

  testFinishedInSecondaryRenderer() {
    this.proxy.sendMessage(
        1,
        content.mojom.WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } message
   */

  printMessageToStderr(
      message) {
    this.proxy.sendMessage(
        2,
        content.mojom.WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !string } message
   */

  printMessage(
      message) {
    this.proxy.sendMessage(
        3,
        content.mojom.WebTestControlHost_PrintMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebPreferences } webPreferences
   */

  overridePreferences(
      webPreferences) {
    this.proxy.sendMessage(
        4,
        content.mojom.WebTestControlHost_OverridePreferences_ParamsSpec.$,
        null,
        [
          webPreferences
        ],
        false);
  }

  
  /**
   */

  reload() {
    this.proxy.sendMessage(
        5,
        content.mojom.WebTestControlHost_Reload_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  checkForLeakedWindows() {
    this.proxy.sendMessage(
        6,
        content.mojom.WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } hidden
   */

  setMainWindowHidden(
      hidden) {
    this.proxy.sendMessage(
        7,
        content.mojom.WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
        null,
        [
          hidden
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.LocalFrameToken } frameToken
   * @param { !boolean } hidden
   */

  setFrameWindowHidden(
      frameToken,
      hidden) {
    this.proxy.sendMessage(
        8,
        content.mojom.WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
        null,
        [
          frameToken,
          hidden
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   */

  goToOffset(
      offset) {
    this.proxy.sendMessage(
        9,
        content.mojom.WebTestControlHost_GoToOffset_ParamsSpec.$,
        null,
        [
          offset
        ],
        false);
  }

  
  /**
   * @param { !string } event
   * @param { !string } argument
   */

  sendBluetoothManualChooserEvent(
      event,
      argument) {
    this.proxy.sendMessage(
        10,
        content.mojom.WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
        null,
        [
          event,
          argument
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  setBluetoothManualChooser(
      enable) {
    this.proxy.sendMessage(
        11,
        content.mojom.WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        events: !Array<!string>,
   *  }>}
   */

  getBluetoothManualChooserEvents() {
    return this.proxy.sendMessage(
        12,
        content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
        content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } blockPopups
   */

  setPopupBlockingEnabled(
      blockPopups) {
    this.proxy.sendMessage(
        13,
        content.mojom.WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
        null,
        [
          blockPopups
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } frameName
   */

  loadURLForFrame(
      url,
      frameName) {
    this.proxy.sendMessage(
        14,
        content.mojom.WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
        null,
        [
          url,
          frameName
        ],
        false);
  }

  
  /**
   */

  simulateScreenOrientationChanged() {
    this.proxy.sendMessage(
        15,
        content.mojom.WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink.mojom.PermissionStatus } status
   * @param { !url.mojom.Url } origin
   * @param { !url.mojom.Url } embeddingOrigin
   */

  setPermission(
      name,
      status,
      origin,
      embeddingOrigin) {
    this.proxy.sendMessage(
        16,
        content.mojom.WebTestControlHost_SetPermission_ParamsSpec.$,
        null,
        [
          name,
          status,
          origin,
          embeddingOrigin
        ],
        false);
  }

  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(
      block) {
    this.proxy.sendMessage(
        17,
        content.mojom.WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        [
          block
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        path: !mojoBase.mojom.FilePath,
   *  }>}
   */

  getWritableDirectory() {
    return this.proxy.sendMessage(
        18,
        content.mojom.WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
        content.mojom.WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   */

  setFilePathForMockFileDialog(
      path) {
    this.proxy.sendMessage(
        19,
        content.mojom.WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
        null,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } disallowedSuffixes
   * @return {!Promise<{
        file: !mojoBase.mojom.File,
   *  }>}
   */

  createSubresourceFilterRulesetFile(
      disallowedSuffixes) {
    return this.proxy.sendMessage(
        20,
        content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
        content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
        [
          disallowedSuffixes
        ],
        false);
  }

  
  /**
   */

  focusDevtoolsSecondaryWindow() {
    this.proxy.sendMessage(
        21,
        content.mojom.WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(
      rawCommitments) {
    return this.proxy.sendMessage(
        22,
        content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
        content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        [
          rawCommitments
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  clearTrustTokenState() {
    return this.proxy.sendMessage(
        23,
        content.mojom.WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
        content.mojom.WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } title
   * @param { !number } actionIndex
   * @param { ?mojoBase.mojom.String16 } reply
   */

  simulateWebNotificationClick(
      title,
      actionIndex,
      reply) {
    this.proxy.sendMessage(
        24,
        content.mojom.WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
        null,
        [
          title,
          actionIndex,
          reply
        ],
        false);
  }

  
  /**
   * @param { !string } title
   * @param { !boolean } byUser
   */

  simulateWebNotificationClose(
      title,
      byUser) {
    this.proxy.sendMessage(
        25,
        content.mojom.WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
        null,
        [
          title,
          byUser
        ],
        false);
  }

  
  /**
   * @param { !string } id
   */

  simulateWebContentIndexDelete(
      id) {
    this.proxy.sendMessage(
        26,
        content.mojom.WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.DictionaryValue } changedWebTestRuntimeFlags
   */

  webTestRuntimeFlagsChanged(
      changedWebTestRuntimeFlags) {
    this.proxy.sendMessage(
        27,
        content.mojom.WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
        null,
        [
          changedWebTestRuntimeFlags
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase.mojom.FilePath> } filePaths
   * @return {!Promise<{
        filesystemId: !string,
   *  }>}
   */

  registerIsolatedFileSystem(
      filePaths) {
    return this.proxy.sendMessage(
        28,
        content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
        content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
        [
          filePaths
        ],
        false);
  }

  
  /**
   */

  dropPointerLock() {
    this.proxy.sendMessage(
        29,
        content.mojom.WebTestControlHost_DropPointerLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setPointerLockWillFail() {
    this.proxy.sendMessage(
        30,
        content.mojom.WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setPointerLockWillRespondAsynchronously() {
    this.proxy.sendMessage(
        31,
        content.mojom.WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  allowPointerLock() {
    this.proxy.sendMessage(
        32,
        content.mojom.WebTestControlHost_AllowPointerLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.WorkItem } workItem
   */

  workItemAdded(
      workItem) {
    this.proxy.sendMessage(
        33,
        content.mojom.WebTestControlHost_WorkItemAdded_ParamsSpec.$,
        null,
        [
          workItem
        ],
        false);
  }

  
  /**
   */

  requestWorkItem() {
    this.proxy.sendMessage(
        34,
        content.mojom.WebTestControlHost_RequestWorkItem_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.DictionaryValue } changedWorkQueueStates
   */

  workQueueStatesChanged(
      changedWorkQueueStates) {
    this.proxy.sendMessage(
        35,
        content.mojom.WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
        null,
        [
          changedWorkQueueStates
        ],
        false);
  }

  
  /**
   * @param { !string } acceptLanguages
   */

  setAcceptLanguages(
      acceptLanguages) {
    this.proxy.sendMessage(
        36,
        content.mojom.WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
        null,
        [
          acceptLanguages
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.WebTestControlHost_AutoResponseMode } mode
   */

  setRegisterProtocolHandlerMode(
      mode) {
    this.proxy.sendMessage(
        37,
        content.mojom.WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } minSize
   * @param { !gfx.mojom.Size } maxSize
   */

  enableAutoResize(
      minSize,
      maxSize) {
    this.proxy.sendMessage(
        38,
        content.mojom.WebTestControlHost_EnableAutoResize_ParamsSpec.$,
        null,
        [
          minSize,
          maxSize
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } newSize
   */

  disableAutoResize(
      newSize) {
    this.proxy.sendMessage(
        39,
        content.mojom.WebTestControlHost_DisableAutoResize_ParamsSpec.$,
        null,
        [
          newSize
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebTestControlHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.WebTestControlHostReceiver = class {
  /**
   * @param {!content.mojom.WebTestControlHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.WebTestControlHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.WebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.WebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
        null,
        impl.initiateCaptureDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        content.mojom.WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
        null,
        impl.testFinishedInSecondaryRenderer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        content.mojom.WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
        null,
        impl.printMessageToStderr.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        content.mojom.WebTestControlHost_PrintMessage_ParamsSpec.$,
        null,
        impl.printMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        content.mojom.WebTestControlHost_OverridePreferences_ParamsSpec.$,
        null,
        impl.overridePreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        content.mojom.WebTestControlHost_Reload_ParamsSpec.$,
        null,
        impl.reload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        content.mojom.WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
        null,
        impl.checkForLeakedWindows.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        content.mojom.WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
        null,
        impl.setMainWindowHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        content.mojom.WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
        null,
        impl.setFrameWindowHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        content.mojom.WebTestControlHost_GoToOffset_ParamsSpec.$,
        null,
        impl.goToOffset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        content.mojom.WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
        null,
        impl.sendBluetoothManualChooserEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        content.mojom.WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
        null,
        impl.setBluetoothManualChooser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
        content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
        impl.getBluetoothManualChooserEvents.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        content.mojom.WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
        null,
        impl.setPopupBlockingEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        content.mojom.WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
        null,
        impl.loadURLForFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        content.mojom.WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
        null,
        impl.simulateScreenOrientationChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        content.mojom.WebTestControlHost_SetPermission_ParamsSpec.$,
        null,
        impl.setPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        content.mojom.WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        impl.blockThirdPartyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        content.mojom.WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
        content.mojom.WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
        impl.getWritableDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        content.mojom.WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
        null,
        impl.setFilePathForMockFileDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
        content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
        impl.createSubresourceFilterRulesetFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        content.mojom.WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
        null,
        impl.focusDevtoolsSecondaryWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
        content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        impl.setTrustTokenKeyCommitments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        content.mojom.WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
        content.mojom.WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
        impl.clearTrustTokenState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        content.mojom.WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
        null,
        impl.simulateWebNotificationClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        content.mojom.WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
        null,
        impl.simulateWebNotificationClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        content.mojom.WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
        null,
        impl.simulateWebContentIndexDelete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        content.mojom.WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
        null,
        impl.webTestRuntimeFlagsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
        content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
        impl.registerIsolatedFileSystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        content.mojom.WebTestControlHost_DropPointerLock_ParamsSpec.$,
        null,
        impl.dropPointerLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        content.mojom.WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
        null,
        impl.setPointerLockWillFail.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        content.mojom.WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
        null,
        impl.setPointerLockWillRespondAsynchronously.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        content.mojom.WebTestControlHost_AllowPointerLock_ParamsSpec.$,
        null,
        impl.allowPointerLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        content.mojom.WebTestControlHost_WorkItemAdded_ParamsSpec.$,
        null,
        impl.workItemAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        content.mojom.WebTestControlHost_RequestWorkItem_ParamsSpec.$,
        null,
        impl.requestWorkItem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        content.mojom.WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
        null,
        impl.workQueueStatesChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        content.mojom.WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
        null,
        impl.setAcceptLanguages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        content.mojom.WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
        null,
        impl.setRegisterProtocolHandlerMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        content.mojom.WebTestControlHost_EnableAutoResize_ParamsSpec.$,
        null,
        impl.enableAutoResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        content.mojom.WebTestControlHost_DisableAutoResize_ParamsSpec.$,
        null,
        impl.disableAutoResize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.WebTestControlHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.WebTestControlHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.WebTestControlHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.WebTestControlHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
content.mojom.WebTestControlHost.AutoResponseModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
content.mojom.WebTestControlHost_AutoResponseMode = {
  
  kNone: 0,
  kAutoAccept: 1,
  kAutoReject: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the WebTestControlHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.WebTestControlHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.WebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.WebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initiateCaptureDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
        null,
        this.initiateCaptureDump.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.testFinishedInSecondaryRenderer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        content.mojom.WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
        null,
        this.testFinishedInSecondaryRenderer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.printMessageToStderr =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        content.mojom.WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
        null,
        this.printMessageToStderr.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.printMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        content.mojom.WebTestControlHost_PrintMessage_ParamsSpec.$,
        null,
        this.printMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.overridePreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        content.mojom.WebTestControlHost_OverridePreferences_ParamsSpec.$,
        null,
        this.overridePreferences.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        content.mojom.WebTestControlHost_Reload_ParamsSpec.$,
        null,
        this.reload.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.checkForLeakedWindows =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        content.mojom.WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
        null,
        this.checkForLeakedWindows.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMainWindowHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        content.mojom.WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
        null,
        this.setMainWindowHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameWindowHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        content.mojom.WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
        null,
        this.setFrameWindowHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.goToOffset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        content.mojom.WebTestControlHost_GoToOffset_ParamsSpec.$,
        null,
        this.goToOffset.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendBluetoothManualChooserEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        content.mojom.WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
        null,
        this.sendBluetoothManualChooserEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBluetoothManualChooser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        content.mojom.WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
        null,
        this.setBluetoothManualChooser.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBluetoothManualChooserEvents =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
        content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
        this.getBluetoothManualChooserEvents.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPopupBlockingEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        content.mojom.WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
        null,
        this.setPopupBlockingEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadURLForFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        content.mojom.WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
        null,
        this.loadURLForFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateScreenOrientationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        content.mojom.WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
        null,
        this.simulateScreenOrientationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        content.mojom.WebTestControlHost_SetPermission_ParamsSpec.$,
        null,
        this.setPermission.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blockThirdPartyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        content.mojom.WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        this.blockThirdPartyCookies.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWritableDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        content.mojom.WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
        content.mojom.WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
        this.getWritableDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFilePathForMockFileDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        content.mojom.WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
        null,
        this.setFilePathForMockFileDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSubresourceFilterRulesetFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
        content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
        this.createSubresourceFilterRulesetFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusDevtoolsSecondaryWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        content.mojom.WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
        null,
        this.focusDevtoolsSecondaryWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrustTokenKeyCommitments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
        content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        this.setTrustTokenKeyCommitments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTrustTokenState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        content.mojom.WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
        content.mojom.WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
        this.clearTrustTokenState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateWebNotificationClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        content.mojom.WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
        null,
        this.simulateWebNotificationClick.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateWebNotificationClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        content.mojom.WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
        null,
        this.simulateWebNotificationClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateWebContentIndexDelete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        content.mojom.WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
        null,
        this.simulateWebContentIndexDelete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.webTestRuntimeFlagsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        content.mojom.WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
        null,
        this.webTestRuntimeFlagsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerIsolatedFileSystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
        content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
        this.registerIsolatedFileSystem.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dropPointerLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        content.mojom.WebTestControlHost_DropPointerLock_ParamsSpec.$,
        null,
        this.dropPointerLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPointerLockWillFail =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        content.mojom.WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
        null,
        this.setPointerLockWillFail.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPointerLockWillRespondAsynchronously =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        content.mojom.WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
        null,
        this.setPointerLockWillRespondAsynchronously.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowPointerLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        content.mojom.WebTestControlHost_AllowPointerLock_ParamsSpec.$,
        null,
        this.allowPointerLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.workItemAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        content.mojom.WebTestControlHost_WorkItemAdded_ParamsSpec.$,
        null,
        this.workItemAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestWorkItem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        content.mojom.WebTestControlHost_RequestWorkItem_ParamsSpec.$,
        null,
        this.requestWorkItem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.workQueueStatesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        content.mojom.WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
        null,
        this.workQueueStatesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAcceptLanguages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        content.mojom.WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
        null,
        this.setAcceptLanguages.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRegisterProtocolHandlerMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        content.mojom.WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
        null,
        this.setRegisterProtocolHandlerMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        content.mojom.WebTestControlHost_EnableAutoResize_ParamsSpec.$,
        null,
        this.enableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        content.mojom.WebTestControlHost_DisableAutoResize_ParamsSpec.$,
        null,
        this.disableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.NonAssociatedWebTestControlHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.NonAssociatedWebTestControlHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { content.mojom.NonAssociatedWebTestControlHostInterface }
 */
content.mojom.NonAssociatedWebTestControlHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.NonAssociatedWebTestControlHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.NonAssociatedWebTestControlHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.NonAssociatedWebTestControlHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.LCPCriticalPathPredictorNavigationTimeHint } hint
   */

  setLCPPNavigationHint(
      hint) {
    this.proxy.sendMessage(
        0,
        content.mojom.NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
        null,
        [
          hint
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NonAssociatedWebTestControlHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.NonAssociatedWebTestControlHostReceiver = class {
  /**
   * @param {!content.mojom.NonAssociatedWebTestControlHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.NonAssociatedWebTestControlHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.NonAssociatedWebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.NonAssociatedWebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
        null,
        impl.setLCPPNavigationHint.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.NonAssociatedWebTestControlHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.NonAssociatedWebTestControlHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.NonAssociatedWebTestControlHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.NonAssociatedWebTestControlHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NonAssociatedWebTestControlHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.NonAssociatedWebTestControlHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.NonAssociatedWebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.NonAssociatedWebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLCPPNavigationHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
        null,
        this.setLCPPNavigationHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRunTestConfigurationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRendererDumpResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WorkItemBackForwardSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WorkItemLoadSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WorkItemReloadSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WorkItemLoadingScriptSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WorkItemNonLoadingScriptSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_DumpFrameLayout_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_SetTestConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_OnDeactivated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_OnReactivated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_BlockTestUntilStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_StartTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_ProcessWorkItem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_InitiateCaptureDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_PrintMessageToStderr_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_PrintMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_OverridePreferences_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_Reload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_CheckForLeakedWindows_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetMainWindowHidden_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetFrameWindowHidden_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_GoToOffset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetBluetoothManualChooser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_LoadURLForFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_BlockThirdPartyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_GetWritableDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_GetWritableDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_ClearTrustTokenState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SimulateWebNotificationClick_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SimulateWebNotificationClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_DropPointerLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetPointerLockWillFail_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_AllowPointerLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_WorkItemAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_RequestWorkItem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_WorkQueueStatesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetAcceptLanguages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_EnableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.WebTestControlHost_DisableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
content.mojom.WorkItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    content.mojom.WebTestRunTestConfigurationSpec.$,
    'WebTestRunTestConfiguration',
    [
      mojo.internal.StructField(
        'currentWorkingDirectory', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tempPath', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'testUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowExternalPages', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedPixelHash', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wptPrintMode', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocolMode', 24,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
content.mojom.WebTestRunTestConfiguration = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.currentWorkingDirectory;
    /** @export { !mojoBase.mojom.FilePath } */
    this.tempPath;
    /** @export { !url.mojom.Url } */
    this.testUrl;
    /** @export { !boolean } */
    this.allowExternalPages;
    /** @export { !string } */
    this.expectedPixelHash;
    /** @export { !boolean } */
    this.wptPrintMode;
    /** @export { !boolean } */
    this.protocolMode;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRendererDumpResultSpec.$,
    'WebTestRendererDumpResult',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layout', 8,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pixels', 16,
        0,
        skia.mojom.BitmapN32Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actualPixelHash', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectionRect', 32,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
content.mojom.WebTestRendererDumpResult = class {
  constructor() {
    /** @export { (Array<!number>|undefined) } */
    this.audio;
    /** @export { (mojoBase.mojom.ByteString|undefined) } */
    this.layout;
    /** @export { (skia.mojom.BitmapN32|undefined) } */
    this.pixels;
    /** @export { !string } */
    this.actualPixelHash;
    /** @export { !gfx.mojom.Rect } */
    this.selectionRect;
  }
};



mojo.internal.Struct(
    content.mojom.WorkItemBackForwardSpec.$,
    'WorkItemBackForward',
    [
      mojo.internal.StructField(
        'distance', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WorkItemBackForward = class {
  constructor() {
    /** @export { !number } */
    this.distance;
  }
};



mojo.internal.Struct(
    content.mojom.WorkItemLoadSpec.$,
    'WorkItemLoad',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'target', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WorkItemLoad = class {
  constructor() {
    /** @export { !string } */
    this.url;
    /** @export { !string } */
    this.target;
  }
};



mojo.internal.Struct(
    content.mojom.WorkItemReloadSpec.$,
    'WorkItemReload',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WorkItemReload = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WorkItemLoadingScriptSpec.$,
    'WorkItemLoadingScript',
    [
      mojo.internal.StructField(
        'script', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WorkItemLoadingScript = class {
  constructor() {
    /** @export { !string } */
    this.script;
  }
};



mojo.internal.Struct(
    content.mojom.WorkItemNonLoadingScriptSpec.$,
    'WorkItemNonLoadingScript',
    [
      mojo.internal.StructField(
        'script', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WorkItemNonLoadingScript = class {
  constructor() {
    /** @export { !string } */
    this.script;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
    'WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
    'WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
    'WebTestRenderFrame_DumpFrameLayout_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_DumpFrameLayout_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
    'WebTestRenderFrame_DumpFrameLayout_ResponseParams',
    [
      mojo.internal.StructField(
        'frameLayoutDump', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestRenderFrame_DumpFrameLayout_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.frameLayoutDump;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
    'WebTestRenderFrame_SetTestConfiguration_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        content.mojom.WebTestRunTestConfigurationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startingTest', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestRenderFrame_SetTestConfiguration_Params = class {
  constructor() {
    /** @export { !content.mojom.WebTestRunTestConfiguration } */
    this.config;
    /** @export { !boolean } */
    this.startingTest;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
    'WebTestRenderFrame_OnDeactivated_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_OnDeactivated_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_OnReactivated_ParamsSpec.$,
    'WebTestRenderFrame_OnReactivated_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_OnReactivated_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
    'WebTestRenderFrame_BlockTestUntilStart_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_BlockTestUntilStart_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_StartTest_ParamsSpec.$,
    'WebTestRenderFrame_StartTest_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_StartTest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
    'WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
    'WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params',
    [
      mojo.internal.StructField(
        'changedLayoutTestRuntimeFlags', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.changedLayoutTestRuntimeFlags;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
    'WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
    'WebTestRenderFrame_ResetRendererAfterWebTest_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestRenderFrame_ResetRendererAfterWebTest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
    'WebTestRenderFrame_ProcessWorkItem_Params',
    [
      mojo.internal.StructField(
        'workItem', 0,
        0,
        content.mojom.WorkItemSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestRenderFrame_ProcessWorkItem_Params = class {
  constructor() {
    /** @export { !content.mojom.WorkItem } */
    this.workItem;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
    'WebTestRenderFrame_ReplicateWorkQueueStates_Params',
    [
      mojo.internal.StructField(
        'workQueueStates', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestRenderFrame_ReplicateWorkQueueStates_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.workQueueStates;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
    'WebTestControlHost_InitiateCaptureDump_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        content.mojom.WebTestRendererDumpResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'captureNavigationHistory', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'capturePixels', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_InitiateCaptureDump_Params = class {
  constructor() {
    /** @export { !content.mojom.WebTestRendererDumpResult } */
    this.result;
    /** @export { !boolean } */
    this.captureNavigationHistory;
    /** @export { !boolean } */
    this.capturePixels;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
    'WebTestControlHost_TestFinishedInSecondaryRenderer_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_TestFinishedInSecondaryRenderer_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
    'WebTestControlHost_PrintMessageToStderr_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_PrintMessageToStderr_Params = class {
  constructor() {
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_PrintMessage_ParamsSpec.$,
    'WebTestControlHost_PrintMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_PrintMessage_Params = class {
  constructor() {
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_OverridePreferences_ParamsSpec.$,
    'WebTestControlHost_OverridePreferences_Params',
    [
      mojo.internal.StructField(
        'webPreferences', 0,
        0,
        blink.mojom.WebPreferencesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_OverridePreferences_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebPreferences } */
    this.webPreferences;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_Reload_ParamsSpec.$,
    'WebTestControlHost_Reload_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_Reload_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
    'WebTestControlHost_CheckForLeakedWindows_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_CheckForLeakedWindows_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
    'WebTestControlHost_SetMainWindowHidden_Params',
    [
      mojo.internal.StructField(
        'hidden', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetMainWindowHidden_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.hidden;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
    'WebTestControlHost_SetFrameWindowHidden_Params',
    [
      mojo.internal.StructField(
        'frameToken', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hidden', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_SetFrameWindowHidden_Params = class {
  constructor() {
    /** @export { !blink.mojom.LocalFrameToken } */
    this.frameToken;
    /** @export { !boolean } */
    this.hidden;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_GoToOffset_ParamsSpec.$,
    'WebTestControlHost_GoToOffset_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_GoToOffset_Params = class {
  constructor() {
    /** @export { !number } */
    this.offset;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
    'WebTestControlHost_SendBluetoothManualChooserEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'argument', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_SendBluetoothManualChooserEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.event;
    /** @export { !string } */
    this.argument;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
    'WebTestControlHost_SetBluetoothManualChooser_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetBluetoothManualChooser_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
    'WebTestControlHost_GetBluetoothManualChooserEvents_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
    'WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams',
    [
      mojo.internal.StructField(
        'events', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.events;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
    'WebTestControlHost_SetPopupBlockingEnabled_Params',
    [
      mojo.internal.StructField(
        'blockPopups', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetPopupBlockingEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.blockPopups;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
    'WebTestControlHost_LoadURLForFrame_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_LoadURLForFrame_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.frameName;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
    'WebTestControlHost_SimulateScreenOrientationChanged_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_SimulateScreenOrientationChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetPermission_ParamsSpec.$,
    'WebTestControlHost_SetPermission_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'embeddingOrigin', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
content.mojom.WebTestControlHost_SetPermission_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
    /** @export { !url.mojom.Url } */
    this.origin;
    /** @export { !url.mojom.Url } */
    this.embeddingOrigin;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
    'WebTestControlHost_BlockThirdPartyCookies_Params',
    [
      mojo.internal.StructField(
        'block', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_BlockThirdPartyCookies_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.block;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
    'WebTestControlHost_GetWritableDirectory_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_GetWritableDirectory_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
    'WebTestControlHost_GetWritableDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_GetWritableDirectory_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
    'WebTestControlHost_SetFilePathForMockFileDialog_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetFilePathForMockFileDialog_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
    'WebTestControlHost_CreateSubresourceFilterRulesetFile_Params',
    [
      mojo.internal.StructField(
        'disallowedSuffixes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.disallowedSuffixes;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
    'WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.File } */
    this.file;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
    'WebTestControlHost_FocusDevtoolsSecondaryWindow_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_FocusDevtoolsSecondaryWindow_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
    'WebTestControlHost_SetTrustTokenKeyCommitments_Params',
    [
      mojo.internal.StructField(
        'rawCommitments', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_Params = class {
  constructor() {
    /** @export { !string } */
    this.rawCommitments;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
    'WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
    'WebTestControlHost_ClearTrustTokenState_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_ClearTrustTokenState_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
    'WebTestControlHost_ClearTrustTokenState_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_ClearTrustTokenState_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
    'WebTestControlHost_SimulateWebNotificationClick_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actionIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reply', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
content.mojom.WebTestControlHost_SimulateWebNotificationClick_Params = class {
  constructor() {
    /** @export { !string } */
    this.title;
    /** @export { !number } */
    this.actionIndex;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.reply;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
    'WebTestControlHost_SimulateWebNotificationClose_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byUser', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_SimulateWebNotificationClose_Params = class {
  constructor() {
    /** @export { !string } */
    this.title;
    /** @export { !boolean } */
    this.byUser;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
    'WebTestControlHost_SimulateWebContentIndexDelete_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SimulateWebContentIndexDelete_Params = class {
  constructor() {
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
    'WebTestControlHost_WebTestRuntimeFlagsChanged_Params',
    [
      mojo.internal.StructField(
        'changedWebTestRuntimeFlags', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_WebTestRuntimeFlagsChanged_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.changedWebTestRuntimeFlags;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
    'WebTestControlHost_RegisterIsolatedFileSystem_Params',
    [
      mojo.internal.StructField(
        'filePaths', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.FilePathSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_Params = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.FilePath> } */
    this.filePaths;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
    'WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams',
    [
      mojo.internal.StructField(
        'filesystemId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.filesystemId;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_DropPointerLock_ParamsSpec.$,
    'WebTestControlHost_DropPointerLock_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_DropPointerLock_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
    'WebTestControlHost_SetPointerLockWillFail_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_SetPointerLockWillFail_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
    'WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_AllowPointerLock_ParamsSpec.$,
    'WebTestControlHost_AllowPointerLock_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_AllowPointerLock_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_WorkItemAdded_ParamsSpec.$,
    'WebTestControlHost_WorkItemAdded_Params',
    [
      mojo.internal.StructField(
        'workItem', 0,
        0,
        content.mojom.WorkItemSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_WorkItemAdded_Params = class {
  constructor() {
    /** @export { !content.mojom.WorkItem } */
    this.workItem;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_RequestWorkItem_ParamsSpec.$,
    'WebTestControlHost_RequestWorkItem_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.WebTestControlHost_RequestWorkItem_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
    'WebTestControlHost_WorkQueueStatesChanged_Params',
    [
      mojo.internal.StructField(
        'changedWorkQueueStates', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_WorkQueueStatesChanged_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.changedWorkQueueStates;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
    'WebTestControlHost_SetAcceptLanguages_Params',
    [
      mojo.internal.StructField(
        'acceptLanguages', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetAcceptLanguages_Params = class {
  constructor() {
    /** @export { !string } */
    this.acceptLanguages;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
    'WebTestControlHost_SetRegisterProtocolHandlerMode_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        content.mojom.WebTestControlHost.AutoResponseModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_SetRegisterProtocolHandlerMode_Params = class {
  constructor() {
    /** @export { !content.mojom.WebTestControlHost_AutoResponseMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_EnableAutoResize_ParamsSpec.$,
    'WebTestControlHost_EnableAutoResize_Params',
    [
      mojo.internal.StructField(
        'minSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.WebTestControlHost_EnableAutoResize_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.minSize;
    /** @export { !gfx.mojom.Size } */
    this.maxSize;
  }
};



mojo.internal.Struct(
    content.mojom.WebTestControlHost_DisableAutoResize_ParamsSpec.$,
    'WebTestControlHost_DisableAutoResize_Params',
    [
      mojo.internal.StructField(
        'newSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.WebTestControlHost_DisableAutoResize_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.newSize;
  }
};



mojo.internal.Struct(
    content.mojom.NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
    'NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params',
    [
      mojo.internal.StructField(
        'hint', 0,
        0,
        blink.mojom.LCPCriticalPathPredictorNavigationTimeHintSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params = class {
  constructor() {
    /** @export { !blink.mojom.LCPCriticalPathPredictorNavigationTimeHint } */
    this.hint;
  }
};



mojo.internal.Union(
    content.mojom.WorkItemSpec.$, 'WorkItem',
    {
      'backForward': {
        'ordinal': 0,
        'type': content.mojom.WorkItemBackForwardSpec.$,
      },
      'load': {
        'ordinal': 1,
        'type': content.mojom.WorkItemLoadSpec.$,
      },
      'reload': {
        'ordinal': 2,
        'type': content.mojom.WorkItemReloadSpec.$,
      },
      'loadingScript': {
        'ordinal': 3,
        'type': content.mojom.WorkItemLoadingScriptSpec.$,
      },
      'nonLoadingScript': {
        'ordinal': 4,
        'type': content.mojom.WorkItemNonLoadingScriptSpec.$,
      },
    });

/**
 * @typedef { {
 *   backForward: (!content.mojom.WorkItemBackForward|undefined),
 *   load: (!content.mojom.WorkItemLoad|undefined),
 *   reload: (!content.mojom.WorkItemReload|undefined),
 *   loadingScript: (!content.mojom.WorkItemLoadingScript|undefined),
 *   nonLoadingScript: (!content.mojom.WorkItemNonLoadingScript|undefined),
 * } }
 */
content.mojom.WorkItem;
