// content/web_test/common/web_test.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'content/web_test/common/web_test.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('content.mojom');
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../mojo/public/mojom/base/file.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../skia/public/mojom/bitmap.mojom.js');
  }
  var lcp_critical_path_predictor$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom', '../../../third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.js');
  }
  var permission_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions/permission_status.mojom', '../../../third_party/blink/public/mojom/permissions/permission_status.mojom.js');
  }
  var web_preferences$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/webpreferences/web_preferences.mojom', '../../../third_party/blink/public/mojom/webpreferences/web_preferences.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../../../third_party/blink/public/mojom/tokens/tokens.mojom.js');
  }



  function WebTestRunTestConfiguration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRunTestConfiguration.prototype.initDefaults_ = function() {
    this.currentWorkingDirectory = null;
    this.tempPath = null;
    this.testUrl = null;
    this.allowExternalPages = false;
    this.wptPrintMode = false;
    this.protocolMode = false;
    this.expectedPixelHash = null;
  };
  WebTestRunTestConfiguration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRunTestConfiguration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRunTestConfiguration.currentWorkingDirectory
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRunTestConfiguration.tempPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRunTestConfiguration.testUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebTestRunTestConfiguration.expectedPixelHash
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTestRunTestConfiguration.encodedSize = codec.kStructHeaderSize + 40;

  WebTestRunTestConfiguration.decode = function(decoder) {
    var packed;
    var val = new WebTestRunTestConfiguration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currentWorkingDirectory =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.tempPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.testUrl =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.allowExternalPages = (packed >> 0) & 1 ? true : false;
    val.wptPrintMode = (packed >> 1) & 1 ? true : false;
    val.protocolMode = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.expectedPixelHash =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestRunTestConfiguration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRunTestConfiguration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.currentWorkingDirectory);
    encoder.encodeStructPointer(file_path$.FilePath, val.tempPath);
    encoder.encodeStructPointer(url$.Url, val.testUrl);
    packed = 0;
    packed |= (val.allowExternalPages & 1) << 0
    packed |= (val.wptPrintMode & 1) << 1
    packed |= (val.protocolMode & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.expectedPixelHash);
  };
  function WebTestRendererDumpResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRendererDumpResult.prototype.initDefaults_ = function() {
    this.audio = null;
    this.layout = null;
    this.pixels = null;
    this.actualPixelHash = null;
    this.selectionRect = null;
  };
  WebTestRendererDumpResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRendererDumpResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRendererDumpResult.audio
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRendererDumpResult.layout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, byte_string$.ByteString, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRendererDumpResult.pixels
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, bitmap$.BitmapN32, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRendererDumpResult.actualPixelHash
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRendererDumpResult.selectionRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRendererDumpResult.encodedSize = codec.kStructHeaderSize + 40;

  WebTestRendererDumpResult.decode = function(decoder) {
    var packed;
    var val = new WebTestRendererDumpResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audio =
        decoder.decodeArrayPointer(codec.Uint8);
    val.layout =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.pixels =
        decoder.decodeStructPointer(bitmap$.BitmapN32);
    val.actualPixelHash =
        decoder.decodeStruct(codec.String);
    val.selectionRect =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  WebTestRendererDumpResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRendererDumpResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.audio);
    encoder.encodeStructPointer(byte_string$.ByteString, val.layout);
    encoder.encodeStructPointer(bitmap$.BitmapN32, val.pixels);
    encoder.encodeStruct(codec.String, val.actualPixelHash);
    encoder.encodeStructPointer(geometry$.Rect, val.selectionRect);
  };
  function WorkItemBackForward(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkItemBackForward.prototype.initDefaults_ = function() {
    this.distance = 0;
  };
  WorkItemBackForward.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkItemBackForward.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WorkItemBackForward.encodedSize = codec.kStructHeaderSize + 8;

  WorkItemBackForward.decode = function(decoder) {
    var packed;
    var val = new WorkItemBackForward();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.distance =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WorkItemBackForward.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkItemBackForward.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.distance);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WorkItemLoad(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkItemLoad.prototype.initDefaults_ = function() {
    this.url = null;
    this.target = null;
  };
  WorkItemLoad.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkItemLoad.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkItemLoad.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkItemLoad.target
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WorkItemLoad.encodedSize = codec.kStructHeaderSize + 16;

  WorkItemLoad.decode = function(decoder) {
    var packed;
    var val = new WorkItemLoad();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStruct(codec.String);
    val.target =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WorkItemLoad.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkItemLoad.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.url);
    encoder.encodeStruct(codec.String, val.target);
  };
  function WorkItemReload(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkItemReload.prototype.initDefaults_ = function() {
  };
  WorkItemReload.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkItemReload.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WorkItemReload.encodedSize = codec.kStructHeaderSize + 0;

  WorkItemReload.decode = function(decoder) {
    var packed;
    var val = new WorkItemReload();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WorkItemReload.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkItemReload.encodedSize);
    encoder.writeUint32(0);
  };
  function WorkItemLoadingScript(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkItemLoadingScript.prototype.initDefaults_ = function() {
    this.script = null;
  };
  WorkItemLoadingScript.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkItemLoadingScript.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkItemLoadingScript.script
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WorkItemLoadingScript.encodedSize = codec.kStructHeaderSize + 8;

  WorkItemLoadingScript.decode = function(decoder) {
    var packed;
    var val = new WorkItemLoadingScript();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.script =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WorkItemLoadingScript.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkItemLoadingScript.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.script);
  };
  function WorkItemNonLoadingScript(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkItemNonLoadingScript.prototype.initDefaults_ = function() {
    this.script = null;
  };
  WorkItemNonLoadingScript.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkItemNonLoadingScript.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkItemNonLoadingScript.script
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WorkItemNonLoadingScript.encodedSize = codec.kStructHeaderSize + 8;

  WorkItemNonLoadingScript.decode = function(decoder) {
    var packed;
    var val = new WorkItemNonLoadingScript();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.script =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WorkItemNonLoadingScript.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkItemNonLoadingScript.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.script);
  };
  function WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_DumpFrameLayout_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_DumpFrameLayout_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_DumpFrameLayout_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_DumpFrameLayout_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_DumpFrameLayout_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_DumpFrameLayout_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_DumpFrameLayout_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_DumpFrameLayout_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_DumpFrameLayout_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_DumpFrameLayout_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_DumpFrameLayout_ResponseParams.prototype.initDefaults_ = function() {
    this.frameLayoutDump = null;
  };
  WebTestRenderFrame_DumpFrameLayout_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_DumpFrameLayout_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRenderFrame_DumpFrameLayout_ResponseParams.frameLayoutDump
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_DumpFrameLayout_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTestRenderFrame_DumpFrameLayout_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_DumpFrameLayout_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameLayoutDump =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestRenderFrame_DumpFrameLayout_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_DumpFrameLayout_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.frameLayoutDump);
  };
  function WebTestRenderFrame_SetTestConfiguration_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_SetTestConfiguration_Params.prototype.initDefaults_ = function() {
    this.config = null;
    this.startingTest = false;
  };
  WebTestRenderFrame_SetTestConfiguration_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_SetTestConfiguration_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRenderFrame_SetTestConfiguration_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebTestRunTestConfiguration, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestRenderFrame_SetTestConfiguration_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestRenderFrame_SetTestConfiguration_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_SetTestConfiguration_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(WebTestRunTestConfiguration);
    packed = decoder.readUint8();
    val.startingTest = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestRenderFrame_SetTestConfiguration_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_SetTestConfiguration_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebTestRunTestConfiguration, val.config);
    packed = 0;
    packed |= (val.startingTest & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestRenderFrame_OnDeactivated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_OnDeactivated_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_OnDeactivated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_OnDeactivated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_OnDeactivated_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_OnDeactivated_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_OnDeactivated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_OnDeactivated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_OnDeactivated_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_OnReactivated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_OnReactivated_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_OnReactivated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_OnReactivated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_OnReactivated_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_OnReactivated_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_OnReactivated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_OnReactivated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_OnReactivated_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_BlockTestUntilStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_BlockTestUntilStart_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_BlockTestUntilStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_BlockTestUntilStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_BlockTestUntilStart_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_BlockTestUntilStart_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_BlockTestUntilStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_BlockTestUntilStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_BlockTestUntilStart_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_StartTest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_StartTest_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_StartTest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_StartTest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_StartTest_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_StartTest_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_StartTest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_StartTest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_StartTest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.prototype.initDefaults_ = function() {
    this.changedLayoutTestRuntimeFlags = null;
  };
  WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.changedLayoutTestRuntimeFlags
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.changedLayoutTestRuntimeFlags =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(values$.DictionaryValue, val.changedLayoutTestRuntimeFlags);
  };
  function WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_ResetRendererAfterWebTest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_ResetRendererAfterWebTest_Params.prototype.initDefaults_ = function() {
  };
  WebTestRenderFrame_ResetRendererAfterWebTest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_ResetRendererAfterWebTest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_ResetRendererAfterWebTest_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestRenderFrame_ResetRendererAfterWebTest_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_ResetRendererAfterWebTest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestRenderFrame_ResetRendererAfterWebTest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_ResetRendererAfterWebTest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestRenderFrame_ProcessWorkItem_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_ProcessWorkItem_Params.prototype.initDefaults_ = function() {
    this.workItem = null;
  };
  WebTestRenderFrame_ProcessWorkItem_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_ProcessWorkItem_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRenderFrame_ProcessWorkItem_Params.workItem
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, WorkItem, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_ProcessWorkItem_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestRenderFrame_ProcessWorkItem_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_ProcessWorkItem_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.workItem =
        decoder.decodeStruct(WorkItem);
    return val;
  };

  WebTestRenderFrame_ProcessWorkItem_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_ProcessWorkItem_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(WorkItem, val.workItem);
  };
  function WebTestRenderFrame_ReplicateWorkQueueStates_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestRenderFrame_ReplicateWorkQueueStates_Params.prototype.initDefaults_ = function() {
    this.workQueueStates = null;
  };
  WebTestRenderFrame_ReplicateWorkQueueStates_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestRenderFrame_ReplicateWorkQueueStates_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestRenderFrame_ReplicateWorkQueueStates_Params.workQueueStates
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestRenderFrame_ReplicateWorkQueueStates_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestRenderFrame_ReplicateWorkQueueStates_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestRenderFrame_ReplicateWorkQueueStates_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.workQueueStates =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  WebTestRenderFrame_ReplicateWorkQueueStates_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestRenderFrame_ReplicateWorkQueueStates_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(values$.DictionaryValue, val.workQueueStates);
  };
  function WebTestControlHost_InitiateCaptureDump_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_InitiateCaptureDump_Params.prototype.initDefaults_ = function() {
    this.result = null;
    this.captureNavigationHistory = false;
    this.capturePixels = false;
  };
  WebTestControlHost_InitiateCaptureDump_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_InitiateCaptureDump_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_InitiateCaptureDump_Params.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebTestRendererDumpResult, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTestControlHost_InitiateCaptureDump_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_InitiateCaptureDump_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_InitiateCaptureDump_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(WebTestRendererDumpResult);
    packed = decoder.readUint8();
    val.captureNavigationHistory = (packed >> 0) & 1 ? true : false;
    val.capturePixels = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_InitiateCaptureDump_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_InitiateCaptureDump_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebTestRendererDumpResult, val.result);
    packed = 0;
    packed |= (val.captureNavigationHistory & 1) << 0
    packed |= (val.capturePixels & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_TestFinishedInSecondaryRenderer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_TestFinishedInSecondaryRenderer_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_TestFinishedInSecondaryRenderer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_TestFinishedInSecondaryRenderer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_TestFinishedInSecondaryRenderer_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_TestFinishedInSecondaryRenderer_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_TestFinishedInSecondaryRenderer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_TestFinishedInSecondaryRenderer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_TestFinishedInSecondaryRenderer_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_PrintMessageToStderr_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_PrintMessageToStderr_Params.prototype.initDefaults_ = function() {
    this.message = null;
  };
  WebTestControlHost_PrintMessageToStderr_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_PrintMessageToStderr_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_PrintMessageToStderr_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_PrintMessageToStderr_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_PrintMessageToStderr_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_PrintMessageToStderr_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_PrintMessageToStderr_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_PrintMessageToStderr_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.message);
  };
  function WebTestControlHost_PrintMessage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_PrintMessage_Params.prototype.initDefaults_ = function() {
    this.message = null;
  };
  WebTestControlHost_PrintMessage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_PrintMessage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_PrintMessage_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_PrintMessage_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_PrintMessage_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_PrintMessage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_PrintMessage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_PrintMessage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.message);
  };
  function WebTestControlHost_OverridePreferences_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_OverridePreferences_Params.prototype.initDefaults_ = function() {
    this.webPreferences = null;
  };
  WebTestControlHost_OverridePreferences_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_OverridePreferences_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_OverridePreferences_Params.webPreferences
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, web_preferences$.WebPreferences, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_OverridePreferences_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_OverridePreferences_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_OverridePreferences_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.webPreferences =
        decoder.decodeStructPointer(web_preferences$.WebPreferences);
    return val;
  };

  WebTestControlHost_OverridePreferences_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_OverridePreferences_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(web_preferences$.WebPreferences, val.webPreferences);
  };
  function WebTestControlHost_Reload_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_Reload_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_Reload_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_Reload_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_Reload_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_Reload_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_Reload_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_Reload_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_Reload_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_CheckForLeakedWindows_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_CheckForLeakedWindows_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_CheckForLeakedWindows_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_CheckForLeakedWindows_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_CheckForLeakedWindows_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_CheckForLeakedWindows_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_CheckForLeakedWindows_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_CheckForLeakedWindows_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_CheckForLeakedWindows_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_SetMainWindowHidden_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetMainWindowHidden_Params.prototype.initDefaults_ = function() {
    this.hidden = false;
  };
  WebTestControlHost_SetMainWindowHidden_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetMainWindowHidden_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_SetMainWindowHidden_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetMainWindowHidden_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetMainWindowHidden_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hidden = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_SetMainWindowHidden_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetMainWindowHidden_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hidden & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_SetFrameWindowHidden_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetFrameWindowHidden_Params.prototype.initDefaults_ = function() {
    this.frameToken = null;
    this.hidden = false;
  };
  WebTestControlHost_SetFrameWindowHidden_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetFrameWindowHidden_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetFrameWindowHidden_Params.frameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.LocalFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_SetFrameWindowHidden_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_SetFrameWindowHidden_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetFrameWindowHidden_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    packed = decoder.readUint8();
    val.hidden = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_SetFrameWindowHidden_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetFrameWindowHidden_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.frameToken);
    packed = 0;
    packed |= (val.hidden & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_GoToOffset_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_GoToOffset_Params.prototype.initDefaults_ = function() {
    this.offset = 0;
  };
  WebTestControlHost_GoToOffset_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_GoToOffset_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_GoToOffset_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_GoToOffset_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_GoToOffset_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_GoToOffset_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_GoToOffset_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.offset);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_SendBluetoothManualChooserEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SendBluetoothManualChooserEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
    this.argument = null;
  };
  WebTestControlHost_SendBluetoothManualChooserEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SendBluetoothManualChooserEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SendBluetoothManualChooserEvent_Params.event
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SendBluetoothManualChooserEvent_Params.argument
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SendBluetoothManualChooserEvent_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_SendBluetoothManualChooserEvent_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SendBluetoothManualChooserEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStruct(codec.String);
    val.argument =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_SendBluetoothManualChooserEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SendBluetoothManualChooserEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.event);
    encoder.encodeStruct(codec.String, val.argument);
  };
  function WebTestControlHost_SetBluetoothManualChooser_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetBluetoothManualChooser_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  WebTestControlHost_SetBluetoothManualChooser_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetBluetoothManualChooser_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_SetBluetoothManualChooser_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetBluetoothManualChooser_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetBluetoothManualChooser_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_SetBluetoothManualChooser_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetBluetoothManualChooser_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_GetBluetoothManualChooserEvents_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_GetBluetoothManualChooserEvents_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_GetBluetoothManualChooserEvents_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_GetBluetoothManualChooserEvents_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_GetBluetoothManualChooserEvents_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_GetBluetoothManualChooserEvents_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_GetBluetoothManualChooserEvents_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_GetBluetoothManualChooserEvents_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_GetBluetoothManualChooserEvents_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.prototype.initDefaults_ = function() {
    this.events = null;
  };
  WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.events
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.events =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.events);
  };
  function WebTestControlHost_SetPopupBlockingEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetPopupBlockingEnabled_Params.prototype.initDefaults_ = function() {
    this.blockPopups = false;
  };
  WebTestControlHost_SetPopupBlockingEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetPopupBlockingEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_SetPopupBlockingEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetPopupBlockingEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetPopupBlockingEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.blockPopups = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_SetPopupBlockingEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetPopupBlockingEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.blockPopups & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_LoadURLForFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_LoadURLForFrame_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.frameName = null;
  };
  WebTestControlHost_LoadURLForFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_LoadURLForFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_LoadURLForFrame_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_LoadURLForFrame_Params.frameName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_LoadURLForFrame_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_LoadURLForFrame_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_LoadURLForFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.frameName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_LoadURLForFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_LoadURLForFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.frameName);
  };
  function WebTestControlHost_SimulateScreenOrientationChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SimulateScreenOrientationChanged_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_SimulateScreenOrientationChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SimulateScreenOrientationChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SimulateScreenOrientationChanged_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_SimulateScreenOrientationChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SimulateScreenOrientationChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_SimulateScreenOrientationChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SimulateScreenOrientationChanged_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_SetPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetPermission_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.status = 0;
    this.origin = null;
    this.embeddingOrigin = null;
  };
  WebTestControlHost_SetPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetPermission_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetPermission_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetPermission_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetPermission_Params.embeddingOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetPermission_Params.encodedSize = codec.kStructHeaderSize + 32;

  WebTestControlHost_SetPermission_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.origin =
        decoder.decodeStructPointer(url$.Url);
    val.embeddingOrigin =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  WebTestControlHost_SetPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.origin);
    encoder.encodeStructPointer(url$.Url, val.embeddingOrigin);
  };
  function WebTestControlHost_BlockThirdPartyCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_BlockThirdPartyCookies_Params.prototype.initDefaults_ = function() {
    this.block = false;
  };
  WebTestControlHost_BlockThirdPartyCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_BlockThirdPartyCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_BlockThirdPartyCookies_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_BlockThirdPartyCookies_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_BlockThirdPartyCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.block = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_BlockThirdPartyCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_BlockThirdPartyCookies_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.block & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_GetWritableDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_GetWritableDirectory_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_GetWritableDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_GetWritableDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_GetWritableDirectory_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_GetWritableDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_GetWritableDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_GetWritableDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_GetWritableDirectory_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_GetWritableDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_GetWritableDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.path = null;
  };
  WebTestControlHost_GetWritableDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_GetWritableDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_GetWritableDirectory_ResponseParams.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_GetWritableDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_GetWritableDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_GetWritableDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  WebTestControlHost_GetWritableDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_GetWritableDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function WebTestControlHost_SetFilePathForMockFileDialog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetFilePathForMockFileDialog_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  WebTestControlHost_SetFilePathForMockFileDialog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetFilePathForMockFileDialog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetFilePathForMockFileDialog_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetFilePathForMockFileDialog_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetFilePathForMockFileDialog_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetFilePathForMockFileDialog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  WebTestControlHost_SetFilePathForMockFileDialog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetFilePathForMockFileDialog_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function WebTestControlHost_CreateSubresourceFilterRulesetFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.prototype.initDefaults_ = function() {
    this.disallowedSuffixes = null;
  };
  WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.disallowedSuffixes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_CreateSubresourceFilterRulesetFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.disallowedSuffixes =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.disallowedSuffixes);
  };
  function WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.prototype.initDefaults_ = function() {
    this.file = null;
  };
  WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.file =
        decoder.decodeStructPointer(file$.File);
    return val;
  };

  WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.file);
  };
  function WebTestControlHost_FocusDevtoolsSecondaryWindow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_FocusDevtoolsSecondaryWindow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_SetTrustTokenKeyCommitments_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetTrustTokenKeyCommitments_Params.prototype.initDefaults_ = function() {
    this.rawCommitments = null;
  };
  WebTestControlHost_SetTrustTokenKeyCommitments_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetTrustTokenKeyCommitments_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetTrustTokenKeyCommitments_Params.rawCommitments
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetTrustTokenKeyCommitments_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetTrustTokenKeyCommitments_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetTrustTokenKeyCommitments_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rawCommitments =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_SetTrustTokenKeyCommitments_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetTrustTokenKeyCommitments_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.rawCommitments);
  };
  function WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_ClearTrustTokenState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_ClearTrustTokenState_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_ClearTrustTokenState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_ClearTrustTokenState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_ClearTrustTokenState_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_ClearTrustTokenState_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_ClearTrustTokenState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_ClearTrustTokenState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_ClearTrustTokenState_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_ClearTrustTokenState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_ClearTrustTokenState_ResponseParams.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_ClearTrustTokenState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_ClearTrustTokenState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_ClearTrustTokenState_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_ClearTrustTokenState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_ClearTrustTokenState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_ClearTrustTokenState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_ClearTrustTokenState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_SimulateWebNotificationClick_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SimulateWebNotificationClick_Params.prototype.initDefaults_ = function() {
    this.title = null;
    this.actionIndex = 0;
    this.reply = null;
  };
  WebTestControlHost_SimulateWebNotificationClick_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SimulateWebNotificationClick_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SimulateWebNotificationClick_Params.title
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebTestControlHost_SimulateWebNotificationClick_Params.reply
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SimulateWebNotificationClick_Params.encodedSize = codec.kStructHeaderSize + 24;

  WebTestControlHost_SimulateWebNotificationClick_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SimulateWebNotificationClick_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.title =
        decoder.decodeStruct(codec.String);
    val.actionIndex =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reply =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  WebTestControlHost_SimulateWebNotificationClick_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SimulateWebNotificationClick_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.title);
    encoder.encodeStruct(codec.Int32, val.actionIndex);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.reply);
  };
  function WebTestControlHost_SimulateWebNotificationClose_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SimulateWebNotificationClose_Params.prototype.initDefaults_ = function() {
    this.title = null;
    this.byUser = false;
  };
  WebTestControlHost_SimulateWebNotificationClose_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SimulateWebNotificationClose_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SimulateWebNotificationClose_Params.title
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTestControlHost_SimulateWebNotificationClose_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_SimulateWebNotificationClose_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SimulateWebNotificationClose_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.title =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.byUser = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_SimulateWebNotificationClose_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SimulateWebNotificationClose_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.title);
    packed = 0;
    packed |= (val.byUser & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_SimulateWebContentIndexDelete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SimulateWebContentIndexDelete_Params.prototype.initDefaults_ = function() {
    this.id = null;
  };
  WebTestControlHost_SimulateWebContentIndexDelete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SimulateWebContentIndexDelete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SimulateWebContentIndexDelete_Params.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SimulateWebContentIndexDelete_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SimulateWebContentIndexDelete_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SimulateWebContentIndexDelete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_SimulateWebContentIndexDelete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SimulateWebContentIndexDelete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
  };
  function WebTestControlHost_WebTestRuntimeFlagsChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_WebTestRuntimeFlagsChanged_Params.prototype.initDefaults_ = function() {
    this.changedWebTestRuntimeFlags = null;
  };
  WebTestControlHost_WebTestRuntimeFlagsChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_WebTestRuntimeFlagsChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_WebTestRuntimeFlagsChanged_Params.changedWebTestRuntimeFlags
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_WebTestRuntimeFlagsChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_WebTestRuntimeFlagsChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_WebTestRuntimeFlagsChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.changedWebTestRuntimeFlags =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  WebTestControlHost_WebTestRuntimeFlagsChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_WebTestRuntimeFlagsChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(values$.DictionaryValue, val.changedWebTestRuntimeFlags);
  };
  function WebTestControlHost_RegisterIsolatedFileSystem_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_RegisterIsolatedFileSystem_Params.prototype.initDefaults_ = function() {
    this.filePaths = null;
  };
  WebTestControlHost_RegisterIsolatedFileSystem_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_RegisterIsolatedFileSystem_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_RegisterIsolatedFileSystem_Params.filePaths
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(file_path$.FilePath), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_RegisterIsolatedFileSystem_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_RegisterIsolatedFileSystem_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_RegisterIsolatedFileSystem_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filePaths =
        decoder.decodeArrayPointer(new codec.PointerTo(file_path$.FilePath));
    return val;
  };

  WebTestControlHost_RegisterIsolatedFileSystem_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_RegisterIsolatedFileSystem_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(file_path$.FilePath), val.filePaths);
  };
  function WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.prototype.initDefaults_ = function() {
    this.filesystemId = null;
  };
  WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.filesystemId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filesystemId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.filesystemId);
  };
  function WebTestControlHost_DropPointerLock_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_DropPointerLock_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_DropPointerLock_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_DropPointerLock_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_DropPointerLock_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_DropPointerLock_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_DropPointerLock_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_DropPointerLock_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_DropPointerLock_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_SetPointerLockWillFail_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetPointerLockWillFail_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_SetPointerLockWillFail_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetPointerLockWillFail_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetPointerLockWillFail_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_SetPointerLockWillFail_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetPointerLockWillFail_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_SetPointerLockWillFail_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetPointerLockWillFail_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_AllowPointerLock_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_AllowPointerLock_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_AllowPointerLock_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_AllowPointerLock_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_AllowPointerLock_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_AllowPointerLock_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_AllowPointerLock_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_AllowPointerLock_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_AllowPointerLock_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_WorkItemAdded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_WorkItemAdded_Params.prototype.initDefaults_ = function() {
    this.workItem = null;
  };
  WebTestControlHost_WorkItemAdded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_WorkItemAdded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_WorkItemAdded_Params.workItem
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, WorkItem, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_WorkItemAdded_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_WorkItemAdded_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_WorkItemAdded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.workItem =
        decoder.decodeStruct(WorkItem);
    return val;
  };

  WebTestControlHost_WorkItemAdded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_WorkItemAdded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(WorkItem, val.workItem);
  };
  function WebTestControlHost_RequestWorkItem_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_RequestWorkItem_Params.prototype.initDefaults_ = function() {
  };
  WebTestControlHost_RequestWorkItem_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_RequestWorkItem_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_RequestWorkItem_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTestControlHost_RequestWorkItem_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_RequestWorkItem_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTestControlHost_RequestWorkItem_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_RequestWorkItem_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTestControlHost_WorkQueueStatesChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_WorkQueueStatesChanged_Params.prototype.initDefaults_ = function() {
    this.changedWorkQueueStates = null;
  };
  WebTestControlHost_WorkQueueStatesChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_WorkQueueStatesChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_WorkQueueStatesChanged_Params.changedWorkQueueStates
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_WorkQueueStatesChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_WorkQueueStatesChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_WorkQueueStatesChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.changedWorkQueueStates =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  WebTestControlHost_WorkQueueStatesChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_WorkQueueStatesChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(values$.DictionaryValue, val.changedWorkQueueStates);
  };
  function WebTestControlHost_SetAcceptLanguages_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetAcceptLanguages_Params.prototype.initDefaults_ = function() {
    this.acceptLanguages = null;
  };
  WebTestControlHost_SetAcceptLanguages_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetAcceptLanguages_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetAcceptLanguages_Params.acceptLanguages
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetAcceptLanguages_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetAcceptLanguages_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetAcceptLanguages_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.acceptLanguages =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTestControlHost_SetAcceptLanguages_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetAcceptLanguages_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.acceptLanguages);
  };
  function WebTestControlHost_SetRegisterProtocolHandlerMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_SetRegisterProtocolHandlerMode_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  WebTestControlHost_SetRegisterProtocolHandlerMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_SetRegisterProtocolHandlerMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_SetRegisterProtocolHandlerMode_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, WebTestControlHost.AutoResponseMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_SetRegisterProtocolHandlerMode_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_SetRegisterProtocolHandlerMode_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_SetRegisterProtocolHandlerMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(WebTestControlHost.AutoResponseMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTestControlHost_SetRegisterProtocolHandlerMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_SetRegisterProtocolHandlerMode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTestControlHost_EnableAutoResize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_EnableAutoResize_Params.prototype.initDefaults_ = function() {
    this.minSize = null;
    this.maxSize = null;
  };
  WebTestControlHost_EnableAutoResize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_EnableAutoResize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_EnableAutoResize_Params.minSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_EnableAutoResize_Params.maxSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_EnableAutoResize_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTestControlHost_EnableAutoResize_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_EnableAutoResize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.minSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.maxSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  WebTestControlHost_EnableAutoResize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_EnableAutoResize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.minSize);
    encoder.encodeStructPointer(geometry$.Size, val.maxSize);
  };
  function WebTestControlHost_DisableAutoResize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTestControlHost_DisableAutoResize_Params.prototype.initDefaults_ = function() {
    this.newSize = null;
  };
  WebTestControlHost_DisableAutoResize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTestControlHost_DisableAutoResize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTestControlHost_DisableAutoResize_Params.newSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTestControlHost_DisableAutoResize_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTestControlHost_DisableAutoResize_Params.decode = function(decoder) {
    var packed;
    var val = new WebTestControlHost_DisableAutoResize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  WebTestControlHost_DisableAutoResize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTestControlHost_DisableAutoResize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.newSize);
  };
  function NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.prototype.initDefaults_ = function() {
    this.hint = null;
  };
  NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.hint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, lcp_critical_path_predictor$.LCPCriticalPathPredictorNavigationTimeHint, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.encodedSize = codec.kStructHeaderSize + 8;

  NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.decode = function(decoder) {
    var packed;
    var val = new NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hint =
        decoder.decodeStructPointer(lcp_critical_path_predictor$.LCPCriticalPathPredictorNavigationTimeHint);
    return val;
  };

  NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(lcp_critical_path_predictor$.LCPCriticalPathPredictorNavigationTimeHint, val.hint);
  };

  function WorkItem(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WorkItem.Tags = {
    backForward: 0,
    load: 1,
    reload: 2,
    loadingScript: 3,
    nonLoadingScript: 4,
  };

  WorkItem.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WorkItem.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "backForward",
        "load",
        "reload",
        "loadingScript",
        "nonLoadingScript",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WorkItem member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WorkItem.prototype, "backForward", {
    get: function() {
      if (this.$tag != WorkItem.Tags.backForward) {
        throw new ReferenceError(
            "WorkItem.backForward is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkItem.Tags.backForward;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkItem.prototype, "load", {
    get: function() {
      if (this.$tag != WorkItem.Tags.load) {
        throw new ReferenceError(
            "WorkItem.load is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkItem.Tags.load;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkItem.prototype, "reload", {
    get: function() {
      if (this.$tag != WorkItem.Tags.reload) {
        throw new ReferenceError(
            "WorkItem.reload is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkItem.Tags.reload;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkItem.prototype, "loadingScript", {
    get: function() {
      if (this.$tag != WorkItem.Tags.loadingScript) {
        throw new ReferenceError(
            "WorkItem.loadingScript is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkItem.Tags.loadingScript;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkItem.prototype, "nonLoadingScript", {
    get: function() {
      if (this.$tag != WorkItem.Tags.nonLoadingScript) {
        throw new ReferenceError(
            "WorkItem.nonLoadingScript is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkItem.Tags.nonLoadingScript;
      this.$data = value;
    }
  });


    WorkItem.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WorkItem.Tags.backForward:
          encoder.encodeStructPointer(WorkItemBackForward, val.backForward);
          break;
        case WorkItem.Tags.load:
          encoder.encodeStructPointer(WorkItemLoad, val.load);
          break;
        case WorkItem.Tags.reload:
          encoder.encodeStructPointer(WorkItemReload, val.reload);
          break;
        case WorkItem.Tags.loadingScript:
          encoder.encodeStructPointer(WorkItemLoadingScript, val.loadingScript);
          break;
        case WorkItem.Tags.nonLoadingScript:
          encoder.encodeStructPointer(WorkItemNonLoadingScript, val.nonLoadingScript);
          break;
      }
      encoder.align();
    };


    WorkItem.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WorkItem();
      var tag = decoder.readUint32();
      switch (tag) {
        case WorkItem.Tags.backForward:
          result.backForward = decoder.decodeStructPointer(WorkItemBackForward);
          break;
        case WorkItem.Tags.load:
          result.load = decoder.decodeStructPointer(WorkItemLoad);
          break;
        case WorkItem.Tags.reload:
          result.reload = decoder.decodeStructPointer(WorkItemReload);
          break;
        case WorkItem.Tags.loadingScript:
          result.loadingScript = decoder.decodeStructPointer(WorkItemLoadingScript);
          break;
        case WorkItem.Tags.nonLoadingScript:
          result.nonLoadingScript = decoder.decodeStructPointer(WorkItemNonLoadingScript);
          break;
      }
      decoder.align();

      return result;
    };


    WorkItem.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WorkItem.Tags.backForward:
          

    // validate WorkItem.backForward
    err = messageValidator.validateStructPointer(data_offset, WorkItemBackForward, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkItem.Tags.load:
          

    // validate WorkItem.load
    err = messageValidator.validateStructPointer(data_offset, WorkItemLoad, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkItem.Tags.reload:
          

    // validate WorkItem.reload
    err = messageValidator.validateStructPointer(data_offset, WorkItemReload, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkItem.Tags.loadingScript:
          

    // validate WorkItem.loadingScript
    err = messageValidator.validateStructPointer(data_offset, WorkItemLoadingScript, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkItem.Tags.nonLoadingScript:
          

    // validate WorkItem.nonLoadingScript
    err = messageValidator.validateStructPointer(data_offset, WorkItemNonLoadingScript, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  WorkItem.encodedSize = 16;
  var kWebTestRenderFrame_SynchronouslyCompositeAfterTest_Name = 0;
  var kWebTestRenderFrame_DumpFrameLayout_Name = 1;
  var kWebTestRenderFrame_SetTestConfiguration_Name = 2;
  var kWebTestRenderFrame_OnDeactivated_Name = 3;
  var kWebTestRenderFrame_OnReactivated_Name = 4;
  var kWebTestRenderFrame_BlockTestUntilStart_Name = 5;
  var kWebTestRenderFrame_StartTest_Name = 6;
  var kWebTestRenderFrame_SetupRendererProcessForNonTestWindow_Name = 7;
  var kWebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Name = 8;
  var kWebTestRenderFrame_TestFinishedFromSecondaryRenderer_Name = 9;
  var kWebTestRenderFrame_ResetRendererAfterWebTest_Name = 10;
  var kWebTestRenderFrame_ProcessWorkItem_Name = 11;
  var kWebTestRenderFrame_ReplicateWorkQueueStates_Name = 12;

  function WebTestRenderFramePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebTestRenderFrame,
                                                   handleOrPtrInfo);
  }

  function WebTestRenderFrameAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebTestRenderFrame, associatedInterfacePtrInfo);
  }

  WebTestRenderFrameAssociatedPtr.prototype =
      Object.create(WebTestRenderFramePtr.prototype);
  WebTestRenderFrameAssociatedPtr.prototype.constructor =
      WebTestRenderFrameAssociatedPtr;

  function WebTestRenderFrameProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebTestRenderFramePtr.prototype.synchronouslyCompositeAfterTest = function() {
    return WebTestRenderFrameProxy.prototype.synchronouslyCompositeAfterTest
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.synchronouslyCompositeAfterTest = function() {
    var params_ = new WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestRenderFrame_SynchronouslyCompositeAfterTest_Name,
          codec.align(WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestRenderFramePtr.prototype.dumpFrameLayout = function() {
    return WebTestRenderFrameProxy.prototype.dumpFrameLayout
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.dumpFrameLayout = function() {
    var params_ = new WebTestRenderFrame_DumpFrameLayout_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestRenderFrame_DumpFrameLayout_Name,
          codec.align(WebTestRenderFrame_DumpFrameLayout_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestRenderFrame_DumpFrameLayout_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestRenderFrame_DumpFrameLayout_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestRenderFramePtr.prototype.setTestConfiguration = function() {
    return WebTestRenderFrameProxy.prototype.setTestConfiguration
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.setTestConfiguration = function(config, startingTest) {
    var params_ = new WebTestRenderFrame_SetTestConfiguration_Params();
    params_.config = config;
    params_.startingTest = startingTest;
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_SetTestConfiguration_Name,
        codec.align(WebTestRenderFrame_SetTestConfiguration_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_SetTestConfiguration_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.onDeactivated = function() {
    return WebTestRenderFrameProxy.prototype.onDeactivated
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.onDeactivated = function() {
    var params_ = new WebTestRenderFrame_OnDeactivated_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_OnDeactivated_Name,
        codec.align(WebTestRenderFrame_OnDeactivated_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_OnDeactivated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.onReactivated = function() {
    return WebTestRenderFrameProxy.prototype.onReactivated
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.onReactivated = function() {
    var params_ = new WebTestRenderFrame_OnReactivated_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_OnReactivated_Name,
        codec.align(WebTestRenderFrame_OnReactivated_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_OnReactivated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.blockTestUntilStart = function() {
    return WebTestRenderFrameProxy.prototype.blockTestUntilStart
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.blockTestUntilStart = function() {
    var params_ = new WebTestRenderFrame_BlockTestUntilStart_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_BlockTestUntilStart_Name,
        codec.align(WebTestRenderFrame_BlockTestUntilStart_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_BlockTestUntilStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.startTest = function() {
    return WebTestRenderFrameProxy.prototype.startTest
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.startTest = function() {
    var params_ = new WebTestRenderFrame_StartTest_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_StartTest_Name,
        codec.align(WebTestRenderFrame_StartTest_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_StartTest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.setupRendererProcessForNonTestWindow = function() {
    return WebTestRenderFrameProxy.prototype.setupRendererProcessForNonTestWindow
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.setupRendererProcessForNonTestWindow = function() {
    var params_ = new WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_SetupRendererProcessForNonTestWindow_Name,
        codec.align(WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.replicateWebTestRuntimeFlagsChanges = function() {
    return WebTestRenderFrameProxy.prototype.replicateWebTestRuntimeFlagsChanges
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.replicateWebTestRuntimeFlagsChanges = function(changedLayoutTestRuntimeFlags) {
    var params_ = new WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params();
    params_.changedLayoutTestRuntimeFlags = changedLayoutTestRuntimeFlags;
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Name,
        codec.align(WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.testFinishedFromSecondaryRenderer = function() {
    return WebTestRenderFrameProxy.prototype.testFinishedFromSecondaryRenderer
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.testFinishedFromSecondaryRenderer = function() {
    var params_ = new WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_TestFinishedFromSecondaryRenderer_Name,
        codec.align(WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.resetRendererAfterWebTest = function() {
    return WebTestRenderFrameProxy.prototype.resetRendererAfterWebTest
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.resetRendererAfterWebTest = function() {
    var params_ = new WebTestRenderFrame_ResetRendererAfterWebTest_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_ResetRendererAfterWebTest_Name,
        codec.align(WebTestRenderFrame_ResetRendererAfterWebTest_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_ResetRendererAfterWebTest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.processWorkItem = function() {
    return WebTestRenderFrameProxy.prototype.processWorkItem
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.processWorkItem = function(workItem) {
    var params_ = new WebTestRenderFrame_ProcessWorkItem_Params();
    params_.workItem = workItem;
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_ProcessWorkItem_Name,
        codec.align(WebTestRenderFrame_ProcessWorkItem_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_ProcessWorkItem_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestRenderFramePtr.prototype.replicateWorkQueueStates = function() {
    return WebTestRenderFrameProxy.prototype.replicateWorkQueueStates
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestRenderFrameProxy.prototype.replicateWorkQueueStates = function(workQueueStates) {
    var params_ = new WebTestRenderFrame_ReplicateWorkQueueStates_Params();
    params_.workQueueStates = workQueueStates;
    var builder = new codec.MessageV0Builder(
        kWebTestRenderFrame_ReplicateWorkQueueStates_Name,
        codec.align(WebTestRenderFrame_ReplicateWorkQueueStates_Params.encodedSize));
    builder.encodeStruct(WebTestRenderFrame_ReplicateWorkQueueStates_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebTestRenderFrameStub(delegate) {
    this.delegate_ = delegate;
  }
  WebTestRenderFrameStub.prototype.synchronouslyCompositeAfterTest = function() {
    return this.delegate_ && this.delegate_.synchronouslyCompositeAfterTest && this.delegate_.synchronouslyCompositeAfterTest();
  }
  WebTestRenderFrameStub.prototype.dumpFrameLayout = function() {
    return this.delegate_ && this.delegate_.dumpFrameLayout && this.delegate_.dumpFrameLayout();
  }
  WebTestRenderFrameStub.prototype.setTestConfiguration = function(config, startingTest) {
    return this.delegate_ && this.delegate_.setTestConfiguration && this.delegate_.setTestConfiguration(config, startingTest);
  }
  WebTestRenderFrameStub.prototype.onDeactivated = function() {
    return this.delegate_ && this.delegate_.onDeactivated && this.delegate_.onDeactivated();
  }
  WebTestRenderFrameStub.prototype.onReactivated = function() {
    return this.delegate_ && this.delegate_.onReactivated && this.delegate_.onReactivated();
  }
  WebTestRenderFrameStub.prototype.blockTestUntilStart = function() {
    return this.delegate_ && this.delegate_.blockTestUntilStart && this.delegate_.blockTestUntilStart();
  }
  WebTestRenderFrameStub.prototype.startTest = function() {
    return this.delegate_ && this.delegate_.startTest && this.delegate_.startTest();
  }
  WebTestRenderFrameStub.prototype.setupRendererProcessForNonTestWindow = function() {
    return this.delegate_ && this.delegate_.setupRendererProcessForNonTestWindow && this.delegate_.setupRendererProcessForNonTestWindow();
  }
  WebTestRenderFrameStub.prototype.replicateWebTestRuntimeFlagsChanges = function(changedLayoutTestRuntimeFlags) {
    return this.delegate_ && this.delegate_.replicateWebTestRuntimeFlagsChanges && this.delegate_.replicateWebTestRuntimeFlagsChanges(changedLayoutTestRuntimeFlags);
  }
  WebTestRenderFrameStub.prototype.testFinishedFromSecondaryRenderer = function() {
    return this.delegate_ && this.delegate_.testFinishedFromSecondaryRenderer && this.delegate_.testFinishedFromSecondaryRenderer();
  }
  WebTestRenderFrameStub.prototype.resetRendererAfterWebTest = function() {
    return this.delegate_ && this.delegate_.resetRendererAfterWebTest && this.delegate_.resetRendererAfterWebTest();
  }
  WebTestRenderFrameStub.prototype.processWorkItem = function(workItem) {
    return this.delegate_ && this.delegate_.processWorkItem && this.delegate_.processWorkItem(workItem);
  }
  WebTestRenderFrameStub.prototype.replicateWorkQueueStates = function(workQueueStates) {
    return this.delegate_ && this.delegate_.replicateWorkQueueStates && this.delegate_.replicateWorkQueueStates(workQueueStates);
  }

  WebTestRenderFrameStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTestRenderFrame_SetTestConfiguration_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_SetTestConfiguration_Params);
      this.setTestConfiguration(params.config, params.startingTest);
      return true;
    case kWebTestRenderFrame_OnDeactivated_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_OnDeactivated_Params);
      this.onDeactivated();
      return true;
    case kWebTestRenderFrame_OnReactivated_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_OnReactivated_Params);
      this.onReactivated();
      return true;
    case kWebTestRenderFrame_BlockTestUntilStart_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_BlockTestUntilStart_Params);
      this.blockTestUntilStart();
      return true;
    case kWebTestRenderFrame_StartTest_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_StartTest_Params);
      this.startTest();
      return true;
    case kWebTestRenderFrame_SetupRendererProcessForNonTestWindow_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params);
      this.setupRendererProcessForNonTestWindow();
      return true;
    case kWebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params);
      this.replicateWebTestRuntimeFlagsChanges(params.changedLayoutTestRuntimeFlags);
      return true;
    case kWebTestRenderFrame_TestFinishedFromSecondaryRenderer_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params);
      this.testFinishedFromSecondaryRenderer();
      return true;
    case kWebTestRenderFrame_ResetRendererAfterWebTest_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_ResetRendererAfterWebTest_Params);
      this.resetRendererAfterWebTest();
      return true;
    case kWebTestRenderFrame_ProcessWorkItem_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_ProcessWorkItem_Params);
      this.processWorkItem(params.workItem);
      return true;
    case kWebTestRenderFrame_ReplicateWorkQueueStates_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_ReplicateWorkQueueStates_Params);
      this.replicateWorkQueueStates(params.workQueueStates);
      return true;
    default:
      return false;
    }
  };

  WebTestRenderFrameStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTestRenderFrame_SynchronouslyCompositeAfterTest_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params);
      this.synchronouslyCompositeAfterTest().then(function(response) {
        var responseParams =
            new WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWebTestRenderFrame_SynchronouslyCompositeAfterTest_Name,
            codec.align(WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTestRenderFrame_DumpFrameLayout_Name:
      var params = reader.decodeStruct(WebTestRenderFrame_DumpFrameLayout_Params);
      this.dumpFrameLayout().then(function(response) {
        var responseParams =
            new WebTestRenderFrame_DumpFrameLayout_ResponseParams();
        responseParams.frameLayoutDump = response.frameLayoutDump;
        var builder = new codec.MessageV1Builder(
            kWebTestRenderFrame_DumpFrameLayout_Name,
            codec.align(WebTestRenderFrame_DumpFrameLayout_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestRenderFrame_DumpFrameLayout_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebTestRenderFrameRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebTestRenderFrame_SynchronouslyCompositeAfterTest_Name:
        if (message.expectsResponse())
          paramsClass = WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params;
      break;
      case kWebTestRenderFrame_DumpFrameLayout_Name:
        if (message.expectsResponse())
          paramsClass = WebTestRenderFrame_DumpFrameLayout_Params;
      break;
      case kWebTestRenderFrame_SetTestConfiguration_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_SetTestConfiguration_Params;
      break;
      case kWebTestRenderFrame_OnDeactivated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_OnDeactivated_Params;
      break;
      case kWebTestRenderFrame_OnReactivated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_OnReactivated_Params;
      break;
      case kWebTestRenderFrame_BlockTestUntilStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_BlockTestUntilStart_Params;
      break;
      case kWebTestRenderFrame_StartTest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_StartTest_Params;
      break;
      case kWebTestRenderFrame_SetupRendererProcessForNonTestWindow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params;
      break;
      case kWebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params;
      break;
      case kWebTestRenderFrame_TestFinishedFromSecondaryRenderer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params;
      break;
      case kWebTestRenderFrame_ResetRendererAfterWebTest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_ResetRendererAfterWebTest_Params;
      break;
      case kWebTestRenderFrame_ProcessWorkItem_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_ProcessWorkItem_Params;
      break;
      case kWebTestRenderFrame_ReplicateWorkQueueStates_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestRenderFrame_ReplicateWorkQueueStates_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebTestRenderFrameResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebTestRenderFrame_SynchronouslyCompositeAfterTest_Name:
        if (message.isResponse())
          paramsClass = WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams;
        break;
      case kWebTestRenderFrame_DumpFrameLayout_Name:
        if (message.isResponse())
          paramsClass = WebTestRenderFrame_DumpFrameLayout_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebTestRenderFrame = {
    name: 'content.mojom.WebTestRenderFrame',
    kVersion: 0,
    ptrClass: WebTestRenderFramePtr,
    proxyClass: WebTestRenderFrameProxy,
    stubClass: WebTestRenderFrameStub,
    validateRequest: validateWebTestRenderFrameRequest,
    validateResponse: validateWebTestRenderFrameResponse,
  };
  WebTestRenderFrameStub.prototype.validator = validateWebTestRenderFrameRequest;
  WebTestRenderFrameProxy.prototype.validator = validateWebTestRenderFrameResponse;
  var kWebTestControlHost_InitiateCaptureDump_Name = 0;
  var kWebTestControlHost_TestFinishedInSecondaryRenderer_Name = 1;
  var kWebTestControlHost_PrintMessageToStderr_Name = 2;
  var kWebTestControlHost_PrintMessage_Name = 3;
  var kWebTestControlHost_OverridePreferences_Name = 4;
  var kWebTestControlHost_Reload_Name = 5;
  var kWebTestControlHost_CheckForLeakedWindows_Name = 6;
  var kWebTestControlHost_SetMainWindowHidden_Name = 7;
  var kWebTestControlHost_SetFrameWindowHidden_Name = 8;
  var kWebTestControlHost_GoToOffset_Name = 9;
  var kWebTestControlHost_SendBluetoothManualChooserEvent_Name = 10;
  var kWebTestControlHost_SetBluetoothManualChooser_Name = 11;
  var kWebTestControlHost_GetBluetoothManualChooserEvents_Name = 12;
  var kWebTestControlHost_SetPopupBlockingEnabled_Name = 13;
  var kWebTestControlHost_LoadURLForFrame_Name = 14;
  var kWebTestControlHost_SimulateScreenOrientationChanged_Name = 15;
  var kWebTestControlHost_SetPermission_Name = 16;
  var kWebTestControlHost_BlockThirdPartyCookies_Name = 17;
  var kWebTestControlHost_GetWritableDirectory_Name = 18;
  var kWebTestControlHost_SetFilePathForMockFileDialog_Name = 19;
  var kWebTestControlHost_CreateSubresourceFilterRulesetFile_Name = 20;
  var kWebTestControlHost_FocusDevtoolsSecondaryWindow_Name = 21;
  var kWebTestControlHost_SetTrustTokenKeyCommitments_Name = 22;
  var kWebTestControlHost_ClearTrustTokenState_Name = 23;
  var kWebTestControlHost_SimulateWebNotificationClick_Name = 24;
  var kWebTestControlHost_SimulateWebNotificationClose_Name = 25;
  var kWebTestControlHost_SimulateWebContentIndexDelete_Name = 26;
  var kWebTestControlHost_WebTestRuntimeFlagsChanged_Name = 27;
  var kWebTestControlHost_RegisterIsolatedFileSystem_Name = 28;
  var kWebTestControlHost_DropPointerLock_Name = 29;
  var kWebTestControlHost_SetPointerLockWillFail_Name = 30;
  var kWebTestControlHost_SetPointerLockWillRespondAsynchronously_Name = 31;
  var kWebTestControlHost_AllowPointerLock_Name = 32;
  var kWebTestControlHost_WorkItemAdded_Name = 33;
  var kWebTestControlHost_RequestWorkItem_Name = 34;
  var kWebTestControlHost_WorkQueueStatesChanged_Name = 35;
  var kWebTestControlHost_SetAcceptLanguages_Name = 36;
  var kWebTestControlHost_SetRegisterProtocolHandlerMode_Name = 37;
  var kWebTestControlHost_EnableAutoResize_Name = 38;
  var kWebTestControlHost_DisableAutoResize_Name = 39;

  function WebTestControlHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebTestControlHost,
                                                   handleOrPtrInfo);
  }

  function WebTestControlHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebTestControlHost, associatedInterfacePtrInfo);
  }

  WebTestControlHostAssociatedPtr.prototype =
      Object.create(WebTestControlHostPtr.prototype);
  WebTestControlHostAssociatedPtr.prototype.constructor =
      WebTestControlHostAssociatedPtr;

  function WebTestControlHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebTestControlHostPtr.prototype.initiateCaptureDump = function() {
    return WebTestControlHostProxy.prototype.initiateCaptureDump
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.initiateCaptureDump = function(result, captureNavigationHistory, capturePixels) {
    var params_ = new WebTestControlHost_InitiateCaptureDump_Params();
    params_.result = result;
    params_.captureNavigationHistory = captureNavigationHistory;
    params_.capturePixels = capturePixels;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_InitiateCaptureDump_Name,
        codec.align(WebTestControlHost_InitiateCaptureDump_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_InitiateCaptureDump_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.testFinishedInSecondaryRenderer = function() {
    return WebTestControlHostProxy.prototype.testFinishedInSecondaryRenderer
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.testFinishedInSecondaryRenderer = function() {
    var params_ = new WebTestControlHost_TestFinishedInSecondaryRenderer_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_TestFinishedInSecondaryRenderer_Name,
        codec.align(WebTestControlHost_TestFinishedInSecondaryRenderer_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_TestFinishedInSecondaryRenderer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.printMessageToStderr = function() {
    return WebTestControlHostProxy.prototype.printMessageToStderr
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.printMessageToStderr = function(message) {
    var params_ = new WebTestControlHost_PrintMessageToStderr_Params();
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_PrintMessageToStderr_Name,
        codec.align(WebTestControlHost_PrintMessageToStderr_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_PrintMessageToStderr_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.printMessage = function() {
    return WebTestControlHostProxy.prototype.printMessage
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.printMessage = function(message) {
    var params_ = new WebTestControlHost_PrintMessage_Params();
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_PrintMessage_Name,
        codec.align(WebTestControlHost_PrintMessage_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_PrintMessage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.overridePreferences = function() {
    return WebTestControlHostProxy.prototype.overridePreferences
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.overridePreferences = function(webPreferences) {
    var params_ = new WebTestControlHost_OverridePreferences_Params();
    params_.webPreferences = webPreferences;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_OverridePreferences_Name,
        codec.align(WebTestControlHost_OverridePreferences_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_OverridePreferences_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.reload = function() {
    return WebTestControlHostProxy.prototype.reload
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.reload = function() {
    var params_ = new WebTestControlHost_Reload_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_Reload_Name,
        codec.align(WebTestControlHost_Reload_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_Reload_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.checkForLeakedWindows = function() {
    return WebTestControlHostProxy.prototype.checkForLeakedWindows
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.checkForLeakedWindows = function() {
    var params_ = new WebTestControlHost_CheckForLeakedWindows_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_CheckForLeakedWindows_Name,
        codec.align(WebTestControlHost_CheckForLeakedWindows_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_CheckForLeakedWindows_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setMainWindowHidden = function() {
    return WebTestControlHostProxy.prototype.setMainWindowHidden
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setMainWindowHidden = function(hidden) {
    var params_ = new WebTestControlHost_SetMainWindowHidden_Params();
    params_.hidden = hidden;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetMainWindowHidden_Name,
        codec.align(WebTestControlHost_SetMainWindowHidden_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetMainWindowHidden_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setFrameWindowHidden = function() {
    return WebTestControlHostProxy.prototype.setFrameWindowHidden
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setFrameWindowHidden = function(frameToken, hidden) {
    var params_ = new WebTestControlHost_SetFrameWindowHidden_Params();
    params_.frameToken = frameToken;
    params_.hidden = hidden;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetFrameWindowHidden_Name,
        codec.align(WebTestControlHost_SetFrameWindowHidden_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetFrameWindowHidden_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.goToOffset = function() {
    return WebTestControlHostProxy.prototype.goToOffset
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.goToOffset = function(offset) {
    var params_ = new WebTestControlHost_GoToOffset_Params();
    params_.offset = offset;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_GoToOffset_Name,
        codec.align(WebTestControlHost_GoToOffset_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_GoToOffset_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.sendBluetoothManualChooserEvent = function() {
    return WebTestControlHostProxy.prototype.sendBluetoothManualChooserEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.sendBluetoothManualChooserEvent = function(event, argument) {
    var params_ = new WebTestControlHost_SendBluetoothManualChooserEvent_Params();
    params_.event = event;
    params_.argument = argument;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SendBluetoothManualChooserEvent_Name,
        codec.align(WebTestControlHost_SendBluetoothManualChooserEvent_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SendBluetoothManualChooserEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setBluetoothManualChooser = function() {
    return WebTestControlHostProxy.prototype.setBluetoothManualChooser
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setBluetoothManualChooser = function(enable) {
    var params_ = new WebTestControlHost_SetBluetoothManualChooser_Params();
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetBluetoothManualChooser_Name,
        codec.align(WebTestControlHost_SetBluetoothManualChooser_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetBluetoothManualChooser_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.getBluetoothManualChooserEvents = function() {
    return WebTestControlHostProxy.prototype.getBluetoothManualChooserEvents
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.getBluetoothManualChooserEvents = function() {
    var params_ = new WebTestControlHost_GetBluetoothManualChooserEvents_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestControlHost_GetBluetoothManualChooserEvents_Name,
          codec.align(WebTestControlHost_GetBluetoothManualChooserEvents_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestControlHost_GetBluetoothManualChooserEvents_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestControlHostPtr.prototype.setPopupBlockingEnabled = function() {
    return WebTestControlHostProxy.prototype.setPopupBlockingEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setPopupBlockingEnabled = function(blockPopups) {
    var params_ = new WebTestControlHost_SetPopupBlockingEnabled_Params();
    params_.blockPopups = blockPopups;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetPopupBlockingEnabled_Name,
        codec.align(WebTestControlHost_SetPopupBlockingEnabled_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetPopupBlockingEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.loadURLForFrame = function() {
    return WebTestControlHostProxy.prototype.loadURLForFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.loadURLForFrame = function(url, frameName) {
    var params_ = new WebTestControlHost_LoadURLForFrame_Params();
    params_.url = url;
    params_.frameName = frameName;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_LoadURLForFrame_Name,
        codec.align(WebTestControlHost_LoadURLForFrame_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_LoadURLForFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.simulateScreenOrientationChanged = function() {
    return WebTestControlHostProxy.prototype.simulateScreenOrientationChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.simulateScreenOrientationChanged = function() {
    var params_ = new WebTestControlHost_SimulateScreenOrientationChanged_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SimulateScreenOrientationChanged_Name,
        codec.align(WebTestControlHost_SimulateScreenOrientationChanged_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SimulateScreenOrientationChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setPermission = function() {
    return WebTestControlHostProxy.prototype.setPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setPermission = function(name, status, origin, embeddingOrigin) {
    var params_ = new WebTestControlHost_SetPermission_Params();
    params_.name = name;
    params_.status = status;
    params_.origin = origin;
    params_.embeddingOrigin = embeddingOrigin;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetPermission_Name,
        codec.align(WebTestControlHost_SetPermission_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetPermission_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.blockThirdPartyCookies = function() {
    return WebTestControlHostProxy.prototype.blockThirdPartyCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.blockThirdPartyCookies = function(block) {
    var params_ = new WebTestControlHost_BlockThirdPartyCookies_Params();
    params_.block = block;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_BlockThirdPartyCookies_Name,
        codec.align(WebTestControlHost_BlockThirdPartyCookies_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_BlockThirdPartyCookies_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.getWritableDirectory = function() {
    return WebTestControlHostProxy.prototype.getWritableDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.getWritableDirectory = function() {
    var params_ = new WebTestControlHost_GetWritableDirectory_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestControlHost_GetWritableDirectory_Name,
          codec.align(WebTestControlHost_GetWritableDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestControlHost_GetWritableDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestControlHost_GetWritableDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestControlHostPtr.prototype.setFilePathForMockFileDialog = function() {
    return WebTestControlHostProxy.prototype.setFilePathForMockFileDialog
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setFilePathForMockFileDialog = function(path) {
    var params_ = new WebTestControlHost_SetFilePathForMockFileDialog_Params();
    params_.path = path;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetFilePathForMockFileDialog_Name,
        codec.align(WebTestControlHost_SetFilePathForMockFileDialog_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetFilePathForMockFileDialog_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.createSubresourceFilterRulesetFile = function() {
    return WebTestControlHostProxy.prototype.createSubresourceFilterRulesetFile
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.createSubresourceFilterRulesetFile = function(disallowedSuffixes) {
    var params_ = new WebTestControlHost_CreateSubresourceFilterRulesetFile_Params();
    params_.disallowedSuffixes = disallowedSuffixes;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestControlHost_CreateSubresourceFilterRulesetFile_Name,
          codec.align(WebTestControlHost_CreateSubresourceFilterRulesetFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestControlHost_CreateSubresourceFilterRulesetFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestControlHostPtr.prototype.focusDevtoolsSecondaryWindow = function() {
    return WebTestControlHostProxy.prototype.focusDevtoolsSecondaryWindow
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.focusDevtoolsSecondaryWindow = function() {
    var params_ = new WebTestControlHost_FocusDevtoolsSecondaryWindow_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_FocusDevtoolsSecondaryWindow_Name,
        codec.align(WebTestControlHost_FocusDevtoolsSecondaryWindow_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_FocusDevtoolsSecondaryWindow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setTrustTokenKeyCommitments = function() {
    return WebTestControlHostProxy.prototype.setTrustTokenKeyCommitments
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setTrustTokenKeyCommitments = function(rawCommitments) {
    var params_ = new WebTestControlHost_SetTrustTokenKeyCommitments_Params();
    params_.rawCommitments = rawCommitments;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestControlHost_SetTrustTokenKeyCommitments_Name,
          codec.align(WebTestControlHost_SetTrustTokenKeyCommitments_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestControlHost_SetTrustTokenKeyCommitments_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestControlHostPtr.prototype.clearTrustTokenState = function() {
    return WebTestControlHostProxy.prototype.clearTrustTokenState
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.clearTrustTokenState = function() {
    var params_ = new WebTestControlHost_ClearTrustTokenState_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestControlHost_ClearTrustTokenState_Name,
          codec.align(WebTestControlHost_ClearTrustTokenState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestControlHost_ClearTrustTokenState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestControlHost_ClearTrustTokenState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestControlHostPtr.prototype.simulateWebNotificationClick = function() {
    return WebTestControlHostProxy.prototype.simulateWebNotificationClick
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.simulateWebNotificationClick = function(title, actionIndex, reply) {
    var params_ = new WebTestControlHost_SimulateWebNotificationClick_Params();
    params_.title = title;
    params_.actionIndex = actionIndex;
    params_.reply = reply;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SimulateWebNotificationClick_Name,
        codec.align(WebTestControlHost_SimulateWebNotificationClick_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SimulateWebNotificationClick_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.simulateWebNotificationClose = function() {
    return WebTestControlHostProxy.prototype.simulateWebNotificationClose
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.simulateWebNotificationClose = function(title, byUser) {
    var params_ = new WebTestControlHost_SimulateWebNotificationClose_Params();
    params_.title = title;
    params_.byUser = byUser;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SimulateWebNotificationClose_Name,
        codec.align(WebTestControlHost_SimulateWebNotificationClose_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SimulateWebNotificationClose_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.simulateWebContentIndexDelete = function() {
    return WebTestControlHostProxy.prototype.simulateWebContentIndexDelete
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.simulateWebContentIndexDelete = function(id) {
    var params_ = new WebTestControlHost_SimulateWebContentIndexDelete_Params();
    params_.id = id;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SimulateWebContentIndexDelete_Name,
        codec.align(WebTestControlHost_SimulateWebContentIndexDelete_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SimulateWebContentIndexDelete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.webTestRuntimeFlagsChanged = function() {
    return WebTestControlHostProxy.prototype.webTestRuntimeFlagsChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.webTestRuntimeFlagsChanged = function(changedWebTestRuntimeFlags) {
    var params_ = new WebTestControlHost_WebTestRuntimeFlagsChanged_Params();
    params_.changedWebTestRuntimeFlags = changedWebTestRuntimeFlags;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_WebTestRuntimeFlagsChanged_Name,
        codec.align(WebTestControlHost_WebTestRuntimeFlagsChanged_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_WebTestRuntimeFlagsChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.registerIsolatedFileSystem = function() {
    return WebTestControlHostProxy.prototype.registerIsolatedFileSystem
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.registerIsolatedFileSystem = function(filePaths) {
    var params_ = new WebTestControlHost_RegisterIsolatedFileSystem_Params();
    params_.filePaths = filePaths;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTestControlHost_RegisterIsolatedFileSystem_Name,
          codec.align(WebTestControlHost_RegisterIsolatedFileSystem_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTestControlHost_RegisterIsolatedFileSystem_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTestControlHostPtr.prototype.dropPointerLock = function() {
    return WebTestControlHostProxy.prototype.dropPointerLock
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.dropPointerLock = function() {
    var params_ = new WebTestControlHost_DropPointerLock_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_DropPointerLock_Name,
        codec.align(WebTestControlHost_DropPointerLock_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_DropPointerLock_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setPointerLockWillFail = function() {
    return WebTestControlHostProxy.prototype.setPointerLockWillFail
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setPointerLockWillFail = function() {
    var params_ = new WebTestControlHost_SetPointerLockWillFail_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetPointerLockWillFail_Name,
        codec.align(WebTestControlHost_SetPointerLockWillFail_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetPointerLockWillFail_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setPointerLockWillRespondAsynchronously = function() {
    return WebTestControlHostProxy.prototype.setPointerLockWillRespondAsynchronously
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setPointerLockWillRespondAsynchronously = function() {
    var params_ = new WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetPointerLockWillRespondAsynchronously_Name,
        codec.align(WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.allowPointerLock = function() {
    return WebTestControlHostProxy.prototype.allowPointerLock
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.allowPointerLock = function() {
    var params_ = new WebTestControlHost_AllowPointerLock_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_AllowPointerLock_Name,
        codec.align(WebTestControlHost_AllowPointerLock_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_AllowPointerLock_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.workItemAdded = function() {
    return WebTestControlHostProxy.prototype.workItemAdded
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.workItemAdded = function(workItem) {
    var params_ = new WebTestControlHost_WorkItemAdded_Params();
    params_.workItem = workItem;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_WorkItemAdded_Name,
        codec.align(WebTestControlHost_WorkItemAdded_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_WorkItemAdded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.requestWorkItem = function() {
    return WebTestControlHostProxy.prototype.requestWorkItem
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.requestWorkItem = function() {
    var params_ = new WebTestControlHost_RequestWorkItem_Params();
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_RequestWorkItem_Name,
        codec.align(WebTestControlHost_RequestWorkItem_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_RequestWorkItem_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.workQueueStatesChanged = function() {
    return WebTestControlHostProxy.prototype.workQueueStatesChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.workQueueStatesChanged = function(changedWorkQueueStates) {
    var params_ = new WebTestControlHost_WorkQueueStatesChanged_Params();
    params_.changedWorkQueueStates = changedWorkQueueStates;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_WorkQueueStatesChanged_Name,
        codec.align(WebTestControlHost_WorkQueueStatesChanged_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_WorkQueueStatesChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setAcceptLanguages = function() {
    return WebTestControlHostProxy.prototype.setAcceptLanguages
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setAcceptLanguages = function(acceptLanguages) {
    var params_ = new WebTestControlHost_SetAcceptLanguages_Params();
    params_.acceptLanguages = acceptLanguages;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetAcceptLanguages_Name,
        codec.align(WebTestControlHost_SetAcceptLanguages_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetAcceptLanguages_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.setRegisterProtocolHandlerMode = function() {
    return WebTestControlHostProxy.prototype.setRegisterProtocolHandlerMode
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.setRegisterProtocolHandlerMode = function(mode) {
    var params_ = new WebTestControlHost_SetRegisterProtocolHandlerMode_Params();
    params_.mode = mode;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_SetRegisterProtocolHandlerMode_Name,
        codec.align(WebTestControlHost_SetRegisterProtocolHandlerMode_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_SetRegisterProtocolHandlerMode_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.enableAutoResize = function() {
    return WebTestControlHostProxy.prototype.enableAutoResize
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.enableAutoResize = function(minSize, maxSize) {
    var params_ = new WebTestControlHost_EnableAutoResize_Params();
    params_.minSize = minSize;
    params_.maxSize = maxSize;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_EnableAutoResize_Name,
        codec.align(WebTestControlHost_EnableAutoResize_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_EnableAutoResize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTestControlHostPtr.prototype.disableAutoResize = function() {
    return WebTestControlHostProxy.prototype.disableAutoResize
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTestControlHostProxy.prototype.disableAutoResize = function(newSize) {
    var params_ = new WebTestControlHost_DisableAutoResize_Params();
    params_.newSize = newSize;
    var builder = new codec.MessageV0Builder(
        kWebTestControlHost_DisableAutoResize_Name,
        codec.align(WebTestControlHost_DisableAutoResize_Params.encodedSize));
    builder.encodeStruct(WebTestControlHost_DisableAutoResize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebTestControlHostStub(delegate) {
    this.delegate_ = delegate;
  }
  WebTestControlHostStub.prototype.initiateCaptureDump = function(result, captureNavigationHistory, capturePixels) {
    return this.delegate_ && this.delegate_.initiateCaptureDump && this.delegate_.initiateCaptureDump(result, captureNavigationHistory, capturePixels);
  }
  WebTestControlHostStub.prototype.testFinishedInSecondaryRenderer = function() {
    return this.delegate_ && this.delegate_.testFinishedInSecondaryRenderer && this.delegate_.testFinishedInSecondaryRenderer();
  }
  WebTestControlHostStub.prototype.printMessageToStderr = function(message) {
    return this.delegate_ && this.delegate_.printMessageToStderr && this.delegate_.printMessageToStderr(message);
  }
  WebTestControlHostStub.prototype.printMessage = function(message) {
    return this.delegate_ && this.delegate_.printMessage && this.delegate_.printMessage(message);
  }
  WebTestControlHostStub.prototype.overridePreferences = function(webPreferences) {
    return this.delegate_ && this.delegate_.overridePreferences && this.delegate_.overridePreferences(webPreferences);
  }
  WebTestControlHostStub.prototype.reload = function() {
    return this.delegate_ && this.delegate_.reload && this.delegate_.reload();
  }
  WebTestControlHostStub.prototype.checkForLeakedWindows = function() {
    return this.delegate_ && this.delegate_.checkForLeakedWindows && this.delegate_.checkForLeakedWindows();
  }
  WebTestControlHostStub.prototype.setMainWindowHidden = function(hidden) {
    return this.delegate_ && this.delegate_.setMainWindowHidden && this.delegate_.setMainWindowHidden(hidden);
  }
  WebTestControlHostStub.prototype.setFrameWindowHidden = function(frameToken, hidden) {
    return this.delegate_ && this.delegate_.setFrameWindowHidden && this.delegate_.setFrameWindowHidden(frameToken, hidden);
  }
  WebTestControlHostStub.prototype.goToOffset = function(offset) {
    return this.delegate_ && this.delegate_.goToOffset && this.delegate_.goToOffset(offset);
  }
  WebTestControlHostStub.prototype.sendBluetoothManualChooserEvent = function(event, argument) {
    return this.delegate_ && this.delegate_.sendBluetoothManualChooserEvent && this.delegate_.sendBluetoothManualChooserEvent(event, argument);
  }
  WebTestControlHostStub.prototype.setBluetoothManualChooser = function(enable) {
    return this.delegate_ && this.delegate_.setBluetoothManualChooser && this.delegate_.setBluetoothManualChooser(enable);
  }
  WebTestControlHostStub.prototype.getBluetoothManualChooserEvents = function() {
    return this.delegate_ && this.delegate_.getBluetoothManualChooserEvents && this.delegate_.getBluetoothManualChooserEvents();
  }
  WebTestControlHostStub.prototype.setPopupBlockingEnabled = function(blockPopups) {
    return this.delegate_ && this.delegate_.setPopupBlockingEnabled && this.delegate_.setPopupBlockingEnabled(blockPopups);
  }
  WebTestControlHostStub.prototype.loadURLForFrame = function(url, frameName) {
    return this.delegate_ && this.delegate_.loadURLForFrame && this.delegate_.loadURLForFrame(url, frameName);
  }
  WebTestControlHostStub.prototype.simulateScreenOrientationChanged = function() {
    return this.delegate_ && this.delegate_.simulateScreenOrientationChanged && this.delegate_.simulateScreenOrientationChanged();
  }
  WebTestControlHostStub.prototype.setPermission = function(name, status, origin, embeddingOrigin) {
    return this.delegate_ && this.delegate_.setPermission && this.delegate_.setPermission(name, status, origin, embeddingOrigin);
  }
  WebTestControlHostStub.prototype.blockThirdPartyCookies = function(block) {
    return this.delegate_ && this.delegate_.blockThirdPartyCookies && this.delegate_.blockThirdPartyCookies(block);
  }
  WebTestControlHostStub.prototype.getWritableDirectory = function() {
    return this.delegate_ && this.delegate_.getWritableDirectory && this.delegate_.getWritableDirectory();
  }
  WebTestControlHostStub.prototype.setFilePathForMockFileDialog = function(path) {
    return this.delegate_ && this.delegate_.setFilePathForMockFileDialog && this.delegate_.setFilePathForMockFileDialog(path);
  }
  WebTestControlHostStub.prototype.createSubresourceFilterRulesetFile = function(disallowedSuffixes) {
    return this.delegate_ && this.delegate_.createSubresourceFilterRulesetFile && this.delegate_.createSubresourceFilterRulesetFile(disallowedSuffixes);
  }
  WebTestControlHostStub.prototype.focusDevtoolsSecondaryWindow = function() {
    return this.delegate_ && this.delegate_.focusDevtoolsSecondaryWindow && this.delegate_.focusDevtoolsSecondaryWindow();
  }
  WebTestControlHostStub.prototype.setTrustTokenKeyCommitments = function(rawCommitments) {
    return this.delegate_ && this.delegate_.setTrustTokenKeyCommitments && this.delegate_.setTrustTokenKeyCommitments(rawCommitments);
  }
  WebTestControlHostStub.prototype.clearTrustTokenState = function() {
    return this.delegate_ && this.delegate_.clearTrustTokenState && this.delegate_.clearTrustTokenState();
  }
  WebTestControlHostStub.prototype.simulateWebNotificationClick = function(title, actionIndex, reply) {
    return this.delegate_ && this.delegate_.simulateWebNotificationClick && this.delegate_.simulateWebNotificationClick(title, actionIndex, reply);
  }
  WebTestControlHostStub.prototype.simulateWebNotificationClose = function(title, byUser) {
    return this.delegate_ && this.delegate_.simulateWebNotificationClose && this.delegate_.simulateWebNotificationClose(title, byUser);
  }
  WebTestControlHostStub.prototype.simulateWebContentIndexDelete = function(id) {
    return this.delegate_ && this.delegate_.simulateWebContentIndexDelete && this.delegate_.simulateWebContentIndexDelete(id);
  }
  WebTestControlHostStub.prototype.webTestRuntimeFlagsChanged = function(changedWebTestRuntimeFlags) {
    return this.delegate_ && this.delegate_.webTestRuntimeFlagsChanged && this.delegate_.webTestRuntimeFlagsChanged(changedWebTestRuntimeFlags);
  }
  WebTestControlHostStub.prototype.registerIsolatedFileSystem = function(filePaths) {
    return this.delegate_ && this.delegate_.registerIsolatedFileSystem && this.delegate_.registerIsolatedFileSystem(filePaths);
  }
  WebTestControlHostStub.prototype.dropPointerLock = function() {
    return this.delegate_ && this.delegate_.dropPointerLock && this.delegate_.dropPointerLock();
  }
  WebTestControlHostStub.prototype.setPointerLockWillFail = function() {
    return this.delegate_ && this.delegate_.setPointerLockWillFail && this.delegate_.setPointerLockWillFail();
  }
  WebTestControlHostStub.prototype.setPointerLockWillRespondAsynchronously = function() {
    return this.delegate_ && this.delegate_.setPointerLockWillRespondAsynchronously && this.delegate_.setPointerLockWillRespondAsynchronously();
  }
  WebTestControlHostStub.prototype.allowPointerLock = function() {
    return this.delegate_ && this.delegate_.allowPointerLock && this.delegate_.allowPointerLock();
  }
  WebTestControlHostStub.prototype.workItemAdded = function(workItem) {
    return this.delegate_ && this.delegate_.workItemAdded && this.delegate_.workItemAdded(workItem);
  }
  WebTestControlHostStub.prototype.requestWorkItem = function() {
    return this.delegate_ && this.delegate_.requestWorkItem && this.delegate_.requestWorkItem();
  }
  WebTestControlHostStub.prototype.workQueueStatesChanged = function(changedWorkQueueStates) {
    return this.delegate_ && this.delegate_.workQueueStatesChanged && this.delegate_.workQueueStatesChanged(changedWorkQueueStates);
  }
  WebTestControlHostStub.prototype.setAcceptLanguages = function(acceptLanguages) {
    return this.delegate_ && this.delegate_.setAcceptLanguages && this.delegate_.setAcceptLanguages(acceptLanguages);
  }
  WebTestControlHostStub.prototype.setRegisterProtocolHandlerMode = function(mode) {
    return this.delegate_ && this.delegate_.setRegisterProtocolHandlerMode && this.delegate_.setRegisterProtocolHandlerMode(mode);
  }
  WebTestControlHostStub.prototype.enableAutoResize = function(minSize, maxSize) {
    return this.delegate_ && this.delegate_.enableAutoResize && this.delegate_.enableAutoResize(minSize, maxSize);
  }
  WebTestControlHostStub.prototype.disableAutoResize = function(newSize) {
    return this.delegate_ && this.delegate_.disableAutoResize && this.delegate_.disableAutoResize(newSize);
  }

  WebTestControlHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTestControlHost_InitiateCaptureDump_Name:
      var params = reader.decodeStruct(WebTestControlHost_InitiateCaptureDump_Params);
      this.initiateCaptureDump(params.result, params.captureNavigationHistory, params.capturePixels);
      return true;
    case kWebTestControlHost_TestFinishedInSecondaryRenderer_Name:
      var params = reader.decodeStruct(WebTestControlHost_TestFinishedInSecondaryRenderer_Params);
      this.testFinishedInSecondaryRenderer();
      return true;
    case kWebTestControlHost_PrintMessageToStderr_Name:
      var params = reader.decodeStruct(WebTestControlHost_PrintMessageToStderr_Params);
      this.printMessageToStderr(params.message);
      return true;
    case kWebTestControlHost_PrintMessage_Name:
      var params = reader.decodeStruct(WebTestControlHost_PrintMessage_Params);
      this.printMessage(params.message);
      return true;
    case kWebTestControlHost_OverridePreferences_Name:
      var params = reader.decodeStruct(WebTestControlHost_OverridePreferences_Params);
      this.overridePreferences(params.webPreferences);
      return true;
    case kWebTestControlHost_Reload_Name:
      var params = reader.decodeStruct(WebTestControlHost_Reload_Params);
      this.reload();
      return true;
    case kWebTestControlHost_CheckForLeakedWindows_Name:
      var params = reader.decodeStruct(WebTestControlHost_CheckForLeakedWindows_Params);
      this.checkForLeakedWindows();
      return true;
    case kWebTestControlHost_SetMainWindowHidden_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetMainWindowHidden_Params);
      this.setMainWindowHidden(params.hidden);
      return true;
    case kWebTestControlHost_SetFrameWindowHidden_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetFrameWindowHidden_Params);
      this.setFrameWindowHidden(params.frameToken, params.hidden);
      return true;
    case kWebTestControlHost_GoToOffset_Name:
      var params = reader.decodeStruct(WebTestControlHost_GoToOffset_Params);
      this.goToOffset(params.offset);
      return true;
    case kWebTestControlHost_SendBluetoothManualChooserEvent_Name:
      var params = reader.decodeStruct(WebTestControlHost_SendBluetoothManualChooserEvent_Params);
      this.sendBluetoothManualChooserEvent(params.event, params.argument);
      return true;
    case kWebTestControlHost_SetBluetoothManualChooser_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetBluetoothManualChooser_Params);
      this.setBluetoothManualChooser(params.enable);
      return true;
    case kWebTestControlHost_SetPopupBlockingEnabled_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetPopupBlockingEnabled_Params);
      this.setPopupBlockingEnabled(params.blockPopups);
      return true;
    case kWebTestControlHost_LoadURLForFrame_Name:
      var params = reader.decodeStruct(WebTestControlHost_LoadURLForFrame_Params);
      this.loadURLForFrame(params.url, params.frameName);
      return true;
    case kWebTestControlHost_SimulateScreenOrientationChanged_Name:
      var params = reader.decodeStruct(WebTestControlHost_SimulateScreenOrientationChanged_Params);
      this.simulateScreenOrientationChanged();
      return true;
    case kWebTestControlHost_SetPermission_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetPermission_Params);
      this.setPermission(params.name, params.status, params.origin, params.embeddingOrigin);
      return true;
    case kWebTestControlHost_BlockThirdPartyCookies_Name:
      var params = reader.decodeStruct(WebTestControlHost_BlockThirdPartyCookies_Params);
      this.blockThirdPartyCookies(params.block);
      return true;
    case kWebTestControlHost_SetFilePathForMockFileDialog_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetFilePathForMockFileDialog_Params);
      this.setFilePathForMockFileDialog(params.path);
      return true;
    case kWebTestControlHost_FocusDevtoolsSecondaryWindow_Name:
      var params = reader.decodeStruct(WebTestControlHost_FocusDevtoolsSecondaryWindow_Params);
      this.focusDevtoolsSecondaryWindow();
      return true;
    case kWebTestControlHost_SimulateWebNotificationClick_Name:
      var params = reader.decodeStruct(WebTestControlHost_SimulateWebNotificationClick_Params);
      this.simulateWebNotificationClick(params.title, params.actionIndex, params.reply);
      return true;
    case kWebTestControlHost_SimulateWebNotificationClose_Name:
      var params = reader.decodeStruct(WebTestControlHost_SimulateWebNotificationClose_Params);
      this.simulateWebNotificationClose(params.title, params.byUser);
      return true;
    case kWebTestControlHost_SimulateWebContentIndexDelete_Name:
      var params = reader.decodeStruct(WebTestControlHost_SimulateWebContentIndexDelete_Params);
      this.simulateWebContentIndexDelete(params.id);
      return true;
    case kWebTestControlHost_WebTestRuntimeFlagsChanged_Name:
      var params = reader.decodeStruct(WebTestControlHost_WebTestRuntimeFlagsChanged_Params);
      this.webTestRuntimeFlagsChanged(params.changedWebTestRuntimeFlags);
      return true;
    case kWebTestControlHost_DropPointerLock_Name:
      var params = reader.decodeStruct(WebTestControlHost_DropPointerLock_Params);
      this.dropPointerLock();
      return true;
    case kWebTestControlHost_SetPointerLockWillFail_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetPointerLockWillFail_Params);
      this.setPointerLockWillFail();
      return true;
    case kWebTestControlHost_SetPointerLockWillRespondAsynchronously_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params);
      this.setPointerLockWillRespondAsynchronously();
      return true;
    case kWebTestControlHost_AllowPointerLock_Name:
      var params = reader.decodeStruct(WebTestControlHost_AllowPointerLock_Params);
      this.allowPointerLock();
      return true;
    case kWebTestControlHost_WorkItemAdded_Name:
      var params = reader.decodeStruct(WebTestControlHost_WorkItemAdded_Params);
      this.workItemAdded(params.workItem);
      return true;
    case kWebTestControlHost_RequestWorkItem_Name:
      var params = reader.decodeStruct(WebTestControlHost_RequestWorkItem_Params);
      this.requestWorkItem();
      return true;
    case kWebTestControlHost_WorkQueueStatesChanged_Name:
      var params = reader.decodeStruct(WebTestControlHost_WorkQueueStatesChanged_Params);
      this.workQueueStatesChanged(params.changedWorkQueueStates);
      return true;
    case kWebTestControlHost_SetAcceptLanguages_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetAcceptLanguages_Params);
      this.setAcceptLanguages(params.acceptLanguages);
      return true;
    case kWebTestControlHost_SetRegisterProtocolHandlerMode_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetRegisterProtocolHandlerMode_Params);
      this.setRegisterProtocolHandlerMode(params.mode);
      return true;
    case kWebTestControlHost_EnableAutoResize_Name:
      var params = reader.decodeStruct(WebTestControlHost_EnableAutoResize_Params);
      this.enableAutoResize(params.minSize, params.maxSize);
      return true;
    case kWebTestControlHost_DisableAutoResize_Name:
      var params = reader.decodeStruct(WebTestControlHost_DisableAutoResize_Params);
      this.disableAutoResize(params.newSize);
      return true;
    default:
      return false;
    }
  };

  WebTestControlHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTestControlHost_GetBluetoothManualChooserEvents_Name:
      var params = reader.decodeStruct(WebTestControlHost_GetBluetoothManualChooserEvents_Params);
      this.getBluetoothManualChooserEvents().then(function(response) {
        var responseParams =
            new WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams();
        responseParams.events = response.events;
        var builder = new codec.MessageV1Builder(
            kWebTestControlHost_GetBluetoothManualChooserEvents_Name,
            codec.align(WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTestControlHost_GetWritableDirectory_Name:
      var params = reader.decodeStruct(WebTestControlHost_GetWritableDirectory_Params);
      this.getWritableDirectory().then(function(response) {
        var responseParams =
            new WebTestControlHost_GetWritableDirectory_ResponseParams();
        responseParams.path = response.path;
        var builder = new codec.MessageV1Builder(
            kWebTestControlHost_GetWritableDirectory_Name,
            codec.align(WebTestControlHost_GetWritableDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestControlHost_GetWritableDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTestControlHost_CreateSubresourceFilterRulesetFile_Name:
      var params = reader.decodeStruct(WebTestControlHost_CreateSubresourceFilterRulesetFile_Params);
      this.createSubresourceFilterRulesetFile(params.disallowedSuffixes).then(function(response) {
        var responseParams =
            new WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams();
        responseParams.file = response.file;
        var builder = new codec.MessageV1Builder(
            kWebTestControlHost_CreateSubresourceFilterRulesetFile_Name,
            codec.align(WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTestControlHost_SetTrustTokenKeyCommitments_Name:
      var params = reader.decodeStruct(WebTestControlHost_SetTrustTokenKeyCommitments_Params);
      this.setTrustTokenKeyCommitments(params.rawCommitments).then(function(response) {
        var responseParams =
            new WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWebTestControlHost_SetTrustTokenKeyCommitments_Name,
            codec.align(WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTestControlHost_ClearTrustTokenState_Name:
      var params = reader.decodeStruct(WebTestControlHost_ClearTrustTokenState_Params);
      this.clearTrustTokenState().then(function(response) {
        var responseParams =
            new WebTestControlHost_ClearTrustTokenState_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWebTestControlHost_ClearTrustTokenState_Name,
            codec.align(WebTestControlHost_ClearTrustTokenState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestControlHost_ClearTrustTokenState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTestControlHost_RegisterIsolatedFileSystem_Name:
      var params = reader.decodeStruct(WebTestControlHost_RegisterIsolatedFileSystem_Params);
      this.registerIsolatedFileSystem(params.filePaths).then(function(response) {
        var responseParams =
            new WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams();
        responseParams.filesystemId = response.filesystemId;
        var builder = new codec.MessageV1Builder(
            kWebTestControlHost_RegisterIsolatedFileSystem_Name,
            codec.align(WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebTestControlHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebTestControlHost_InitiateCaptureDump_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_InitiateCaptureDump_Params;
      break;
      case kWebTestControlHost_TestFinishedInSecondaryRenderer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_TestFinishedInSecondaryRenderer_Params;
      break;
      case kWebTestControlHost_PrintMessageToStderr_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_PrintMessageToStderr_Params;
      break;
      case kWebTestControlHost_PrintMessage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_PrintMessage_Params;
      break;
      case kWebTestControlHost_OverridePreferences_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_OverridePreferences_Params;
      break;
      case kWebTestControlHost_Reload_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_Reload_Params;
      break;
      case kWebTestControlHost_CheckForLeakedWindows_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_CheckForLeakedWindows_Params;
      break;
      case kWebTestControlHost_SetMainWindowHidden_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetMainWindowHidden_Params;
      break;
      case kWebTestControlHost_SetFrameWindowHidden_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetFrameWindowHidden_Params;
      break;
      case kWebTestControlHost_GoToOffset_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_GoToOffset_Params;
      break;
      case kWebTestControlHost_SendBluetoothManualChooserEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SendBluetoothManualChooserEvent_Params;
      break;
      case kWebTestControlHost_SetBluetoothManualChooser_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetBluetoothManualChooser_Params;
      break;
      case kWebTestControlHost_GetBluetoothManualChooserEvents_Name:
        if (message.expectsResponse())
          paramsClass = WebTestControlHost_GetBluetoothManualChooserEvents_Params;
      break;
      case kWebTestControlHost_SetPopupBlockingEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetPopupBlockingEnabled_Params;
      break;
      case kWebTestControlHost_LoadURLForFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_LoadURLForFrame_Params;
      break;
      case kWebTestControlHost_SimulateScreenOrientationChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SimulateScreenOrientationChanged_Params;
      break;
      case kWebTestControlHost_SetPermission_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetPermission_Params;
      break;
      case kWebTestControlHost_BlockThirdPartyCookies_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_BlockThirdPartyCookies_Params;
      break;
      case kWebTestControlHost_GetWritableDirectory_Name:
        if (message.expectsResponse())
          paramsClass = WebTestControlHost_GetWritableDirectory_Params;
      break;
      case kWebTestControlHost_SetFilePathForMockFileDialog_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetFilePathForMockFileDialog_Params;
      break;
      case kWebTestControlHost_CreateSubresourceFilterRulesetFile_Name:
        if (message.expectsResponse())
          paramsClass = WebTestControlHost_CreateSubresourceFilterRulesetFile_Params;
      break;
      case kWebTestControlHost_FocusDevtoolsSecondaryWindow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_FocusDevtoolsSecondaryWindow_Params;
      break;
      case kWebTestControlHost_SetTrustTokenKeyCommitments_Name:
        if (message.expectsResponse())
          paramsClass = WebTestControlHost_SetTrustTokenKeyCommitments_Params;
      break;
      case kWebTestControlHost_ClearTrustTokenState_Name:
        if (message.expectsResponse())
          paramsClass = WebTestControlHost_ClearTrustTokenState_Params;
      break;
      case kWebTestControlHost_SimulateWebNotificationClick_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SimulateWebNotificationClick_Params;
      break;
      case kWebTestControlHost_SimulateWebNotificationClose_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SimulateWebNotificationClose_Params;
      break;
      case kWebTestControlHost_SimulateWebContentIndexDelete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SimulateWebContentIndexDelete_Params;
      break;
      case kWebTestControlHost_WebTestRuntimeFlagsChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_WebTestRuntimeFlagsChanged_Params;
      break;
      case kWebTestControlHost_RegisterIsolatedFileSystem_Name:
        if (message.expectsResponse())
          paramsClass = WebTestControlHost_RegisterIsolatedFileSystem_Params;
      break;
      case kWebTestControlHost_DropPointerLock_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_DropPointerLock_Params;
      break;
      case kWebTestControlHost_SetPointerLockWillFail_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetPointerLockWillFail_Params;
      break;
      case kWebTestControlHost_SetPointerLockWillRespondAsynchronously_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params;
      break;
      case kWebTestControlHost_AllowPointerLock_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_AllowPointerLock_Params;
      break;
      case kWebTestControlHost_WorkItemAdded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_WorkItemAdded_Params;
      break;
      case kWebTestControlHost_RequestWorkItem_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_RequestWorkItem_Params;
      break;
      case kWebTestControlHost_WorkQueueStatesChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_WorkQueueStatesChanged_Params;
      break;
      case kWebTestControlHost_SetAcceptLanguages_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetAcceptLanguages_Params;
      break;
      case kWebTestControlHost_SetRegisterProtocolHandlerMode_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_SetRegisterProtocolHandlerMode_Params;
      break;
      case kWebTestControlHost_EnableAutoResize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_EnableAutoResize_Params;
      break;
      case kWebTestControlHost_DisableAutoResize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTestControlHost_DisableAutoResize_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebTestControlHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebTestControlHost_GetBluetoothManualChooserEvents_Name:
        if (message.isResponse())
          paramsClass = WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams;
        break;
      case kWebTestControlHost_GetWritableDirectory_Name:
        if (message.isResponse())
          paramsClass = WebTestControlHost_GetWritableDirectory_ResponseParams;
        break;
      case kWebTestControlHost_CreateSubresourceFilterRulesetFile_Name:
        if (message.isResponse())
          paramsClass = WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams;
        break;
      case kWebTestControlHost_SetTrustTokenKeyCommitments_Name:
        if (message.isResponse())
          paramsClass = WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams;
        break;
      case kWebTestControlHost_ClearTrustTokenState_Name:
        if (message.isResponse())
          paramsClass = WebTestControlHost_ClearTrustTokenState_ResponseParams;
        break;
      case kWebTestControlHost_RegisterIsolatedFileSystem_Name:
        if (message.isResponse())
          paramsClass = WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebTestControlHost = {
    name: 'content.mojom.WebTestControlHost',
    kVersion: 0,
    ptrClass: WebTestControlHostPtr,
    proxyClass: WebTestControlHostProxy,
    stubClass: WebTestControlHostStub,
    validateRequest: validateWebTestControlHostRequest,
    validateResponse: validateWebTestControlHostResponse,
  };
  WebTestControlHost.AutoResponseMode = {};
  WebTestControlHost.AutoResponseMode.kNone = 0;
  WebTestControlHost.AutoResponseMode.kAutoAccept = 1;
  WebTestControlHost.AutoResponseMode.kAutoReject = 2;
  WebTestControlHost.AutoResponseMode.MIN_VALUE = 0;
  WebTestControlHost.AutoResponseMode.MAX_VALUE = 2;

  WebTestControlHost.AutoResponseMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WebTestControlHost.AutoResponseMode.toKnownEnumValue = function(value) {
    return value;
  };

  WebTestControlHost.AutoResponseMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  WebTestControlHostStub.prototype.validator = validateWebTestControlHostRequest;
  WebTestControlHostProxy.prototype.validator = validateWebTestControlHostResponse;
  var kNonAssociatedWebTestControlHost_SetLCPPNavigationHint_Name = 0;

  function NonAssociatedWebTestControlHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NonAssociatedWebTestControlHost,
                                                   handleOrPtrInfo);
  }

  function NonAssociatedWebTestControlHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NonAssociatedWebTestControlHost, associatedInterfacePtrInfo);
  }

  NonAssociatedWebTestControlHostAssociatedPtr.prototype =
      Object.create(NonAssociatedWebTestControlHostPtr.prototype);
  NonAssociatedWebTestControlHostAssociatedPtr.prototype.constructor =
      NonAssociatedWebTestControlHostAssociatedPtr;

  function NonAssociatedWebTestControlHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  NonAssociatedWebTestControlHostPtr.prototype.setLCPPNavigationHint = function() {
    return NonAssociatedWebTestControlHostProxy.prototype.setLCPPNavigationHint
        .apply(this.ptr.getProxy(), arguments);
  };

  NonAssociatedWebTestControlHostProxy.prototype.setLCPPNavigationHint = function(hint) {
    var params_ = new NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params();
    params_.hint = hint;
    var builder = new codec.MessageV0Builder(
        kNonAssociatedWebTestControlHost_SetLCPPNavigationHint_Name,
        codec.align(NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params.encodedSize));
    builder.encodeStruct(NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NonAssociatedWebTestControlHostStub(delegate) {
    this.delegate_ = delegate;
  }
  NonAssociatedWebTestControlHostStub.prototype.setLCPPNavigationHint = function(hint) {
    return this.delegate_ && this.delegate_.setLCPPNavigationHint && this.delegate_.setLCPPNavigationHint(hint);
  }

  NonAssociatedWebTestControlHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNonAssociatedWebTestControlHost_SetLCPPNavigationHint_Name:
      var params = reader.decodeStruct(NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params);
      this.setLCPPNavigationHint(params.hint);
      return true;
    default:
      return false;
    }
  };

  NonAssociatedWebTestControlHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateNonAssociatedWebTestControlHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNonAssociatedWebTestControlHost_SetLCPPNavigationHint_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNonAssociatedWebTestControlHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NonAssociatedWebTestControlHost = {
    name: 'content.mojom.NonAssociatedWebTestControlHost',
    kVersion: 0,
    ptrClass: NonAssociatedWebTestControlHostPtr,
    proxyClass: NonAssociatedWebTestControlHostProxy,
    stubClass: NonAssociatedWebTestControlHostStub,
    validateRequest: validateNonAssociatedWebTestControlHostRequest,
    validateResponse: null,
  };
  NonAssociatedWebTestControlHostStub.prototype.validator = validateNonAssociatedWebTestControlHostRequest;
  NonAssociatedWebTestControlHostProxy.prototype.validator = null;
  exports.WebTestRunTestConfiguration = WebTestRunTestConfiguration;
  exports.WebTestRendererDumpResult = WebTestRendererDumpResult;
  exports.WorkItemBackForward = WorkItemBackForward;
  exports.WorkItemLoad = WorkItemLoad;
  exports.WorkItemReload = WorkItemReload;
  exports.WorkItemLoadingScript = WorkItemLoadingScript;
  exports.WorkItemNonLoadingScript = WorkItemNonLoadingScript;
  exports.WorkItem = WorkItem;
  exports.WebTestRenderFrame = WebTestRenderFrame;
  exports.WebTestRenderFramePtr = WebTestRenderFramePtr;
  exports.WebTestRenderFrameAssociatedPtr = WebTestRenderFrameAssociatedPtr;
  exports.WebTestControlHost = WebTestControlHost;
  exports.WebTestControlHostPtr = WebTestControlHostPtr;
  exports.WebTestControlHostAssociatedPtr = WebTestControlHostAssociatedPtr;
  exports.NonAssociatedWebTestControlHost = NonAssociatedWebTestControlHost;
  exports.NonAssociatedWebTestControlHostPtr = NonAssociatedWebTestControlHostPtr;
  exports.NonAssociatedWebTestControlHostAssociatedPtr = NonAssociatedWebTestControlHostAssociatedPtr;
})();