// extensions/common/mojom/automation_registry.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  AutomationRemote as ax_mojom_AutomationRemote,
  AutomationPendingReceiver as ax_mojom_AutomationPendingReceiver
} from '../../../services/accessibility/public/mojom/automation.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererAutomationRegistryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.RendererAutomationRegistry', scope);
  }
}

/** @interface */
export class RendererAutomationRegistryInterface {
  
  /**
   * @param { !Object } automation
   */

  bindAutomation(automation) {}
}

/**
 * @implements { RendererAutomationRegistryInterface }
 */
export class RendererAutomationRegistryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererAutomationRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererAutomationRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererAutomationRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } automation
   */

  bindAutomation(
      automation) {
    this.proxy.sendMessage(
        0,
        RendererAutomationRegistry_BindAutomation_ParamsSpec.$,
        null,
        [
          automation
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererAutomationRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererAutomationRegistryReceiver {
  /**
   * @param {!RendererAutomationRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererAutomationRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererAutomationRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAutomationRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererAutomationRegistry_BindAutomation_ParamsSpec.$,
        null,
        impl.bindAutomation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererAutomationRegistry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.RendererAutomationRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererAutomationRegistryRemote}
   */
  static getRemote() {
    let remote = new RendererAutomationRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererAutomationRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererAutomationRegistryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererAutomationRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAutomationRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindAutomation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererAutomationRegistry_BindAutomation_ParamsSpec.$,
        null,
        this.bindAutomation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererAutomationRegistry_BindAutomation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RendererAutomationRegistry_BindAutomation_ParamsSpec.$,
    'RendererAutomationRegistry_BindAutomation_Params',
    [
      mojo.internal.StructField(
        'automation', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(ax_mojom_AutomationRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererAutomationRegistry_BindAutomation_Params {
  constructor() {
    /** @type { !Object } */
    this.automation;
  }
}

