// extensions/common/mojom/frame.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/frame.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var uuid$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/uuid.mojom', '../../../mojo/public/mojom/base/uuid.mojom.js');
  }
  var code_injection$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/code_injection.mojom', 'code_injection.mojom.js');
  }
  var context_type$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/context_type.mojom', 'context_type.mojom.js');
  }
  var extra_response_data$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/extra_response_data.mojom', 'extra_response_data.mojom.js');
  }
  var host_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/host_id.mojom', 'host_id.mojom.js');
  }
  var injection_type$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/injection_type.mojom', 'injection_type.mojom.js');
  }
  var extension_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/extension_id.mojom', 'extension_id.mojom.js');
  }
  var match_origin_as_fallback$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/match_origin_as_fallback.mojom', 'match_origin_as_fallback.mojom.js');
  }
  var message_port$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/message_port.mojom', 'message_port.mojom.js');
  }
  var run_location$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/run_location.mojom', 'run_location.mojom.js');
  }
  var stack_frame$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/stack_frame.mojom', 'stack_frame.mojom.js');
  }
  var view_type$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/view_type.mojom', 'view_type.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }
  var console_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/devtools/console_message.mojom', '../../../third_party/blink/public/mojom/devtools/console_message.mojom.js');
  }



  function ExecuteCodeParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ExecuteCodeParams.prototype.initDefaults_ = function() {
    this.hostId = null;
    this.injection = null;
    this.webviewSrc = null;
    this.matchOriginAsFallbackBehavior = 0;
    this.runAt = 0;
    this.isWebView = false;
  };
  ExecuteCodeParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ExecuteCodeParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExecuteCodeParams.hostId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, host_id$.HostID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExecuteCodeParams.injection
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, code_injection$.CodeInjection, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExecuteCodeParams.webviewSrc
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExecuteCodeParams.matchOriginAsFallbackBehavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, match_origin_as_fallback$.MatchOriginAsFallbackBehavior);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExecuteCodeParams.runAt
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, run_location$.RunLocation);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ExecuteCodeParams.encodedSize = codec.kStructHeaderSize + 48;

  ExecuteCodeParams.decode = function(decoder) {
    var packed;
    var val = new ExecuteCodeParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hostId =
        decoder.decodeStructPointer(host_id$.HostID);
    val.injection =
        decoder.decodeStruct(code_injection$.CodeInjection);
    val.webviewSrc =
        decoder.decodeStructPointer(url$.Url);
    val.matchOriginAsFallbackBehavior =
        decoder.decodeStruct(new codec.Enum(match_origin_as_fallback$.MatchOriginAsFallbackBehavior));
    val.runAt =
        decoder.decodeStruct(new codec.Enum(run_location$.RunLocation));
    packed = decoder.readUint8();
    val.isWebView = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ExecuteCodeParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ExecuteCodeParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(host_id$.HostID, val.hostId);
    encoder.encodeStruct(code_injection$.CodeInjection, val.injection);
    encoder.encodeStructPointer(url$.Url, val.webviewSrc);
    encoder.encodeStruct(codec.Int32, val.matchOriginAsFallbackBehavior);
    encoder.encodeStruct(codec.Int32, val.runAt);
    packed = 0;
    packed |= (val.isWebView & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RequestParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RequestParams.prototype.initDefaults_ = function() {
    this.name = null;
    this.arguments = null;
    this.extensionId = null;
    this.sourceUrl = null;
    this.contextType = 0;
    this.requestId = 0;
    this.hasCallback = false;
    this.userGesture = false;
    this.workerThreadId = 0;
    this.serviceWorkerVersionId = 0;
    this.jsCallstack = null;
  };
  RequestParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RequestParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestParams.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestParams.arguments
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestParams.extensionId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestParams.sourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestParams.contextType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, context_type$.ContextType);
    if (err !== validator.validationError.NONE)
        return err;







    // validate RequestParams.jsCallstack
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(stack_frame$.StackFrame), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RequestParams.encodedSize = codec.kStructHeaderSize + 64;

  RequestParams.decode = function(decoder) {
    var packed;
    var val = new RequestParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.arguments =
        decoder.decodeStructPointer(values$.ListValue);
    val.extensionId =
        decoder.decodeStruct(codec.String);
    val.sourceUrl =
        decoder.decodeStructPointer(url$.Url);
    val.contextType =
        decoder.decodeStruct(new codec.Enum(context_type$.ContextType));
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.hasCallback = (packed >> 0) & 1 ? true : false;
    val.userGesture = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.workerThreadId =
        decoder.decodeStruct(codec.Int32);
    val.serviceWorkerVersionId =
        decoder.decodeStruct(codec.Int64);
    val.jsCallstack =
        decoder.decodeArrayPointer(new codec.PointerTo(stack_frame$.StackFrame));
    return val;
  };

  RequestParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RequestParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(values$.ListValue, val.arguments);
    encoder.encodeStruct(codec.String, val.extensionId);
    encoder.encodeStructPointer(url$.Url, val.sourceUrl);
    encoder.encodeStruct(codec.Int32, val.contextType);
    encoder.encodeStruct(codec.Int32, val.requestId);
    packed = 0;
    packed |= (val.hasCallback & 1) << 0
    packed |= (val.userGesture & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.workerThreadId);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerVersionId);
    encoder.encodeArrayPointer(new codec.PointerTo(stack_frame$.StackFrame), val.jsCallstack);
  };
  function LocalFrame_SetFrameName_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_SetFrameName_Params.prototype.initDefaults_ = function() {
    this.frameName = null;
  };
  LocalFrame_SetFrameName_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_SetFrameName_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_SetFrameName_Params.frameName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_SetFrameName_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_SetFrameName_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_SetFrameName_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LocalFrame_SetFrameName_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_SetFrameName_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.frameName);
  };
  function LocalFrame_SetSpatialNavigationEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_SetSpatialNavigationEnabled_Params.prototype.initDefaults_ = function() {
    this.spatialNavEnabled = false;
  };
  LocalFrame_SetSpatialNavigationEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_SetSpatialNavigationEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LocalFrame_SetSpatialNavigationEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_SetSpatialNavigationEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_SetSpatialNavigationEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.spatialNavEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrame_SetSpatialNavigationEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_SetSpatialNavigationEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.spatialNavEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrame_SetTabId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_SetTabId_Params.prototype.initDefaults_ = function() {
    this.tabId = 0;
  };
  LocalFrame_SetTabId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_SetTabId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LocalFrame_SetTabId_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_SetTabId_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_SetTabId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tabId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrame_SetTabId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_SetTabId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.tabId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrame_AppWindowClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_AppWindowClosed_Params.prototype.initDefaults_ = function() {
    this.sendOnclosed = false;
  };
  LocalFrame_AppWindowClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_AppWindowClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LocalFrame_AppWindowClosed_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_AppWindowClosed_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_AppWindowClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.sendOnclosed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrame_AppWindowClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_AppWindowClosed_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.sendOnclosed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrame_NotifyRenderViewType_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_NotifyRenderViewType_Params.prototype.initDefaults_ = function() {
    this.viewType = 0;
  };
  LocalFrame_NotifyRenderViewType_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_NotifyRenderViewType_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_NotifyRenderViewType_Params.viewType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, view_type$.ViewType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_NotifyRenderViewType_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_NotifyRenderViewType_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_NotifyRenderViewType_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.viewType =
        decoder.decodeStruct(new codec.Enum(view_type$.ViewType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrame_NotifyRenderViewType_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_NotifyRenderViewType_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.viewType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrame_MessageInvoke_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_MessageInvoke_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.moduleName = null;
    this.functionName = null;
    this.args = null;
  };
  LocalFrame_MessageInvoke_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_MessageInvoke_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_MessageInvoke_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_MessageInvoke_Params.moduleName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_MessageInvoke_Params.functionName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_MessageInvoke_Params.args
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_MessageInvoke_Params.encodedSize = codec.kStructHeaderSize + 32;

  LocalFrame_MessageInvoke_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_MessageInvoke_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.moduleName =
        decoder.decodeStruct(codec.String);
    val.functionName =
        decoder.decodeStruct(codec.String);
    val.args =
        decoder.decodeStructPointer(values$.ListValue);
    return val;
  };

  LocalFrame_MessageInvoke_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_MessageInvoke_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.moduleName);
    encoder.encodeStruct(codec.String, val.functionName);
    encoder.encodeStructPointer(values$.ListValue, val.args);
  };
  function LocalFrame_ExecuteCode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_ExecuteCode_Params.prototype.initDefaults_ = function() {
    this.param = null;
  };
  LocalFrame_ExecuteCode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_ExecuteCode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_ExecuteCode_Params.param
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ExecuteCodeParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_ExecuteCode_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_ExecuteCode_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_ExecuteCode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.param =
        decoder.decodeStructPointer(ExecuteCodeParams);
    return val;
  };

  LocalFrame_ExecuteCode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_ExecuteCode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ExecuteCodeParams, val.param);
  };
  function LocalFrame_ExecuteCode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_ExecuteCode_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
    this.url = null;
    this.result = null;
  };
  LocalFrame_ExecuteCode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_ExecuteCode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_ExecuteCode_ResponseParams.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_ExecuteCode_ResponseParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_ExecuteCode_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, values$.Value, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_ExecuteCode_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  LocalFrame_ExecuteCode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_ExecuteCode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.result =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  LocalFrame_ExecuteCode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_ExecuteCode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.error);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(values$.Value, val.result);
  };
  function LocalFrame_ExecuteDeclarativeScript_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_ExecuteDeclarativeScript_Params.prototype.initDefaults_ = function() {
    this.tabId = 0;
    this.extensionId = null;
    this.scriptId = null;
    this.url = null;
  };
  LocalFrame_ExecuteDeclarativeScript_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_ExecuteDeclarativeScript_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LocalFrame_ExecuteDeclarativeScript_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_ExecuteDeclarativeScript_Params.scriptId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_ExecuteDeclarativeScript_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_ExecuteDeclarativeScript_Params.encodedSize = codec.kStructHeaderSize + 32;

  LocalFrame_ExecuteDeclarativeScript_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_ExecuteDeclarativeScript_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tabId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.scriptId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  LocalFrame_ExecuteDeclarativeScript_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_ExecuteDeclarativeScript_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.tabId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.scriptId);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function LocalFrame_UpdateBrowserWindowId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_UpdateBrowserWindowId_Params.prototype.initDefaults_ = function() {
    this.windowId = 0;
  };
  LocalFrame_UpdateBrowserWindowId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_UpdateBrowserWindowId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LocalFrame_UpdateBrowserWindowId_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_UpdateBrowserWindowId_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_UpdateBrowserWindowId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.windowId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrame_UpdateBrowserWindowId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_UpdateBrowserWindowId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.windowId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrame_DispatchOnConnect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_DispatchOnConnect_Params.prototype.initDefaults_ = function() {
    this.portId = null;
    this.channelType = 0;
    this.port = new associatedBindings.AssociatedInterfaceRequest();
    this.channelName = null;
    this.tabInfo = null;
    this.externalConnectionInfo = null;
    this.portHost = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  LocalFrame_DispatchOnConnect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_DispatchOnConnect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.channelType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, message_port$.ChannelType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.channelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.tabInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, message_port$.TabConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.externalConnectionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, message_port$.ExternalConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.port
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrame_DispatchOnConnect_Params.portHost
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 40, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrame_DispatchOnConnect_Params.encodedSize = codec.kStructHeaderSize + 48;

  LocalFrame_DispatchOnConnect_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_DispatchOnConnect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.channelType =
        decoder.decodeStruct(new codec.Enum(message_port$.ChannelType));
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.channelName =
        decoder.decodeStruct(codec.String);
    val.tabInfo =
        decoder.decodeStructPointer(message_port$.TabConnectionInfo);
    val.externalConnectionInfo =
        decoder.decodeStructPointer(message_port$.ExternalConnectionInfo);
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  LocalFrame_DispatchOnConnect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_DispatchOnConnect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.Int32, val.channelType);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.port);
    encoder.encodeStruct(codec.String, val.channelName);
    encoder.encodeStructPointer(message_port$.TabConnectionInfo, val.tabInfo);
    encoder.encodeStructPointer(message_port$.ExternalConnectionInfo, val.externalConnectionInfo);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.portHost);
  };
  function LocalFrame_DispatchOnConnect_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrame_DispatchOnConnect_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  LocalFrame_DispatchOnConnect_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrame_DispatchOnConnect_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LocalFrame_DispatchOnConnect_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrame_DispatchOnConnect_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LocalFrame_DispatchOnConnect_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrame_DispatchOnConnect_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrame_DispatchOnConnect_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrameHost_RequestScriptInjectionPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_RequestScriptInjectionPermission_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.scriptType = 0;
    this.runLocation = 0;
  };
  LocalFrameHost_RequestScriptInjectionPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_RequestScriptInjectionPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_RequestScriptInjectionPermission_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_RequestScriptInjectionPermission_Params.scriptType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, injection_type$.InjectionType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_RequestScriptInjectionPermission_Params.runLocation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, run_location$.RunLocation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_RequestScriptInjectionPermission_Params.encodedSize = codec.kStructHeaderSize + 16;

  LocalFrameHost_RequestScriptInjectionPermission_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_RequestScriptInjectionPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.scriptType =
        decoder.decodeStruct(new codec.Enum(injection_type$.InjectionType));
    val.runLocation =
        decoder.decodeStruct(new codec.Enum(run_location$.RunLocation));
    return val;
  };

  LocalFrameHost_RequestScriptInjectionPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_RequestScriptInjectionPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.Int32, val.scriptType);
    encoder.encodeStruct(codec.Int32, val.runLocation);
  };
  function LocalFrameHost_RequestScriptInjectionPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.granted = false;
  };
  LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_RequestScriptInjectionPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.granted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.granted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrameHost_GetAppInstallState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_GetAppInstallState_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  LocalFrameHost_GetAppInstallState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_GetAppInstallState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_GetAppInstallState_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_GetAppInstallState_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameHost_GetAppInstallState_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_GetAppInstallState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  LocalFrameHost_GetAppInstallState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_GetAppInstallState_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function LocalFrameHost_GetAppInstallState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_GetAppInstallState_ResponseParams.prototype.initDefaults_ = function() {
    this.state = null;
  };
  LocalFrameHost_GetAppInstallState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_GetAppInstallState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_GetAppInstallState_ResponseParams.state
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_GetAppInstallState_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameHost_GetAppInstallState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_GetAppInstallState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LocalFrameHost_GetAppInstallState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_GetAppInstallState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.state);
  };
  function LocalFrameHost_Request_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_Request_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  LocalFrameHost_Request_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_Request_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_Request_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, RequestParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_Request_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameHost_Request_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_Request_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(RequestParams);
    return val;
  };

  LocalFrameHost_Request_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_Request_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(RequestParams, val.params);
  };
  function LocalFrameHost_Request_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_Request_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.responseWrapper = null;
    this.error = null;
    this.extraData = null;
  };
  LocalFrameHost_Request_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_Request_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LocalFrameHost_Request_ResponseParams.responseWrapper
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_Request_ResponseParams.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_Request_ResponseParams.extraData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, extra_response_data$.ExtraResponseData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_Request_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  LocalFrameHost_Request_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_Request_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.responseWrapper =
        decoder.decodeStructPointer(values$.ListValue);
    val.error =
        decoder.decodeStruct(codec.String);
    val.extraData =
        decoder.decodeStructPointer(extra_response_data$.ExtraResponseData);
    return val;
  };

  LocalFrameHost_Request_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_Request_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(values$.ListValue, val.responseWrapper);
    encoder.encodeStruct(codec.String, val.error);
    encoder.encodeStructPointer(extra_response_data$.ExtraResponseData, val.extraData);
  };
  function LocalFrameHost_ResponseAck_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_ResponseAck_Params.prototype.initDefaults_ = function() {
    this.requestUuid = null;
  };
  LocalFrameHost_ResponseAck_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_ResponseAck_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_ResponseAck_Params.requestUuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, uuid$.Uuid, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_ResponseAck_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameHost_ResponseAck_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_ResponseAck_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestUuid =
        decoder.decodeStructPointer(uuid$.Uuid);
    return val;
  };

  LocalFrameHost_ResponseAck_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_ResponseAck_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(uuid$.Uuid, val.requestUuid);
  };
  function LocalFrameHost_WatchedPageChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_WatchedPageChange_Params.prototype.initDefaults_ = function() {
    this.cssSelectors = null;
  };
  LocalFrameHost_WatchedPageChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_WatchedPageChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_WatchedPageChange_Params.cssSelectors
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_WatchedPageChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameHost_WatchedPageChange_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_WatchedPageChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cssSelectors =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  LocalFrameHost_WatchedPageChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_WatchedPageChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.cssSelectors);
  };
  function LocalFrameHost_DetailedConsoleMessageAdded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_DetailedConsoleMessageAdded_Params.prototype.initDefaults_ = function() {
    this.message = null;
    this.source = null;
    this.stackTrace = null;
    this.level = 0;
  };
  LocalFrameHost_DetailedConsoleMessageAdded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_DetailedConsoleMessageAdded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_DetailedConsoleMessageAdded_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_DetailedConsoleMessageAdded_Params.source
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_DetailedConsoleMessageAdded_Params.stackTrace
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(stack_frame$.StackFrame), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_DetailedConsoleMessageAdded_Params.level
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, console_message$.ConsoleMessageLevel);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_DetailedConsoleMessageAdded_Params.encodedSize = codec.kStructHeaderSize + 32;

  LocalFrameHost_DetailedConsoleMessageAdded_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_DetailedConsoleMessageAdded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStructPointer(string16$.String16);
    val.source =
        decoder.decodeStructPointer(string16$.String16);
    val.stackTrace =
        decoder.decodeArrayPointer(new codec.PointerTo(stack_frame$.StackFrame));
    val.level =
        decoder.decodeStruct(new codec.Enum(console_message$.ConsoleMessageLevel));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrameHost_DetailedConsoleMessageAdded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_DetailedConsoleMessageAdded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.message);
    encoder.encodeStructPointer(string16$.String16, val.source);
    encoder.encodeArrayPointer(new codec.PointerTo(stack_frame$.StackFrame), val.stackTrace);
    encoder.encodeStruct(codec.Int32, val.level);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrameHost_ContentScriptsExecuting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_ContentScriptsExecuting_Params.prototype.initDefaults_ = function() {
    this.extensionIdToScripts = null;
    this.frameUrl = null;
  };
  LocalFrameHost_ContentScriptsExecuting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_ContentScriptsExecuting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_ContentScriptsExecuting_Params.extensionIdToScripts
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.ArrayOf(codec.String), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_ContentScriptsExecuting_Params.frameUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_ContentScriptsExecuting_Params.encodedSize = codec.kStructHeaderSize + 16;

  LocalFrameHost_ContentScriptsExecuting_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_ContentScriptsExecuting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionIdToScripts =
        decoder.decodeMapPointer(codec.String, new codec.ArrayOf(codec.String));
    val.frameUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  LocalFrameHost_ContentScriptsExecuting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_ContentScriptsExecuting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.ArrayOf(codec.String), val.extensionIdToScripts);
    encoder.encodeStructPointer(url$.Url, val.frameUrl);
  };
  function LocalFrameHost_IncrementLazyKeepaliveCount_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_IncrementLazyKeepaliveCount_Params.prototype.initDefaults_ = function() {
  };
  LocalFrameHost_IncrementLazyKeepaliveCount_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_IncrementLazyKeepaliveCount_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_IncrementLazyKeepaliveCount_Params.encodedSize = codec.kStructHeaderSize + 0;

  LocalFrameHost_IncrementLazyKeepaliveCount_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_IncrementLazyKeepaliveCount_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  LocalFrameHost_IncrementLazyKeepaliveCount_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_IncrementLazyKeepaliveCount_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function LocalFrameHost_DecrementLazyKeepaliveCount_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_DecrementLazyKeepaliveCount_Params.prototype.initDefaults_ = function() {
  };
  LocalFrameHost_DecrementLazyKeepaliveCount_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_DecrementLazyKeepaliveCount_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_DecrementLazyKeepaliveCount_Params.encodedSize = codec.kStructHeaderSize + 0;

  LocalFrameHost_DecrementLazyKeepaliveCount_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_DecrementLazyKeepaliveCount_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  LocalFrameHost_DecrementLazyKeepaliveCount_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_DecrementLazyKeepaliveCount_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function LocalFrameHost_AppWindowReady_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_AppWindowReady_Params.prototype.initDefaults_ = function() {
  };
  LocalFrameHost_AppWindowReady_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_AppWindowReady_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_AppWindowReady_Params.encodedSize = codec.kStructHeaderSize + 0;

  LocalFrameHost_AppWindowReady_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_AppWindowReady_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  LocalFrameHost_AppWindowReady_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_AppWindowReady_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function LocalFrameHost_OpenChannelToExtension_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_OpenChannelToExtension_Params.prototype.initDefaults_ = function() {
    this.info = null;
    this.channelType = 0;
    this.portHost = new associatedBindings.AssociatedInterfaceRequest();
    this.channelName = null;
    this.portId = null;
    this.port = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  LocalFrameHost_OpenChannelToExtension_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_OpenChannelToExtension_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToExtension_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, message_port$.ExternalConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToExtension_Params.channelType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, message_port$.ChannelType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToExtension_Params.channelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToExtension_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToExtension_Params.port
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 32, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToExtension_Params.portHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_OpenChannelToExtension_Params.encodedSize = codec.kStructHeaderSize + 40;

  LocalFrameHost_OpenChannelToExtension_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_OpenChannelToExtension_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(message_port$.ExternalConnectionInfo);
    val.channelType =
        decoder.decodeStruct(new codec.Enum(message_port$.ChannelType));
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.channelName =
        decoder.decodeStruct(codec.String);
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  LocalFrameHost_OpenChannelToExtension_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_OpenChannelToExtension_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(message_port$.ExternalConnectionInfo, val.info);
    encoder.encodeStruct(codec.Int32, val.channelType);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.portHost);
    encoder.encodeStruct(codec.String, val.channelName);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.port);
  };
  function LocalFrameHost_OpenChannelToNativeApp_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_OpenChannelToNativeApp_Params.prototype.initDefaults_ = function() {
    this.nativeAppName = null;
    this.portId = null;
    this.port = new associatedBindings.AssociatedInterfacePtrInfo();
    this.portHost = new associatedBindings.AssociatedInterfaceRequest();
  };
  LocalFrameHost_OpenChannelToNativeApp_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_OpenChannelToNativeApp_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToNativeApp_Params.nativeAppName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToNativeApp_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToNativeApp_Params.port
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToNativeApp_Params.portHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_OpenChannelToNativeApp_Params.encodedSize = codec.kStructHeaderSize + 32;

  LocalFrameHost_OpenChannelToNativeApp_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_OpenChannelToNativeApp_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nativeAppName =
        decoder.decodeStruct(codec.String);
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LocalFrameHost_OpenChannelToNativeApp_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_OpenChannelToNativeApp_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.nativeAppName);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.port);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.portHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LocalFrameHost_OpenChannelToTab_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameHost_OpenChannelToTab_Params.prototype.initDefaults_ = function() {
    this.tabId = 0;
    this.frameId = 0;
    this.documentId = null;
    this.channelType = 0;
    this.portHost = new associatedBindings.AssociatedInterfaceRequest();
    this.channelName = null;
    this.portId = null;
    this.port = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  LocalFrameHost_OpenChannelToTab_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameHost_OpenChannelToTab_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate LocalFrameHost_OpenChannelToTab_Params.documentId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToTab_Params.channelType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, message_port$.ChannelType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToTab_Params.channelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToTab_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToTab_Params.port
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 40, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameHost_OpenChannelToTab_Params.portHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 20, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameHost_OpenChannelToTab_Params.encodedSize = codec.kStructHeaderSize + 48;

  LocalFrameHost_OpenChannelToTab_Params.decode = function(decoder) {
    var packed;
    var val = new LocalFrameHost_OpenChannelToTab_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tabId =
        decoder.decodeStruct(codec.Int32);
    val.frameId =
        decoder.decodeStruct(codec.Int32);
    val.documentId =
        decoder.decodeStruct(codec.String);
    val.channelType =
        decoder.decodeStruct(new codec.Enum(message_port$.ChannelType));
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.channelName =
        decoder.decodeStruct(codec.String);
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  LocalFrameHost_OpenChannelToTab_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameHost_OpenChannelToTab_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.tabId);
    encoder.encodeStruct(codec.Int32, val.frameId);
    encoder.encodeStruct(codec.String, val.documentId);
    encoder.encodeStruct(codec.Int32, val.channelType);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.portHost);
    encoder.encodeStruct(codec.String, val.channelName);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.port);
  };
  var kLocalFrame_SetFrameName_Name = 0;
  var kLocalFrame_SetSpatialNavigationEnabled_Name = 1;
  var kLocalFrame_SetTabId_Name = 2;
  var kLocalFrame_AppWindowClosed_Name = 3;
  var kLocalFrame_NotifyRenderViewType_Name = 4;
  var kLocalFrame_MessageInvoke_Name = 5;
  var kLocalFrame_ExecuteCode_Name = 6;
  var kLocalFrame_ExecuteDeclarativeScript_Name = 7;
  var kLocalFrame_UpdateBrowserWindowId_Name = 8;
  var kLocalFrame_DispatchOnConnect_Name = 9;

  function LocalFramePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LocalFrame,
                                                   handleOrPtrInfo);
  }

  function LocalFrameAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LocalFrame, associatedInterfacePtrInfo);
  }

  LocalFrameAssociatedPtr.prototype =
      Object.create(LocalFramePtr.prototype);
  LocalFrameAssociatedPtr.prototype.constructor =
      LocalFrameAssociatedPtr;

  function LocalFrameProxy(receiver) {
    this.receiver_ = receiver;
  }
  LocalFramePtr.prototype.setFrameName = function() {
    return LocalFrameProxy.prototype.setFrameName
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.setFrameName = function(frameName) {
    var params_ = new LocalFrame_SetFrameName_Params();
    params_.frameName = frameName;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_SetFrameName_Name,
        codec.align(LocalFrame_SetFrameName_Params.encodedSize));
    builder.encodeStruct(LocalFrame_SetFrameName_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.setSpatialNavigationEnabled = function() {
    return LocalFrameProxy.prototype.setSpatialNavigationEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.setSpatialNavigationEnabled = function(spatialNavEnabled) {
    var params_ = new LocalFrame_SetSpatialNavigationEnabled_Params();
    params_.spatialNavEnabled = spatialNavEnabled;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_SetSpatialNavigationEnabled_Name,
        codec.align(LocalFrame_SetSpatialNavigationEnabled_Params.encodedSize));
    builder.encodeStruct(LocalFrame_SetSpatialNavigationEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.setTabId = function() {
    return LocalFrameProxy.prototype.setTabId
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.setTabId = function(tabId) {
    var params_ = new LocalFrame_SetTabId_Params();
    params_.tabId = tabId;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_SetTabId_Name,
        codec.align(LocalFrame_SetTabId_Params.encodedSize));
    builder.encodeStruct(LocalFrame_SetTabId_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.appWindowClosed = function() {
    return LocalFrameProxy.prototype.appWindowClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.appWindowClosed = function(sendOnclosed) {
    var params_ = new LocalFrame_AppWindowClosed_Params();
    params_.sendOnclosed = sendOnclosed;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_AppWindowClosed_Name,
        codec.align(LocalFrame_AppWindowClosed_Params.encodedSize));
    builder.encodeStruct(LocalFrame_AppWindowClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.notifyRenderViewType = function() {
    return LocalFrameProxy.prototype.notifyRenderViewType
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.notifyRenderViewType = function(viewType) {
    var params_ = new LocalFrame_NotifyRenderViewType_Params();
    params_.viewType = viewType;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_NotifyRenderViewType_Name,
        codec.align(LocalFrame_NotifyRenderViewType_Params.encodedSize));
    builder.encodeStruct(LocalFrame_NotifyRenderViewType_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.messageInvoke = function() {
    return LocalFrameProxy.prototype.messageInvoke
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.messageInvoke = function(extensionId, moduleName, functionName, args) {
    var params_ = new LocalFrame_MessageInvoke_Params();
    params_.extensionId = extensionId;
    params_.moduleName = moduleName;
    params_.functionName = functionName;
    params_.args = args;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_MessageInvoke_Name,
        codec.align(LocalFrame_MessageInvoke_Params.encodedSize));
    builder.encodeStruct(LocalFrame_MessageInvoke_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.executeCode = function() {
    return LocalFrameProxy.prototype.executeCode
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.executeCode = function(param) {
    var params_ = new LocalFrame_ExecuteCode_Params();
    params_.param = param;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLocalFrame_ExecuteCode_Name,
          codec.align(LocalFrame_ExecuteCode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LocalFrame_ExecuteCode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LocalFrame_ExecuteCode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LocalFramePtr.prototype.executeDeclarativeScript = function() {
    return LocalFrameProxy.prototype.executeDeclarativeScript
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.executeDeclarativeScript = function(tabId, extensionId, scriptId, url) {
    var params_ = new LocalFrame_ExecuteDeclarativeScript_Params();
    params_.tabId = tabId;
    params_.extensionId = extensionId;
    params_.scriptId = scriptId;
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_ExecuteDeclarativeScript_Name,
        codec.align(LocalFrame_ExecuteDeclarativeScript_Params.encodedSize));
    builder.encodeStruct(LocalFrame_ExecuteDeclarativeScript_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.updateBrowserWindowId = function() {
    return LocalFrameProxy.prototype.updateBrowserWindowId
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.updateBrowserWindowId = function(windowId) {
    var params_ = new LocalFrame_UpdateBrowserWindowId_Params();
    params_.windowId = windowId;
    var builder = new codec.MessageV0Builder(
        kLocalFrame_UpdateBrowserWindowId_Name,
        codec.align(LocalFrame_UpdateBrowserWindowId_Params.encodedSize));
    builder.encodeStruct(LocalFrame_UpdateBrowserWindowId_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFramePtr.prototype.dispatchOnConnect = function() {
    return LocalFrameProxy.prototype.dispatchOnConnect
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameProxy.prototype.dispatchOnConnect = function(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {
    var params_ = new LocalFrame_DispatchOnConnect_Params();
    params_.portId = portId;
    params_.channelType = channelType;
    params_.channelName = channelName;
    params_.tabInfo = tabInfo;
    params_.externalConnectionInfo = externalConnectionInfo;
    params_.port = port;
    params_.portHost = portHost;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kLocalFrame_DispatchOnConnect_Name,
          codec.align(LocalFrame_DispatchOnConnect_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(LocalFrame_DispatchOnConnect_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LocalFrame_DispatchOnConnect_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function LocalFrameStub(delegate) {
    this.delegate_ = delegate;
  }
  LocalFrameStub.prototype.setFrameName = function(frameName) {
    return this.delegate_ && this.delegate_.setFrameName && this.delegate_.setFrameName(frameName);
  }
  LocalFrameStub.prototype.setSpatialNavigationEnabled = function(spatialNavEnabled) {
    return this.delegate_ && this.delegate_.setSpatialNavigationEnabled && this.delegate_.setSpatialNavigationEnabled(spatialNavEnabled);
  }
  LocalFrameStub.prototype.setTabId = function(tabId) {
    return this.delegate_ && this.delegate_.setTabId && this.delegate_.setTabId(tabId);
  }
  LocalFrameStub.prototype.appWindowClosed = function(sendOnclosed) {
    return this.delegate_ && this.delegate_.appWindowClosed && this.delegate_.appWindowClosed(sendOnclosed);
  }
  LocalFrameStub.prototype.notifyRenderViewType = function(viewType) {
    return this.delegate_ && this.delegate_.notifyRenderViewType && this.delegate_.notifyRenderViewType(viewType);
  }
  LocalFrameStub.prototype.messageInvoke = function(extensionId, moduleName, functionName, args) {
    return this.delegate_ && this.delegate_.messageInvoke && this.delegate_.messageInvoke(extensionId, moduleName, functionName, args);
  }
  LocalFrameStub.prototype.executeCode = function(param) {
    return this.delegate_ && this.delegate_.executeCode && this.delegate_.executeCode(param);
  }
  LocalFrameStub.prototype.executeDeclarativeScript = function(tabId, extensionId, scriptId, url) {
    return this.delegate_ && this.delegate_.executeDeclarativeScript && this.delegate_.executeDeclarativeScript(tabId, extensionId, scriptId, url);
  }
  LocalFrameStub.prototype.updateBrowserWindowId = function(windowId) {
    return this.delegate_ && this.delegate_.updateBrowserWindowId && this.delegate_.updateBrowserWindowId(windowId);
  }
  LocalFrameStub.prototype.dispatchOnConnect = function(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {
    return this.delegate_ && this.delegate_.dispatchOnConnect && this.delegate_.dispatchOnConnect(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost);
  }

  LocalFrameStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLocalFrame_SetFrameName_Name:
      var params = reader.decodeStruct(LocalFrame_SetFrameName_Params);
      this.setFrameName(params.frameName);
      return true;
    case kLocalFrame_SetSpatialNavigationEnabled_Name:
      var params = reader.decodeStruct(LocalFrame_SetSpatialNavigationEnabled_Params);
      this.setSpatialNavigationEnabled(params.spatialNavEnabled);
      return true;
    case kLocalFrame_SetTabId_Name:
      var params = reader.decodeStruct(LocalFrame_SetTabId_Params);
      this.setTabId(params.tabId);
      return true;
    case kLocalFrame_AppWindowClosed_Name:
      var params = reader.decodeStruct(LocalFrame_AppWindowClosed_Params);
      this.appWindowClosed(params.sendOnclosed);
      return true;
    case kLocalFrame_NotifyRenderViewType_Name:
      var params = reader.decodeStruct(LocalFrame_NotifyRenderViewType_Params);
      this.notifyRenderViewType(params.viewType);
      return true;
    case kLocalFrame_MessageInvoke_Name:
      var params = reader.decodeStruct(LocalFrame_MessageInvoke_Params);
      this.messageInvoke(params.extensionId, params.moduleName, params.functionName, params.args);
      return true;
    case kLocalFrame_ExecuteDeclarativeScript_Name:
      var params = reader.decodeStruct(LocalFrame_ExecuteDeclarativeScript_Params);
      this.executeDeclarativeScript(params.tabId, params.extensionId, params.scriptId, params.url);
      return true;
    case kLocalFrame_UpdateBrowserWindowId_Name:
      var params = reader.decodeStruct(LocalFrame_UpdateBrowserWindowId_Params);
      this.updateBrowserWindowId(params.windowId);
      return true;
    default:
      return false;
    }
  };

  LocalFrameStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLocalFrame_ExecuteCode_Name:
      var params = reader.decodeStruct(LocalFrame_ExecuteCode_Params);
      this.executeCode(params.param).then(function(response) {
        var responseParams =
            new LocalFrame_ExecuteCode_ResponseParams();
        responseParams.error = response.error;
        responseParams.url = response.url;
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kLocalFrame_ExecuteCode_Name,
            codec.align(LocalFrame_ExecuteCode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LocalFrame_ExecuteCode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLocalFrame_DispatchOnConnect_Name:
      var params = reader.decodeStruct(LocalFrame_DispatchOnConnect_Params);
      this.dispatchOnConnect(params.portId, params.channelType, params.channelName, params.tabInfo, params.externalConnectionInfo, params.port, params.portHost).then(function(response) {
        var responseParams =
            new LocalFrame_DispatchOnConnect_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV2Builder(
            kLocalFrame_DispatchOnConnect_Name,
            codec.align(LocalFrame_DispatchOnConnect_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(LocalFrame_DispatchOnConnect_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateLocalFrameRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLocalFrame_SetFrameName_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_SetFrameName_Params;
      break;
      case kLocalFrame_SetSpatialNavigationEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_SetSpatialNavigationEnabled_Params;
      break;
      case kLocalFrame_SetTabId_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_SetTabId_Params;
      break;
      case kLocalFrame_AppWindowClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_AppWindowClosed_Params;
      break;
      case kLocalFrame_NotifyRenderViewType_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_NotifyRenderViewType_Params;
      break;
      case kLocalFrame_MessageInvoke_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_MessageInvoke_Params;
      break;
      case kLocalFrame_ExecuteCode_Name:
        if (message.expectsResponse())
          paramsClass = LocalFrame_ExecuteCode_Params;
      break;
      case kLocalFrame_ExecuteDeclarativeScript_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_ExecuteDeclarativeScript_Params;
      break;
      case kLocalFrame_UpdateBrowserWindowId_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrame_UpdateBrowserWindowId_Params;
      break;
      case kLocalFrame_DispatchOnConnect_Name:
        if (message.expectsResponse())
          paramsClass = LocalFrame_DispatchOnConnect_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLocalFrameResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kLocalFrame_ExecuteCode_Name:
        if (message.isResponse())
          paramsClass = LocalFrame_ExecuteCode_ResponseParams;
        break;
      case kLocalFrame_DispatchOnConnect_Name:
        if (message.isResponse())
          paramsClass = LocalFrame_DispatchOnConnect_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var LocalFrame = {
    name: 'extensions.mojom.LocalFrame',
    kVersion: 0,
    ptrClass: LocalFramePtr,
    proxyClass: LocalFrameProxy,
    stubClass: LocalFrameStub,
    validateRequest: validateLocalFrameRequest,
    validateResponse: validateLocalFrameResponse,
  };
  LocalFrameStub.prototype.validator = validateLocalFrameRequest;
  LocalFrameProxy.prototype.validator = validateLocalFrameResponse;
  var kLocalFrameHost_RequestScriptInjectionPermission_Name = 0;
  var kLocalFrameHost_GetAppInstallState_Name = 1;
  var kLocalFrameHost_Request_Name = 2;
  var kLocalFrameHost_ResponseAck_Name = 3;
  var kLocalFrameHost_WatchedPageChange_Name = 4;
  var kLocalFrameHost_DetailedConsoleMessageAdded_Name = 5;
  var kLocalFrameHost_ContentScriptsExecuting_Name = 6;
  var kLocalFrameHost_IncrementLazyKeepaliveCount_Name = 7;
  var kLocalFrameHost_DecrementLazyKeepaliveCount_Name = 8;
  var kLocalFrameHost_AppWindowReady_Name = 9;
  var kLocalFrameHost_OpenChannelToExtension_Name = 10;
  var kLocalFrameHost_OpenChannelToNativeApp_Name = 11;
  var kLocalFrameHost_OpenChannelToTab_Name = 12;

  function LocalFrameHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LocalFrameHost,
                                                   handleOrPtrInfo);
  }

  function LocalFrameHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LocalFrameHost, associatedInterfacePtrInfo);
  }

  LocalFrameHostAssociatedPtr.prototype =
      Object.create(LocalFrameHostPtr.prototype);
  LocalFrameHostAssociatedPtr.prototype.constructor =
      LocalFrameHostAssociatedPtr;

  function LocalFrameHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  LocalFrameHostPtr.prototype.requestScriptInjectionPermission = function() {
    return LocalFrameHostProxy.prototype.requestScriptInjectionPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.requestScriptInjectionPermission = function(extensionId, scriptType, runLocation) {
    var params_ = new LocalFrameHost_RequestScriptInjectionPermission_Params();
    params_.extensionId = extensionId;
    params_.scriptType = scriptType;
    params_.runLocation = runLocation;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLocalFrameHost_RequestScriptInjectionPermission_Name,
          codec.align(LocalFrameHost_RequestScriptInjectionPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LocalFrameHost_RequestScriptInjectionPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LocalFrameHost_RequestScriptInjectionPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LocalFrameHostPtr.prototype.getAppInstallState = function() {
    return LocalFrameHostProxy.prototype.getAppInstallState
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.getAppInstallState = function(url) {
    var params_ = new LocalFrameHost_GetAppInstallState_Params();
    params_.url = url;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLocalFrameHost_GetAppInstallState_Name,
          codec.align(LocalFrameHost_GetAppInstallState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LocalFrameHost_GetAppInstallState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LocalFrameHost_GetAppInstallState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LocalFrameHostPtr.prototype.request = function() {
    return LocalFrameHostProxy.prototype.request
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.request = function(params) {
    var params_ = new LocalFrameHost_Request_Params();
    params_.params = params;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLocalFrameHost_Request_Name,
          codec.align(LocalFrameHost_Request_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LocalFrameHost_Request_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LocalFrameHost_Request_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LocalFrameHostPtr.prototype.responseAck = function() {
    return LocalFrameHostProxy.prototype.responseAck
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.responseAck = function(requestUuid) {
    var params_ = new LocalFrameHost_ResponseAck_Params();
    params_.requestUuid = requestUuid;
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_ResponseAck_Name,
        codec.align(LocalFrameHost_ResponseAck_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_ResponseAck_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.watchedPageChange = function() {
    return LocalFrameHostProxy.prototype.watchedPageChange
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.watchedPageChange = function(cssSelectors) {
    var params_ = new LocalFrameHost_WatchedPageChange_Params();
    params_.cssSelectors = cssSelectors;
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_WatchedPageChange_Name,
        codec.align(LocalFrameHost_WatchedPageChange_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_WatchedPageChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.detailedConsoleMessageAdded = function() {
    return LocalFrameHostProxy.prototype.detailedConsoleMessageAdded
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.detailedConsoleMessageAdded = function(message, source, stackTrace, level) {
    var params_ = new LocalFrameHost_DetailedConsoleMessageAdded_Params();
    params_.message = message;
    params_.source = source;
    params_.stackTrace = stackTrace;
    params_.level = level;
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_DetailedConsoleMessageAdded_Name,
        codec.align(LocalFrameHost_DetailedConsoleMessageAdded_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_DetailedConsoleMessageAdded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.contentScriptsExecuting = function() {
    return LocalFrameHostProxy.prototype.contentScriptsExecuting
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.contentScriptsExecuting = function(extensionIdToScripts, frameUrl) {
    var params_ = new LocalFrameHost_ContentScriptsExecuting_Params();
    params_.extensionIdToScripts = extensionIdToScripts;
    params_.frameUrl = frameUrl;
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_ContentScriptsExecuting_Name,
        codec.align(LocalFrameHost_ContentScriptsExecuting_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_ContentScriptsExecuting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.incrementLazyKeepaliveCount = function() {
    return LocalFrameHostProxy.prototype.incrementLazyKeepaliveCount
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.incrementLazyKeepaliveCount = function() {
    var params_ = new LocalFrameHost_IncrementLazyKeepaliveCount_Params();
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_IncrementLazyKeepaliveCount_Name,
        codec.align(LocalFrameHost_IncrementLazyKeepaliveCount_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_IncrementLazyKeepaliveCount_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.decrementLazyKeepaliveCount = function() {
    return LocalFrameHostProxy.prototype.decrementLazyKeepaliveCount
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.decrementLazyKeepaliveCount = function() {
    var params_ = new LocalFrameHost_DecrementLazyKeepaliveCount_Params();
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_DecrementLazyKeepaliveCount_Name,
        codec.align(LocalFrameHost_DecrementLazyKeepaliveCount_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_DecrementLazyKeepaliveCount_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.appWindowReady = function() {
    return LocalFrameHostProxy.prototype.appWindowReady
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.appWindowReady = function() {
    var params_ = new LocalFrameHost_AppWindowReady_Params();
    var builder = new codec.MessageV0Builder(
        kLocalFrameHost_AppWindowReady_Name,
        codec.align(LocalFrameHost_AppWindowReady_Params.encodedSize));
    builder.encodeStruct(LocalFrameHost_AppWindowReady_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.openChannelToExtension = function() {
    return LocalFrameHostProxy.prototype.openChannelToExtension
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.openChannelToExtension = function(info, channelType, channelName, portId, port, portHost) {
    var params_ = new LocalFrameHost_OpenChannelToExtension_Params();
    params_.info = info;
    params_.channelType = channelType;
    params_.channelName = channelName;
    params_.portId = portId;
    params_.port = port;
    params_.portHost = portHost;
    var builder = new codec.MessageV2Builder(
        kLocalFrameHost_OpenChannelToExtension_Name,
        codec.align(LocalFrameHost_OpenChannelToExtension_Params.encodedSize));
    builder.setPayload(LocalFrameHost_OpenChannelToExtension_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.openChannelToNativeApp = function() {
    return LocalFrameHostProxy.prototype.openChannelToNativeApp
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.openChannelToNativeApp = function(nativeAppName, portId, port, portHost) {
    var params_ = new LocalFrameHost_OpenChannelToNativeApp_Params();
    params_.nativeAppName = nativeAppName;
    params_.portId = portId;
    params_.port = port;
    params_.portHost = portHost;
    var builder = new codec.MessageV2Builder(
        kLocalFrameHost_OpenChannelToNativeApp_Name,
        codec.align(LocalFrameHost_OpenChannelToNativeApp_Params.encodedSize));
    builder.setPayload(LocalFrameHost_OpenChannelToNativeApp_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LocalFrameHostPtr.prototype.openChannelToTab = function() {
    return LocalFrameHostProxy.prototype.openChannelToTab
        .apply(this.ptr.getProxy(), arguments);
  };

  LocalFrameHostProxy.prototype.openChannelToTab = function(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {
    var params_ = new LocalFrameHost_OpenChannelToTab_Params();
    params_.tabId = tabId;
    params_.frameId = frameId;
    params_.documentId = documentId;
    params_.channelType = channelType;
    params_.channelName = channelName;
    params_.portId = portId;
    params_.port = port;
    params_.portHost = portHost;
    var builder = new codec.MessageV2Builder(
        kLocalFrameHost_OpenChannelToTab_Name,
        codec.align(LocalFrameHost_OpenChannelToTab_Params.encodedSize));
    builder.setPayload(LocalFrameHost_OpenChannelToTab_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function LocalFrameHostStub(delegate) {
    this.delegate_ = delegate;
  }
  LocalFrameHostStub.prototype.requestScriptInjectionPermission = function(extensionId, scriptType, runLocation) {
    return this.delegate_ && this.delegate_.requestScriptInjectionPermission && this.delegate_.requestScriptInjectionPermission(extensionId, scriptType, runLocation);
  }
  LocalFrameHostStub.prototype.getAppInstallState = function(url) {
    return this.delegate_ && this.delegate_.getAppInstallState && this.delegate_.getAppInstallState(url);
  }
  LocalFrameHostStub.prototype.request = function(params) {
    return this.delegate_ && this.delegate_.request && this.delegate_.request(params);
  }
  LocalFrameHostStub.prototype.responseAck = function(requestUuid) {
    return this.delegate_ && this.delegate_.responseAck && this.delegate_.responseAck(requestUuid);
  }
  LocalFrameHostStub.prototype.watchedPageChange = function(cssSelectors) {
    return this.delegate_ && this.delegate_.watchedPageChange && this.delegate_.watchedPageChange(cssSelectors);
  }
  LocalFrameHostStub.prototype.detailedConsoleMessageAdded = function(message, source, stackTrace, level) {
    return this.delegate_ && this.delegate_.detailedConsoleMessageAdded && this.delegate_.detailedConsoleMessageAdded(message, source, stackTrace, level);
  }
  LocalFrameHostStub.prototype.contentScriptsExecuting = function(extensionIdToScripts, frameUrl) {
    return this.delegate_ && this.delegate_.contentScriptsExecuting && this.delegate_.contentScriptsExecuting(extensionIdToScripts, frameUrl);
  }
  LocalFrameHostStub.prototype.incrementLazyKeepaliveCount = function() {
    return this.delegate_ && this.delegate_.incrementLazyKeepaliveCount && this.delegate_.incrementLazyKeepaliveCount();
  }
  LocalFrameHostStub.prototype.decrementLazyKeepaliveCount = function() {
    return this.delegate_ && this.delegate_.decrementLazyKeepaliveCount && this.delegate_.decrementLazyKeepaliveCount();
  }
  LocalFrameHostStub.prototype.appWindowReady = function() {
    return this.delegate_ && this.delegate_.appWindowReady && this.delegate_.appWindowReady();
  }
  LocalFrameHostStub.prototype.openChannelToExtension = function(info, channelType, channelName, portId, port, portHost) {
    return this.delegate_ && this.delegate_.openChannelToExtension && this.delegate_.openChannelToExtension(info, channelType, channelName, portId, port, portHost);
  }
  LocalFrameHostStub.prototype.openChannelToNativeApp = function(nativeAppName, portId, port, portHost) {
    return this.delegate_ && this.delegate_.openChannelToNativeApp && this.delegate_.openChannelToNativeApp(nativeAppName, portId, port, portHost);
  }
  LocalFrameHostStub.prototype.openChannelToTab = function(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {
    return this.delegate_ && this.delegate_.openChannelToTab && this.delegate_.openChannelToTab(tabId, frameId, documentId, channelType, channelName, portId, port, portHost);
  }

  LocalFrameHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLocalFrameHost_ResponseAck_Name:
      var params = reader.decodeStruct(LocalFrameHost_ResponseAck_Params);
      this.responseAck(params.requestUuid);
      return true;
    case kLocalFrameHost_WatchedPageChange_Name:
      var params = reader.decodeStruct(LocalFrameHost_WatchedPageChange_Params);
      this.watchedPageChange(params.cssSelectors);
      return true;
    case kLocalFrameHost_DetailedConsoleMessageAdded_Name:
      var params = reader.decodeStruct(LocalFrameHost_DetailedConsoleMessageAdded_Params);
      this.detailedConsoleMessageAdded(params.message, params.source, params.stackTrace, params.level);
      return true;
    case kLocalFrameHost_ContentScriptsExecuting_Name:
      var params = reader.decodeStruct(LocalFrameHost_ContentScriptsExecuting_Params);
      this.contentScriptsExecuting(params.extensionIdToScripts, params.frameUrl);
      return true;
    case kLocalFrameHost_IncrementLazyKeepaliveCount_Name:
      var params = reader.decodeStruct(LocalFrameHost_IncrementLazyKeepaliveCount_Params);
      this.incrementLazyKeepaliveCount();
      return true;
    case kLocalFrameHost_DecrementLazyKeepaliveCount_Name:
      var params = reader.decodeStruct(LocalFrameHost_DecrementLazyKeepaliveCount_Params);
      this.decrementLazyKeepaliveCount();
      return true;
    case kLocalFrameHost_AppWindowReady_Name:
      var params = reader.decodeStruct(LocalFrameHost_AppWindowReady_Params);
      this.appWindowReady();
      return true;
    case kLocalFrameHost_OpenChannelToExtension_Name:
      var params = reader.decodeStruct(LocalFrameHost_OpenChannelToExtension_Params);
      this.openChannelToExtension(params.info, params.channelType, params.channelName, params.portId, params.port, params.portHost);
      return true;
    case kLocalFrameHost_OpenChannelToNativeApp_Name:
      var params = reader.decodeStruct(LocalFrameHost_OpenChannelToNativeApp_Params);
      this.openChannelToNativeApp(params.nativeAppName, params.portId, params.port, params.portHost);
      return true;
    case kLocalFrameHost_OpenChannelToTab_Name:
      var params = reader.decodeStruct(LocalFrameHost_OpenChannelToTab_Params);
      this.openChannelToTab(params.tabId, params.frameId, params.documentId, params.channelType, params.channelName, params.portId, params.port, params.portHost);
      return true;
    default:
      return false;
    }
  };

  LocalFrameHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLocalFrameHost_RequestScriptInjectionPermission_Name:
      var params = reader.decodeStruct(LocalFrameHost_RequestScriptInjectionPermission_Params);
      this.requestScriptInjectionPermission(params.extensionId, params.scriptType, params.runLocation).then(function(response) {
        var responseParams =
            new LocalFrameHost_RequestScriptInjectionPermission_ResponseParams();
        responseParams.granted = response.granted;
        var builder = new codec.MessageV1Builder(
            kLocalFrameHost_RequestScriptInjectionPermission_Name,
            codec.align(LocalFrameHost_RequestScriptInjectionPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LocalFrameHost_RequestScriptInjectionPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLocalFrameHost_GetAppInstallState_Name:
      var params = reader.decodeStruct(LocalFrameHost_GetAppInstallState_Params);
      this.getAppInstallState(params.url).then(function(response) {
        var responseParams =
            new LocalFrameHost_GetAppInstallState_ResponseParams();
        responseParams.state = response.state;
        var builder = new codec.MessageV1Builder(
            kLocalFrameHost_GetAppInstallState_Name,
            codec.align(LocalFrameHost_GetAppInstallState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LocalFrameHost_GetAppInstallState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLocalFrameHost_Request_Name:
      var params = reader.decodeStruct(LocalFrameHost_Request_Params);
      this.request(params.params).then(function(response) {
        var responseParams =
            new LocalFrameHost_Request_ResponseParams();
        responseParams.success = response.success;
        responseParams.responseWrapper = response.responseWrapper;
        responseParams.error = response.error;
        responseParams.extraData = response.extraData;
        var builder = new codec.MessageV1Builder(
            kLocalFrameHost_Request_Name,
            codec.align(LocalFrameHost_Request_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LocalFrameHost_Request_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateLocalFrameHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLocalFrameHost_RequestScriptInjectionPermission_Name:
        if (message.expectsResponse())
          paramsClass = LocalFrameHost_RequestScriptInjectionPermission_Params;
      break;
      case kLocalFrameHost_GetAppInstallState_Name:
        if (message.expectsResponse())
          paramsClass = LocalFrameHost_GetAppInstallState_Params;
      break;
      case kLocalFrameHost_Request_Name:
        if (message.expectsResponse())
          paramsClass = LocalFrameHost_Request_Params;
      break;
      case kLocalFrameHost_ResponseAck_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_ResponseAck_Params;
      break;
      case kLocalFrameHost_WatchedPageChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_WatchedPageChange_Params;
      break;
      case kLocalFrameHost_DetailedConsoleMessageAdded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_DetailedConsoleMessageAdded_Params;
      break;
      case kLocalFrameHost_ContentScriptsExecuting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_ContentScriptsExecuting_Params;
      break;
      case kLocalFrameHost_IncrementLazyKeepaliveCount_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_IncrementLazyKeepaliveCount_Params;
      break;
      case kLocalFrameHost_DecrementLazyKeepaliveCount_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_DecrementLazyKeepaliveCount_Params;
      break;
      case kLocalFrameHost_AppWindowReady_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_AppWindowReady_Params;
      break;
      case kLocalFrameHost_OpenChannelToExtension_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_OpenChannelToExtension_Params;
      break;
      case kLocalFrameHost_OpenChannelToNativeApp_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_OpenChannelToNativeApp_Params;
      break;
      case kLocalFrameHost_OpenChannelToTab_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LocalFrameHost_OpenChannelToTab_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLocalFrameHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kLocalFrameHost_RequestScriptInjectionPermission_Name:
        if (message.isResponse())
          paramsClass = LocalFrameHost_RequestScriptInjectionPermission_ResponseParams;
        break;
      case kLocalFrameHost_GetAppInstallState_Name:
        if (message.isResponse())
          paramsClass = LocalFrameHost_GetAppInstallState_ResponseParams;
        break;
      case kLocalFrameHost_Request_Name:
        if (message.isResponse())
          paramsClass = LocalFrameHost_Request_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var LocalFrameHost = {
    name: 'extensions.mojom.LocalFrameHost',
    kVersion: 0,
    ptrClass: LocalFrameHostPtr,
    proxyClass: LocalFrameHostProxy,
    stubClass: LocalFrameHostStub,
    validateRequest: validateLocalFrameHostRequest,
    validateResponse: validateLocalFrameHostResponse,
  };
  LocalFrameHostStub.prototype.validator = validateLocalFrameHostRequest;
  LocalFrameHostProxy.prototype.validator = validateLocalFrameHostResponse;
  exports.ExecuteCodeParams = ExecuteCodeParams;
  exports.RequestParams = RequestParams;
  exports.LocalFrame = LocalFrame;
  exports.LocalFramePtr = LocalFramePtr;
  exports.LocalFrameAssociatedPtr = LocalFrameAssociatedPtr;
  exports.LocalFrameHost = LocalFrameHost;
  exports.LocalFrameHostPtr = LocalFrameHostPtr;
  exports.LocalFrameHostAssociatedPtr = LocalFrameHostAssociatedPtr;
})();