// extensions/common/mojom/frame.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  Uuid as mojoBase_mojom_Uuid,
  UuidSpec as mojoBase_mojom_UuidSpec
} from '../../../mojo/public/mojom/base/uuid.mojom.m.js';

import {
  ListValue as mojoBase_mojom_ListValue,
  ListValueSpec as mojoBase_mojom_ListValueSpec,
  Value as mojoBase_mojom_Value,
  ValueSpec as mojoBase_mojom_ValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  ConsoleMessageLevel as blink_mojom_ConsoleMessageLevel,
  ConsoleMessageLevelSpec as blink_mojom_ConsoleMessageLevelSpec
} from '../../../third_party/blink/public/mojom/devtools/console_message.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  CodeInjection as extensions_mojom_CodeInjection,
  CodeInjectionSpec as extensions_mojom_CodeInjectionSpec
} from './code_injection.mojom.m.js';

import {
  ContextType as extensions_mojom_ContextType,
  ContextTypeSpec as extensions_mojom_ContextTypeSpec
} from './context_type.mojom.m.js';

import {
  ExtensionId as extensions_mojom_ExtensionId,
  ExtensionIdSpec as extensions_mojom_ExtensionIdSpec
} from './extension_id.mojom.m.js';

import {
  ExtraResponseData as extensions_mojom_ExtraResponseData,
  ExtraResponseDataSpec as extensions_mojom_ExtraResponseDataSpec
} from './extra_response_data.mojom.m.js';

import {
  HostID as extensions_mojom_HostID,
  HostIDSpec as extensions_mojom_HostIDSpec
} from './host_id.mojom.m.js';

import {
  InjectionType as extensions_mojom_InjectionType,
  InjectionTypeSpec as extensions_mojom_InjectionTypeSpec
} from './injection_type.mojom.m.js';

import {
  MatchOriginAsFallbackBehavior as extensions_mojom_MatchOriginAsFallbackBehavior,
  MatchOriginAsFallbackBehaviorSpec as extensions_mojom_MatchOriginAsFallbackBehaviorSpec
} from './match_origin_as_fallback.mojom.m.js';

import {
  ChannelType as extensions_mojom_ChannelType,
  ChannelTypeSpec as extensions_mojom_ChannelTypeSpec,
  MessagePortRemote as extensions_mojom_MessagePortRemote,
  MessagePortPendingReceiver as extensions_mojom_MessagePortPendingReceiver,
  MessagePortHostRemote as extensions_mojom_MessagePortHostRemote,
  MessagePortHostPendingReceiver as extensions_mojom_MessagePortHostPendingReceiver,
  ExternalConnectionInfo as extensions_mojom_ExternalConnectionInfo,
  ExternalConnectionInfoSpec as extensions_mojom_ExternalConnectionInfoSpec,
  PortId as extensions_mojom_PortId,
  PortIdSpec as extensions_mojom_PortIdSpec,
  TabConnectionInfo as extensions_mojom_TabConnectionInfo,
  TabConnectionInfoSpec as extensions_mojom_TabConnectionInfoSpec
} from './message_port.mojom.m.js';

import {
  RunLocation as extensions_mojom_RunLocation,
  RunLocationSpec as extensions_mojom_RunLocationSpec
} from './run_location.mojom.m.js';

import {
  StackFrame as extensions_mojom_StackFrame,
  StackFrameSpec as extensions_mojom_StackFrameSpec
} from './stack_frame.mojom.m.js';

import {
  ViewType as extensions_mojom_ViewType,
  ViewTypeSpec as extensions_mojom_ViewTypeSpec
} from './view_type.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LocalFramePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.LocalFrame', scope);
  }
}

/** @interface */
export class LocalFrameInterface {
  
  /**
   * @param { !string } frameName
   */

  setFrameName(frameName) {}
  
  /**
   * @param { !boolean } spatialNavEnabled
   */

  setSpatialNavigationEnabled(spatialNavEnabled) {}
  
  /**
   * @param { !number } tabId
   */

  setTabId(tabId) {}
  
  /**
   * @param { !boolean } sendOnclosed
   */

  appWindowClosed(sendOnclosed) {}
  
  /**
   * @param { !extensions_mojom_ViewType } viewType
   */

  notifyRenderViewType(viewType) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } moduleName
   * @param { !string } functionName
   * @param { !mojoBase_mojom_ListValue } args
   */

  messageInvoke(extensionId, moduleName, functionName, args) {}
  
  /**
   * @param { !ExecuteCodeParams } param
   * @return {!Promise<{
        error: !string,
        url: !url_mojom_Url,
        result: ?mojoBase_mojom_Value,
   *  }>}
   */

  executeCode(param) {}
  
  /**
   * @param { !number } tabId
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } scriptId
   * @param { !url_mojom_Url } url
   */

  executeDeclarativeScript(tabId, extensionId, scriptId, url) {}
  
  /**
   * @param { !number } windowId
   */

  updateBrowserWindowId(windowId) {}
  
  /**
   * @param { !extensions_mojom_PortId } portId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_TabConnectionInfo } tabInfo
   * @param { !extensions_mojom_ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {}
}

/**
 * @implements { LocalFrameInterface }
 */
export class LocalFrameRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LocalFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LocalFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LocalFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } frameName
   */

  setFrameName(
      frameName) {
    this.proxy.sendMessage(
        0,
        LocalFrame_SetFrameName_ParamsSpec.$,
        null,
        [
          frameName
        ],
        false);
  }

  
  /**
   * @param { !boolean } spatialNavEnabled
   */

  setSpatialNavigationEnabled(
      spatialNavEnabled) {
    this.proxy.sendMessage(
        1,
        LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
        null,
        [
          spatialNavEnabled
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   */

  setTabId(
      tabId) {
    this.proxy.sendMessage(
        2,
        LocalFrame_SetTabId_ParamsSpec.$,
        null,
        [
          tabId
        ],
        false);
  }

  
  /**
   * @param { !boolean } sendOnclosed
   */

  appWindowClosed(
      sendOnclosed) {
    this.proxy.sendMessage(
        3,
        LocalFrame_AppWindowClosed_ParamsSpec.$,
        null,
        [
          sendOnclosed
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ViewType } viewType
   */

  notifyRenderViewType(
      viewType) {
    this.proxy.sendMessage(
        4,
        LocalFrame_NotifyRenderViewType_ParamsSpec.$,
        null,
        [
          viewType
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } moduleName
   * @param { !string } functionName
   * @param { !mojoBase_mojom_ListValue } args
   */

  messageInvoke(
      extensionId,
      moduleName,
      functionName,
      args) {
    this.proxy.sendMessage(
        5,
        LocalFrame_MessageInvoke_ParamsSpec.$,
        null,
        [
          extensionId,
          moduleName,
          functionName,
          args
        ],
        false);
  }

  
  /**
   * @param { !ExecuteCodeParams } param
   * @return {!Promise<{
        error: !string,
        url: !url_mojom_Url,
        result: ?mojoBase_mojom_Value,
   *  }>}
   */

  executeCode(
      param) {
    return this.proxy.sendMessage(
        6,
        LocalFrame_ExecuteCode_ParamsSpec.$,
        LocalFrame_ExecuteCode_ResponseParamsSpec.$,
        [
          param
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } scriptId
   * @param { !url_mojom_Url } url
   */

  executeDeclarativeScript(
      tabId,
      extensionId,
      scriptId,
      url) {
    this.proxy.sendMessage(
        7,
        LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
        null,
        [
          tabId,
          extensionId,
          scriptId,
          url
        ],
        false);
  }

  
  /**
   * @param { !number } windowId
   */

  updateBrowserWindowId(
      windowId) {
    this.proxy.sendMessage(
        8,
        LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
        null,
        [
          windowId
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_PortId } portId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_TabConnectionInfo } tabInfo
   * @param { !extensions_mojom_ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(
      portId,
      channelType,
      channelName,
      tabInfo,
      externalConnectionInfo,
      port,
      portHost) {
    return this.proxy.sendMessage(
        9,
        LocalFrame_DispatchOnConnect_ParamsSpec.$,
        LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
        [
          portId,
          channelType,
          channelName,
          tabInfo,
          externalConnectionInfo,
          port,
          portHost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LocalFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LocalFrameReceiver {
  /**
   * @param {!LocalFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LocalFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LocalFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LocalFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LocalFrame_SetFrameName_ParamsSpec.$,
        null,
        impl.setFrameName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
        null,
        impl.setSpatialNavigationEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LocalFrame_SetTabId_ParamsSpec.$,
        null,
        impl.setTabId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LocalFrame_AppWindowClosed_ParamsSpec.$,
        null,
        impl.appWindowClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LocalFrame_NotifyRenderViewType_ParamsSpec.$,
        null,
        impl.notifyRenderViewType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LocalFrame_MessageInvoke_ParamsSpec.$,
        null,
        impl.messageInvoke.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        LocalFrame_ExecuteCode_ParamsSpec.$,
        LocalFrame_ExecuteCode_ResponseParamsSpec.$,
        impl.executeCode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
        null,
        impl.executeDeclarativeScript.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
        null,
        impl.updateBrowserWindowId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        LocalFrame_DispatchOnConnect_ParamsSpec.$,
        LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
        impl.dispatchOnConnect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LocalFrame {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.LocalFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LocalFrameRemote}
   */
  static getRemote() {
    let remote = new LocalFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LocalFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LocalFrameCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LocalFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LocalFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LocalFrame_SetFrameName_ParamsSpec.$,
        null,
        this.setFrameName.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSpatialNavigationEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
        null,
        this.setSpatialNavigationEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTabId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LocalFrame_SetTabId_ParamsSpec.$,
        null,
        this.setTabId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.appWindowClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LocalFrame_AppWindowClosed_ParamsSpec.$,
        null,
        this.appWindowClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyRenderViewType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LocalFrame_NotifyRenderViewType_ParamsSpec.$,
        null,
        this.notifyRenderViewType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.messageInvoke =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LocalFrame_MessageInvoke_ParamsSpec.$,
        null,
        this.messageInvoke.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeCode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        LocalFrame_ExecuteCode_ParamsSpec.$,
        LocalFrame_ExecuteCode_ResponseParamsSpec.$,
        this.executeCode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeDeclarativeScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
        null,
        this.executeDeclarativeScript.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateBrowserWindowId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
        null,
        this.updateBrowserWindowId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchOnConnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        LocalFrame_DispatchOnConnect_ParamsSpec.$,
        LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
        this.dispatchOnConnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LocalFrameHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.LocalFrameHost', scope);
  }
}

/** @interface */
export class LocalFrameHostInterface {
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !extensions_mojom_InjectionType } scriptType
   * @param { !extensions_mojom_RunLocation } runLocation
   * @return {!Promise<{
        granted: !boolean,
   *  }>}
   */

  requestScriptInjectionPermission(extensionId, scriptType, runLocation) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        state: !string,
   *  }>}
   */

  getAppInstallState(url) {}
  
  /**
   * @param { !RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase_mojom_ListValue,
        error: !string,
        extraData: ?extensions_mojom_ExtraResponseData,
   *  }>}
   */

  request(params) {}
  
  /**
   * @param { !mojoBase_mojom_Uuid } requestUuid
   */

  responseAck(requestUuid) {}
  
  /**
   * @param { !Array<!string> } cssSelectors
   */

  watchedPageChange(cssSelectors) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } message
   * @param { !mojoBase_mojom_String16 } source
   * @param { !Array<!extensions_mojom_StackFrame> } stackTrace
   * @param { !blink_mojom_ConsoleMessageLevel } level
   */

  detailedConsoleMessageAdded(message, source, stackTrace, level) {}
  
  /**
   * @param { !Object<!string, !Array<!string>> } extensionIdToScripts
   * @param { !url_mojom_Url } frameUrl
   */

  contentScriptsExecuting(extensionIdToScripts, frameUrl) {}
  
  /**
   */

  incrementLazyKeepaliveCount() {}
  
  /**
   */

  decrementLazyKeepaliveCount() {}
  
  /**
   */

  appWindowReady() {}
  
  /**
   * @param { !extensions_mojom_ExternalConnectionInfo } info
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(info, channelType, channelName, portId, port, portHost) {}
  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(nativeAppName, portId, port, portHost) {}
  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {}
}

/**
 * @implements { LocalFrameHostInterface }
 */
export class LocalFrameHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LocalFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LocalFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LocalFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !extensions_mojom_InjectionType } scriptType
   * @param { !extensions_mojom_RunLocation } runLocation
   * @return {!Promise<{
        granted: !boolean,
   *  }>}
   */

  requestScriptInjectionPermission(
      extensionId,
      scriptType,
      runLocation) {
    return this.proxy.sendMessage(
        0,
        LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
        LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
        [
          extensionId,
          scriptType,
          runLocation
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        state: !string,
   *  }>}
   */

  getAppInstallState(
      url) {
    return this.proxy.sendMessage(
        1,
        LocalFrameHost_GetAppInstallState_ParamsSpec.$,
        LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase_mojom_ListValue,
        error: !string,
        extraData: ?extensions_mojom_ExtraResponseData,
   *  }>}
   */

  request(
      params) {
    return this.proxy.sendMessage(
        2,
        LocalFrameHost_Request_ParamsSpec.$,
        LocalFrameHost_Request_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Uuid } requestUuid
   */

  responseAck(
      requestUuid) {
    this.proxy.sendMessage(
        3,
        LocalFrameHost_ResponseAck_ParamsSpec.$,
        null,
        [
          requestUuid
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } cssSelectors
   */

  watchedPageChange(
      cssSelectors) {
    this.proxy.sendMessage(
        4,
        LocalFrameHost_WatchedPageChange_ParamsSpec.$,
        null,
        [
          cssSelectors
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } message
   * @param { !mojoBase_mojom_String16 } source
   * @param { !Array<!extensions_mojom_StackFrame> } stackTrace
   * @param { !blink_mojom_ConsoleMessageLevel } level
   */

  detailedConsoleMessageAdded(
      message,
      source,
      stackTrace,
      level) {
    this.proxy.sendMessage(
        5,
        LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
        null,
        [
          message,
          source,
          stackTrace,
          level
        ],
        false);
  }

  
  /**
   * @param { !Object<!string, !Array<!string>> } extensionIdToScripts
   * @param { !url_mojom_Url } frameUrl
   */

  contentScriptsExecuting(
      extensionIdToScripts,
      frameUrl) {
    this.proxy.sendMessage(
        6,
        LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
        null,
        [
          extensionIdToScripts,
          frameUrl
        ],
        false);
  }

  
  /**
   */

  incrementLazyKeepaliveCount() {
    this.proxy.sendMessage(
        7,
        LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  decrementLazyKeepaliveCount() {
    this.proxy.sendMessage(
        8,
        LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  appWindowReady() {
    this.proxy.sendMessage(
        9,
        LocalFrameHost_AppWindowReady_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExternalConnectionInfo } info
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(
      info,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        10,
        LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        [
          info,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(
      nativeAppName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        11,
        LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        [
          nativeAppName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(
      tabId,
      frameId,
      documentId,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        12,
        LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
        null,
        [
          tabId,
          frameId,
          documentId,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LocalFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LocalFrameHostReceiver {
  /**
   * @param {!LocalFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LocalFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
        LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
        impl.requestScriptInjectionPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LocalFrameHost_GetAppInstallState_ParamsSpec.$,
        LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
        impl.getAppInstallState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LocalFrameHost_Request_ParamsSpec.$,
        LocalFrameHost_Request_ResponseParamsSpec.$,
        impl.request.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LocalFrameHost_ResponseAck_ParamsSpec.$,
        null,
        impl.responseAck.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LocalFrameHost_WatchedPageChange_ParamsSpec.$,
        null,
        impl.watchedPageChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
        null,
        impl.detailedConsoleMessageAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
        null,
        impl.contentScriptsExecuting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        impl.incrementLazyKeepaliveCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        impl.decrementLazyKeepaliveCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        LocalFrameHost_AppWindowReady_ParamsSpec.$,
        null,
        impl.appWindowReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        impl.openChannelToExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        impl.openChannelToNativeApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
        null,
        impl.openChannelToTab.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LocalFrameHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.LocalFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LocalFrameHostRemote}
   */
  static getRemote() {
    let remote = new LocalFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LocalFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LocalFrameHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestScriptInjectionPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
        LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
        this.requestScriptInjectionPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAppInstallState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LocalFrameHost_GetAppInstallState_ParamsSpec.$,
        LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
        this.getAppInstallState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.request =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LocalFrameHost_Request_ParamsSpec.$,
        LocalFrameHost_Request_ResponseParamsSpec.$,
        this.request.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.responseAck =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LocalFrameHost_ResponseAck_ParamsSpec.$,
        null,
        this.responseAck.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.watchedPageChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LocalFrameHost_WatchedPageChange_ParamsSpec.$,
        null,
        this.watchedPageChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detailedConsoleMessageAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
        null,
        this.detailedConsoleMessageAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contentScriptsExecuting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
        null,
        this.contentScriptsExecuting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.incrementLazyKeepaliveCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        this.incrementLazyKeepaliveCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decrementLazyKeepaliveCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
        null,
        this.decrementLazyKeepaliveCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.appWindowReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        LocalFrameHost_AppWindowReady_ParamsSpec.$,
        null,
        this.appWindowReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        this.openChannelToExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToNativeApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        this.openChannelToNativeApp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
        null,
        this.openChannelToTab.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ExecuteCodeParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RequestParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_SetFrameName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_SetSpatialNavigationEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_SetTabId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_AppWindowClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_NotifyRenderViewType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_MessageInvoke_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_ExecuteCode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_ExecuteCode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_ExecuteDeclarativeScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_UpdateBrowserWindowId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_DispatchOnConnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrame_DispatchOnConnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_GetAppInstallState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_GetAppInstallState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_Request_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_Request_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_ResponseAck_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_WatchedPageChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_ContentScriptsExecuting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_AppWindowReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_OpenChannelToExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_OpenChannelToNativeApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LocalFrameHost_OpenChannelToTab_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ExecuteCodeParamsSpec.$,
    'ExecuteCodeParams',
    [
      mojo.internal.StructField(
        'hostId', 0,
        0,
        extensions_mojom_HostIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'injection', 8,
        0,
        extensions_mojom_CodeInjectionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'webviewSrc', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchOriginAsFallbackBehavior', 32,
        0,
        extensions_mojom_MatchOriginAsFallbackBehaviorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'runAt', 36,
        0,
        extensions_mojom_RunLocationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWebView', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ExecuteCodeParams {
  constructor() {
    /** @type { !extensions_mojom_HostID } */
    this.hostId;
    /** @type { !extensions_mojom_CodeInjection } */
    this.injection;
    /** @type { !url_mojom_Url } */
    this.webviewSrc;
    /** @type { !extensions_mojom_MatchOriginAsFallbackBehavior } */
    this.matchOriginAsFallbackBehavior;
    /** @type { !extensions_mojom_RunLocation } */
    this.runAt;
    /** @type { !boolean } */
    this.isWebView;
  }
}



mojo.internal.Struct(
    RequestParamsSpec.$,
    'RequestParams',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'arguments', 8,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensionId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contextType', 32,
        0,
        extensions_mojom_ContextTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestId', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasCallback', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 40,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerThreadId', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 48,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'jsCallstack', 56,
        0,
        mojo.internal.Array(extensions_mojom_StackFrameSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class RequestParams {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !mojoBase_mojom_ListValue } */
    this.arguments;
    /** @type { !string } */
    this.extensionId;
    /** @type { !url_mojom_Url } */
    this.sourceUrl;
    /** @type { !extensions_mojom_ContextType } */
    this.contextType;
    /** @type { !number } */
    this.requestId;
    /** @type { !boolean } */
    this.hasCallback;
    /** @type { !boolean } */
    this.userGesture;
    /** @type { !number } */
    this.workerThreadId;
    /** @type { !bigint } */
    this.serviceWorkerVersionId;
    /** @type { (Array<!extensions_mojom_StackFrame>|undefined) } */
    this.jsCallstack;
  }
}



mojo.internal.Struct(
    LocalFrame_SetFrameName_ParamsSpec.$,
    'LocalFrame_SetFrameName_Params',
    [
      mojo.internal.StructField(
        'frameName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_SetFrameName_Params {
  constructor() {
    /** @type { !string } */
    this.frameName;
  }
}



mojo.internal.Struct(
    LocalFrame_SetSpatialNavigationEnabled_ParamsSpec.$,
    'LocalFrame_SetSpatialNavigationEnabled_Params',
    [
      mojo.internal.StructField(
        'spatialNavEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_SetSpatialNavigationEnabled_Params {
  constructor() {
    /** @type { !boolean } */
    this.spatialNavEnabled;
  }
}



mojo.internal.Struct(
    LocalFrame_SetTabId_ParamsSpec.$,
    'LocalFrame_SetTabId_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_SetTabId_Params {
  constructor() {
    /** @type { !number } */
    this.tabId;
  }
}



mojo.internal.Struct(
    LocalFrame_AppWindowClosed_ParamsSpec.$,
    'LocalFrame_AppWindowClosed_Params',
    [
      mojo.internal.StructField(
        'sendOnclosed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_AppWindowClosed_Params {
  constructor() {
    /** @type { !boolean } */
    this.sendOnclosed;
  }
}



mojo.internal.Struct(
    LocalFrame_NotifyRenderViewType_ParamsSpec.$,
    'LocalFrame_NotifyRenderViewType_Params',
    [
      mojo.internal.StructField(
        'viewType', 0,
        0,
        extensions_mojom_ViewTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_NotifyRenderViewType_Params {
  constructor() {
    /** @type { !extensions_mojom_ViewType } */
    this.viewType;
  }
}



mojo.internal.Struct(
    LocalFrame_MessageInvoke_ParamsSpec.$,
    'LocalFrame_MessageInvoke_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'moduleName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'functionName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'args', 24,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LocalFrame_MessageInvoke_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.moduleName;
    /** @type { !string } */
    this.functionName;
    /** @type { !mojoBase_mojom_ListValue } */
    this.args;
  }
}



mojo.internal.Struct(
    LocalFrame_ExecuteCode_ParamsSpec.$,
    'LocalFrame_ExecuteCode_Params',
    [
      mojo.internal.StructField(
        'param', 0,
        0,
        ExecuteCodeParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_ExecuteCode_Params {
  constructor() {
    /** @type { !ExecuteCodeParams } */
    this.param;
  }
}



mojo.internal.Struct(
    LocalFrame_ExecuteCode_ResponseParamsSpec.$,
    'LocalFrame_ExecuteCode_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 16,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LocalFrame_ExecuteCode_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.error;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { (mojoBase_mojom_Value|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    LocalFrame_ExecuteDeclarativeScript_ParamsSpec.$,
    'LocalFrame_ExecuteDeclarativeScript_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensionId', 8,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LocalFrame_ExecuteDeclarativeScript_Params {
  constructor() {
    /** @type { !number } */
    this.tabId;
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.scriptId;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    LocalFrame_UpdateBrowserWindowId_ParamsSpec.$,
    'LocalFrame_UpdateBrowserWindowId_Params',
    [
      mojo.internal.StructField(
        'windowId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_UpdateBrowserWindowId_Params {
  constructor() {
    /** @type { !number } */
    this.windowId;
  }
}



mojo.internal.Struct(
    LocalFrame_DispatchOnConnect_ParamsSpec.$,
    'LocalFrame_DispatchOnConnect_Params',
    [
      mojo.internal.StructField(
        'portId', 0,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions_mojom_ChannelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tabInfo', 24,
        0,
        extensions_mojom_TabConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'externalConnectionInfo', 32,
        0,
        extensions_mojom_ExternalConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortHostRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class LocalFrame_DispatchOnConnect_Params {
  constructor() {
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !extensions_mojom_ChannelType } */
    this.channelType;
    /** @type { !string } */
    this.channelName;
    /** @type { !extensions_mojom_TabConnectionInfo } */
    this.tabInfo;
    /** @type { !extensions_mojom_ExternalConnectionInfo } */
    this.externalConnectionInfo;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}



mojo.internal.Struct(
    LocalFrame_DispatchOnConnect_ResponseParamsSpec.$,
    'LocalFrame_DispatchOnConnect_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrame_DispatchOnConnect_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    LocalFrameHost_RequestScriptInjectionPermission_ParamsSpec.$,
    'LocalFrameHost_RequestScriptInjectionPermission_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptType', 8,
        0,
        extensions_mojom_InjectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'runLocation', 12,
        0,
        extensions_mojom_RunLocationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LocalFrameHost_RequestScriptInjectionPermission_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !extensions_mojom_InjectionType } */
    this.scriptType;
    /** @type { !extensions_mojom_RunLocation } */
    this.runLocation;
  }
}



mojo.internal.Struct(
    LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsSpec.$,
    'LocalFrameHost_RequestScriptInjectionPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'granted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrameHost_RequestScriptInjectionPermission_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.granted;
  }
}



mojo.internal.Struct(
    LocalFrameHost_GetAppInstallState_ParamsSpec.$,
    'LocalFrameHost_GetAppInstallState_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrameHost_GetAppInstallState_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    LocalFrameHost_GetAppInstallState_ResponseParamsSpec.$,
    'LocalFrameHost_GetAppInstallState_ResponseParams',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrameHost_GetAppInstallState_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.state;
  }
}



mojo.internal.Struct(
    LocalFrameHost_Request_ParamsSpec.$,
    'LocalFrameHost_Request_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        RequestParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrameHost_Request_Params {
  constructor() {
    /** @type { !RequestParams } */
    this.params;
  }
}



mojo.internal.Struct(
    LocalFrameHost_Request_ResponseParamsSpec.$,
    'LocalFrameHost_Request_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseWrapper', 8,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        extensions_mojom_ExtraResponseDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LocalFrameHost_Request_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !mojoBase_mojom_ListValue } */
    this.responseWrapper;
    /** @type { !string } */
    this.error;
    /** @type { (extensions_mojom_ExtraResponseData|undefined) } */
    this.extraData;
  }
}



mojo.internal.Struct(
    LocalFrameHost_ResponseAck_ParamsSpec.$,
    'LocalFrameHost_ResponseAck_Params',
    [
      mojo.internal.StructField(
        'requestUuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrameHost_ResponseAck_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Uuid } */
    this.requestUuid;
  }
}



mojo.internal.Struct(
    LocalFrameHost_WatchedPageChange_ParamsSpec.$,
    'LocalFrameHost_WatchedPageChange_Params',
    [
      mojo.internal.StructField(
        'cssSelectors', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LocalFrameHost_WatchedPageChange_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.cssSelectors;
  }
}



mojo.internal.Struct(
    LocalFrameHost_DetailedConsoleMessageAdded_ParamsSpec.$,
    'LocalFrameHost_DetailedConsoleMessageAdded_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stackTrace', 16,
        0,
        mojo.internal.Array(extensions_mojom_StackFrameSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'level', 24,
        0,
        blink_mojom_ConsoleMessageLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LocalFrameHost_DetailedConsoleMessageAdded_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.message;
    /** @type { !mojoBase_mojom_String16 } */
    this.source;
    /** @type { !Array<!extensions_mojom_StackFrame> } */
    this.stackTrace;
    /** @type { !blink_mojom_ConsoleMessageLevel } */
    this.level;
  }
}



mojo.internal.Struct(
    LocalFrameHost_ContentScriptsExecuting_ParamsSpec.$,
    'LocalFrameHost_ContentScriptsExecuting_Params',
    [
      mojo.internal.StructField(
        'extensionIdToScripts', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.String, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LocalFrameHost_ContentScriptsExecuting_Params {
  constructor() {
    /** @type { !Object<!string, !Array<!string>> } */
    this.extensionIdToScripts;
    /** @type { !url_mojom_Url } */
    this.frameUrl;
  }
}



mojo.internal.Struct(
    LocalFrameHost_IncrementLazyKeepaliveCount_ParamsSpec.$,
    'LocalFrameHost_IncrementLazyKeepaliveCount_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LocalFrameHost_IncrementLazyKeepaliveCount_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    LocalFrameHost_DecrementLazyKeepaliveCount_ParamsSpec.$,
    'LocalFrameHost_DecrementLazyKeepaliveCount_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LocalFrameHost_DecrementLazyKeepaliveCount_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    LocalFrameHost_AppWindowReady_ParamsSpec.$,
    'LocalFrameHost_AppWindowReady_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LocalFrameHost_AppWindowReady_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    LocalFrameHost_OpenChannelToExtension_ParamsSpec.$,
    'LocalFrameHost_OpenChannelToExtension_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        extensions_mojom_ExternalConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions_mojom_ChannelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portId', 24,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 32,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class LocalFrameHost_OpenChannelToExtension_Params {
  constructor() {
    /** @type { !extensions_mojom_ExternalConnectionInfo } */
    this.info;
    /** @type { !extensions_mojom_ChannelType } */
    this.channelType;
    /** @type { !string } */
    this.channelName;
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}



mojo.internal.Struct(
    LocalFrameHost_OpenChannelToNativeApp_ParamsSpec.$,
    'LocalFrameHost_OpenChannelToNativeApp_Params',
    [
      mojo.internal.StructField(
        'nativeAppName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portId', 8,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 24,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LocalFrameHost_OpenChannelToNativeApp_Params {
  constructor() {
    /** @type { !string } */
    this.nativeAppName;
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}



mojo.internal.Struct(
    LocalFrameHost_OpenChannelToTab_ParamsSpec.$,
    'LocalFrameHost_OpenChannelToTab_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelType', 16,
        0,
        extensions_mojom_ChannelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portId', 32,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 20,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class LocalFrameHost_OpenChannelToTab_Params {
  constructor() {
    /** @type { !number } */
    this.tabId;
    /** @type { !number } */
    this.frameId;
    /** @type { (string|undefined) } */
    this.documentId;
    /** @type { !extensions_mojom_ChannelType } */
    this.channelType;
    /** @type { !string } */
    this.channelName;
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}

